/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

public class TestWasSearch
extends AbstractJqlFuncTest {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestWasSearch.xml");
    }

    public void testStatusField() {
        this.navigation.login("bob");
        this.assertSearchWithResults("status was Open", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults("status was in (Open,'In Progress')", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults("status was Closed", new String[0]);
        this.assertSearchWithResults("Status was open", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults("Status was not 'In Progress'", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults("status was not in ('In Progress',Reopened,Closed)", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithError("status was dingbat", "The value 'dingbat' does not exist for the field 'status'.");
    }

    public void testStatusFieldUpdates() {
        this.navigation.login("fred");
        this.navigation.issue().closeIssue("HSP-1", "Fixed", "Fixed");
        this.assertSearchWithResults("status was Open", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults("status was Closed", "HSP-1");
    }

    public void testAddStatusAndSearch() {
        this.navigation.login("admin");
        this.tester.gotoPage("secure/admin/ViewStatuses.jspa");
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.setFormElement("name", "myStatus");
        this.tester.submit("Add");
        this.assertSearchWithResults("status was myStatus", new String[0]);
    }

    public void testStatusFieldRename() {
        this.navigation.login("admin");
        this.navigation.issue().closeIssue("HSP-1", "Fixed", "Fixed");
        this.assertSearchWithResults("status was Closed", "HSP-1");
        this.tester.gotoPage("secure/admin/EditStatus!default.jspa?id=6");
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.setFormElement("name", "Shut");
        this.tester.submit("Update");
        this.assertSearchWithResults("Status was Closed", "HSP-1");
        this.assertSearchWithResults("Status was shut", "HSP-1");
    }

    public void testByPredicates() {
        this.navigation.login("fred");
        this.navigation.issue().closeIssue("HSP-1", "Fixed", "Fixed");
        this.navigation.login("admin");
        this.navigation.issue().closeIssue("HSP-2", "Fixed", "Fixed");
        this.assertExactSearchWithResults("status was Closed order by key asc", "HSP-1", "HSP-2");
        this.assertSearchWithResults("status was Closed by fred", "HSP-1");
        this.assertSearchWithResults("status was Closed by admin", "HSP-2");
    }
}

