/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.navigator.ContainsIssueKeysCondition;
import com.atlassian.jira.functest.framework.navigator.NumberOfIssuesCondition;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

public class TestUserNameSearching
extends AbstractJqlFuncTest {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestUserNameSearching.xml");
    }

    public void testSystemFieldSearchByUserName() throws Exception {
        this._testSearchByUserNameFits("assignee", "assignee");
        this._testSearchByFullNameDoesntFit("assignee");
        this._testSearchByEmailDoesntFit("assignee");
        this._testSearchByEmailReturnsResultsByEmail("assignee");
    }

    public void testUserPickerSearchByUserName() throws Exception {
        this._testSearchByUserNameFits("userpicker", "customfield_10000");
        this._testSearchByFullNameDoesntFit("userpicker");
        this._testSearchByEmailDoesntFit("userpicker");
        this._testSearchByEmailReturnsResultsByEmail("userpicker");
    }

    public void testUserGroupPickerSearchByUserName() throws Exception {
        this._testSearchByUserNameFits("usergrouppicker", "customfield_10001");
        this._testSearchByFullNameDoesntFit("usergrouppicker");
        this._testSearchByEmailDoesntFit("usergrouppicker");
        this._testSearchByEmailReturnsResultsByEmail("usergrouppicker");
    }

    public void _testSearchByUserNameFits(String field, String formName) throws Exception {
        this.assertFitsFilterForm(field + " = admin", TestUserNameSearching.createFilterFormParam(formName, "admin"));
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(CollectionBuilder.newBuilder(new NumberOfIssuesCondition(this.text, 1), new ContainsIssueKeysCondition(this.text, "HSP-1")).asList());
    }

    public void _testSearchByFullNameDoesntFit(String field) throws Exception {
        this.assertTooComplex(field + " = " + "Administrator");
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(CollectionBuilder.newBuilder(new NumberOfIssuesCondition(this.text, 1), new ContainsIssueKeysCondition(this.text, "HSP-1")).asList());
    }

    public void _testSearchByEmailDoesntFit(String field) throws Exception {
        this.assertTooComplex(field + " = 'admin@example.com'");
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(CollectionBuilder.newBuilder(new NumberOfIssuesCondition(this.text, 1), new ContainsIssueKeysCondition(this.text, "HSP-1")).asList());
    }

    public void _testSearchByEmailReturnsResultsByEmail(String field) throws Exception {
        this.navigation.issueNavigator().createSearch(field + " = 'email@example.com'");
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(CollectionBuilder.newBuilder(new NumberOfIssuesCondition(this.text, 1), new ContainsIssueKeysCondition(this.text, "HSP-3")).asList());
    }
}

