/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import junit.framework.Assert;

@Splitable
public class TestSorting
extends AbstractJqlFuncTest {
    private final Map<String, String> columnHeaders = MapBuilder.newBuilder().add("Component/s", "Components").add("Due Date", "Due").add("Security Level", "Security").add("Priority", "P").add("Resolution", "Resolution").add("Issue Type", "T").add("Type", "T").toMap();

    public void testOrderByClauseNameResolvesToMultipleFields() throws Exception {
        this.administration.restoreData("TestOrderByClauseNameResolvesToMultipleFields.xml");
        this.navigation.issueNavigator().createSearch("ORDER BY NF");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("HSP-1", "HSP-3", "HSP-2", "HSP-4");
        this.tester.clickLink("viewfilter");
        this.assertions.getTextAssertions().assertTextSequence(new XPathLocator(this.tester, "//div[@id='filter-summary']"), "Sorted by", "NF ascending, then NF ascending");
    }

    public void testModifyOrderByClicking() throws Exception {
        this.administration.restoreData("TestCustomFieldDefaultSortOrderings.xml");
        for (int customFieldId = 10000; customFieldId < 10020; ++customFieldId) {
            this.createSearchAndAssertIssuesAndSorts("project = two order by KEY DESC", "Key descending", "TWO-4", "TWO-3", "TWO-2", "TWO-1");
            this._clickSortCustomField(customFieldId, "DESC");
            this._clickSortCustomField(customFieldId, "ASC");
        }
        this.createSearchAndAssertIssuesAndSorts("project = two order by KEY DESC", "Key descending", "TWO-4", "TWO-3", "TWO-2", "TWO-1");
        String query = "project = two";
        SortPair keySortDesc = new SortPair("KEY", SortPair.Direction.DESC);
        SortPair assigneeSortAsc = new SortPair("assignee", SortPair.Direction.ASC);
        this._clickSortSystemField("project = two", assigneeSortAsc, keySortDesc);
        SortPair resolutionSortDesc = new SortPair("resolution", SortPair.Direction.DESC);
        this._clickSortSystemField("project = two", resolutionSortDesc, assigneeSortAsc, keySortDesc);
        SortPair prioritySortDesc = new SortPair("priority", SortPair.Direction.DESC);
        this._clickSortSystemField("project = two", prioritySortDesc, resolutionSortDesc, assigneeSortAsc);
        this._clickSortSystemField("project = two", assigneeSortAsc, prioritySortDesc, resolutionSortDesc);
        SortPair prioritySortAsc = new SortPair("priority", SortPair.Direction.ASC);
        this._clickSortSystemField("project = two", prioritySortAsc, assigneeSortAsc, resolutionSortDesc);
    }

    public void testModifyOrderByClickingOldAliasPreserved() throws Exception {
        this.administration.restoreData("TestCustomFieldDefaultSortOrderings.xml");
        this.createSearchAndAssertIssuesAndSorts("project = two order by issuekey ASC", "Key ascending", "TWO-1", "TWO-2", "TWO-3", "TWO-4");
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?sorter/field=issuekey&sorter/order=DESC");
        this.assertions.getIssueNavigatorAssertions().assertNoJqlErrors();
        String jql = this.tester.getDialog().getFormParameterValue("jqlQuery");
        Assert.assertEquals((String)"project = two ORDER BY issuekey DESC", (String)jql);
        this.createSearchAndAssertIssuesAndSorts("project = two order by assignee ASC, issuekey ASC", "Assignee ascending, then Key ascending", "TWO-1", "TWO-2", "TWO-3", "TWO-4");
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?sorter/field=issuekey&sorter/order=DESC");
        this.assertions.getIssueNavigatorAssertions().assertNoJqlErrors();
        jql = this.tester.getDialog().getFormParameterValue("jqlQuery");
        Assert.assertEquals((String)"project = two ORDER BY issuekey DESC, assignee ASC", (String)jql);
        this.createSearchAndAssertIssuesAndSorts("project = two order by status ASC, priority ASC, assignee ASC, issuekey ASC", "Status ascending, then Priority ascending, then Assignee ascending, then Key ascending", "TWO-1", "TWO-2", "TWO-3", "TWO-4");
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?sorter/field=issuekey&sorter/order=DESC");
        this.assertions.getIssueNavigatorAssertions().assertNoJqlErrors();
        jql = this.tester.getDialog().getFormParameterValue("jqlQuery");
        Assert.assertEquals((String)"project = two ORDER BY issuekey DESC, status ASC, priority ASC", (String)jql);
    }

    public void testOrderingByNonSearchableFields() throws Exception {
        this.administration.restoreData("TestOrderByNavigableFields.xml");
        this.createSearchAndAssertIssuesAndSorts("project = HSP ORDER BY progress ASC, key ASC", "Progress ascending", "HSP-2", "HSP-1", "HSP-3", "HSP-4");
        this.createSearchAndAssertIssuesAndSorts("project = HSP ORDER BY progress DESC, key ASC", "Progress descending", "HSP-3", "HSP-4", "HSP-1", "HSP-2");
        this.createSearchAndAssertIssuesAndSorts("project = HSP ORDER BY subtasks ASC, key ASC", "Sub-Tasks ascending", "HSP-2", "HSP-1", "HSP-3", "HSP-4");
        this.createSearchAndAssertIssuesAndSorts("project = HSP ORDER BY subtasks DESC, key ASC", "Sub-Tasks descending", "HSP-1", "HSP-3", "HSP-4", "HSP-2");
    }

    private void _clickSortCustomField(int customField, String orderDirection) {
        this.tester.gotoPage(String.format("/secure/IssueNavigator!executeAdvanced.jspa?sorter/field=customfield_%d&sorter/order=%s", customField, orderDirection));
        this.assertions.getIssueNavigatorAssertions().assertNoJqlErrors();
        String jql = this.tester.getDialog().getFormParameterValue("jqlQuery");
        Assert.assertEquals((String)String.format("project = two ORDER BY cf[%d] %s, KEY DESC", customField, orderDirection), (String)jql);
    }

    private void _clickSortSystemField(String query, SortPair newSort, SortPair ... expectedSorts) {
        this.tester.gotoPage(String.format("/secure/IssueNavigator!executeAdvanced.jspa?sorter/field=%s&sorter/order=%s", newSort.getFieldName(), newSort.getDirection().toString()));
        this.assertions.getIssueNavigatorAssertions().assertNoJqlErrors();
        String jql = this.tester.getDialog().getFormParameterValue("jqlQuery");
        Assert.assertTrue((expectedSorts.length <= 2 ? 1 : 0) != 0);
        StringBuilder sb = new StringBuilder(String.format("%s ORDER BY %s %s", query, newSort.getFieldName(), newSort.getDirection().toString()));
        for (SortPair expectedSort : expectedSorts) {
            sb.append(", ");
            sb.append(String.format("%s %s", expectedSort.getFieldName(), expectedSort.getDirection().toString()));
        }
        Assert.assertEquals((String)sb.toString(), (String)jql);
    }

    public void testMultipleCustomFieldsWithSameDisplayName() throws Exception {
        this.administration.restoreData("TestSortMultipleCustomFieldsWithSameDisplayName.xml");
        this.navigation.issueNavigator().createSearch("ORDER BY NF");
        this.tester.gotoPage("/secure/IssueNavigator!executeAdvanced.jspa?sorter/field=customfield_10005&sorter/order=DESC");
        this.assertions.getIssueNavigatorAssertions().assertNoJqlErrors();
        String jql = this.tester.getDialog().getFormParameterValue("jqlQuery");
        Assert.assertEquals((String)"ORDER BY cf[10005] DESC, cf[10004]", (String)jql);
        this.tester.clickLink("viewfilter");
        this.assertions.getTextAssertions().assertTextSequence(new XPathLocator(this.tester, "//div[@id='filter-summary']"), "Sorted by", "NF descending, then NF ascending");
    }

    public void testOrderByInvisibleCustomField() throws Exception {
        this.administration.restoreData("TestOrderByInvisibleCustomField.xml");
        this.navigation.login("fred");
        this.navigation.issueNavigator().createSearch("ORDER BY DT");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Not able to sort using field 'DT'.");
        this.loadFilterAndAssertNotAbleToSort("dt", 10000);
    }

    public void testJqlBuiltOrderByClauses() {
        this.administration.restoreData("TestCustomFieldDefaultSortOrderings.xml");
        this._testUnlimitedFieldsInOrderByClause();
        this._testFieldCannotBeUsedTwice();
        this._testDisabledCustomFieldsSorting();
        this._testNonExistentField();
    }

    private void _testNonExistentField() {
        this.navigation.issueNavigator().createSearch("ORDER BY bleargh");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Not able to sort using field 'bleargh'.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testDisabledCustomFieldsSorting() {
        try {
            String[] fields;
            this.administration.plugins().disablePlugin("com.atlassian.jira.plugin.system.customfieldtypes");
            for (String field : fields = new String[]{"CSF", "DP", "DT", "FTF", "GP", "II", "MC", "MGP", "MS", "MUP", "NF", "PP", "RB", "ROTF", "SL", "SVP", "TF", "UP", "URL", "VP", "cf[10000]", "cf[10001]", "cf[10002]", "cf[10003]", "cf[10004]", "cf[10005]", "cf[10006]", "cf[10007]", "cf[10008]", "cf[10009]", "cf[10010]", "cf[10011]", "cf[10012]", "cf[10013]", "cf[10014]", "cf[10015]", "cf[10016]", "cf[10017]", "cf[10018]", "cf[10019]", "cf[10020]"}) {
                this.assertNotAbleToSort(field);
            }
            this.loadFilterAndAssertNotAbleToSort("CSF", 10000);
            this.loadFilterAndAssertNotAbleToSort("DP", 10001);
            this.loadFilterAndAssertNotAbleToSort("DT", 10002);
            this.loadFilterAndAssertNotAbleToSort("FTF", 10003);
        }
        finally {
            this.administration.plugins().enablePlugin("com.atlassian.jira.plugin.system.customfieldtypes");
        }
    }

    private void loadFilterAndAssertNotAbleToSort(String fieldName, int filterId) {
        this.navigation.issueNavigator().loadFilter(filterId, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        String errorMessage = String.format("Not able to sort using field '%s'.", fieldName);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(errorMessage);
    }

    private void _testUnlimitedFieldsInOrderByClause() {
        this.createSearchAndAssertIssuesAndSorts("project in (one, two, three, four, five, six, seven, eight, nine, ten) ORDER BY csf, dp, dt, ftf, gp, ii, mc, mgp, ms, mup, key", "CSF ascending, then DP ascending, then DT ascending, then FTF ascending, then GP ascending, then II ascending, then MC ascending, then MGP ascending, then MS ascending, then MUP ascending, then Key ascending", "ONE-2", "ONE-3", "ONE-4", "TWO-2", "TWO-3", "TWO-4", "THREE-2", "THREE-3", "THREE-4", "FOUR-3", "FOUR-2", "FIVE-3", "FIVE-2", "SIX-2", "SIX-3", "SIX-4", "SEVEN-2", "SEVEN-3", "EIGHT-3", "EIGHT-2", "NINE-2", "NINE-3", "TEN-3", "TEN-2", "EIGHT-1", "FIVE-1", "FOUR-1", "NINE-1", "ONE-1", "SEVEN-1", "SIX-1", "TEN-1", "THREE-1", "TWO-1");
    }

    private void _testFieldCannotBeUsedTwice() {
        this.navigation.issueNavigator().createSearch("ORDER BY key, priority, key");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The sort field 'key' is referenced multiple times in the JQL sort.");
        this.navigation.issueNavigator().createSearch("ORDER BY issuekey, priority, key");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The sort field 'key' is referenced multiple times in the JQL sort. Field 'key' is an alias for field 'issuekey'.");
        this.navigation.issueNavigator().createSearch("ORDER BY DP, priority, cf[10001]");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The sort field 'cf[10001]' is referenced multiple times in the JQL sort. Field 'cf[10001]' is an alias for field 'DP'.");
    }

    public void testDefaultOrderByClause() throws Exception {
        this.administration.restoreData("TestDefaultOrderByClause.xml");
        this.navigation.issueNavigator().createSearch("project = HSP");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("HSP-3", "HSP-2", "HSP-1");
        this.tester.clickLink("viewfilter");
        this.assertions.getTextAssertions().assertTextSequence(new XPathLocator(this.tester, "//div[@id='filter-summary']"), "Sorted by", "Key descending");
        this.tester.assertLinkNotPresentWithText("Clear Sorts");
        this.navigation.issueNavigator().createSearch("summary ~ 'quick brown fox'");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("HSP-1", "HSP-3", "HSP-2");
        this.tester.clickLink("viewfilter");
        this.assertions.getTextAssertions().assertTextNotPresent(new XPathLocator(this.tester, "//div[@id='filter-summary']"), "Sorted by");
        this.tester.assertLinkNotPresentWithText("Clear Sorts");
    }

    public void testClearSorts() throws Exception {
        this.administration.restoreData("TestDefaultOrderByClause.xml");
        this.navigation.issueNavigator().createSearch("project = hsp ORDER BY assignee ASC");
        this.tester.assertLinkPresentWithText("Clear Sorts");
        this.tester.clickLinkWithText("Clear Sorts");
        this.assertJqlQueryInTextArea("project = hsp");
        this.tester.assertLinkNotPresentWithText("Clear Sorts");
    }

    public void testSystemFieldDefaultSortOrderings() {
        this.administration.restoreData("TestSystemFieldDefaultSortOrderings.xml");
        this.assertDoesNotSupportSorting("comment");
        this.assertNotAbleToSort("category");
        this.assertNotAbleToSort("parent");
        this.assertNotAbleToSort("savedFilter");
        this.assertNotAbleToSort("text");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY affectedVersion, issue DESC", "Affects Version/s ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY affectedVersion ASC, issue DESC", "Affects Version/s ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY affectedVersion DESC, issue DESC", "Affects Version/s descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY assignee, issue DESC", "Assignee ascending, then Key descending", "MKY-1", "HSP-4", "HSP-1", "HSP-2", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY assignee ASC, issue DESC", "Assignee ascending, then Key descending", "MKY-1", "HSP-4", "HSP-1", "HSP-2", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY assignee DESC, issue DESC", "Assignee descending, then Key descending", "HSP-3", "HSP-2", "MKY-1", "HSP-4", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY component, issue DESC", "Component/s ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY component ASC, issue DESC", "Component/s ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY component DESC, issue DESC", "Component/s descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY created", "Created descending", "HSP-4", "MKY-1", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY created ASC", "Created ascending", "HSP-1", "HSP-2", "HSP-3", "MKY-1", "HSP-4");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY created DESC", "Created descending", "HSP-4", "MKY-1", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY description, issue DESC", "Description ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY description ASC, issue DESC", "Description ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY description DESC, issue DESC", "Description descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY due, issue DESC", "Due Date descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-1", "HSP-2");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY due ASC, issue DESC", "Due Date ascending, then Key descending", "HSP-2", "HSP-1", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY due DESC, issue DESC", "Due Date descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-1", "HSP-2");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY environment, issue DESC", "Environment ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY environment ASC, issue DESC", "Environment ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY environment DESC, issue DESC", "Environment descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY fixVersion, issue DESC", "Fix Version/s ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY fixVersion ASC, issue DESC", "Fix Version/s ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY fixVersion DESC, issue DESC", "Fix Version/s descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY issue", "Key ascending", "HSP-1", "HSP-2", "HSP-3", "HSP-4", "MKY-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY issue ASC", "Key ascending", "HSP-1", "HSP-2", "HSP-3", "HSP-4", "MKY-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY issue DESC", "Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY level, issue DESC", "Security Level ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY level ASC, issue DESC", "Security Level ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY level DESC, issue DESC", "Security Level descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY originalEstimate, issue DESC", "Original Estimate descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY originalEstimate ASC, issue DESC", "Original Estimate ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY originalEstimate DESC, issue DESC", "Original Estimate descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY priority, issue DESC", "Priority descending, then Key descending", "HSP-1", "MKY-1", "HSP-4", "HSP-2", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY priority ASC, issue DESC", "Priority ascending, then Key descending", "HSP-3", "MKY-1", "HSP-4", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY priority DESC, issue DESC", "Priority descending, then Key descending", "HSP-1", "MKY-1", "HSP-4", "HSP-2", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY project, issue ASC", "Project ascending, then Key ascending", "HSP-1", "HSP-2", "HSP-3", "HSP-4", "MKY-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY project ASC, issue ASC", "Project ascending, then Key ascending", "HSP-1", "HSP-2", "HSP-3", "HSP-4", "MKY-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY project DESC, issue DESC", "Project descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY remainingEstimate, issue DESC", "Remaining Estimate descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY remainingEstimate ASC, issue DESC", "Remaining Estimate ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY remainingEstimate DESC, issue DESC", "Remaining Estimate descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY reporter, issue DESC", "Reporter ascending, then Key descending", "MKY-1", "HSP-1", "HSP-2", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY reporter ASC, issue DESC", "Reporter ascending, then Key descending", "MKY-1", "HSP-1", "HSP-2", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY reporter DESC, issue DESC", "Reporter descending, then Key descending", "HSP-4", "HSP-3", "HSP-2", "MKY-1", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY resolution, issue DESC", "Resolution ascending, then Key descending", "MKY-1", "HSP-3", "HSP-4", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY resolution ASC, issue DESC", "Resolution ascending, then Key descending", "MKY-1", "HSP-3", "HSP-4", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY resolution DESC, issue DESC", "Resolution descending, then Key descending", "HSP-4", "HSP-2", "HSP-1", "HSP-3", "MKY-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY resolved, issue DESC", "Resolved descending, then Key descending", "HSP-4", "HSP-2", "HSP-1", "HSP-3", "MKY-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY resolved ASC, issue DESC", "Resolved ascending, then Key descending", "MKY-1", "HSP-3", "HSP-4", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY resolved DESC, issue DESC", "Resolved descending, then Key descending", "HSP-4", "HSP-2", "HSP-1", "HSP-3", "MKY-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY status, issue DESC", "Status descending, then Key descending", "MKY-1", "HSP-3", "HSP-1", "HSP-4", "HSP-2");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY status ASC, issue DESC", "Status ascending, then Key descending", "HSP-4", "HSP-2", "HSP-1", "MKY-1", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY status DESC, issue DESC", "Status descending, then Key descending", "MKY-1", "HSP-3", "HSP-1", "HSP-4", "HSP-2");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY summary, issue DESC", "Summary ascending, then Key descending", "MKY-1", "HSP-3", "HSP-2", "HSP-1", "HSP-4");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY summary ASC, issue DESC", "Summary ascending, then Key descending", "MKY-1", "HSP-3", "HSP-2", "HSP-1", "HSP-4");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY summary DESC, issue DESC", "Summary descending, then Key descending", "HSP-4", "HSP-1", "HSP-2", "HSP-3", "MKY-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY timeSpent, issue DESC", "Time Spent descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY timeSpent ASC, issue DESC", "Time Spent ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY timeSpent DESC, issue DESC", "Time Spent descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY type, issue DESC", "Type descending, then Key descending", "HSP-1", "MKY-1", "HSP-4", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY type ASC, issue DESC", "Type ascending, then Key descending", "HSP-4", "HSP-3", "HSP-2", "MKY-1", "HSP-1");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY issuetype DESC, issue DESC", "Type descending, then Key descending", "HSP-1", "MKY-1", "HSP-4", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY updated", "Updated descending", "HSP-4", "HSP-1", "HSP-3", "MKY-1", "HSP-2");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY updated ASC", "Updated ascending", "HSP-2", "MKY-1", "HSP-3", "HSP-1", "HSP-4");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY updated DESC", "Updated descending", "HSP-4", "HSP-1", "HSP-3", "MKY-1", "HSP-2");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY votes, issue DESC", "Votes descending, then Key descending", "HSP-4", "HSP-1", "MKY-1", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY votes ASC, issue DESC", "Votes ascending, then Key descending", "MKY-1", "HSP-3", "HSP-2", "HSP-1", "HSP-4");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY votes DESC, issue DESC", "Votes descending, then Key descending", "HSP-4", "HSP-1", "MKY-1", "HSP-3", "HSP-2");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY workratio, issue DESC", "Work Ratio ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY workratio ASC, issue DESC", "Work Ratio ascending, then Key descending", "HSP-1", "HSP-2", "MKY-1", "HSP-4", "HSP-3");
        this.createSearchAndAssertIssuesAndSorts("ORDER BY workratio DESC, issue DESC", "Work Ratio descending, then Key descending", "MKY-1", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
    }

    public void testCustomFieldDefaultSortOrderings() {
        this.administration.restoreData("TestCustomFieldDefaultSortOrderings.xml");
        this._testCustomFieldDefaultSortOrderings("CSF", "cf[10000]", "ONE", "2", "3", "4", "1");
        this._testCustomFieldDefaultSortOrderings("DP", "cf[10001]", "TWO", "2", "3", "4", "1");
        this._testCustomFieldDefaultSortOrderings("DT", "cf[10002]", "THREE", "2", "3", "4", "1");
        this._testCustomFieldDefaultSortOrderings("FTF", "cf[10003]", "FOUR", "3", "2", "1");
        this._testCustomFieldDefaultSortOrderings("GP", "cf[10004]", "FIVE", "3", "2", "1");
        this._testCustomFieldDefaultSortOrderings("II", "cf[10005]", "SIX", "2", "3", "4", "1");
        this._testCustomFieldDefaultSortOrderings("MC", "cf[10006]", "SEVEN", "2", "3", "1");
        this._testCustomFieldDefaultSortOrderings("MGP", "cf[10007]", "EIGHT", "3", "2", "1");
        this._testCustomFieldDefaultSortOrderings("MS", "cf[10008]", "NINE", "2", "3", "1");
        this._testCustomFieldDefaultSortOrderings("MUP", "cf[10009]", "TEN", "3", "2", "1");
        this._testCustomFieldDefaultSortOrderings("NF", "cf[10010]", "ELEVEN", "2", "3", "4", "1");
        this._testCustomFieldDefaultSortOrderings("PP", "cf[10011]", "TWELVE", "3", "2", "1");
        this._testCustomFieldDefaultSortOrderings("RB", "cf[10012]", "THIRTEEN", "2", "3", "1");
        this._testCustomFieldDefaultSortOrderings("ROTF", "cf[10013]", "FOURTEEN", "3", "2", "1");
        this._testCustomFieldDefaultSortOrderings("SL", "cf[10014]", "FIFTEEN", "2", "3", "1");
        this._testCustomFieldDefaultSortOrderings("SVP", "cf[10015]", "SIXTEEN", "2", "3", "4", "1");
        this._testCustomFieldDefaultSortOrderings("TF", "cf[10016]", "SEVENTEEN", "3", "2", "1");
        this._testCustomFieldDefaultSortOrderings("URL", "cf[10017]", "EIGHTEEN", "2", "3", "1");
        this._testCustomFieldDefaultSortOrderings("UP", "cf[10018]", "NINETEEN", "3", "2", "1");
        this._testCustomFieldDefaultSortOrderings("VP", "cf[10019]", "TWENTY", "2", "3", "4", "1");
    }

    private void _testCustomFieldDefaultSortOrderings(String cfName, String cfId, String projectKey, String ... issueNumbers) {
        String[] ids;
        for (int i = 0; i < issueNumbers.length; ++i) {
            issueNumbers[i] = projectKey + "-" + issueNumbers[i];
        }
        LinkedList<String> issueNumbersList = new LinkedList<String>(Arrays.asList(issueNumbers));
        Collections.reverse(issueNumbersList);
        String[] reverseIssueNumbers = new String[issueNumbers.length];
        reverseIssueNumbers = issueNumbersList.toArray(reverseIssueNumbers);
        for (String id : ids = new String[]{cfName, cfId}) {
            this.createSearchAndAssertIssuesAndSorts(String.format("project = %s ORDER BY %s", projectKey, id), String.format("%s ascending", cfName), issueNumbers);
            this.createSearchAndAssertIssuesAndSorts(String.format("project = %s ORDER BY %s ASC", projectKey, id), String.format("%s ascending", cfName), issueNumbers);
            this.createSearchAndAssertIssuesAndSorts(String.format("project = %s ORDER BY %s DESC", projectKey, id), String.format("%s descending", cfName), reverseIssueNumbers);
        }
    }

    private void assertDoesNotSupportSorting(String fieldName) {
        String jqlQuery = String.format("ORDER BY %s", fieldName);
        String errorMessage = String.format("Field '%s' does not support sorting.", fieldName);
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(errorMessage);
    }

    private void assertNotAbleToSort(String fieldName) {
        String jqlQuery = String.format("ORDER BY %s", fieldName);
        String errorMessage = String.format("Not able to sort using field '%s'.", fieldName);
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(errorMessage);
    }

    private void createSearchAndAssertIssuesAndSorts(String jqlQuery, String sortDescription, String ... keys) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(keys);
        this.tester.clickLink("viewfilter");
        this.assertions.getTextAssertions().assertTextSequence(new XPathLocator(this.tester, "//div[@id='filter-summary']"), "Sorted by", sortDescription);
        String sortedColumn = new XPathLocator(this.tester, "//table[@id='issuetable']//tr[@class='rowHeader']//th[contains(@class, 'active')]//child::span").getText();
        String firstSort = sortDescription.split("\\s+(ascending|descending)")[0];
        String columnHeader = this.columnHeaders.containsKey(firstSort) ? this.columnHeaders.get(firstSort) : firstSort;
        Assert.assertEquals((String)sortedColumn, (String)columnHeader);
        String direction = sortDescription.substring(firstSort.length()).trim();
        if (direction.startsWith("ascending")) {
            XPathLocator arrowLocator = new XPathLocator(this.tester, "//table[@id='issuetable']//tr[@class='rowHeader']//th[contains(@class, 'ascending')]");
            this.assertions.assertNodeExists(arrowLocator);
        } else if (direction.startsWith("descending")) {
            XPathLocator arrowLocator = new XPathLocator(this.tester, "//table[@id='issuetable']//tr[@class='rowHeader']//th[contains(@class, 'descending')]");
            this.assertions.assertNodeExists(arrowLocator);
        } else {
            TestSorting.fail((String)"Failed to determine sort direction on column.");
        }
    }

    private static final class SortPair {
        private final Direction direction;
        private final String fieldName;

        public Direction getDirection() {
            return this.direction;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public SortPair(String fieldName, Direction direction) {
            this.fieldName = fieldName;
            this.direction = direction;
        }

        public static enum Direction {
            ASC,
            DESC;

        }
    }
}

