/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TestQueriesInDocumentation
extends AbstractJqlFuncTest {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestQueriesInDocumentation.xml");
    }

    public void testJQLLanguageReference() throws Exception {
        this.assertSearchWithResults("project = \"New office\" and status = \"open\"", "NO-1");
        this.assertSearchWithResults("status = open and priority = urgent and assignee = jsmith", "ABC-3", "ABC-2");
        this.assertSearchWithResults("project = JRA and assignee != jsmith", "JRA-2");
        this.assertSearchWithResults("project in (JRA,CONF) and fixVersion = \"3.14\"", "JRA-2", "JRA-1", "CONF-1");
        this.assertSearchWithResults("reporter = jsmith or reporter = jbrown", "MKY-1", "HSP-1");
        this.assertSearchWithResults("duedate < now() or duedate is empty", "NO-1", "MKY-1", "JRA-2", "JRA-1", "HSP-1", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("not assignee = jsmith", "NO-1", "MKY-1", "JRA-2", "HSP-1", "CONF-1", "ABC-4");
        this.assertSearchWithResults("assignee != jsmith", "NO-1", "MKY-1", "JRA-2", "HSP-1", "CONF-1", "ABC-4");
        this.assertSearchWithResults("reporter != jsmith", "NO-1", "MKY-1", "JRA-2", "JRA-1", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("reporter = currentUser() and assignee != currentUser()", "ABC-3", "ABC-2");
        this.assertSearchWithResults("assignee != \"John Smith\" or reporter != \"John Smith\"", "NO-1", "MKY-1", "JRA-2", "JRA-1", "HSP-1", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("assignee != empty", "NO-1", "MKY-1", "JRA-2", "HSP-1", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("assignee != empty", "NO-1", "MKY-1", "JRA-2", "HSP-1", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("reporter in (jsmith,jbrown,jjones)", "MKY-1", "HSP-1", "ABC-4");
        this.assertSearchWithResults("reporter in (Jack,Jill) or assignee in (Jack,Jill)", "MKY-1");
        this.assertSearchWithResults("affectedVersion in (\"3.14\", \"4.2\")", "JRA-2", "JRA-1");
        this.assertSearchWithResults("reporter = jsmith", "HSP-1");
        this.assertSearchWithResults("reporter = \"John Smith\"", "HSP-1");
        this.assertSearchWithResults("votes > 4", "MKY-1");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy");
        Date date = new Date(System.currentTimeMillis() - 604800000L);
        this.navigation.issue().viewIssue("MKY-1");
        this.tester.clickLink("editIssue");
        this.tester.setFormElement("duedate", dateFormat.format(date));
        this.tester.submit();
        this.navigation.issue().viewIssue("NO-1");
        this.tester.clickLink("editIssue");
        this.tester.setFormElement("duedate", dateFormat.format(date));
        this.tester.submit();
        this.assertSearchWithResults("due < now()  and resolution is empty", "NO-1", "MKY-1");
        this.assertSearchWithResults("priority > normal", "MKY-1", "JRA-2", "JRA-1", "HSP-1", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("votes >= 4", "MKY-1", "JRA-2");
        SimpleDateFormat dF = new SimpleDateFormat("yyyy-MM-dd");
        this.assertSearchWithResults("due >= \"" + dF.format(date) + "\"", "NO-1", "MKY-1");
        this.assertSearchWithResults("votes < 4", "NO-1", "JRA-1", "HSP-1", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("votes <= 4", "NO-1", "JRA-2", "JRA-1", "HSP-1", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("summary ~ fin", "MKY-1");
        this.assertSearchWithResults("summary ~ Harry\\'s", "NO-1", "JRA-2");
        this.assertSearchWithResults("summary ~ Sales\\\\Marketing", "ABC-3", "ABC-2");
        this.assertSearchWithResults("summary ~ \"\\\"Harry's computer\\\"\"", "JRA-2");
        this.assertSearchWithResults("due = empty", "JRA-2", "JRA-1", "HSP-1", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("due is empty", "JRA-2", "JRA-1", "HSP-1", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("due = null", "JRA-2", "JRA-1", "HSP-1", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("due is null", "JRA-2", "JRA-1", "HSP-1", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.navigation.issueNavigator().createSearch("due = empty order by created");
        this.assertIssues("ABC-4", "ABC-3", "HSP-1", "CONF-1", "JRA-2", "JRA-1", "ABC-2");
        this.navigation.issueNavigator().createSearch("due = empty order by created, priority desc");
        this.assertIssues("ABC-4", "ABC-3", "HSP-1", "CONF-1", "JRA-2", "JRA-1", "ABC-2");
        this.navigation.issueNavigator().createSearch("due = empty order by created, priority asc");
        this.assertIssues("ABC-4", "ABC-3", "HSP-1", "CONF-1", "JRA-2", "JRA-1", "ABC-2");
    }

    public void testFieldsAndFunctionsReference() throws Exception {
        this.assertSearchWithResults("project = \"ABC Project\"", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("project = \"ABC\"", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("project = 10010", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("category = \"Alphabet Projects\"", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("issueKey = \"ABC-2\"", "ABC-2");
        this.assertSearchWithResults("affectedVersion = \"3.14\"", "JRA-2");
        this.assertSearchWithResults("affectedVersion = \"Big Ted\"", "NO-1", "ABC-3");
        this.assertSearchWithResults("affectedVersion = \"10020\"", "NO-1");
        this.assertSearchWithResults("fixVersion in (\"3.14\", \"4.2\")", "JRA-2", "JRA-1", "CONF-1");
        this.assertSearchWithResults("fixVersion = \"Little Ted\"", "ABC-3", "ABC-2");
        this.assertSearchWithResults("fixVersion = \"Little Ted\"", "ABC-3", "ABC-2");
        this.assertSearchWithResults("fixVersion = 10012", "ABC-3", "ABC-2");
        this.assertSearchWithResults("component in (Comp1, Comp2)", "ABC-3", "ABC-2");
        this.assertSearchWithResults("component = 10010", "ABC-3", "ABC-2");
        this.assertSearchWithResults("issueType in (Bug,Improvement)", "MKY-1", "JRA-2", "JRA-1", "HSP-1", "CONF-1", "ABC-2");
        this.assertSearchWithResults("issueType = Bug", "MKY-1", "JRA-2", "JRA-1", "HSP-1", "CONF-1", "ABC-2");
        this.assertSearchWithResults("issueType = 2", "ABC-4");
        this.assertSearchWithResults("priority = High", "ABC-4");
        this.assertSearchWithResults("priority = 8", "ABC-4");
        this.assertSearchWithResults("status = Open", "NO-1", "MKY-1", "JRA-2", "CONF-1", "ABC-3", "ABC-2");
        this.assertSearchWithResults("status = 1", "NO-1", "MKY-1", "JRA-2", "CONF-1", "ABC-3", "ABC-2");
        this.assertSearchWithResults("resolution in (\"Cannot Reproduce\", \"Won't Fix\")", "JRA-1", "HSP-1");
        this.assertSearchWithResults("resolution = 1", "ABC-4");
        this.assertSearchWithResults("level in (\"Really High\", level1)", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("level = 10000", "ABC-3", "ABC-2");
        this.assertSearchWithResults("summary ~ \"Error saving file\"", "ABC-4");
        this.assertSearchWithResults("description ~ \"Please see screenshot for details.\"", "ABC-4");
        this.assertSearchWithResults("environment ~ \"Third floor\"", "ABC-4");
        this.assertSearchWithResults("comment ~ \"My PC is quite old\"", "ABC-4");
        this.assertSearchWithResults("assignee = \"John Smith\"", "ABC-3", "ABC-2");
        this.assertSearchWithResults("assignee = jsmith", "ABC-3", "ABC-2");
        this.assertSearchWithResults("reporter = \"Jill Jones\"", "ABC-4");
        this.assertSearchWithResults("reporter = jjones", "ABC-4");
        this.assertSearchWithResults("parent = \"ABC-2\"", "ABC-3");
        this.assertSearchWithResults("originalEstimate = 1h", "NO-1", "HSP-1");
        this.assertSearchWithResults("originalEstimate > 2d", "JRA-2", "CONF-1");
        this.assertSearchWithResults("remainingEstimate > 4h", "JRA-2", "CONF-1");
        this.assertSearchWithResults("timeSpent > 5d", "CONF-1");
        this.assertSearchWithResults("workratio > 75", "HSP-1");
        this.assertSearchWithResults("votes >= 12", new String[0]);
        this.assertSearchWithResults("created >= \"2009/07/23\" AND created < \"2009/07/24\"", "NO-1", "MKY-1", "JRA-2", "JRA-1", "HSP-1", "CONF-1", "ABC-2");
        this.assertSearchWithResults("updated >= \"2009/07/24\" AND updated < \"2009/07/25\"", "HSP-1", "CONF-1");
        this.assertSearchWithResults("due = \"2009/07/24\"", "NO-1");
        this.assertSearchWithResults("resolved <= \"2009/07/31\" and resolved >= \"2009/07/01\"", "JRA-1", "HSP-1", "ABC-4");
        this.assertSearchWithResults("location != empty", "NO-1", "MKY-1", "JRA-2", "ABC-4");
        this.assertSearchWithResults("location = \"New York\"", "ABC-4");
        this.assertSearchWithResults("location in (\"London\",\"Milan\",\"Paris\")", "NO-1", "MKY-1", "JRA-2");
        this.assertSearchWithResults("cf[10000] = \"New York\"", "ABC-4");
        this.assertSearchWithResults("version in (\"3.12\", \"3.13\", \"3.14\")", "JRA-2", "JRA-1");
        this.assertSearchWithResults("project = \"JIRA\" and version != \"3.14\"", "JRA-1");
        this.assertSearchWithResults("assignee = currentUser()", "NO-1", "MKY-1", "JRA-2", "HSP-1", "CONF-1", "ABC-4");
        this.assertSearchWithResults("reporter = currentUser() and assignee != currentUser()", "ABC-3", "ABC-2");
        this.assertSearchWithResults("assignee in membersOf(\"jira-developers\")", "NO-1", "MKY-1", "JRA-2", "HSP-1", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("assignee in membersOf(QA) and assignee not in (\"Jill Jones\")", "ABC-3", "ABC-2");
        this.assertSearchWithResults("assignee not in membersOf(QA)", "NO-1", "MKY-1", "JRA-2", "HSP-1", "CONF-1", "ABC-4");
        this.assertSearchWithResults("due < now() and status not in (closed, resolved)", "NO-1", "MKY-1");
        this.assertSearchWithResults("fixVersion in releasedVersions(ABC)", "ABC-3", "ABC-2");
        this.assertSearchWithResults("affectedVersion in releasedVersions(ABC)", "ABC-4");
        this.assertSearchWithResults("fixVersion in unreleasedVersions(ABC)", "ABC-4");
        this.assertSearchWithResults("affectedVersion in unreleasedVersions(ABC) or fixVersion in unreleasedVersions(ABC)", "ABC-4", "ABC-3");
        this.assertSearchWithResults("issuetype in standardIssueTypes()", "NO-1", "MKY-1", "JRA-2", "JRA-1", "HSP-1", "CONF-1", "ABC-4", "ABC-2");
        this.assertSearchWithResults("issue in linkedIssues(\"ABC-4\")", "ABC-2");
        this.assertSearchWithResults("issue in linkedIssues(\"ABC-4\",\"is related to\")", "ABC-2");
        this.assertSearchWithResults("issue in votedIssues()", "MKY-1");
        this.assertSearchWithResults("issue in watchedIssues()", "JRA-2");
        this.assertSearchWithResults("filter = \"JIRA, Confluence and ABC Project Issues\"", "JRA-2", "JRA-1", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("filter = \"JIRA, Confluence and ABC Project Issues\" and assignee = jsmith", "ABC-3", "ABC-2");
        this.assertSearchWithResults("filter = 10000 and assignee = jsmith", "ABC-3", "ABC-2");
        this.assertSearchWithResults("myCascadingSelect in cascadeoption(parentOption1,child1OfParentOption1)", "ABC-4");
        this.navigation.issue().viewIssue("NO-1");
        this.assertSearchWithResults("issue in issueHistory()", "NO-1", "MKY-1", "JRA-2", "JRA-1", "HSP-1", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        String issueKey = this.navigation.issue().createIssue("JIRA", "Bug", "Just created");
        this.assertSearchWithResults("created > \"-8h\"", issueKey);
    }
}

