/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import java.io.UnsupportedEncodingException;

public class TestIssueNavigatorLoadFilter
extends AbstractJqlFuncTest {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestIssueNavigatorLoadFilter.xml");
    }

    public void testIssueNavigatorRetainSimpleSearch() throws Exception {
        long jqlInValidDoesntFit = 10000L;
        long jqlInValidFits = 10001L;
        long jqlValidDoesnFit = 10002L;
        long jqlValidAndFits = 10003L;
        this.executeNavigatorJqlQuery(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, jqlInValidDoesntFit, "The value 'New Component 5' does not exist for the field 'component'.");
        this.executeNavigatorJqlQuery(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, jqlInValidFits, "Could not find group: blub");
        this.executeNavigatorJqlQuery(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, null, jqlValidDoesnFit, new String[0]);
        this.assertIssues("HSP-1");
        this.executeNavigatorJqlQuery(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, null, jqlValidAndFits, new String[0]);
        this.assertIssues("HSP-1");
    }

    public void testIssueNavigatorRetainAdvancedSearch() throws Exception {
        long jqlInValidDoesntFit = 10000L;
        long jqlInValidFits = 10001L;
        long jqlValidDoesnFit = 10002L;
        long jqlValidAndFits = 10003L;
        this.executeNavigatorJqlQuery(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, jqlInValidDoesntFit, "The value 'New Component 5' does not exist for the field 'component'.");
        this.executeNavigatorJqlQuery(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, jqlInValidFits, "Function 'membersOf' can not generate a list of usernames for group 'blub'; the group does not exist.");
        this.executeNavigatorJqlQuery(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, null, jqlValidDoesnFit, new String[0]);
        this.assertIssues("HSP-1");
        this.executeNavigatorJqlQuery(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, null, jqlValidAndFits, new String[0]);
        this.assertIssues("HSP-1");
    }

    private void executeNavigatorJqlQuery(IssueNavigatorNavigation.NavigatorEditMode startEditMode, IssueNavigatorNavigation.NavigatorEditMode expectedEditMode, long filter, String ... expectedErrors) throws UnsupportedEncodingException {
        if (this.navigation.issueNavigator().getCurrentEditMode() != startEditMode) {
            this.navigation.issueNavigator().displayAllIssues();
            this.navigation.issueNavigator().gotoEditMode(startEditMode);
        }
        this.navigation.issueNavigator().loadFilter(filter, null);
        TestIssueNavigatorLoadFilter.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.SUMMARY), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
        if (expectedEditMode != null) {
            this.tester.clickLink("editfilter");
            TestIssueNavigatorLoadFilter.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorMode.EDIT), (Object)((Object)this.navigation.issueNavigator().getCurrentMode()));
            TestIssueNavigatorLoadFilter.assertEquals((Object)((Object)expectedEditMode), (Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()));
            if (expectedErrors != null) {
                if (this.navigation.issueNavigator().getCurrentEditMode() == IssueNavigatorNavigation.NavigatorEditMode.ADVANCED) {
                    this.assertions.getIssueNavigatorAssertions().assertJqlErrors(expectedErrors);
                } else {
                    for (String expectedError : expectedErrors) {
                        this.text.assertTextPresent(this.tester.getDialog().getResponseText(), expectedError);
                    }
                }
            }
        }
    }
}

