/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TestEmptyNotEmptyLiterals
extends AbstractJqlFuncTest {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestEmptyNotEmptyLiterals.xml");
    }

    public void testIsEmpty() throws Exception {
        StringBuffer jqlQuery;
        ArrayList<String> clauseNames = new ArrayList<String>();
        clauseNames.add("affectedVersion");
        clauseNames.add("assignee");
        clauseNames.add("component");
        clauseNames.add("description");
        clauseNames.add("environment");
        clauseNames.add("fixVersion");
        clauseNames.add("level");
        clauseNames.add("originalEstimate");
        clauseNames.add("reporter");
        List<String> homosapienIssueKeys = CollectionBuilder.newBuilder("HSP-1", "HSP-2", "HSP-3", "HSP-4", "HSP-5", "HSP-6", "HSP-7", "HSP-8", "HSP-9", "HSP-10").asList();
        List<String> monkeyIssueKeys = CollectionBuilder.newBuilder("MKY-1", "MKY-2", "MKY-3", "MKY-4", "MKY-5", "MKY-6", "MKY-7", "MKY-8", "MKY-9", "MKY-10").asList();
        int count = clauseNames.size();
        for (int i = 0; i <= count; ++i) {
            Iterator iterator = clauseNames.iterator();
            jqlQuery = new StringBuffer();
            for (int j = 0; j < i; ++j) {
                jqlQuery.append((String)iterator.next() + " IS NOT EMPTY ");
                if (!iterator.hasNext()) continue;
                jqlQuery.append("AND ");
            }
            for (int k = i; k < count; ++k) {
                jqlQuery.append((String)iterator.next() + " IS EMPTY ");
                if (!iterator.hasNext()) continue;
                jqlQuery.append("AND ");
            }
            this.assertSearchWithResults(jqlQuery.toString(), monkeyIssueKeys.get(i), homosapienIssueKeys.get(i));
        }
        for (String clauseName : clauseNames) {
            jqlQuery = new StringBuffer();
            jqlQuery.append(clauseName + " IS EMPTY AND " + clauseName + " IS NOT EMPTY");
            this.navigation.issueNavigator().createSearch(jqlQuery.toString());
            this.assertIssues(new String[0]);
        }
    }

    public void testIsEmptyORHasSpecificValue() throws Exception {
        this.assertSearchWithResults("affectedVersion IS EMPTY OR affectedVersion = \"New Version 1\" AND assignee IS EMPTY AND component IS EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY", "MKY-2", "MKY-1", "HSP-2", "HSP-1");
        this.assertSearchWithResults("affectedVersion IS NOT EMPTY AND assignee IS EMPTY OR assignee = \"admin\" AND component IS EMPTY AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY", "MKY-3", "MKY-2", "HSP-3", "HSP-2");
        this.assertSearchWithResults("affectedVersion IS NOT EMPTY AND assignee IS NOT EMPTY AND component IS EMPTY OR component = \"New Component 1\" AND description IS EMPTY AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY", "MKY-4", "MKY-3", "HSP-4", "HSP-3");
        this.assertSearchWithResults("affectedVersion IS NOT EMPTY AND assignee IS NOT EMPTY AND component IS NOT EMPTY AND description IS EMPTY OR description ~ \"Blub\" AND environment IS EMPTY AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY", "MKY-5", "MKY-4", "HSP-5", "HSP-4");
        this.assertSearchWithResults("affectedVersion IS NOT EMPTY AND assignee IS NOT EMPTY AND component IS NOT EMPTY AND description IS NOT EMPTY AND environment IS EMPTY OR environment ~ \"some environment information\" AND fixVersion IS EMPTY AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY", "MKY-6", "MKY-5", "HSP-6", "HSP-5");
        this.assertSearchWithResults("affectedVersion IS NOT EMPTY AND assignee IS NOT EMPTY AND component IS NOT EMPTY AND description IS NOT EMPTY AND environment IS NOT EMPTY AND fixVersion IS EMPTY OR fixVersion = \"New Version 1\" AND level IS EMPTY AND originalEstimate IS EMPTY AND reporter IS EMPTY", "MKY-7", "MKY-6", "HSP-7", "HSP-6");
        this.assertSearchWithResults("affectedVersion IS NOT EMPTY AND assignee IS NOT EMPTY AND component IS NOT EMPTY AND description IS NOT EMPTY AND environment IS NOT EMPTY AND fixVersion IS NOT EMPTY AND level IS EMPTY OR level = \"Level 1\" AND originalEstimate IS EMPTY AND reporter IS EMPTY", "MKY-8", "MKY-7", "HSP-8", "HSP-7");
        this.assertSearchWithResults("affectedVersion IS NOT EMPTY AND assignee IS NOT EMPTY AND component IS NOT EMPTY AND description IS NOT EMPTY AND environment IS NOT EMPTY AND fixVersion IS NOT EMPTY AND level IS NOT EMPTY AND originalEstimate IS EMPTY OR originalEstimate = \"12h\" AND reporter IS EMPTY", "MKY-9", "MKY-8", "HSP-9", "HSP-8");
        this.assertSearchWithResults("affectedVersion IS NOT EMPTY AND assignee IS NOT EMPTY AND component IS NOT EMPTY AND description IS NOT EMPTY AND environment IS NOT EMPTY AND fixVersion IS NOT EMPTY AND level IS NOT EMPTY AND originalEstimate IS NOT EMPTY AND reporter IS EMPTY OR reporter = \"admin\"", "MKY-10", "MKY-9", "HSP-10", "HSP-9");
        this.assertSearchWithResults("affectedVersion IS NOT EMPTY AND assignee IS NOT EMPTY AND component IS NOT EMPTY AND description IS NOT EMPTY AND environment IS NOT EMPTY AND fixVersion IS NOT EMPTY AND level IS NOT EMPTY AND originalEstimate IS NOT EMPTY AND reporter IS NOT EMPTY", "MKY-10", "HSP-10");
        this.assertSearchWithResults("resolution is empty OR resolution = \"Fixed\"", "MKY-10", "MKY-9", "MKY-8", "MKY-7", "MKY-6", "MKY-1", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-1");
        this.assertSearchWithResults("resolution is empty OR resolution = \"Won't Fix\"", "MKY-10", "MKY-9", "MKY-8", "MKY-7", "MKY-6", "MKY-2", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-2");
        this.assertSearchWithResults("resolution is empty OR resolution = \"Duplicate\"", "MKY-10", "MKY-9", "MKY-8", "MKY-7", "MKY-6", "MKY-3", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-3");
        this.assertSearchWithResults("resolution is empty OR resolution = \"Incomplete\"", "MKY-10", "MKY-9", "MKY-8", "MKY-7", "MKY-6", "MKY-4", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-4");
        this.assertSearchWithResults("resolution is empty OR resolution = \"Cannot Reproduce\"", "MKY-10", "MKY-9", "MKY-8", "MKY-7", "MKY-6", "MKY-5", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5");
        this.assertSearchWithResults("remainingEstimate = \"12h\" or remainingEstimate is empty", "MKY-9", "MKY-8", "MKY-7", "MKY-6", "MKY-5", "MKY-4", "MKY-3", "MKY-2", "MKY-1", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults("duedate = \"2009/07/22\" OR duedate is empty", "MKY-10", "MKY-9", "MKY-7", "MKY-6", "MKY-5", "MKY-4", "MKY-3", "MKY-2", "MKY-1", "HSP-10", "HSP-9", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchWithResults("workRatio = \"16\" OR workRatio is empty", "MKY-10", "MKY-8", "MKY-7", "MKY-6", "MKY-5", "MKY-4", "MKY-3", "MKY-2", "MKY-1", "HSP-10", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
    }
}

