/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.WebTesterFactory;
import net.sourceforge.jwebunit.WebTester;

public class TestIssueNavigatorPageShown
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueNavigatorPageShown.xml");
    }

    public void testOpensToCorrectPage() {
        this.navigation.issueNavigator().displayAllIssues();
        this.assertNumberOfIssues(1, 50, 250);
        this.assertTopRowSelected();
        this.navigation.issue().viewIssue("TEST-99");
        this.returnToSearch();
        this.assertNumberOfIssues(151, 200, 250);
        this.assertIssueSelected("TEST-99");
        this.navigation.issue().viewIssue("TEST-99");
        this.previousIssue();
        this.previousIssue();
        this.previousIssue();
        this.assertViewingIssue("TEST-102");
        this.returnToSearch();
        this.assertNumberOfIssues(101, 150, 250);
        this.assertIssueSelected("TEST-102");
        this.navigation.issue().viewIssue("TEST-201");
        this.nextIssue();
        this.nextIssue();
        this.nextIssue();
        this.assertViewingIssue("TEST-198");
        this.returnToSearch();
        this.assertNumberOfIssues(51, 100, 250);
        this.assertIssueSelected("TEST-198");
        this.navigation.issue().viewIssue("TEST-175");
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.assertNumberOfIssues(51, 100, 249);
        this.assertIssueSelected("TEST-174");
        this.navigation.issue().viewIssue("TEST-174");
        WebTester otherWindow = this.newWebTester();
        int TEST_174_ID = 11243;
        this.deleteIssues(otherWindow, 11243L, 2L);
        this.assertViewingIssue("TEST-174");
        this.returnToSearch();
        this.assertNumberOfIssues(51, 100, 247);
        this.assertIssueSelected("TEST-200");
    }

    public void testDeletingLoneIssueOnLastPage() {
        this.navigation.issue().createIssue("TEST", "Bug", "foo bar");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("page_6");
        this.assertNumberOfIssues(251, 251, 251);
        this.navigation.issue().viewIssue("TEST-1");
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.assertNumberOfIssues(1, 50, 250);
    }

    private void deleteIssues(WebTester webTester, long startingIssueId, long numberToDelete) {
        long i = 0L;
        long issueId = startingIssueId;
        while (i < numberToDelete) {
            webTester.beginAt("/secure/DeleteIssue!default.jspa?id=" + issueId);
            webTester.submit("Delete");
            ++i;
            --issueId;
        }
    }

    private WebTester newWebTester() {
        WebTester tester = WebTesterFactory.createNewWebTester(this.environmentData);
        tester.beginAt("/login.jsp");
        tester.setFormElement("os_username", "admin");
        tester.setFormElement("os_password", "admin");
        tester.setWorkingForm("login-form");
        tester.submit();
        return tester;
    }

    private void assertViewingIssue(String issueKey) {
        this.tester.assertTextInElement("key-val", issueKey);
    }

    private void nextIssue() {
        this.tester.clickLink("next-issue");
    }

    private void previousIssue() {
        this.tester.clickLink("previous-issue");
    }

    private void returnToSearch() {
        this.tester.clickLink("return-to-search");
    }

    private void assertNumberOfIssues(int from, int to, int total) {
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@class='results-count']"), String.format("%d to %d of %d", from, to, total));
    }

    private void assertIssueSelected(String issueKey) {
        TestIssueNavigatorPageShown.assertTrue((boolean)new XPathLocator(this.tester, String.format("//tr[contains(@class, 'focused') and @data-issuekey='%s']", issueKey)).exists());
    }

    private void assertTopRowSelected() {
        TestIssueNavigatorPageShown.assertTrue((boolean)new XPathLocator(this.tester, "//tr[contains(@class, 'focused') and position()=1]").exists());
    }
}

