/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.webtests.LicenseKeys;
import com.meterware.httpunit.WebTable;
import java.io.File;
import java.io.IOException;

public class TestSetup
extends FuncTestCase {
    public void testSetupCannotBeRunTwice() {
        this.administration.restoreBlankInstance();
        String[] actions = new String[]{"Setup.jspa", "Setup!input.jspa", "Setup!default.jspa", "Setup2.jspa", "Setup2!default.jspa", "SetupExisting.jspa", "SetupExisting!default.jspa", "Setup3.jspa", "Setup3!default.jspa", "SetupComplete.jspa", "SetupComplete!default.jspa", "SetupImport.jspa", "SetupImport!default.jspa"};
        String[] views = new String[]{"setup.jsp", "setup2.jsp", "setup2-existingadmins.jsp", "setup3.jsp", "setup-import.jsp"};
        for (String action : actions) {
            this.tester.gotoPage("/secure/" + action);
            this.assertSetupAlreadyLong();
        }
        for (String view : views) {
            this.tester.gotoPage("/views/" + view);
            this.assertSetupAlreadyShort();
        }
    }

    public void testMissingTitle() throws Exception {
        this.gotoSetupStep1();
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.tester.assertTextPresent("Step 1 of 3: Application properties");
        this.tester.assertTextPresent("You must specify a title.");
        this.tester.assertTextNotPresent("Invalid license key specified.");
    }

    public void testMissingLicense() throws Exception {
        this.gotoSetupStep1();
        this.tester.setFormElement("title", "My JIRA");
        this.tester.submit();
        this.tester.assertTextPresent("Step 1 of 3: Application properties");
        this.tester.assertTextNotPresent("You must specify a title.");
        this.tester.assertTextPresent("Invalid license key specified.");
    }

    public void testInvalidLicense() throws Exception {
        this.gotoSetupStep1();
        this.tester.setFormElement("title", "My JIRA");
        this.tester.setFormElement("license", "blah");
        this.tester.submit();
        this.tester.assertTextPresent("Step 1 of 3: Application properties");
        this.tester.assertTextNotPresent("You must specify a title.");
        this.tester.assertTextPresent("Invalid license key specified.");
    }

    public void testInvalidSmtpPorts() throws Exception {
        this.doSetupStep1();
        this.doSetupStep2();
        this.tester.setFormElement("serverName", "localhost");
        this.tester.setFormElement("port", "-1");
        this.tester.submit("Finish");
        this.tester.assertTextPresent("SMTP port must be a number between 0 and 65535");
        this.tester.setFormElement("serverName", "localhost");
        this.tester.setFormElement("port", String.valueOf(65536));
        this.tester.submit("Finish");
        this.tester.assertTextPresent("SMTP port must be a number between 0 and 65535");
    }

    public void testSetupWithDefaultDirectories() throws IOException {
        this.gotoSetupStep1();
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("title", "My JIRA");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.doSetupStep2and3();
        this.navigation.gotoAdminSection("attachments");
        this.tester.assertTextPresent("Attachment Settings");
        WebTable AttachmentSettings = this.tester.getDialog().getWebTableBySummaryOrId("AttachmentSettings");
        TestSetup.assertEquals((String)"Cell (1, 0) in table 'AttachmentSettings' should be 'Allow Attachments'.", (String)"Allow Attachments", (String)AttachmentSettings.getCellAsText(1, 0).trim());
        TestSetup.assertEquals((String)"Cell (1, 1) in table 'AttachmentSettings' should be 'ON'.", (String)"ON", (String)AttachmentSettings.getCellAsText(1, 1).trim());
        TestSetup.assertEquals((String)"Cell (2, 0) in table 'AttachmentSettings' should be 'Attachment Path'.", (String)"Attachment Path", (String)AttachmentSettings.getCellAsText(2, 0).trim());
        TestSetup.assertTrue((String)"Default Directory [/home/mlassau/jira_homes/jira_trunk/data/attachments]", (boolean)AttachmentSettings.getCellAsText(2, 1).trim().startsWith("Default Directory ["));
        this.navigation.gotoAdminSection("indexing");
        this.tester.assertTextPresent("Re-Indexing");
        this.administration.services().goTo();
        this.tester.assertTextPresent("Backup Service");
        this.tester.assertTextPresent("<tr><td><strong>USE_DEFAULT_DIRECTORY:</strong></td><td>true</td></tr>");
        this.tester.assertTextNotPresent("<td><b>DIR_NAME:</b></td><td>");
        this.administration.services().clickEdit("Backup Service");
        this.tester.assertFormElementEquals("USE_DEFAULT_DIRECTORY", "true");
        this.assertTimeTrackingActivationAndDefaultValues();
        this.assertIssueLinking();
    }

    public void testSetupWithDisabledDirectories() throws IOException {
        this.gotoSetupStep1();
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("title", "My JIRA");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.setFormElement("attachmentPathOption", "DISABLED");
        this.tester.setFormElement("backupPathOption", "DISABLED");
        this.tester.submit();
        this.doSetupStep2and3();
        this.navigation.gotoAdminSection("attachments");
        this.tester.assertTextPresent("Attachment Settings");
        WebTable AttachmentSettings = this.tester.getDialog().getWebTableBySummaryOrId("AttachmentSettings");
        TestSetup.assertEquals((String)"Cell (1, 0) in table 'AttachmentSettings' should be 'Allow Attachments'.", (String)"Allow Attachments", (String)AttachmentSettings.getCellAsText(1, 0).trim());
        TestSetup.assertEquals((String)"Cell (1, 1) in table 'AttachmentSettings' should be 'OFF'.", (String)"OFF", (String)AttachmentSettings.getCellAsText(1, 1).trim());
        TestSetup.assertEquals((String)"Cell (2, 0) in table 'AttachmentSettings' should be 'Attachment Path'.", (String)"Attachment Path", (String)AttachmentSettings.getCellAsText(2, 0).trim());
        TestSetup.assertEquals((String)"Cell (2, 1) in table 'AttachmentSettings' should be ''.", (String)"", (String)AttachmentSettings.getCellAsText(2, 1).trim());
        this.navigation.gotoAdminSection("services");
        this.tester.assertTextNotPresent("Backup Service");
        this.tester.assertTextNotPresent("USE_DEFAULT_DIRECTORY");
        this.tester.assertTextNotPresent("DIR_NAME");
        this.assertTimeTrackingActivationAndDefaultValues();
        this.assertIssueLinking();
    }

    public void testSetupImportMissingFilename() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("This setup page is to import existing data from another JIRA installation.");
        this.tester.setFormElement("filename", "");
        this.tester.submit();
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("You must enter the location of an XML file.");
        this.tester.assertTextNotPresent("You must specify a location for index files");
    }

    public void testSetupImportInvalidLicense() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("This setup page is to import existing data from another JIRA installation.");
        this.tester.setFormElement("filename", File.createTempFile("import", ".xml").getAbsolutePath());
        this.tester.setFormElement("license", "wrong");
        this.tester.submit();
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("Invalid license key specified.");
        this.tester.assertTextNotPresent("You must enter the location of an XML file.");
    }

    public void testSetupImportWithOldLicenseInXML() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("This setup page is to import existing data from another JIRA installation.");
        this.tester.setFormElement("filename", new File(this.environmentData.getXMLDataLocation(), "oldlicense.xml").getAbsolutePath());
        this.tester.submit();
        this.text.assertTextPresent(new WebPageLocator(this.tester), "The license in the imported data is not compatible with this installation of JIRA.");
    }

    public void testSetupImportWithDodgyIndexPath() throws IOException {
        this.restoreEmptyInstance();
        File indexPath = File.createTempFile("testXmlImportWithInvalidIndexDirectory", null);
        indexPath.createNewFile();
        indexPath.deleteOnExit();
        File dataFile = this.administration.replaceTokensInFile("TestSetupInvalidIndexPath.xml", EasyMap.build((Object)"@@INDEX_PATH@@", (Object)indexPath.getAbsolutePath()));
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("This setup page is to import existing data from another JIRA installation.");
        this.tester.setFormElement("filename", dataFile.getAbsolutePath());
        this.tester.submit();
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Cannot write to index directory. Check that the application server and JIRA have permissions to write to: " + indexPath.getAbsolutePath());
    }

    public void testSetupImportWithDodgyAttachmentPath() throws IOException {
        this.restoreEmptyInstance();
        File attachmentPath = File.createTempFile("testXmlImportWithInvalidAttachmentDirectory", null);
        attachmentPath.createNewFile();
        attachmentPath.deleteOnExit();
        File dataFile = this.administration.replaceTokensInFile("TestSetupInvalidAttachmentPath.xml", EasyMap.build((Object)"@@ATTACHMENT_PATH@@", (Object)attachmentPath.getAbsolutePath()));
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("This setup page is to import existing data from another JIRA installation.");
        this.tester.setFormElement("filename", dataFile.getAbsolutePath());
        this.tester.submit();
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Cannot write to attachment directory. Check that the application server and JIRA have permissions to write to: " + attachmentPath.getAbsolutePath());
    }

    public void testSetupImportDefaultIndexDirectory() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("This setup page is to import existing data from another JIRA installation.");
        this.tester.setFormElement("filename", new File(this.environmentData.getXMLDataLocation(), "oldlicense.xml").getAbsolutePath());
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.tester.assertTextPresent("Setup Complete");
        this.navigation.login("admin");
        this.navigation.gotoAdminSection("indexing");
        this.tester.assertTextPresent("Re-Indexing");
    }

    public void testSetupImportDefaultsForSetupComplete() throws IOException {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/SetupImport!default.jspa");
        this.tester.assertTextPresent("Import Existing Data");
        this.tester.assertTextPresent("This setup page is to import existing data from another JIRA installation.");
        this.tester.setFormElement("filename", new File(this.environmentData.getXMLDataLocation(), "oldlicense.xml").getAbsolutePath());
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.tester.assertTextPresent("Setup Complete");
        this.navigation.login("admin");
        this.assertSubTasksDisabled();
        this.assertDefaultTextRendererIsSetForAllRenderableFields();
    }

    private void assertSubTasksDisabled() {
        TestSetup.assertFalse((String)"Sub-tasks were enabled when they shouldn't have been", (boolean)this.administration.subtasks().isEnabled());
    }

    private void assertDefaultTextRendererIsSetForAllRenderableFields() {
        String[] renderableFields;
        for (String fieldName : renderableFields = new String[]{"Comment", "Description", "Environment"}) {
            TestSetup.assertEquals((String)"Default Text Renderer", (String)this.administration.fieldConfigurations().defaultFieldConfiguration().getRenderer(fieldName));
        }
    }

    private void restoreEmptyInstance() {
        this.administration.restoreNotSetupInstance();
    }

    private void assertTimeTrackingActivationAndDefaultValues() {
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.tester.assertTextPresent("The number of working hours per day is <b>8");
        this.tester.assertTextPresent("The number of working days per week is <b>5");
    }

    private void assertIssueLinking() {
        this.tester.gotoPage("secure/admin/ViewLinkTypes!default.jspa");
        this.navigation.checkWebSudoWithLastPassword();
        WebPageLocator page = new WebPageLocator(this.tester);
        this.text.assertTextPresent(page, "Issue linking is currently ON.");
        this.text.assertTextSequence(page, new String[]{"Blocks", "blocks", "is blocked by"});
        this.text.assertTextSequence(page, new String[]{"Cloners", "clones", "is cloned by"});
        this.text.assertTextSequence(page, new String[]{"Duplicate", "duplicates", "is duplicated by"});
        this.text.assertTextSequence(page, new String[]{"Relates", "relates to", "relates to"});
    }

    private void assertSetupAlreadyLong() {
        this.tester.assertTextPresent("SETUP ALREADY");
        this.tester.assertTextPresent("It seems that you have tried to setup JIRA when it is already setup.");
    }

    private void assertSetupAlreadyShort() {
        this.tester.assertTextPresent("JIRA has already been set up.");
    }

    private void doSetupStep1() {
        this.gotoSetupStep1();
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("title", "TestSetup JIRA");
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
    }

    private void doSetupStep2and3() {
        this.doSetupStep2();
        this.doSetupStep3();
    }

    private void doSetupStep3() {
        this.log("Noemail");
        this.tester.submit("noemail");
        this.log("Noemail");
        this.tester.assertTextPresent("Setup Complete");
        this.navigation.login("admin");
    }

    private void doSetupStep2() {
        this.tester.assertTextPresent("Step 2 of 3: Administrator account");
        this.tester.setFormElement("username", "admin");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("confirm", "admin");
        this.tester.setFormElement("fullname", "Mary Magdelene");
        this.tester.setFormElement("email", "admin@example.com");
        this.tester.submit();
        this.tester.assertTextPresent("Step 3 of 3: Email Notification");
    }

    private void gotoSetupStep1() {
        this.restoreEmptyInstance();
        this.tester.gotoPage("secure/Setup.jspa");
        this.tester.assertTextPresent("Step 1 of 3: Application properties");
    }
}

