/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.WebTesterFactory;
import com.meterware.httpunit.WebLink;
import org.xml.sax.SAXException;

public class TestSessionIdInUrl
extends JIRAWebTest {
    public TestSessionIdInUrl(String name) {
        super(name);
    }

    public void testBrowseIssue() throws SAXException {
        this.restoreBlankInstance();
        this.logout();
        this.beginAt("/login.jsp");
        this.setFormElement("os_username", "admin");
        this.setFormElement("os_password", "admin");
        this.checkCheckbox("os_cookie", "true");
        this.setWorkingForm("login-form");
        this.submit();
        this.clickLink("create_link");
        this.submit("Next");
        this.setFormElement("summary", "Bug 1");
        this.selectOption("versions", "New Version 4");
        this.selectOption("fixVersions", "New Version 5");
        this.selectOption("components", "New Component 1");
        this.selectOption("components", "New Component 2");
        this.submit("Create");
        this.assertTextPresent("New Component 2");
        this.assertTextPresent("New Version 4");
        this.assertTextPresent("New Version 5");
        this.assertLinkPresentWithText("New Component 2");
        this.assertLinkNotPresentWithText("New Version 4");
        this.assertLinkPresentWithText("New Version 5");
        this.navigation.gotoAdminSection("view_projects");
        this.clickLinkWithText("homosapien");
        this.clickLink("edit_permission_scheme");
        this.clickLink("add_perm_10");
        this.checkCheckbox("type", "group");
        this.submit(" Add ");
        this.getDialog().getWebClient().clearContents();
        WebTesterFactory.setupWebTester(this.tester, this.environmentData);
        this.gotoPage("/browse/HSP-1");
        this.assertTextPresent("New Component 2");
        this.assertTextPresent("New Version 4");
        this.assertTextPresent("New Version 5");
        this.assertLinkPresentWithText("New Component 2");
        this.assertLinkNotPresentWithText("New Version 4");
        this.assertLinkPresentWithText("New Version 5");
        WebLink componentLink = this.getDialog().getResponse().getLinkWith("New Component 2");
        this.verifyUrl(componentLink.getURLString());
        WebLink fixVersionLink = this.getDialog().getResponse().getLinkWith("New Version 5");
        this.verifyUrl(fixVersionLink.getURLString());
    }

    private void verifyUrl(String url) {
        String JSESSIONID = "jsessionid";
        int index = url.indexOf("jsessionid");
        int index2 = url.lastIndexOf("jsessionid");
        TestSessionIdInUrl.assertEquals((int)index, (int)index2);
    }
}

