/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

public class TestLoginActions
extends FuncTestCase {
    private static final String NOT_RECORDED = "Not recorded";
    private static final String AUTHENTICATION_ERR_MSG = "Sorry, your username and password are incorrect - please try again.";
    private static final String CAPTCHA_ERR_MSG = "Sorry, your userid is required to answer a CAPTCHA question correctly.";

    public void testLogin() {
        this.navigation.login("admin", "admin");
        this.assertRedirectPath(this.getEnvironmentData().getContext() + "/secure/Dashboard.jspa");
    }

    public void testLoginPageWithNoPassword() {
        this.navigation.login(null, null);
        this.tester.assertTextPresent(AUTHENTICATION_ERR_MSG);
    }

    public void testBadPasswordLogin() {
        this.navigation.login("admin", "bad password");
        this.tester.assertTextPresent(AUTHENTICATION_ERR_MSG);
    }

    public void testGoodPasswordNoPermission() {
        this.administration.restoreBlankInstance();
        this.gotoUserBrowser();
        this.tester.clickLink("fred");
        this.tester.clickLink("editgroups_link");
        this.tester.selectOption("groupsToLeave", "jira-users");
        this.tester.submit("leave");
        this.tester.selectOption("groupsToJoin", "jira-developers");
        this.tester.submit("join");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.assertTextPresent("You do not have a permission to log in.");
    }

    public void testLastLoginInfoIsShown() {
        this.administration.restoreData("TestLastLogin.xml");
        this.gotoUserBrowser();
        TableLocator tableLocator = new TableLocator(this.tester, "user_browser_table");
        this.text.assertTextSequence(tableLocator, "admin", "Today", "fred", NOT_RECORDED, "nouserpermission", NOT_RECORDED);
        this.assertViewUser("admin", true, true, 2L);
        this.assertViewUser("fred", false, false, null);
        this.assertViewUser("nouserpermission", false, false, null);
        this.loginAsAndThenAs("fred", "admin");
        this.gotoUserBrowser();
        tableLocator = new TableLocator(this.tester, "user_browser_table");
        this.text.assertTextSequence(tableLocator, "admin", "Today", "fred", "Today", "nouserpermission", NOT_RECORDED);
        this.assertViewUser("fred", true, false, 1L);
        this.assertViewUser("nouserpermission", false, false, null);
        this.loginAsAndThenAs("fred", "admin");
        this.gotoUserBrowser();
        tableLocator = new TableLocator(this.tester, "user_browser_table");
        this.text.assertTextSequence(tableLocator, "admin", "Today", "fred", "Today", "nouserpermission", NOT_RECORDED);
        this.assertViewUser("fred", true, true, 2L);
        this.assertViewUser("nouserpermission", false, false, null);
        this.loginAsAndThenAs("nouserpermission", "admin");
        this.gotoUserBrowser();
        tableLocator = new TableLocator(this.tester, "user_browser_table");
        this.text.assertTextSequence(tableLocator, "admin", "Today", "fred", "Today", "nouserpermission", NOT_RECORDED);
        this.assertViewUser("fred", true, true, 2L);
        this.assertViewUser("nouserpermission", false, false, null);
    }

    public void testCAPTCHALockedOut() {
        this.administration.restoreData("TestLastLogin.xml");
        this.setMaximumLoginAttempts("3");
        this.loginAsAndThenAs("fred", "FAIL", "admin", false, AUTHENTICATION_ERR_MSG);
        this.assertViewUserFailedAttempts("fred", true, 1L, 1L);
        this.loginAsAndThenAs("fred", "FAIL", "admin", false, AUTHENTICATION_ERR_MSG);
        this.assertViewUserFailedAttempts("fred", true, 2L, 2L);
        this.loginAsAndThenAs("fred", "FAIL", "admin", true, AUTHENTICATION_ERR_MSG);
        this.assertViewUserFailedAttempts("fred", true, 3L, 3L);
        this.resetUserLoginCount("fred");
        this.assertViewUserFailedAttempts("fred", true, 0L, 3L);
        this.loginAsAndThenAs("fred", "FAIL", "admin", false, AUTHENTICATION_ERR_MSG);
        this.assertViewUserFailedAttempts("fred", true, 1L, 4L);
        this.loginAsAndThenAs("fred", "fred", "admin", false, null);
        this.assertViewUserFailedAttempts("fred", true, 0L, 4L);
        this.navigation.login("admin");
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLinkWithText("fred");
        this.tester.clickLinkWithText("Set Password");
        this.tester.setFormElement("password", "fred");
        this.tester.setFormElement("confirm", "fred");
        this.tester.submit("Update");
        this.assertViewUser("fred", true, false, 1L);
    }

    private void resetUserLoginCount(String userName) {
        this.gotoUserBrowser();
        this.tester.clickLinkWithText("Reset Failed Login Count");
    }

    private void setMaximumLoginAttempts(String howMany) {
        this.navigation.gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.setFormElement("title", "jWebTest JIRA installation");
        this.tester.setFormElement("maximumAuthenticationAttemptsAllowed", howMany);
        this.tester.checkCheckbox("captcha", "false");
        this.tester.submit("Update");
    }

    private void gotoUserBrowser() {
        this.navigation.gotoAdminSection("user_browser");
    }

    private void loginAsAndThenAs(String userName1, String userName2) {
        this.loginAsAndThenAs(userName1, userName1, userName2, false, null);
    }

    private void loginAsAndThenAs(String userName1, String userName1password, String userName2, boolean requireCaptcha, String errMsg) {
        this.navigation.logout();
        this.navigation.login(userName1, userName1password);
        this.assertCAPTCHAShown(requireCaptcha);
        if (StringUtils.isNotBlank((String)errMsg)) {
            this.tester.assertTextPresent(errMsg);
        }
        this.navigation.logout();
        this.navigation.login(userName2);
    }

    private void assertViewUser(String userName, boolean lastLoginSet, boolean prevLoginSet, Long loginCount) {
        this.tester.gotoPage("secure/admin/user/ViewUser.jspa?name=" + userName);
        this.navigation.checkWebSudoWithLastPassword();
        this.assertNotRecorded(lastLoginSet, new XPathLocator(this.tester, "//span[@id='lastLogin']"));
        this.assertNotRecorded(prevLoginSet, new XPathLocator(this.tester, "//span[@id='previousLogin']"));
        this.assertLoginNumber(loginCount, "loginCount");
    }

    private void assertViewUserFailedAttempts(String userName, boolean lastFailedLoginSet, Long currentFailedCount, Long totalFailedLoginCount) {
        this.tester.gotoPage("secure/admin/user/ViewUser.jspa?name=" + userName);
        this.navigation.checkWebSudoWithLastPassword();
        this.assertNotRecorded(lastFailedLoginSet, new XPathLocator(this.tester, "//span[@id='lastFailedLogin']"));
        this.assertLoginNumber(currentFailedCount, "currentFailedLoginCount");
        this.assertLoginNumber(totalFailedLoginCount, "totalFailedLoginCount");
    }

    private void assertLoginNumber(Long currentFailedCount, String fieldName) {
        XPathLocator pathLocator = new XPathLocator(this.tester, "//span[@id='" + fieldName + "']");
        if (currentFailedCount != null) {
            this.text.assertTextPresent(pathLocator, String.valueOf(currentFailedCount));
        } else {
            TestLoginActions.assertEquals((String)("The " + fieldName + " should be Not Recorded"), (String)NOT_RECORDED, (String)pathLocator.getText());
        }
    }

    private void assertCAPTCHAShown(boolean requireCaptcha) {
        boolean hasCaptcha = this.tester.getDialog().hasFormParameterNamed("os_captcha");
        TestLoginActions.assertEquals((String)("CAPTCHA should " + (requireCaptcha ? "BE" : "NOT BE") + " present"), (boolean)requireCaptcha, (boolean)hasCaptcha);
    }

    private void assertNotRecorded(boolean lastLoginSet, XPathLocator loc) {
        if (!lastLoginSet) {
            this.text.assertTextPresent(loc, NOT_RECORDED);
        } else {
            this.text.assertTextNotPresent(loc, NOT_RECORDED);
        }
    }

    private void assertRedirectPath(String s) {
        URL url = this.tester.getDialog().getResponse().getURL();
        TestLoginActions.assertEquals((String)s, (String)url.getPath());
    }
}

