/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import java.io.UnsupportedEncodingException;

public class TestDifferentEncodings
extends FuncTestCase {
    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testNonASCIIGroupName() throws UnsupportedEncodingException {
        this.administration.generalConfiguration().setEncoding("ISO-8859-1");
        this.assertCreateGroupEncodesCorrectly("J%FCrgen");
        this.administration.generalConfiguration().setEncoding("UTF-8");
        this.assertCreateGroupEncodesCorrectly("J%C3%BCrgen");
    }

    private void assertCreateGroupEncodesCorrectly(String groupName) {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/jira/GroupBrowser!add.jspa?addName=" + groupName));
        this.text.assertTextPresent("ViewGroup.jspa?atl_token=" + this.page.getXsrfToken() + "&amp;name=" + groupName);
    }
}

