/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.webtests.JIRAWebTest;
import java.io.File;
import java.io.IOException;
import org.junit.Ignore;

@Ignore(value="This test is unreliable, and is messing up our CI. Disabled until someone makes it reliable. --lmiranda")
public class TestCvsIntegration
extends JIRAWebTest {
    private static final String TEST_CVS_INTEGRATION_LOG = "TestCvsIntegration.log";

    public TestCvsIntegration(String name) {
        super(name);
    }

    public void testCommitsWithSimilarProjectKeys() throws InterruptedException {
        this.restoreBlankInstance();
        this.addProject("AHSP", "AHSP", null, "admin", null);
        this.createIssueStep1("homosapien", "Bug");
        this.setFormElement("summary", "First issue");
        this.submit("Create");
        this.createIssueStep1("AHSP", "Bug");
        this.setFormElement("summary", "Second issue");
        this.submit("Create");
        this.addCvsModule("Test", TEST_CVS_INTEGRATION_LOG);
        this.addCvsModuleToProject("AHSP", "Test");
        this.addCvsModuleToProject("homosapien", "Test");
        this.administration.utilities().runServiceNow(10010L);
        this.gotoPage("/browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels:cvs-tabpanel");
        this.assertTextPresent("re-ordered sourcing the base_build_jira script such that the current directory is set correctly");
        this.assertTextNotPresent("Hopefully fixed maven2 build by explicitly setting the path");
        this.gotoPage("/browse/AHSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels:cvs-tabpanel");
        this.assertTextNotPresent("re-ordered sourcing the base_build_jira script such that the current directory is set correctly");
        this.assertTextPresent("Hopefully fixed maven2 build by explicitly setting the path");
    }

    public void testCvsIntegrationMovedIssue() throws InterruptedException {
        this.restoreData("TestCvsIntegrationMovedIssue.xml");
        this.addCvsModule("Test", "TestCvsIntegrationMovedIssue.log");
        this.addCvsModule("NewRepo", "TestCvsIntegrationMovedIssueOtherRepository.log");
        this.assertTextPresent("Test");
        this.assertTextPresent("NewRepo");
        this.addCvsModuleToProject("AHSP", "Test");
        this.addCvsModuleToProject("homosapien", "Test");
        this.addCvsModuleToProject("monkey", "NewRepo");
        this.administration.utilities().runServiceNow(10010L);
        this.navigation.issue().viewIssue("HSP-2");
        this.clickLinkWithText("Version Control");
        this.assertTextPresent("HSP-1 Initial revision");
        this.assertTextPresent("moving to use tmp dir HSP-1 local to build root");
        this.assertTextPresent("massaging temp dir path AHSP-2 references to use absolute rendition of working directory");
        this.assertTextPresent("removing verbose flag on tar MKY-1 zxvf to reduce distracting build log bloat");
        this.assertTextPresent("remove the temp dir deletion if the MKY-1 build failed");
        this.assertTextPresent("MKY-1 Added releaseInfo flag to the source release");
        this.assertTextSequence(new String[]{"HSP-2", "Use maven2 to build source release if a pom.xml file exists"});
        this.assertTextSequence(new String[]{"HSP-2", "Hopefully fixed maven2 build by explicitly setting the path"});
        this.assertTextSequence(new String[]{"HSP-2", "re-ordered sourcing the base_build_jira script such that the current directory is set correctly"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCanNotModify() throws InterruptedException {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.login("root", "root");
            this.addProject("AHSP", "AHSP", null, "admin", null);
            this.addCvsModule("Test", TEST_CVS_INTEGRATION_LOG);
            this.assertLinkPresent("edit_10000");
            this.assertLinkPresent("test_10000");
            this.assertLinkPresent("delete_10000");
            this.assertLinkPresent("add_cvs_module");
            this.login("admin", "admin");
            this.gotoAdmin();
            this.clickLink("cvs_modules");
            this.assertLinkNotPresent("edit_10000");
            this.assertLinkNotPresent("test_10000");
            this.assertLinkNotPresent("delete_10000");
            this.assertLinkNotPresent("add_cvs_module");
            this.assertTextPresent("Only JIRA system administrators can manipulate CVS modules.");
            this.gotoPage("/secure/admin/AddRepository!default.jspa");
            this.navigation.checkWebSudoWithLastPassword();
            this.assertTextPresent("Only JIRA system administrators can manipulate CVS modules.");
            this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/AddRepository.jspa?name=AnotherTest&cvsRoot=someroot&moduleName=dummy&fetchLog=false&logFilePath=/tmp"));
            this.assertTextPresent("You must be a JIRA system administrator to add a CVS repository to JIRA.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    public void testTimeoutOverflow() throws Exception {
        this.restoreBlankInstance();
        this.gotoAdmin();
        this.clickLink("cvs_modules");
        this.clickLink("add_cvs_module");
        this.setFormElement("name", "Test");
        this.setFormElement("cvsRoot", ":pserver:anonymous@example.com:/");
        this.setFormElement("moduleName", "hello");
        this.setFormElement("logFilePath", this.getCvsLogFile(TEST_CVS_INTEGRATION_LOG));
        this.checkCheckbox("fetchLog", "false");
        this.setFormElement("timeout", String.valueOf(3600000));
        this.submit(" Add ");
        this.assertTextPresent("CVS Modules");
        this.text.assertTextSequence(new TableLocator(this.tester, "cvs_modules_table"), "CVS Timeout", "3600000 seconds");
        this.clickLink("edit_10000");
        this.setFormElement("timeout", String.valueOf(9223372036854775707L));
        this.submit(" Update ");
        this.assertTextPresent("CVS Modules");
        this.text.assertTextSequence(new TableLocator(this.tester, "cvs_modules_table"), "CVS Timeout", String.format("%d seconds", 9223372036854775L));
    }

    private void addCvsModuleToProject(String projectName, String repositoryName) {
        this.clickLink("view_projects");
        this.clickLinkWithText(projectName);
        this.clickLinkWithText("Select Module");
        this.selectOption("multipleRepositoryIds", repositoryName);
        this.submit("Select");
    }

    private void addCvsModule(String name, String logfile) {
        this.gotoAdmin();
        this.clickLink("cvs_modules");
        this.clickLinkWithText("Add");
        this.setFormElement("name", name);
        this.setFormElement("cvsRoot", ":pserver:anonymous@example.com:/");
        this.setFormElement("moduleName", "dummy");
        this.checkCheckbox("fetchLog", "false");
        this.setFormElement("logFilePath", this.getCvsLogFile(logfile));
        this.submit(" Add ");
        this.assertTextInTable("cvs_modules_table", name);
    }

    private String getCvsLogFile(String logfile) {
        File dataLocation = new File(this.getEnvironmentData().getXMLDataLocation(), logfile);
        try {
            return dataLocation.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

