/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.webtests.JIRAWebTest;
import junit.framework.AssertionFailedError;

public class TestComponentActions
extends JIRAWebTest {
    public TestComponentActions(String name) {
        super(name);
    }

    public void testComponentActions() {
        this.restoreBlankInstance();
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "Test issue for components", "Major", new String[]{"New Component 3"}, null, null, "Administrator", "test environment", "Issue to be moved from deleted component", null, null, null);
        try {
            this.addComponent("homosapien", "New Component 1");
        }
        catch (AssertionFailedError expectedWeAlreadyHaveComponentOne) {
            // empty catch block
        }
        try {
            this.addComponent("homosapien", "New Component 1".toUpperCase());
        }
        catch (AssertionFailedError expectedWeAlreadyHaveComponentOne) {
            // empty catch block
        }
        try {
            this.addComponent("homosapien", "New Component 1".toLowerCase());
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        this.addProject("monkey", "MKY", "", "admin", "Project for monkeys");
        this.addComponent("monkey", "New Component 1");
        this.setComponentName("monkey", "New Component 1", "New Component 1".toLowerCase());
        this.setComponentName("monkey", "New Component 1".toLowerCase(), "New Component 1");
        this.setComponentName("monkey", "New Component 1", "New Component 1".toUpperCase());
        this.componentActionDeleteComponentWithIssueByMovingIssue(issueKey);
        this.componentActionDeleteComponentWithIssueByDeletingIssue(issueKey);
        this.deleteComponentTest();
        this.deleteIssue(issueKey);
    }

    public void testComponentLead() {
        this.restoreBlankInstance();
        this.deleteComponent("homosapien", "New Component 1");
        this.deleteComponent("homosapien", "New Component 2");
        this.deleteComponent("homosapien", "New Component 3");
        this.gotoAdmin();
        this.goToProject("homosapien");
        this.assertLinkNotPresent("select_component_assignees");
        String userAnn = "annie";
        String fullNameAnn = "Ann Dee";
        this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
        this.addUser("annie", "bob_password", "Ann Dee", "ann@ann.com");
        this.addUserToGroup("bob", "jira-developers");
        this.addUserToGroup("annie", "jira-developers");
        String componentOne = this.addComponent("homosapien", "New Component 1", "bob");
        String componentTwo = this.addComponent("homosapien", "New Component 2", "annie");
        TestComponentActions.log("Assigning components to bob and ann");
        this.assertLinkPresent("select_component_assignees");
        this.clickLink("select_component_assignees");
        this.checkCheckbox("component_" + componentOne, "1");
        this.checkCheckbox("component_" + componentTwo, "2");
        this.submit("Update");
        this.assertTextPresentBeforeText("New Component 1", "Bob The Builder");
        this.assertTextPresentBeforeText("New Component 2", "Ann Dee");
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "Component1 Lead test", "Major", new String[]{"New Component 1"}, null, null, null, null, null, null, null, null);
        this.assertTextPresentBeforeText("Assignee:", "Bob The Builder");
        this.assignIssue(issueKey, "reassign", "Administrator");
        this.deleteIssue(issueKey);
        issueKey = this.addIssue("homosapien", "HSP", "Bug", "Component1 Lead test", "Major", new String[]{"New Component 2"}, null, null, null, null, null, null, null, null);
        this.assertTextPresentBeforeText("Assignee:", "Administrator");
        this.deleteIssue(issueKey);
        this.deleteUser("bob");
        this.deleteUser("annie");
        this.deleteComponent("homosapien", "New Component 1");
        this.deleteComponent("homosapien", "New Component 2");
        this.deleteProject("homosapien");
    }

    public void testComponentDeleteGeneratesChangeHistory() {
        this.restoreData("TestDeleteComponent.xml");
        this.gotoAdmin();
        this.clickLink("admin_link");
        this.clickLinkWithText("homosapien");
        this.clickLink("del_comp_New Component 1");
        this.checkCheckbox("action", "swap");
        this.selectOption("swapComponentId", "New Component 2");
        this.submit("Delete");
        this.assertLastChangeHistoryIs("HSP-1", "Component/s", "10000", "");
        this.assertLastChangeHistoryIs("HSP-1", "Component/s", "", "10001");
    }

    public void testComponentDeleteMigrateToExistingComponent() {
        this.restoreData("TestDeleteComponent.xml");
        this.gotoAdmin();
        this.clickLink("admin_link");
        this.clickLinkWithText("homosapien");
        this.clickLink("del_comp_New Component 1");
        this.checkCheckbox("action", "swap");
        this.selectOption("swapComponentId", "New Component 2");
        this.submit("Delete");
        this.assertLastChangeHistoryIs("HSP-2", "Component/s", "10000", "");
    }

    public void testComponentDeleteNoMigrationGeneratesChangeHistory() {
        this.restoreData("TestDeleteComponent.xml");
        this.gotoAdmin();
        this.clickLink("admin_link");
        this.clickLinkWithText("homosapien");
        this.clickLink("del_comp_New Component 1");
        this.checkCheckbox("action", "remove");
        this.submit("Delete");
        this.assertLastChangeHistoryIs("HSP-1", "Component/s", "10000", "");
    }

    public void testGetOtherComponentOnDelete() {
        this.restoreData("TestDeleteComponent.xml");
        this.gotoAdmin();
        this.clickLink("admin_link");
        this.clickLinkWithText("homosapien");
        this.clickLink("del_comp_New Component 1");
        this.checkCheckbox("action", "swap");
        this.assertOptionNotPresent("swapComponentId", "New Component 1");
        this.selectOption("swapComponentId", "New Component 2");
        this.selectOption("swapComponentId", "New Component 3");
    }

    public void testComponentDeleteSwapReindexesIssue() {
        this.restoreData("TestDeleteComponent.xml");
        this.gotoAdmin();
        this.clickLink("admin_link");
        this.clickLinkWithText("homosapien");
        this.clickLink("del_comp_New Component 1");
        this.checkCheckbox("action", "swap");
        this.selectOption("swapComponentId", "New Component 2");
        this.submit("Delete");
        this.clickLink("find_link");
        this.selectOption("pid", "homosapien");
        this.submit("show");
        this.assertTextNotPresent("New Component 1");
        this.selectOption("component", "New Component 2");
        this.submit("show");
        this.assertTextPresent("HSP-1");
    }

    public void testComponentDeleteRemoveComponentWithoutSwap() {
        this.restoreData("TestDeleteComponent.xml");
        this.gotoIssue("HSP-1");
        this.assertTextPresent("Component 1");
        this.assertTextNotPresent("Component 2");
        this.assertTextNotPresent("Component 3");
        this.getNavigation().gotoAdminSection("view_projects");
        this.clickLinkWithText("homosapien");
        this.clickLink("del_comp_New Component 1");
        this.checkCheckbox("action", "remove");
        this.submit("Delete");
        this.gotoIssue("HSP-1");
        this.assertTextNotPresent("Component 1");
        this.assertTextNotPresent("Component 2");
        this.assertTextNotPresent("Component 3");
    }

    private void deleteComponentTest() {
        TestComponentActions.log("Deleting a component");
        this.deleteComponent("homosapien", "New Component 1");
        this.assertTextNotPresent("New Component 1");
    }

    private void componentActionDeleteComponentWithIssueByMovingIssue(String issueKey) {
        TestComponentActions.log("Component Action: Test the operation to move issues to another component if component is deleted");
        this.goToProject("homosapien");
        this.assertLinkPresent("del_comp_New Component 3");
        this.clickLink("del_comp_New Component 3");
        this.selectOption("swapComponentId", "New Component 2");
        this.submit();
        this.assertTextNotPresent("New Component 3");
        this.gotoIssue(issueKey);
        this.assertTextPresent("New Component 2");
    }

    private void componentActionDeleteComponentWithIssueByDeletingIssue(String issueKey) {
        TestComponentActions.log("Component Action: Test the operation to remove issues from a component if component is deleted");
        this.goToProject("homosapien");
        this.assertLinkPresent("del_comp_New Component 2");
        this.clickLink("del_comp_New Component 2");
        this.getDialog().setFormParameter("action", "remove");
        this.assertRadioOptionSelected("action", "remove");
        this.submit();
        this.gotoIssue(issueKey);
        this.assertTextPresent("None");
    }
}

