/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;

public class TestAnnouncementBanner
extends JIRAWebTest {
    private static final String ANNOUNCEMENT = "<p>JIRA 3.4 IS NOW INSTALLED <a href=\"http://confluence.atlassian.com/display/JIRA/JIRA+3.4+and+3.4.1+Release%20Notes\" target=\"_blank\">Review Release Notes Here</a></p>";

    public TestAnnouncementBanner(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnouncementBanner() {
        try {
            this.setBannerText(ANNOUNCEMENT);
        }
        finally {
            this.clearBannerText();
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnouncementBannerDoesNotShowInPrivateModeWithNoUser() {
        try {
            this.setBannerText(ANNOUNCEMENT);
            this.setBannerDisplayMode(false);
            this.logout();
            this.beginAt("/secure/Dashboard.jspa");
            this.assertTextNotPresent(ANNOUNCEMENT);
        }
        finally {
            this.login("admin", "admin");
            this.clearBannerText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnouncementBannerShownInPublicModeWithNoUser() {
        try {
            this.setBannerText(ANNOUNCEMENT);
            this.setBannerDisplayMode(true);
            this.logout();
            this.beginAt("/secure/Dashboard.jspa");
            this.assertTextPresent(ANNOUNCEMENT);
        }
        finally {
            this.login("admin", "admin");
            this.clearBannerText();
        }
    }

    private void setJIRAModePublic(boolean publicMode) {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        this.selectOption("mode", publicMode ? "Public" : "Private");
        this.submit();
    }

    protected void setBannerDisplayMode(boolean isPublic) {
        this.gotoAdmin();
        this.clickLink("edit_announcement");
        if (isPublic) {
            this.checkCheckbox("bannerVisibility", "public");
        } else {
            this.checkCheckbox("bannerVisibility", "private");
        }
        this.submit("Set Banner");
    }

    protected void clearBannerText() {
        this.gotoBannerPage();
        this.setFormElement("announcement", "");
        this.submit();
    }

    protected void setBannerText(String bannerText) {
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.gotoBannerPage();
        this.setFormElement("announcement", bannerText);
        this.submit();
        this.assertTextPresent(bannerText);
    }

    protected void gotoBannerPage() {
        this.gotoAdmin();
        this.clickLink("edit_announcement");
    }
}

