/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import net.sourceforge.jwebunit.TestContext;

public class Test500Page
extends FuncTestCase {
    private boolean isBeforeJdk = false;

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("Test500Page.xml");
        this.isBeforeJdk = new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isJavaBeforeJdk15();
        this.navigation.gotoDashboard();
    }

    public void test500PageServiceParamVisibility() {
        this.navigation.login("admin", "admin");
        this.tester.gotoPage("/500page.jsp");
        this.text.assertTextSequence(this.locator.page(), "ParamListeners", "com.atlassian.jira.event.listeners.DebugParamListener");
        this.text.assertTextSequence(this.locator.page(), "Param1:", "paramKey");
        this.text.assertTextSequence(this.locator.page(), "Param2:", "paramValue");
        this.assertServiceHeaderPresent("Pop Service", "com.atlassian.jira.service.services.pop.PopService", "123");
        this.text.assertTextSequence(this.locator.page(), "usessl:", "No SSL");
        this.text.assertTextSequence(this.locator.page(), "popserver:", "fake server");
        this.text.assertTextSequence(this.locator.page(), "handler.params:", "project=hsp, issuetype=1, catchemail=sam@atlassian.com");
        this.text.assertTextSequence(this.locator.page(), "forwardEmail:", "fake@example.com");
        this.text.assertTextSequence(this.locator.page(), "handler:", "Create Or Comment Handler");
        this.navigation.logout();
        this.tester.gotoPage("/500page.jsp");
        this.text.assertTextSequence(this.locator.page(), "ParamListeners", "com.atlassian.jira.event.listeners.DebugParamListener");
        this.text.assertTextNotPresent(this.locator.page(), "Param1:");
        this.text.assertTextNotPresent(this.locator.page(), "paramKey");
        this.text.assertTextNotPresent(this.locator.page(), "Param2:");
        this.text.assertTextNotPresent(this.locator.page(), "paramValue");
        this.assertServiceHeaderPresent("Pop Service", "com.atlassian.jira.service.services.pop.PopService", "123");
        this.assertServiceParamsNotVisible();
        this.navigation.login("bob", "bob_password");
        this.tester.gotoPage("/500page.jsp");
        this.text.assertTextSequence(this.locator.page(), "ParamListeners", "com.atlassian.jira.event.listeners.DebugParamListener");
        this.text.assertTextNotPresent(this.locator.page(), "Param1:");
        this.text.assertTextNotPresent(this.locator.page(), "paramKey");
        this.text.assertTextNotPresent(this.locator.page(), "Param2:");
        this.text.assertTextNotPresent(this.locator.page(), "paramValue");
        this.assertServiceHeaderPresent("Pop Service", "com.atlassian.jira.service.services.pop.PopService", "123");
        this.assertServiceParamsNotVisible();
    }

    public void test500PageContainsMemoryAndInputArgsInfo() {
        this.tester.gotoPage("/500page.jsp");
        this.text.assertTextPresent(this.locator.page(), "Used PermGen Memory");
        this.text.assertTextPresent(this.locator.page(), "Free PermGen Memory");
        this.text.assertTextPresent(this.locator.page(), "JVM Input Arguments");
        if (this.isBeforeJdk) {
            this.text.assertTextPresent(this.locator.page(), "Unable to determine, this requires running JDK 1.5 and higher.");
        } else {
            this.text.assertTextNotPresent(this.locator.page(), "Unable to determine, this requires running JDK 1.5 and higher.");
        }
    }

    public void testExternalUserManagement() {
        this.tester.gotoPage("/500page.jsp");
        this.text.assertTextPresent(this.locator.page(), "External user management");
    }

    public void testHtmlEscapingOfErrors() throws Exception {
        String badHtml = "<body onload=alert('XSSATTACK')>";
        String badHtmlEscaped = "%3Cbody%20onload=alert('XSSATTACK')%3E";
        GetMethodWebRequest request = new GetMethodWebRequest(this.getEnvironmentData().getBaseUrl() + "/secure/Dashboard!default" + badHtmlEscaped + ".jspa");
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        webClient.setExceptionsThrownOnErrorStatus(false);
        WebResponse response = webClient.sendRequest((WebRequest)request);
        String responseText = response.getText();
        Test500Page.assertFalse((String)"Found bad HTML in the response", (responseText.indexOf(badHtml) >= 0 ? 1 : 0) != 0);
    }

    public void testAdministratorDoesntSeeContactYourAdmin() {
        this.tester.gotoPage("/500page.jsp");
        this.text.assertTextNotPresent(this.locator.page(), "If this problem persists - please notify your JIRA administrator of this problem.");
        this.text.assertTextSequence(this.locator.page(), "try submitting this problem via the", "Support Request Page");
    }

    public void testNonAdministratorSeesContactYourAdmin() {
        this.navigation.login("bob", "bob_password");
        this.tester.gotoPage("/500page.jsp");
        this.text.assertTextPresent(this.locator.page(), "If this problem persists - please notify your JIRA administrator of this problem.");
        this.text.assertTextNotPresent(this.locator.page(), "try submitting this problem via the");
        this.text.assertTextNotPresent(this.locator.page(), "Support Request Page");
    }

    public void testSystemAdministratorCanSeeSysAdminOnlyProperties() {
        this.tester.gotoPage("/500page.jsp");
        this.text.assertTextNotPresent(this.locator.page(), "Contact your System Administrator to discover file path information.");
        this.text.assertTextNotPresent(this.locator.page(), "Contact your System Administrator to discover this property value.");
        this.text.assertTextSequence(this.locator.page(), "Server ID", "ABN9-RZYJ-WI2T-37UF");
        this.text.assertTextSequence(this.locator.page(), "attach the application server log file (", "atlassian-jira.log", ")");
        this.text.assertTextSequence(this.locator.page(), "File Paths:", "entityengine.xml", "atlassian-jira.log");
        this.text.assertTextPresent(this.locator.page(), "JVM Input Arguments");
        if (!this.isBeforeJdk) {
            this.text.assertTextPresent(this.locator.page(), "-D");
        }
        this.text.assertTextPresent(this.locator.page(), "Current Working Directory");
    }

    public void testNonSystemAdministratorDoesntSeeFilePaths() {
        this.navigation.login("bob", "bob_password");
        this.tester.gotoPage("/500page.jsp");
        this.text.assertTextNotPresent(this.locator.page(), "attach the application server log file");
        this.text.assertTextNotPresent(this.locator.page(), "atlassian-jira.log");
        this.text.assertTextSequence(this.locator.page(), "Server ID", "Contact your Administrator to discover this property value.", "File Paths:", "Contact your System Administrator to discover file path information.", "Current Working Directory", "Contact your System Administrator to discover this property value.", "JVM Input Arguments", "Contact your System Administrator to discover this property value.");
        this.text.assertTextNotPresent(this.locator.page(), "-Xmx");
        this.navigation.login("admin_non_sysadmin", "admin_non_sysadmin");
        this.tester.gotoPage("/500page.jsp");
        this.text.assertTextSequence(this.locator.page(), "Server ID", "ABN9-RZYJ-WI2T-37UF", "File Paths:", "Contact your System Administrator to discover file path information.", "Current Working Directory", "Contact your System Administrator to discover this property value.", "JVM Input Arguments", "Contact your System Administrator to discover this property value.");
        this.text.assertTextNotPresent(this.locator.page(), "-Xmx");
    }

    private void assertServiceHeaderPresent(String serviceName, String serviceClass, String delay) {
        this.text.assertTextSequence(this.locator.page(), "Services", serviceName, serviceClass, "Delay:", delay, "minutes");
    }

    private void assertServiceParamsNotVisible() {
        this.text.assertTextNotPresent(this.locator.page(), "usessl:");
        this.text.assertTextNotPresent(this.locator.page(), "No SSL");
        this.text.assertTextNotPresent(this.locator.page(), "popserver:");
        this.text.assertTextNotPresent(this.locator.page(), "fake server");
        this.text.assertTextNotPresent(this.locator.page(), "handler.params:");
        this.text.assertTextNotPresent(this.locator.page(), "project=hsp, issuetype=1, catchemail=sam@atlassian.com");
        this.text.assertTextNotPresent(this.locator.page(), "forwardEmail:");
        this.text.assertTextNotPresent(this.locator.page(), "fake@example.com");
        this.text.assertTextNotPresent(this.locator.page(), "handler:");
        this.text.assertTextNotPresent(this.locator.page(), "Create Or Comment Handler");
    }
}

