/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.util.dbc.Null;
import com.meterware.httpunit.WebForm;
import java.io.IOException;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class TestXsrfIssue
extends FuncTestCase {
    private static final String MY_SUMMARY = "My Summary";
    public static final String ATL_TOKEN = "atl_token";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("blankprojects.xml");
    }

    public void testXsrfPageCanBeRetried() {
        this.standardCreateIssueSetup();
        this.removeClientSideToken();
        this.tester.submit("Create");
        this.assertions.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), "XSRF Security Token Missing", "JIRA could not complete this action due to a missing form token", "The original input has been captured and you can retry the operation");
        this.tester.submit("atl_token_retry_button");
        this.assertions.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), "MKY-1", MY_SUMMARY, "Type:", "Bug", "Status:", "Open");
    }

    public void testXsrfPageSessionCanBeRetried() {
        this.standardCreateIssueSetup();
        this.removeJSessionID();
        this.tester.submit("Create");
        this.assertions.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), "Session Expired", "JIRA could not complete this action because your session has expired", "We have captured the submitted values");
    }

    private void removeJSessionID() {
        this.tester.getDialog().getWebClient().removeCookie("JSESSIONID");
    }

    private void standardCreateIssueSetup() {
        this.tester.clickLink("create_link");
        this.tester.selectOption("pid", "monkey");
        this.tester.selectOption("issuetype", "Bug");
        this.tester.submit();
        this.tester.setFormElement("summary", MY_SUMMARY);
        this.tester.setFormElement("description", "My description");
    }

    private void removeClientSideToken() {
        for (WebForm webForm : this.form.getForms()) {
            if (webForm.hasParameterNamed(ATL_TOKEN)) {
                webForm.getScriptableObject().setParameterValue(ATL_TOKEN, "invalidToken");
            }
            webForm.getScriptableObject().setAction(XsrfCheck.invalidTokenInUrl(webForm.getAction()));
        }
    }

    public void testCreateIssue() throws Exception {
        new XsrfTestSuite(new XsrfCheck("CreateIssue", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfIssue.this.standardCreateIssueSetup();
            }
        }, new XsrfCheck.FormSubmission("Create"))).run(this.funcTestHelperFactory);
    }

    public void testWorkFlowActions() throws Exception {
        new XsrfTestSuite(new XsrfCheck("StartProgress", new CreateAndViewIssue(), new XsrfCheck.LinkWithTextSubmission("Start Progress")), new XsrfCheck("StopProgress", new CreateViewIssueAndStartProgress(), new XsrfCheck.LinkWithTextSubmission("Stop Progress")), new XsrfCheck("Resolve Issue", new CreateViewIssueAndAssignComment("Resolve Issue"), new XsrfCheck.FormSubmission("Transition")), new XsrfCheck("Close Issue", new CreateViewIssueAndAssignComment("Close Issue"), new XsrfCheck.FormSubmission("Transition")), new XsrfCheck("Reopen Issue", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLinkWithText("Resolve Issue");
                TestXsrfIssue.this.tester.submit("Transition");
                TestXsrfIssue.this.tester.clickLinkWithText("Reopen Issue");
            }
        }, new XsrfCheck.FormSubmission("Transition"))).run(this.funcTestHelperFactory);
    }

    public void testIssueLinking() {
        this.administration.issueLinking().enable();
        this.administration.issueLinking().addIssueLink("link", "inward", "outward");
        String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
        String issueKey2 = this.navigation.issue().createIssue("monkey", "Bug", "My Bug2");
        this.navigation.issue().viewIssue(issueKey);
        StringBuilder url = new StringBuilder().append("/secure/LinkExistingIssue.jspa?atl_token=").append("invalidtoken").append("&id=").append(this.getIssueIdWithIssueKey(issueKey)).append("&linkDesc=").append("inward").append("&currentIssueKey=").append(issueKey).append("&linkKey=").append(issueKey2);
        this.navigation.gotoPage(url.toString());
        this.text.assertTextPresent(new WebPageLocator(this.tester), "JIRA could not complete this action due to a missing form token.");
        url = new StringBuilder().append("/secure/LinkExistingIssue.jspa?atl_token=").append(this.page.getXsrfToken()).append("&id=").append(this.getIssueIdWithIssueKey(issueKey)).append("&linkDesc=").append("inward").append("&currentIssueKey=").append(issueKey).append("&linkKey=").append(issueKey2);
        this.navigation.gotoPage(url.toString());
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "JIRA could not complete this action due to a missing form token.");
    }

    private String getIssueIdWithIssueKey(String issueKey) {
        String issueId;
        this.navigation.issue().gotoIssue(issueKey);
        try {
            String text = this.tester.getDialog().getResponse().getText();
            String paramName = "ViewVoters!default.jspa?id=";
            int issueIdLocation = text.indexOf(paramName) + paramName.length();
            issueId = text.substring(issueIdLocation, issueIdLocation + 5);
            this.log("issueId = " + issueId);
        }
        catch (IOException e) {
            TestXsrfIssue.fail((String)("Unable to retrieve issue id" + e.getMessage()));
            return "fail";
        }
        return issueId;
    }

    public void testIssueOperations() throws Exception {
        this.administration.usersAndGroups().addUser("my-user");
        this.administration.usersAndGroups().addUserToGroup("my-user", "jira-developers");
        this.administration.attachments().enable();
        this.administration.enableTrackBacks();
        this.administration.activateSubTasks();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(35, "jira-users");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(43, "jira-users");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(41, "jira-users");
        new XsrfTestSuite(new XsrfCheck("Assign - another user", new CreateViewIssueAndAssignComment("Assign", "my-user"), new XsrfCheck.FormSubmission("Assign"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Assign - to me", new CreateAndViewIssue("my-user"), new XsrfCheck.LinkWithTextSubmission("Assign To Me"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Attach file", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLinkWithText("Attach file");
            }
        }, new XsrfCheck.FormSubmission("Attach"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Delete Attachment", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfIssue.this.administration.restoreData("TestCloneIssueAttachments.xml");
                TestXsrfIssue.this.navigation.gotoPage("/secure/DeleteAttachment!default.jspa?id=10032&deleteAttachmentId=10020");
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Clone", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfIssue.this.administration.restoreData("blankprojects.xml");
                TestXsrfIssue.this.administration.usersAndGroups().addUser("my-user");
                TestXsrfIssue.this.administration.usersAndGroups().addUserToGroup("my-user", "jira-developers");
                TestXsrfIssue.this.administration.attachments().enable();
                TestXsrfIssue.this.administration.enableTrackBacks();
                TestXsrfIssue.this.administration.activateSubTasks();
                TestXsrfIssue.this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
                TestXsrfIssue.this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(35, "jira-users");
                TestXsrfIssue.this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(43, "jira-users");
                TestXsrfIssue.this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(41, "jira-users");
                new CreateViewIssueAndAssignComment("Clone").setup();
            }
        }, new XsrfCheck.FormSubmission("Create"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Add Comment", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLinkWithText("Comment");
                TestXsrfIssue.this.tester.setFormElement("comment", "This is a comment");
            }
        }, new XsrfCheck.FormSubmission("Add"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Delete Comment", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLinkWithText("Comment");
                TestXsrfIssue.this.tester.setWorkingForm("comment-add");
                TestXsrfIssue.this.tester.setFormElement("comment", "This is a comment");
                TestXsrfIssue.this.tester.submit("Add");
                XPathLocator locator = new XPathLocator(TestXsrfIssue.this.tester, "//div[@id='issue_actions_container']//span[text()='Delete']");
                Node node = locator.getNode();
                Null.not("node", node);
                String linkId = ((Attr)node.getParentNode().getAttributes().getNamedItem("id")).getValue();
                TestXsrfIssue.this.tester.clickLink(linkId);
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Edit Comment", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLinkWithText("Comment");
                TestXsrfIssue.this.tester.setFormElement("comment", "This is a comment");
                TestXsrfIssue.this.tester.setWorkingForm("comment-add");
                TestXsrfIssue.this.tester.submit("Add");
                XPathLocator locator = new XPathLocator(TestXsrfIssue.this.tester, "//div[@id='issue_actions_container']//span[text()='Edit']");
                Node node = locator.getNode();
                Null.not("node", node);
                String linkId = ((Attr)node.getParentNode().getAttributes().getNamedItem("id")).getValue();
                TestXsrfIssue.this.tester.clickLink(linkId);
            }
        }, new XsrfCheck.FormSubmission("Save"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Create sub-task", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLinkWithText("sub-task");
                TestXsrfIssue.this.tester.setFormElement("summary", "This is my subtask");
            }
        }, new XsrfCheck.FormSubmission("Create"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Delete", new CreateViewIssueAndAssignComment("Delete"), new XsrfCheck.FormSubmission("Delete"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Edit", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLinkWithText("Edit");
                TestXsrfIssue.this.tester.setFormElement("description", "My edit description");
            }
        }, new XsrfCheck.FormSubmission("Update"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Move", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLinkWithText("Move");
                TestXsrfIssue.this.tester.selectOption("pid", "homosapien");
                TestXsrfIssue.this.tester.submit("Next >>");
                TestXsrfIssue.this.tester.submit("Next >>");
            }
        }, new XsrfCheck.FormSubmission("Move"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Convert to sub-task", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
                String issueKey2 = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug2");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLinkWithText("Convert");
                TestXsrfIssue.this.tester.setFormElement("parentIssueKey", issueKey2);
                TestXsrfIssue.this.tester.submit("Next >>");
                TestXsrfIssue.this.tester.submit("Next >>");
            }
        }, new XsrfCheck.FormSubmission("Finish"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Move this subtask", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
                String issueKey2 = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug2");
                String issueKey3 = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug3");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLinkWithText("Convert");
                TestXsrfIssue.this.tester.setFormElement("parentIssueKey", issueKey2);
                TestXsrfIssue.this.tester.submit("Next >>");
                TestXsrfIssue.this.tester.submit("Next >>");
                TestXsrfIssue.this.tester.submit("Finish");
                TestXsrfIssue.this.tester.clickLinkWithText("Move");
                TestXsrfIssue.this.tester.checkCheckbox("operation", "move.subtask.parent.operation.name");
                TestXsrfIssue.this.tester.submit("Next >>");
                TestXsrfIssue.this.tester.setFormElement("parentIssue", issueKey3);
            }
        }, new XsrfCheck.FormSubmission("Change Parent"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Convert to Issue", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
                String issueKey2 = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug2");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLinkWithText("Convert");
                TestXsrfIssue.this.tester.setFormElement("parentIssueKey", issueKey2);
                TestXsrfIssue.this.tester.submit("Next >>");
                TestXsrfIssue.this.tester.submit("Next >>");
                TestXsrfIssue.this.tester.submit("Finish");
                TestXsrfIssue.this.tester.clickLinkWithText("Convert");
                TestXsrfIssue.this.tester.submit("Next >>");
                TestXsrfIssue.this.tester.submit("Next >>");
            }
        }, new XsrfCheck.FormSubmission("Finish"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Add subtask", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
                String issueKey2 = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug2");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLinkWithText("Convert");
                TestXsrfIssue.this.tester.setFormElement("parentIssueKey", issueKey2);
                TestXsrfIssue.this.tester.submit("Next >>");
                TestXsrfIssue.this.tester.submit("Next >>");
                TestXsrfIssue.this.tester.submit("Finish");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey2);
                TestXsrfIssue.this.tester.setFormElement("summary", "my subtask");
            }
        }, new XsrfCheck.FormSubmission(""))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Log Work", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLinkWithText("Log Work");
                TestXsrfIssue.this.tester.setFormElement("timeLogged", "1h");
            }
        }, new XsrfCheck.FormSubmission("Log"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Delete Work Log", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLinkWithText("Log Work");
                TestXsrfIssue.this.tester.setFormElement("timeLogged", "1h");
                TestXsrfIssue.this.tester.submit("Log");
                TestXsrfIssue.this.tester.clickLinkWithText("All");
                TestXsrfIssue.this.tester.clickLinkWithText("Work Log");
                XPathLocator locator = new XPathLocator(TestXsrfIssue.this.tester, "//div[@id='issue_actions_container']//span[text()='Delete']");
                Node node = locator.getNode();
                Null.not("node", node);
                String linkId = ((Attr)node.getParentNode().getAttributes().getNamedItem("id")).getValue();
                TestXsrfIssue.this.tester.clickLink(linkId);
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.funcTestHelperFactory);
        new XsrfTestSuite(new XsrfCheck("Edit Work Log", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLinkWithText("Log Work");
                TestXsrfIssue.this.tester.setFormElement("timeLogged", "1h");
                TestXsrfIssue.this.tester.submit("Log");
                TestXsrfIssue.this.tester.clickLinkWithText("All");
                TestXsrfIssue.this.tester.clickLinkWithText("Work Log");
                XPathLocator locator = new XPathLocator(TestXsrfIssue.this.tester, "//div[@id='issue_actions_container']//span[text()='Edit']");
                Node node = locator.getNode();
                Null.not("node", node);
                String linkId = ((Attr)node.getParentNode().getAttributes().getNamedItem("id")).getValue();
                TestXsrfIssue.this.tester.clickLink(linkId);
            }
        }, new XsrfCheck.FormSubmission("Log"))).run(this.funcTestHelperFactory);
    }

    public void testVotingOrWatching() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.logout();
        this.navigation.login("fred");
        final String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
        this.navigation.login("admin");
        new XsrfTestSuite(new XsrfCheck("Vote for an issue", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
            }
        }, new XsrfCheck.LinkWithIdSubmission("vote-toggle")), new XsrfCheck("Watch an issue", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
            }
        }, new XsrfCheck.LinkWithIdSubmission("watching-toggle")), new XsrfCheck("Unvote an issue", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLink("vote-toggle");
            }
        }, new XsrfCheck.LinkWithIdSubmission("vote-toggle")), new XsrfCheck("Unwatch an issue", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
                TestXsrfIssue.this.tester.clickLink("watching-toggle");
            }
        }, new XsrfCheck.LinkWithIdSubmission("watching-toggle")), new XsrfCheck("View Voters - Un Vote", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfIssue.this.tester.gotoPage("secure/ViewVoters!default.jspa?id=10000");
            }
        }, new XsrfCheck.LinkWithIdSubmission("unvote")), new XsrfCheck("View Voters - Vote", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfIssue.this.tester.gotoPage("secure/ViewVoters!default.jspa?id=10000");
            }
        }, new XsrfCheck.LinkWithIdSubmission("vote")), new XsrfCheck("Manager Watches - Un Watch", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfIssue.this.tester.gotoPage("secure/ManageWatchers!default.jspa?id=10000");
            }
        }, new XsrfCheck.LinkWithIdSubmission("unwatch")), new XsrfCheck("Manager Watches - Watch", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfIssue.this.tester.gotoPage("secure/ManageWatchers!default.jspa?id=10000");
            }
        }, new XsrfCheck.LinkWithIdSubmission("watch")), new XsrfCheck("Manager Watches - Add Watcher", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfIssue.this.tester.gotoPage("secure/ManageWatchers!default.jspa?id=10000");
                TestXsrfIssue.this.tester.setFormElement("userNames", "fred");
            }
        }, new XsrfCheck.FormSubmission("add"))).run(this.funcTestHelperFactory);
    }

    class CreateViewIssueAndAssignComment
    implements XsrfCheck.Setup {
        private String linkText;
        private String assignee;

        public CreateViewIssueAndAssignComment(String linkText, String assignee) {
            this.linkText = linkText;
            this.assignee = assignee;
        }

        public CreateViewIssueAndAssignComment(String linkText) {
            this.linkText = linkText;
        }

        @Override
        public void setup() {
            String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
            TestXsrfIssue.this.tester.clickLinkWithText(this.linkText);
            if (this.assignee != null) {
                TestXsrfIssue.this.tester.selectOption("assignee", this.assignee);
            }
        }
    }

    class CreateViewIssueAndStartProgress
    implements XsrfCheck.Setup {
        CreateViewIssueAndStartProgress() {
        }

        @Override
        public void setup() {
            String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
            TestXsrfIssue.this.tester.clickLinkWithText("Start Progress");
        }
    }

    class CreateAndViewIssue
    implements XsrfCheck.Setup {
        String assignee;

        public CreateAndViewIssue() {
        }

        public CreateAndViewIssue(String assignee) {
            this.assignee = assignee;
        }

        @Override
        public void setup() {
            String issueKey = TestXsrfIssue.this.navigation.issue().createIssue("monkey", "Bug", "My Bug");
            if (this.assignee != null) {
                TestXsrfIssue.this.navigation.issue().assignIssue(issueKey, "", this.assignee);
            }
            TestXsrfIssue.this.navigation.issue().viewIssue(issueKey);
        }
    }
}

