/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.assign;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestAssignUserProgress
extends JIRAWebTest {
    public static final String TESTCOMMENT = "testing progress inconsistency";
    public static final String INPROGRESS = "In Progress";

    public TestAssignUserProgress(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void testChangeProgresswithAssign() {
        this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
        this.addUserToGroup("bob", "jira-developers");
        this.addProject("homosapien", "HSP", "", "admin", "homosapien");
        String key = this.addIssue("homosapien", "HSP", "Bug", TESTCOMMENT);
        this.gotoIssue(key);
        this.clickLinkWithText("Start Progress");
        this.assignIssue(key, TESTCOMMENT, "Bob The Builder");
        this.assertTextPresent(INPROGRESS);
    }

    public void testChangeProgresswithEdit() {
        this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
        this.addUserToGroup("bob", "jira-developers");
        this.addProject("homosapien", "HSP", "", "admin", "homosapien");
        String key = this.addIssue("homosapien", "HSP", "Bug", TESTCOMMENT);
        this.gotoIssue(key);
        this.clickLinkWithText("Start Progress");
        this.clickLinkWithText("Edit");
        this.selectOption("assignee", "Bob The Builder");
        this.submit("Update");
        this.assertTextPresent(INPROGRESS);
    }
}

