/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.meterware.httpunit.WebLink;
import junit.framework.AssertionFailedError;
import org.xml.sax.SAXException;

public class TestWikiRendererXSS
extends FuncTestCase {
    public void testCodeMacro() {
        this.administration.restoreData("TestWikiRendererXSSInLink.xml");
        this.navigation.issue().addComment("HSP-1", "{code:lang=x\"</pre><script>alert(1)</script>}xxx{code}", null);
        this.navigation.issue().viewIssue("HSP-1");
        String xpath = "//div[@id='comment-10020']/div[1]//pre";
        this.assertions.assertNodeDoesNotHaveText("//div[@id='comment-10020']/div[1]//pre", "alert(1)\">xxx");
        this.assertions.assertNodeHasText("//div[@id='comment-10020']/div[1]//pre", "xxx");
    }

    public void testXSSLinks() {
        this.administration.restoreData("TestWikiRendererXSSInLink.xml");
        this.navigation.issue().viewIssue("HSP-1");
        this.assertLinkPresent("test email link", "mailto:whatever@broken.com\" onclick=\"alert('hi. I am a fun onclick event')");
        this.assertLinkPresent("test file link", "file:anything\" onclick=\"alert('hi. I am a fun onclick event')");
        this.assertLinkPresent("test http link", "http://www.atlassian.com\" onclick=\"alert('hi. I am a fun onclick event')");
        this.assertLinkPresent("bad user", "secure/ViewProfile.jspa?name=bad%22+onclick%3Dalert%28%27bad%27%29");
        this.assertLinkPresent("attachment xss", "secure/attachment/10000/10000_%23b+onclick%3Dalert%28%27b%27%29.png");
        this.assertLinkPresent("escaped", "<escaped>");
        WebLink anchorLink = this.getLinkWithName("anchor");
        TestWikiRendererXSS.assertEquals((String)"brenden\" onclick=\"alert('XSS')", (String)anchorLink.getFragmentIdentifier());
    }

    private void assertLinkPresent(String linkName, String urlSuffix) {
        WebLink webLink = this.getLinkWithName(linkName);
        TestWikiRendererXSS.assertTrue((String)("Link should have ended with '" + urlSuffix + "' but actually was '" + webLink.getURLString() + "'"), (boolean)webLink.getURLString().endsWith(urlSuffix));
    }

    private WebLink getLinkWithName(String linkName) {
        try {
            return this.tester.getDialog().getResponse().getLinkWith(linkName);
        }
        catch (SAXException e) {
            AssertionFailedError error = new AssertionFailedError("Unable to read in document to find link with text'" + linkName + "'.");
            error.initCause((Throwable)e);
            throw error;
        }
    }
}

