/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestIssueSecurityWithCustomFields
extends FuncTestCase {
    private static final String GROUP_CUSTOM_FIELD_ID = "customfield_10001";
    private static final String USER_CUSTOM_FIELD_ID = "customfield_10010";
    private static final String GROUP_CF_ISSUE_ID = "HSP-1";
    private static final String USER_CF_ISSUE_ID = "MKY-1";
    private static final String SELECT_CUSTOM_ISSUE_ID_BIGADMIN = "MKY-3";
    private static final String SELECT_CUSTOM_ISSUE_ID_LITTLEADMIN = "MKY-2";
    private static final String PERMISSION_VIOLATION_ERROR = "It seems that you have tried to perform an operation which you are not permitted to perform.";
    private static final String DISPLAYING_ISSUES_COUNT = "Displaying issues <span id=\"results-count-start\">1</span> to 1";

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueSecurityWithCustomFields.xml");
        this.navigation.login("admin");
    }

    public void testIssueSecurityWithCustomField() {
        this.navigation.issueNavigator().displayAllIssues();
        this.text.assertTextPresent(GROUP_CF_ISSUE_ID);
        this.navigation.issue().gotoIssue(GROUP_CF_ISSUE_ID);
        this.text.assertTextNotPresent(PERMISSION_VIOLATION_ERROR);
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issueNavigator().displayAllIssues();
        this.text.assertTextNotPresent(GROUP_CF_ISSUE_ID);
        this.navigation.issue().gotoIssue(GROUP_CF_ISSUE_ID);
        this.text.assertTextPresent(PERMISSION_VIOLATION_ERROR);
    }

    public void testViewIssueWithGroupCustomFieldDeleted() {
        this.deleteCustomField(GROUP_CUSTOM_FIELD_ID);
        this.text.assertTextPresent("Custom field cannot be deleted because it is used in the following Issue Level Security Scheme(s): My Issue Security Scheme");
    }

    public void testViewIssueWithUserCustomFieldDeleted() {
        this.deleteCustomField(USER_CUSTOM_FIELD_ID);
        this.text.assertTextPresent("Custom field cannot be deleted because it is used in the following Issue Level Security Scheme(s): My Issue Security Scheme");
    }

    private void _testUserOnlySeesCorrectIssue(String userName, String issueKey, String expectedText) {
        this.navigation.logout();
        this.navigation.login(userName);
        this.navigation.issueNavigator().displayAllIssues();
        this.text.assertTextNotPresent(issueKey);
        this.text.assertTextPresent(expectedText);
    }

    public void _testSearchWithGroupCustomFieldDeleted() {
        this.deleteCustomField(GROUP_CUSTOM_FIELD_ID);
        this.navigation.issueNavigator().displayAllIssues();
        this.text.assertTextNotPresent(GROUP_CF_ISSUE_ID);
    }

    public void _testSearchWithUserCustomFieldDeleted() {
        this.deleteCustomField(USER_CUSTOM_FIELD_ID);
        this.navigation.issueNavigator().displayAllIssues();
        this.text.assertTextNotPresent(USER_CF_ISSUE_ID);
    }

    private void deleteCustomField(String fieldId) {
        this.administration.customFields().removeCustomField(fieldId);
    }
}

