/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.webtests.JIRAWebTest;

public class TestIssueOperations
extends JIRAWebTest {
    private static final String ATTACHMENT_DOUBLE_QUOTES = "bigdummy\"\"Attachment";
    private static final String ISSUE_KEY_1 = "HSP-1";
    private static final String ISSUE_KEY_2 = "HSP-2";
    private static final String TEST_USER_1 = "testuser";
    private static final String TEST_USER_2 = "testuser2";

    public TestIssueOperations(String name) {
        super(name);
    }

    public void testIssueOperations() {
        this.restoreData("TestIssueOperations.xml");
        this.administration.attachments().enable();
        this.issueOperationsWithWorkOnPermission(ISSUE_KEY_1);
        this.issueOperationWithUnassignableUser(ISSUE_KEY_1);
        this.issueOperationWithAssignPermission(ISSUE_KEY_1);
        this.issueOperationWithCreateAttachmentsPermission(ISSUE_KEY_1);
        this.issueOperationCacheControl(ISSUE_KEY_1);
        this.issueWithoutBrowsePermissionLookForRDF(ISSUE_KEY_1);
    }

    public void testIssueLinksForOperations() {
        this.restoreData("TestIssueIconOperations.xml");
        this.login("fred");
        this.gotoIssue(ISSUE_KEY_1);
        this.assertLinkPresent("aszip");
        this.assertLinkPresent("manage-attachment-link");
        this.assertLinkPresent("add-attachments-link");
        this.assertLinkPresent("add-links-link");
        this.assertLinkPresent("log-work-link");
        this.clickLink("manage-attachment-link");
        this.assertTextSequence(new String[]{"Manage Attachments", "This page allows you to manage the attachments", "foobar.json"});
        this.assertLinkPresent("aszipbutton");
        this.gotoIssue(ISSUE_KEY_1);
        this.clickLink("add-attachments-link");
        this.assertTextSequence(new String[]{"Attach Files"});
        this.gotoIssue(ISSUE_KEY_1);
        this.gotoIssue(ISSUE_KEY_1);
        this.clickLink("add-links-link");
        this.assertTextSequence(new String[]{"Link Issue"});
        this.gotoIssue(ISSUE_KEY_1);
        this.clickLink("log-work-link");
        this.assertTextSequence(new String[]{"Log Work"});
        this.login("user", "user");
        this.gotoIssue(ISSUE_KEY_1);
        this.assertLinkPresent("aszip");
        this.assertLinkNotPresent("manage-attachment-link");
        this.assertLinkNotPresent("add-attachments-link");
        this.assertLinkNotPresent("add-links-link");
        this.assertLinkNotPresent("log-work-link");
        this.login("admin");
        this.gotoIssue(ISSUE_KEY_1);
        this.assertLinkPresent("aszip");
        this.assertLinkPresent("manage-attachment-link");
        this.assertLinkNotPresent("add-attachments-link");
        this.assertLinkNotPresent("add-links-link");
        this.assertLinkNotPresent("log-work-link");
        this.administration.attachments().disableZipSupport();
        this.gotoIssue(ISSUE_KEY_1);
        this.assertLinkNotPresent("aszip");
        this.clickLink("manage-attachment-link");
        this.assertLinkNotPresent("aszipbutton");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void issueWithoutBrowsePermissionLookForRDF(String issueKey) {
        try {
            this.removeGroupPermission(10, "jira-users");
            this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
            this.logout();
            this.login("bob", "bob_password");
            this.beginAt("/browse/" + issueKey);
            this.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
            this.assertTextPresent("rdf:Description");
            this.assertTextPresent("trackback:ping=");
        }
        finally {
            try {
                this.logout();
                this.login("admin", "admin");
                this.deleteUser("bob");
                this.grantGroupPermission(10, "jira-users");
            }
            catch (Exception exception) {}
        }
    }

    public void issueOperationsWithWorkOnPermission(String issueKey) {
        TestIssueOperations.log("Issue Operation: Test availability of Log Work Link with 'Work On Issues' permission.");
        this.activateTimeTracking();
        this.removeGroupPermission(20, "jira-developers");
        this.gotoIssue(issueKey);
        this.assertLinkNotPresent("log-work");
        this.grantGroupPermission(20, "jira-developers");
        this.gotoIssue(issueKey);
        this.assertLinkPresent("log-work");
        this.deactivateTimeTracking();
    }

    public void testLogWorkOperationTimeTrackingDisabled() {
        this.restoreData("TestIssueOperations.xml");
        this.deactivateTimeTracking();
        this.gotoIssue(ISSUE_KEY_1);
        this.assertLinkNotPresent("log-work");
    }

    public void testLogWorkOperationAnonymous() {
        this.restoreData("TestIssueOperations.xml");
        this.activateTimeTracking();
        this.clickLink("admin_link");
        this.clickLink("permission_schemes");
        this.clickLinkWithText("Default Permission Scheme");
        this.clickLink("add_perm_10");
        this.checkCheckbox("type", "group");
        this.submit(" Add ");
        this.logout();
        this.gotoPage("/browse/HSP-1");
        this.assertLinkNotPresent("log-work");
    }

    public void testLogWorkOperationIssueInNonEditableState() {
        this.restoreData("TestIssueOperations.xml");
        this.activateTimeTracking();
        this.gotoIssue(ISSUE_KEY_1);
        this.clickLinkWithText("Close Issue");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.assertLinkNotPresent("log-work");
    }

    public void testLogWorkOperationHappyPath() {
        this.restoreData("TestIssueOperations.xml");
        this.activateTimeTracking();
        this.gotoIssue(ISSUE_KEY_1);
        this.assertLinkPresent("log-work");
    }

    public void issueOperationWithUnassignableUser(String issueKey) {
        TestIssueOperations.log("Issue Operation: Attempt to set the assignee to be an unassignable user ...");
        this.removeGroupPermission(17, "jira-developers");
        this.gotoIssue(issueKey);
        this.clickLink("assign-issue");
        this.setWorkingForm("assign-issue");
        this.submit();
        this.assertTextPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.grantGroupPermission(17, "jira-developers");
    }

    public void issueOperationWithAssignPermission(String issueKey) {
        TestIssueOperations.log("Issue Operation: Test the availability of the 'Assign Link' with 'Assign Issues' Permission.");
        this.gotoIssue(issueKey);
        this.assertLinkPresent("assign-issue");
        this.removeGroupPermission(13, "jira-developers");
        this.gotoIssue(issueKey);
        this.assertLinkNotPresent("assign-issue");
        this.grantGroupPermission(13, "jira-developers");
    }

    public void issueOperationWithCreateAttachmentsPermission(String issueKey) {
        TestIssueOperations.log("Issue Operation: Test the availability of the 'Attach Link' with 'Create Attachments' Permission.");
        this.removeGroupPermission(19, "jira-users");
        this.gotoIssue(issueKey);
        this.assertLinkNotPresent("attach-file");
        this.grantGroupPermission(19, "jira-users");
        this.gotoIssue(issueKey);
        this.assertLinkPresent("attach-file");
    }

    public void issueOperationCacheControl(String issueKey) {
        TestIssueOperations.log("Issue Operation: Test cache control for Issue Navigator pages.");
        this.clickLink("find_link");
        this.tester.submit("show");
        this.tester.clickLink("viewfilter");
        String cache = this.getDialog().getResponse().getHeaderField("Cache-Control");
        TestIssueOperations.assertEquals((String)cache, (String)"no-cache, no-store, must-revalidate");
        this.gotoIssue(issueKey);
        cache = this.getDialog().getResponse().getHeaderField("Cache-Control");
        TestIssueOperations.assertEquals((String)cache, (String)"no-cache, no-store, must-revalidate");
    }

    public void testIssueOperationManageWatcherList() {
        this.restoreData("TestIssueOperationsWithReporter.xml");
        this.administration.attachments().enable();
        this.grantPermissionToReporter(32);
        this.logout();
        this.login(TEST_USER_1, TEST_USER_1);
        this.gotoIssue(ISSUE_KEY_2);
        this.assertLinkPresent("manage-watchers");
        this.logout();
        this.login(TEST_USER_2, TEST_USER_2);
        this.assertLinkNotPresent("manage-watchers");
        this.logout();
    }

    public void testIssueOperationsWithLongNames() {
        this.restoreData("TestIssueOperationsWithLongTransitions.xml");
        this.gotoIssue(ISSUE_KEY_1);
        IdLocator locator = new IdLocator(this.tester, "action_id_711");
        this.text.assertTextPresent(locator, "Another really long on...");
        TestIssueOperations.assertEquals((String)"Another really long one that has a description as well - Yep, this is the description", (String)locator.getNode().getAttributes().getNamedItem("title").getNodeValue());
        locator = new IdLocator(this.tester, "action_id_4");
        this.text.assertTextPresent(locator, "Start Progress that is...");
        TestIssueOperations.assertEquals((String)"Start Progress that is stupidly long and will make the buttons go really wide.  Quite Silly when you think about it.", (String)locator.getNode().getAttributes().getNamedItem("title").getNodeValue());
        locator = new IdLocator(this.tester, "action_id_5");
        this.text.assertTextPresent(locator, "Resolve Issue");
        TestIssueOperations.assertEquals((String)"Resolve Issue - We can still give it a description", (String)locator.getNode().getAttributes().getNamedItem("title").getNodeValue());
        locator = new IdLocator(this.tester, "action_id_2");
        this.text.assertTextPresent(locator, "Close Issue");
        TestIssueOperations.assertEquals((String)"", (String)locator.getNode().getAttributes().getNamedItem("title").getNodeValue());
    }
}

