/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestIssueConstants
extends JIRAWebTest {
    private static final String INVALID_ELEMENT_NAME = "wrong";
    private static final String SUFFIX_HTML = " </td><td><input name=&quot;wrong&quot;>";
    private static final String SUFFIX_TEXT = " </td><td><input name=\"wrong\">";
    private static final String SUFFIX_ESC = " &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String NAME_PREFIX = "name ";
    private static final String DESC_PREFIX = "desc ";
    private static final String ISSUE_TYPE_HTML_OPTION = "name type </td><td><input name=\"wrong\">";
    private static final String ISSUE_TYPE_NAME_HTML = "name type </td><td><input name=&quot;wrong&quot;>";
    private static final String ISSUE_TYPE_DESC_HTML = "desc type </td><td><input name=&quot;wrong&quot;>";
    private static final String ISSUE_TYPE_NAME_HTML_ESC = "name type &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String ISSUE_TYPE_DESC_HTML_ESC = "desc type &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String ISSUE_TYPE_NAME_TEXT = "New Feature";
    private static final String ISSUE_TYPE_DESC_TEXT = "A new feature of the product, which has yet to be developed.";
    private static final String SUBTASK_TYPE_NAME_HTML = "name subtype </td><td><input name=&quot;wrong&quot;>";
    private static final String SUBTASK_TYPE_DESC_HTML = "desc subtype </td><td><input name=&quot;wrong&quot;>";
    private static final String SUBTASK_TYPE_NAME_HTML_ESC = "name subtype &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String SUBTASK_TYPE_DESC_HTML_ESC = "desc subtype &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String PRIORITY_HTML_OPTION = "name priority </td><td><input name=\"wrong\">";
    private static final String PRIORITY_NAME_HTML = "name priority </td><td><input name=&quot;wrong&quot;>";
    private static final String PRIORITY_DESC_HTML = "desc priority </td><td><input name=&quot;wrong&quot;>";
    private static final String PRIORITY_NAME_HTML_ESC = "name priority &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String PRIORITY_DESC_HTML_ESC = "desc priority &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String PRIORITY_NAME_TEXT = "Major";
    private static final String PRIORITY_DESC_TEXT = "Major loss of function.";
    private static final String RESOLUTION_HTML_OPTION = "name resolution </td><td><input name=\"wrong\">";
    private static final String RESOLUTION_NAME_HTML = "name resolution </td><td><input name=&quot;wrong&quot;>";
    private static final String RESOLUTION_DESC_HTML = "desc resolution </td><td><input name=&quot;wrong&quot;>";
    private static final String RESOLUTION_NAME_HTML_ESC = "name resolution &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String RESOLUTION_DESC_HTML_ESC = "desc resolution &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String RESOLUTION_NAME_TEXT = "Duplicate";
    private static final String RESOLUTION_DESC_TEXT = "The problem is a duplicate of an existing issue.";
    private static final String STATUS_HTML_OPTION = "name status </td><td><input name=\"wrong\">";
    private static final String STATUS_NAME_HTML = "name status </td><td><input name=&quot;wrong&quot;>";
    private static final String STATUS_DESC_HTML = "desc status </td><td><input name=&quot;wrong&quot;>";
    private static final String STATUS_NAME_HTML_ESC = "name status &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String STATUS_DESC_HTML_ESC = "desc status &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String STATUS_NAME_TEXT = "In Progress";
    private static final String STATUS_DESC_TEXT = "This issue is being actively worked on at the moment by the assignee.";
    private static final String RESOLVED_STATUS_HTML_OPTION = "name resolved </td><td><input name=\"wrong\">";
    private static final String RESOLVED_STATUS_NAME_HTML = "name resolved </td><td><input name=&quot;wrong&quot;>";
    private static final String RESOLVED_STATUS_DESC_HTML = "desc resolved </td><td><input name=&quot;wrong&quot;>";
    private static final String RESOLVED_STATUS_NAME_HTML_ESC = "name resolved &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";
    private static final String RESOLVED_STATUS_DESC_HTML_ESC = "desc resolved &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;";

    public TestIssueConstants(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueConstants.xml");
    }

    public void testIssueConstantsAreEncodedOnBrowseProjectPage() {
        this.gotoProjectBrowse("HSP");
        this.clickLink("issues-panel-panel");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextPresent("title=\"name priority &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;");
        this.assertTextPresent("title=\"Major");
        this.assertTextPresent("title=\"name status &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;");
        this.assertTextPresent("title=\"In Progress");
        this.gotoPage("/browse/HSP?selectedTab=com.atlassian.jira.plugin.system.project:roadmap-panel&expandVersion=10002");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertIssueConstantHTMLTitlesPresent();
        this.gotoPage("/browse/HSP?selectedTab=com.atlassian.jira.plugin.system.project:changelog-panel&expandVersion=10001");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertIssueConstantHTMLTitlesPresent();
        this.gotoPage("/browse/HSP?selectedTab=com.atlassian.jira.plugin.system.project:popularissues-panel");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertIssueConstantHTMLTitlesPresent();
    }

    public void testIssueConstantsAreEncodedOnReports() {
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:version-workload");
        this.selectOption("versionId", "- version 3");
        this.submit("Next");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextPresent(ISSUE_TYPE_NAME_HTML_ESC);
        this.assertTextPresent(ISSUE_TYPE_NAME_TEXT);
        this.assertTextPresent(PRIORITY_NAME_HTML_ESC);
        this.assertTextPresent(PRIORITY_NAME_TEXT);
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.selectOption("mapper", "Issue Type");
        this.setFormElement("filterid", "10002");
        this.submit("Next");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertIssueConstantHTMLTitlesPresent();
    }

    public void testIssueConstantsAreEncodedOnIssueNavigator() {
        this.clickLink("find_link");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.selectOption("type", ISSUE_TYPE_NAME_TEXT);
        this.selectOption("priority", PRIORITY_NAME_TEXT);
        this.selectOption("status", STATUS_NAME_TEXT);
        this.selectOption("resolution", RESOLUTION_NAME_TEXT);
        this.tester.submit("show");
        this.tester.clickLink("viewfilter");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextPresent(ISSUE_TYPE_NAME_TEXT);
        this.assertTextPresent(PRIORITY_NAME_TEXT);
        this.assertTextPresent(STATUS_NAME_TEXT);
        this.assertTextPresent(RESOLUTION_NAME_TEXT);
        this.displayAllIssues();
        this.assertIssueConstantHTMLTitlesPresent();
        this.clickLink("find_link");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.selectOption("type", ISSUE_TYPE_HTML_OPTION);
        this.selectOption("priority", PRIORITY_HTML_OPTION);
        this.selectOption("status", STATUS_HTML_OPTION);
        this.selectOption("resolution", RESOLUTION_HTML_OPTION);
        this.tester.submit("show");
        this.tester.clickLink("viewfilter");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextPresent(ISSUE_TYPE_NAME_HTML_ESC);
        this.assertTextPresent(PRIORITY_NAME_HTML_ESC);
        this.assertTextPresent(STATUS_NAME_HTML_ESC);
        this.assertTextPresent(RESOLUTION_NAME_HTML_ESC);
        this.displayAllIssues();
        this.clickLink("printable");
        this.assertIssueConstantHTMLTitlesPresent();
        this.gotoPage("/secure/Dashboard.jspa");
        this.displayAllIssues();
        this.clickLink("fullContent");
        this.assertIssueConstantHTMLContentViewPresent();
        this.assertIssueConstantTextContentViewPresent();
        this.gotoPage("/secure/Dashboard.jspa");
        this.displayAllIssues();
        this.clickLink("xml");
        this.assertIssueConstantHTMLPresentInXML();
        this.assertTextSequence(new String[]{"<status id=\"1\"", ">", STATUS_NAME_HTML_ESC, "</status>"});
        this.assertTextSequence(new String[]{"<type id=\"2\"", ">", ISSUE_TYPE_NAME_TEXT, "</type>"});
        this.assertTextSequence(new String[]{"<priority id=\"3\"", ">", PRIORITY_NAME_TEXT, "</priority>"});
        this.assertTextSequence(new String[]{"<status id=\"3\"", ">", STATUS_NAME_TEXT, "</status>"});
        this.gotoPage("/secure/Dashboard.jspa");
        this.displayAllIssues();
        this.clickLink("word");
        this.assertIssueConstantHTMLContentViewPresent();
        this.assertIssueConstantTextContentViewPresent();
        this.gotoPage("/secure/Dashboard.jspa");
        this.displayAllIssues();
        this.clickLink("currentExcelFields");
        this.assertTextPresent(ISSUE_TYPE_NAME_TEXT);
        this.assertTextPresent(PRIORITY_NAME_TEXT);
        this.assertTextPresent(STATUS_NAME_TEXT);
        this.assertTextPresent(ISSUE_TYPE_NAME_HTML_ESC);
        this.assertTextPresent(PRIORITY_NAME_HTML_ESC);
        this.assertTextPresent(STATUS_NAME_HTML_ESC);
        this.gotoPage("/secure/Dashboard.jspa");
    }

    public void testIssueConstantsAreEncodedOnBulkOperation() {
        this.displayAllIssues();
        this.clickLink("bulkedit_all");
        this.selectIssuesForBulkOperation();
        this.checkCheckbox("operation", "bulk.edit.operation.name");
        this.submit("Next");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.checkCheckbox("actions", "issuetype");
        this.selectOption("issuetype", ISSUE_TYPE_HTML_OPTION);
        this.checkCheckbox("actions", "priority");
        this.selectOption("priority", PRIORITY_HTML_OPTION);
        this.submit("Next");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertIssueConstantHTMLTitlesPresent();
        this.displayAllIssues();
        this.clickLink("bulkedit_all");
        this.selectIssuesForBulkOperation();
        this.checkCheckbox("operation", "bulk.move.operation.name");
        this.submit("Next");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertIssueConstantStraightHTMLNotPresent();
        this.displayAllIssues();
        this.clickLink("bulkedit_all");
        this.selectIssuesForBulkOperation();
        this.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.submit("Next");
        this.checkCheckbox("wftransition", "jira_4_3");
        this.submit("Next");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextNotPresent(STATUS_NAME_HTML);
        this.assertTextPresent(STATUS_NAME_HTML_ESC);
        this.displayAllIssues();
        this.clickLink("bulkedit_all");
        this.selectIssuesForBulkOperation();
        this.checkCheckbox("operation", "bulk.delete.operation.name");
        this.submit("Next");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertIssueConstantStraightHTMLNotPresent();
    }

    public void testIssueConstantsAreEncodedOnViewIssue() {
        this.gotoIssue("HSP-3");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertIssueConstantStraightHTMLNotPresent();
        this.assertTextPresent("title=\"name type &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt; - desc type &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;\"");
        this.assertTextPresent("title=\"name priority &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt; - desc priority &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;\"");
        this.assertTextPresent("title=\"name resolved &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt; - desc resolved &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;\"");
        this.assertTextPresent(RESOLUTION_NAME_HTML_ESC);
        this.assertTextPresent(SUBTASK_TYPE_NAME_HTML_ESC);
        this.gotoIssue("HSP-4");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextNotPresent(SUBTASK_TYPE_NAME_HTML);
        this.assertTextNotPresent(PRIORITY_NAME_HTML);
        this.assertTextNotPresent(RESOLVED_STATUS_NAME_HTML);
        this.assertTextNotPresent(SUBTASK_TYPE_DESC_HTML);
        this.assertTextNotPresent(PRIORITY_DESC_HTML);
        this.assertTextNotPresent(RESOLVED_STATUS_DESC_HTML);
        this.assertTextPresent("title=\"name subtype &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt; - desc subtype &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;\"");
        this.assertTextPresent("title=\"name priority &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt; - desc priority &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;\"");
        this.assertTextPresent("title=\"name status &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt; - desc status &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;\"");
        this.gotoIssue("HSP-3");
        this.clickLinkWithText("Printable");
        this.assertIssueConstantHTMLContentViewPresent();
        this.assertTextPresentBeforeText("Resolution:", RESOLUTION_NAME_HTML_ESC);
        this.assertFormNotPresent();
        this.gotoPage("/secure/Dashboard.jspa");
        this.gotoIssue("HSP-3");
        this.clickLinkWithText("XML");
        this.assertIssueConstantHTMLPresentInXML();
        this.assertTextSequence(new String[]{"<status id=\"5\"", ">", RESOLVED_STATUS_NAME_HTML_ESC, "</status>"});
        this.gotoPage("/secure/Dashboard.jspa");
        this.gotoIssue("HSP-3");
        this.clickLinkWithText("Word");
        this.assertIssueConstantHTMLContentViewPresent();
        this.assertTextPresentBeforeText("Resolution:", RESOLUTION_NAME_HTML_ESC);
        this.gotoPage("/secure/Dashboard.jspa");
    }

    public void testIssueConstantsAreEncodedOnAdminPage() {
        this.gotoAdmin();
        this.clickLink("issue_types");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextPresentBeforeText(ISSUE_TYPE_NAME_HTML_ESC, ISSUE_TYPE_DESC_HTML_ESC);
        this.assertTextPresentBeforeText(SUBTASK_TYPE_NAME_HTML_ESC, SUBTASK_TYPE_DESC_HTML_ESC);
        this.clickLink("translate_link");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextPresentBeforeText(ISSUE_TYPE_NAME_HTML_ESC, ISSUE_TYPE_DESC_HTML_ESC);
        this.gotoAdmin();
        this.clickLink("priorities");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextPresentBeforeText(PRIORITY_NAME_HTML_ESC, PRIORITY_DESC_HTML_ESC);
        this.gotoPage("/secure/admin/ViewTranslations!default.jspa?issueConstantType=priority");
        this.navigation.checkWebSudoWithLastPassword();
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextPresentBeforeText(PRIORITY_NAME_HTML_ESC, PRIORITY_DESC_HTML_ESC);
        this.gotoAdmin();
        this.clickLink("resolutions");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextPresentBeforeText(RESOLUTION_NAME_HTML_ESC, RESOLUTION_DESC_HTML_ESC);
        this.gotoPage("/secure/admin/ViewTranslations!default.jspa?issueConstantType=resolution");
        this.navigation.checkWebSudoWithLastPassword();
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextPresentBeforeText(RESOLUTION_NAME_HTML_ESC, RESOLUTION_DESC_HTML_ESC);
        this.gotoAdmin();
        this.clickLink("statuses");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextPresentBeforeText(STATUS_NAME_HTML_ESC, STATUS_DESC_HTML_ESC);
        this.assertTextPresentBeforeText(RESOLVED_STATUS_NAME_HTML_ESC, RESOLVED_STATUS_DESC_HTML_ESC);
        this.gotoPage("/secure/admin/ViewTranslations!default.jspa?issueConstantType=status");
        this.navigation.checkWebSudoWithLastPassword();
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextPresentBeforeText(STATUS_NAME_HTML_ESC, STATUS_DESC_HTML_ESC);
        this.assertTextPresentBeforeText(RESOLVED_STATUS_NAME_HTML_ESC, RESOLVED_STATUS_DESC_HTML_ESC);
    }

    public void testIssueConstantsAreEncodedOnEditIssue() {
        this.gotoIssue("HSP-3");
        this.clickLink("editIssue");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextPresent(ISSUE_TYPE_NAME_HTML_ESC);
        this.assertTextPresent(ISSUE_TYPE_NAME_TEXT);
        this.gotoAdmin();
        this.clickLink("issue_types");
        this.gotoPage("/secure/admin/DeleteIssueType!default.jspa?id=4");
        this.navigation.checkWebSudoWithLastPassword();
        this.submit("Delete");
        this.gotoPage("/secure/admin/DeleteIssueType!default.jspa?id=3");
        this.navigation.checkWebSudoWithLastPassword();
        this.submit("Delete");
        this.gotoPage("/secure/admin/DeleteIssueType!default.jspa?id=2");
        this.navigation.checkWebSudoWithLastPassword();
        this.submit("Delete");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextPresentBeforeText(ISSUE_TYPE_NAME_HTML_ESC, ISSUE_TYPE_DESC_HTML_ESC);
        this.gotoIssue("HSP-3");
        this.clickLink("editIssue");
        this.assertFormElementNotPresent(INVALID_ELEMENT_NAME);
        this.assertTextPresent(ISSUE_TYPE_NAME_HTML_ESC);
        this.assertTextNotPresent(ISSUE_TYPE_NAME_TEXT);
        this.assertTextPresent("There are no issue types with compatible field configuration and/or workflow associations.");
    }

    private void assertIssueConstantHTMLTitlesPresent() {
        this.assertIssueConstantStraightHTMLNotPresent();
        this.assertTextPresent("title=\"name type &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt; - desc type &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;");
        this.assertTextPresent("title=\"name status &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt; - desc status &lt;/td&gt;&lt;td&gt;&lt;input name=&quot;wrong&quot;&gt;");
        this.assertTextPresent("title=\"New Feature - A new feature of the product, which has yet to be developed.");
        this.assertTextPresent("title=\"In Progress - This issue is being actively worked on at the moment by the assignee.");
    }

    private void assertIssueConstantHTMLPresentInXML() {
        this.assertIssueConstantStraightHTMLNotPresent();
        this.assertTextSequence(new String[]{"<type id=\"1\"", ">", ISSUE_TYPE_NAME_HTML_ESC, "</type>"});
        this.assertTextSequence(new String[]{"<priority id=\"1\"", ">", PRIORITY_NAME_HTML_ESC, "</priority>"});
        this.assertTextSequence(new String[]{"<resolution id=\"1\"", ">", RESOLUTION_NAME_HTML_ESC, "</resolution>"});
    }

    private void assertIssueConstantHTMLContentViewPresent() {
        this.assertIssueConstantStraightHTMLNotPresent();
        this.assertTextPresentBeforeText("Type:", ISSUE_TYPE_NAME_HTML_ESC);
        this.assertTextPresentBeforeText("Priority:", PRIORITY_NAME_HTML_ESC);
        this.assertTextPresentBeforeText("Status:", STATUS_NAME_HTML_ESC);
    }

    private void assertIssueConstantTextContentViewPresent() {
        this.assertIssueConstantStraightHTMLNotPresent();
        this.assertTextPresentBeforeText("Type:", ISSUE_TYPE_NAME_TEXT);
        this.assertTextPresentBeforeText("Priority:", PRIORITY_NAME_TEXT);
        this.assertTextPresentBeforeText("Status:", STATUS_NAME_TEXT);
    }

    private void assertIssueConstantStraightHTMLNotPresent() {
        this.assertTextNotPresent(ISSUE_TYPE_NAME_HTML);
        this.assertTextNotPresent(PRIORITY_NAME_HTML);
        this.assertTextNotPresent(STATUS_NAME_HTML);
        this.assertTextNotPresent(ISSUE_TYPE_DESC_HTML);
        this.assertTextNotPresent(PRIORITY_DESC_HTML);
        this.assertTextNotPresent(STATUS_DESC_HTML);
    }

    private void selectIssuesForBulkOperation() {
        this.checkCheckbox("bulkedit_10010", "on");
        this.checkCheckbox("bulkedit_10001", "on");
        this.checkCheckbox("bulkedit_10000", "on");
        this.clickOnNext();
    }
}

