/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestEditIssueFields
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestEditIssueVersion.xml");
        this.navigation.login("admin", "admin");
    }

    public void testNoneDisplayedGivenNoAvailableVersions() {
        this.navigation.issue().gotoEditIssue("MK-1");
        this.assertions.assertNodeHasText(this.versionPickerLocatorFor("versions"), "None");
        this.assertions.assertNodeDoesNotHaveText(this.versionPickerLocatorFor("versions"), "Unknown");
        this.assertions.assertNodeHasText(this.versionPickerLocatorFor("fixVersions"), "None");
        this.assertions.assertNodeDoesNotHaveText(this.versionPickerLocatorFor("fixVersions"), "Unknown");
    }

    public void testNoneDisplayedGivenNoAvailableComponents() {
        this.navigation.issue().gotoEditIssue("MK-1");
        this.assertions.assertNodeHasText(this.componentPickerLocator(), "None");
        this.assertions.assertNodeDoesNotHaveText(this.componentPickerLocator(), "Unknown");
    }

    private String versionPickerLocatorFor(String versionPickerFieldId) {
        return String.format("//div[contains(@class, 'field-group') and contains(@class, 'aui-field-versionspicker')]/label[@for='%s']/..", versionPickerFieldId);
    }

    private String componentPickerLocator() {
        return "//div[contains(@class, 'field-group') and contains(@class, 'aui-field-componentspicker')]";
    }
}

