/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.navigator.ProjectCondition;
import com.atlassian.jira.functest.framework.sharing.GroupTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.functest.framework.util.json.TestJSONException;
import java.util.Collections;
import java.util.Set;

public class TestSaveFilter
extends FuncTestCase {
    private static final int ADMIN_ALLFILTER_ID = 10000;

    public void testSaveNoFilter() {
        this.administration.restoreData("TestSaveFilter.xml");
        this.navigation.logout();
        this.navigation.login("fred");
        this.tester.gotoPage("secure/SaveFilter!default.jspa");
        this.assertions.getTextAssertions().assertTextPresent("There is no current search request");
    }

    public void testSaveNotOwner() {
        this.administration.restoreData("TestSaveFilter.xml");
        this.navigation.login("fred");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.gotoPage("secure/SaveFilter!default.jspa");
        this.assertions.getTextAssertions().assertTextPresent("You may only create, modify or delete filters that you own.");
        ProjectCondition projectCondition = new ProjectCondition();
        projectCondition.addOption("monkey");
        NavigatorSearch expectedSearch = new NavigatorSearch((NavigatorCondition)projectCondition);
        this.navigation.issueNavigator().modifySearch(expectedSearch);
        this.assertions.getTextAssertions().assertTextPresent(new XPathLocator(this.tester, "//ul[@id='filter-description']"), "Filter modified since loading");
        this.tester.assertLinkPresent("copyasnewfilter");
        this.tester.assertLinkNotPresent("filtereditshares");
        this.tester.assertLinkNotPresent("filtersave");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//div[@id='issue-filter']", "Subscriptions");
    }

    public void testSaveBadSharePermissions() {
        SharedEntityInfo fredAllFilter = new SharedEntityInfo(10000L, "FredAll", "Fred All description", true, Collections.singleton(new GroupTestSharingPermission("jira-developers")));
        this.administration.restoreData("TestSaveFilterBadShares.xml");
        this.navigation.login("fred");
        this.navigation.issueNavigator().loadFilter(fredAllFilter.getId(), IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        ProjectCondition projectCondition = new ProjectCondition();
        projectCondition.addOption("monkey");
        NavigatorSearch expectedSearch = new NavigatorSearch((NavigatorCondition)projectCondition);
        this.navigation.issueNavigator().modifySearch(expectedSearch);
        this.navigation.issueNavigator().saveCurrentFilter();
        this.navigation.issueNavigator().loadFilter(fredAllFilter.getId(), IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertions.getIssueNavigatorAssertions().assertSimpleSearch(expectedSearch, this.tester);
        this.assertFilterDetails(fredAllFilter);
    }

    private void assertFilterDetails(SharedEntityInfo expectedInfo) {
        this.tester.gotoPage("secure/EditFilter!default.jspa");
        this.tester.assertFormElementEquals("filterName", expectedInfo.getName());
        this.tester.assertFormElementEquals("filterDescription", expectedInfo.getDescription());
        this.tester.assertFormElementEquals("favourite", String.valueOf(expectedInfo.isFavourite()));
        TestSaveFilter.assertEquals(expectedInfo.getSharingPermissions(), (Object)this.parsePermissions());
    }

    private Set parsePermissions() {
        XPathLocator xpath = new XPathLocator(this.tester, "//span[@id='shares_data']");
        String value = xpath.getText();
        try {
            return TestSharingPermissionUtils.parsePermissions(value);
        }
        catch (TestJSONException e) {
            TestSaveFilter.fail((String)("Unable to parse shares: " + e.getMessage()));
            return null;
        }
    }
}

