/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.UserProfileImpl;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;

public class TestIssueNotifications
extends EmailFuncTestCase {
    public void testDeleteUserBeforeCommentNotification() throws InterruptedException, MessagingException, IOException {
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServer();
        this.tester.clickLink("admin_link");
        this.tester.clickLink("services");
        this.tester.setFormElement("name", "");
        this.tester.clickLink("edit_10000");
        this.tester.setFormElement("delay", "100");
        this.tester.submit("Update");
        this.navigation.logout();
        this.navigation.login("henry.ford");
        this.navigation.issue().viewIssue("COW-2");
        this.tester.clickLink("comment-issue");
        this.tester.setFormElement("comment", "monkeys");
        this.tester.submit();
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("editIssue");
        this.tester.setFormElement("reporter", "admin");
        this.tester.submit("Update");
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("deleteuser_link_henry.ford");
        this.tester.submit("Delete");
        this.tester.clickLink("admin_link");
        this.tester.clickLink("services");
        this.tester.setFormElement("name", "");
        this.tester.clickLink("edit_10000");
        this.tester.setFormElement("delay", "1");
        this.tester.submit("Update");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.getGreenMail().getReceivedMessages();
        TestIssueNotifications.assertEquals((int)2, (int)mimeMessages.length);
        TestIssueNotifications.assertTrue((String)"henry.ford commented", (mimeMessages[0].getContent().toString().indexOf("henry.ford commented on COW-2") >= 0 ? 1 : 0) != 0);
        TestIssueNotifications.assertTrue((String)"updated reporter", (mimeMessages[1].getContent().toString().indexOf("admin updated COW-1") >= 0 ? 1 : 0) != 0);
    }

    public void testDeleteIssueBeforeCommentNotification() throws InterruptedException, MessagingException, IOException {
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServer();
        this.tester.clickLink("admin_link");
        this.tester.clickLink("services");
        this.tester.setFormElement("name", "");
        this.tester.clickLink("edit_10000");
        this.tester.setFormElement("delay", "100");
        this.tester.submit("Update");
        this.navigation.logout();
        this.navigation.login("henry.ford");
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("comment-issue");
        this.tester.setFormElement("comment", "monkeys");
        this.tester.submit();
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.navigation.gotoAdminSection("services");
        this.tester.setFormElement("name", "");
        this.tester.clickLink("edit_10000");
        this.tester.setFormElement("delay", "1");
        this.tester.submit("Update");
        this.flushMailQueueAndWait(4);
        MimeMessage[] mimeMessages = this.getGreenMail().getReceivedMessages();
        TestIssueNotifications.assertEquals((int)4, (int)mimeMessages.length);
        TestIssueNotifications.assertTrue((String)"henry comment", (boolean)mimeMessages[0].getContent().toString().contains("henry.ford commented on COW-1"));
        TestIssueNotifications.assertTrue((String)"admin deleted", (boolean)mimeMessages[1].getContent().toString().contains("admin deleted COW-1"));
    }

    public void testDeleteSubTaskNotification() throws InterruptedException, MessagingException, IOException {
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServer();
        String issueId = "COW-3";
        this.navigation.issue().viewIssue(issueId);
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.getGreenMail().getReceivedMessages();
        TestIssueNotifications.assertEquals((int)1, (int)mimeMessages.length);
        MimeMessage message = mimeMessages[0];
        TestIssueNotifications.assertEquals((String)"admin@example.com", (String)message.getHeader("To")[0]);
        this.assertMailProperties(message, issueId, "[JIRATEST] Deleted: (COW-3) A calf is a tasty little renet factory");
    }

    public void testDeleteIssueNotification() throws InterruptedException, MessagingException, IOException {
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServer();
        String issueId = "COW-1";
        this.navigation.issue().viewIssue(issueId);
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.getGreenMail().getReceivedMessages();
        TestIssueNotifications.assertEquals((int)2, (int)mimeMessages.length);
        List expectedList = EasyList.build((Object)"admin@example.com", (Object)"Henry.Ford@example.com");
        List receivedList = EasyList.build((Object)mimeMessages[0].getHeader("To")[0], (Object)mimeMessages[1].getHeader("To")[0]);
        TestIssueNotifications.assertEquals(new HashSet(expectedList), new HashSet(receivedList));
        this.assertMailProperties(mimeMessages[0], issueId, "[JIRATEST] Deleted: (COW-1) The cow is in the pasture");
        this.assertMailProperties(mimeMessages[1], issueId, "[JIRATEST] Deleted: (COW-1) The cow is in the pasture");
    }

    public void testUserPreferencesUrlInHtml() throws InterruptedException, MessagingException {
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServer();
        this.tester.clickLink("view_profile");
        this.tester.clickLink("edit_prefs_lnk");
        this.tester.selectOption("userNotificationsMimeType", "HTML");
        this.tester.submit();
        this.navigation.logout();
        this.navigation.login("henry.ford");
        this.tester.clickLink("view_profile");
        this.tester.clickLink("edit_prefs_lnk");
        this.tester.selectOption("userNotificationsMimeType", "HTML");
        this.tester.submit();
        this.navigation.logout();
        this.navigation.login("admin");
        String issueId = "COW-1";
        this.navigation.issue().viewIssue(issueId);
        this.tester.clickLink("delete-issue");
        this.tester.submit("Delete");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.getGreenMail().getReceivedMessages();
        TestIssueNotifications.assertEquals((int)2, (int)mimeMessages.length);
        List expectedList = EasyList.build((Object)"admin@example.com", (Object)"Henry.Ford@example.com");
        List receivedList = EasyList.build((Object)mimeMessages[0].getHeader("To")[0], (Object)mimeMessages[1].getHeader("To")[0]);
        TestIssueNotifications.assertEquals(new HashSet(expectedList), new HashSet(receivedList));
        String body = GreenMailUtil.getBody((Part)mimeMessages[0]);
        String prefUrl = this.getPrefUrl(body);
        TestIssueNotifications.assertTrue((String)"Profile link for admin could not be found.", (body.indexOf("secure/ViewProfile.jspa?name=admin") >= 0 ? 1 : 0) != 0);
        TestIssueNotifications.assertTrue((String)"Profile link for henry.ford could not be found.", (body.indexOf("secure/ViewProfile.jspa?name=henry.ford") >= 0 ? 1 : 0) != 0);
        TestIssueNotifications.assertTrue((String)"Profile link id for henry.ford could not be found.", (body.indexOf("id=\"email_henry.ford\"") >= 0 ? 1 : 0) != 0);
        TestIssueNotifications.assertTrue((String)"Profile link id for admin could not be found.", (body.indexOf("id=\"email_admin\"") >= 0 ? 1 : 0) != 0);
    }

    public void testDeleteCommentNotification() throws InterruptedException, MessagingException, IOException {
        String commentBody = "This comment will be deleted";
        String emailSubject = "[JIRATEST] Updated: (COW-1) The cow is in the pasture";
        UserProfileImpl userProfile = new UserProfileImpl(this.tester, this.getEnvironmentData(), this.navigation);
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServer();
        userProfile.changeUserNotificationType(true);
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("comment-issue");
        this.tester.setFormElement("comment", "This comment will be deleted");
        this.tester.submit();
        this.tester.assertTextPresent("This comment will be deleted");
        this.tester.clickLink("delete_comment_10000");
        this.tester.submit("Delete");
        this.tester.assertTextNotPresent("This comment will be deleted");
        this.flushMailQueueAndWait(4);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueNotifications.assertEquals((int)2, (int)messagesForAdmin.size());
        for (MimeMessage message : messagesForAdmin) {
            String subject = message.getSubject();
            if (subject.indexOf("Updated") < 0) continue;
            this.assertEmailSubjectEquals(message, "[JIRATEST] Updated: (COW-1) The cow is in the pasture");
            this.assertEmailBodyContains(message, "The following issue had a comment deleted.");
            this.assertEmailBodyContains(message, "This comment will be deleted");
        }
        List<MimeMessage> messagesForHenry = this.getMessagesForRecipient("Henry.Ford@example.com");
        TestIssueNotifications.assertEquals((int)2, (int)messagesForHenry.size());
        for (MimeMessage message : messagesForHenry) {
            String subject = message.getSubject();
            if (subject.indexOf("Updated") < 0) continue;
            this.assertEmailSubjectEquals(message, "[JIRATEST] Updated: (COW-1) The cow is in the pasture");
            this.assertEmailBodyContains(message, "Comment: was deleted");
            this.assertEmailBodyContains(message, "(was: This comment will be deleted)");
        }
    }

    public void testEditCommentNotification() throws InterruptedException, MessagingException, IOException {
        String originalComment = "This text will be soon edited";
        String newCommentAdmin = "The administrator just edited this text";
        String newCommentAnon = "An anonymous user just edited this text";
        String emailSubject = "[JIRATEST] Issue Comment Edited: (COW-1) The cow is in the pasture";
        this.administration.restoreData("TestIssueNotificationsAnonymous.xml");
        this.configureAndStartSmtpServer();
        this.editIssue("This text will be soon edited", "henry.ford", "COW-1", "comment-issue");
        this.editIssueInForm("The administrator just edited this text", "admin", "COW-1", "edit_comment_10000", "comment-edit", "The administrator just edited this text");
        this.editIssueInForm("The administrator just edited this text", null, "COW-1", "edit_comment_10000", "comment-edit", "An anonymous user just edited this text");
        this.navigation.login("admin");
        this.flushMailQueueAndWait(6);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueNotifications.assertEquals((int)3, (int)messagesForAdmin.size());
        for (MimeMessage message : messagesForAdmin) {
            String subject = message.getSubject();
            if (subject.indexOf("Edited") < 0) continue;
            this.assertEmailSubjectEquals(message, "[JIRATEST] Issue Comment Edited: (COW-1) The cow is in the pasture");
            String from = message.getFrom()[0].toString();
            if (from.indexOf("Administrator") >= 0) {
                this.assertEmailBodyContains(message, "Administrator edited comment on COW-1 at");
                this.assertEmailBodyContains(message, "The administrator just edited this text");
                this.assertEmailBodyContains(message, "This text will be soon edited");
                this.assertEmailBodyDoesntContain(message, "An anonymous user just edited this text");
                continue;
            }
            this.assertEmailBodyContains(message, "Anonymous edited comment on COW-1 at");
            this.assertEmailBodyContains(message, "An anonymous user just edited this text");
            this.assertEmailBodyContains(message, "The administrator just edited this text");
            this.assertEmailBodyDoesntContain(message, "This text will be soon edited");
        }
    }

    private void editIssueInForm(String newCommentAdmin, String userName, String issueKey, String linkId, String workingFormName, String newComment) {
        this.navigation.logout();
        if (userName != null) {
            this.navigation.login(userName);
        } else {
            this.tester.gotoPage("/secure/Dashboard.jspa");
        }
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink(linkId);
        this.tester.setWorkingForm(workingFormName);
        this.tester.setFormElement("comment", newComment);
        this.tester.submit("Save");
        this.tester.assertTextPresent(newComment);
    }

    private void editIssue(String originalComment, String userName, String issueKey, String linkId) {
        this.navigation.logout();
        this.navigation.login(userName);
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink(linkId);
        this.tester.setFormElement("comment", originalComment);
        this.tester.submit();
        this.tester.assertTextPresent(originalComment);
    }

    public void testAnonymousUser() throws InterruptedException, MessagingException, IOException {
        String originalComment = "a comment from henry";
        this.administration.restoreData("TestIssueNotificationsNoName.xml");
        this.configureAndStartSmtpServer();
        this.navigation.logout();
        this.tester.gotoPage("/secure/Dashboard.jspa");
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("comment-issue");
        this.tester.setFormElement("comment", "a comment from henry");
        this.tester.submit();
        this.tester.assertTextPresent("a comment from henry");
        this.navigation.logout();
        this.navigation.login("henry.ford");
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("comment-issue");
        this.tester.setFormElement("comment", "a comment from henry");
        this.tester.submit();
        this.tester.assertTextPresent("a comment from henry");
        this.navigation.login("admin");
        this.flushMailQueueAndWait(2);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueNotifications.assertEquals((int)2, (int)messagesForAdmin.size());
        String emailBody = GreenMailUtil.getBody((Part)((Part)messagesForAdmin.get(0)));
        if (emailBody.contains("Anonymous commented on COW-1")) {
            this.assertEmailBodyContains(messagesForAdmin.get(1), "henry.ford commented on COW-1");
        } else {
            this.assertEmailBodyContains(messagesForAdmin.get(0), "henry.ford commented on COW-1");
            this.assertEmailBodyContains(messagesForAdmin.get(1), "Anonymous commented on COW-1");
        }
    }

    public void testAssignIssueNotificationNoCurrentAssignee() throws Exception {
        this.administration.restoreData("TestIssueNotificationsNotCurrentAssignee.xml");
        this.configureAndStartSmtpServer();
        this.navigation.issue().assignIssue("COw-2", "this is a comment", "henry.ford");
        this.flushMailQueueAndWait(0);
        List<MimeMessage> messagesForHank = this.getMessagesForRecipient("Henry.Ford@example.com");
        TestIssueNotifications.assertEquals((int)0, (int)messagesForHank.size());
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueNotifications.assertEquals((int)0, (int)messagesForAdmin.size());
    }

    public void testAssignIssueNotificationCurrentAndPreviousAssignee() throws Exception {
        this.administration.restoreData("TestIssueNotificationsCurrentAssignee.xml");
        this.configureAndStartSmtpServer();
        this.navigation.issue().assignIssue("COw-2", "this is a comment", "henry.ford");
        this.flushMailQueueAndWait(2);
        List<MimeMessage> messagesForHank = this.getMessagesForRecipient("Henry.Ford@example.com");
        TestIssueNotifications.assertEquals((int)1, (int)messagesForHank.size());
        MimeMessage message = messagesForHank.get(0);
        TestIssueNotifications.assertTrue((message.getSubject().indexOf("Assigned") != -1 ? 1 : 0) != 0);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueNotifications.assertEquals((int)1, (int)messagesForAdmin.size());
        message = messagesForAdmin.get(0);
        TestIssueNotifications.assertTrue((message.getSubject().indexOf("Assigned") != -1 ? 1 : 0) != 0);
    }

    public void testAssignIssueNotificationUnassigned() throws Exception {
        this.administration.restoreData("TestIssueNotificationsCurrentAssignee.xml");
        this.configureAndStartSmtpServer();
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        this.navigation.issue().unassignIssue("COW-2", "this is a comment");
        this.flushMailQueueAndWait(1);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueNotifications.assertEquals((int)1, (int)messagesForAdmin.size());
        MimeMessage message = messagesForAdmin.get(0);
        TestIssueNotifications.assertTrue((message.getSubject().indexOf("Assigned") != -1 ? 1 : 0) != 0);
    }

    public void testResolutionDateInEmail() throws InterruptedException, MessagingException, IOException {
        this.administration.restoreData("TestIssueNotifications.xml");
        this.configureAndStartSmtpServer();
        this.tester.clickLink("view_profile");
        this.tester.clickLink("edit_prefs_lnk");
        this.tester.selectOption("userNotificationsMimeType", "HTML");
        this.tester.submit();
        this.navigation.issue().viewIssue("COW-1");
        this.tester.clickLink("comment-issue");
        this.tester.setWorkingForm("comment-add");
        this.tester.setFormElement("comment", "Test comment");
        this.tester.submit("Add");
        this.tester.clickLink("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.flushMailQueueAndWait(2);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestIssueNotifications.assertEquals((int)2, (int)messagesForAdmin.size());
        MimeMessage message = messagesForAdmin.get(0);
        TestIssueNotifications.assertTrue((boolean)message.getSubject().contains("Commented"));
        this.assertEmailBodyDoesntContain(message, "Resolved:");
        MimeMessage resolvedMessage = messagesForAdmin.get(1);
        TestIssueNotifications.assertTrue((boolean)resolvedMessage.getSubject().contains("Resolved"));
        this.assertEmailBodyContains(resolvedMessage, "Resolved:");
    }

    public void testMailOrdering() throws Exception {
        String originalComment = "This text will be soon edited";
        String newCommentAdmin = "The administrator just edited this text";
        String newCommentAnon = "An anonymous user just edited this text";
        String emailSubject = "[JIRATEST] Issue Comment Edited: (COW-1) The cow is in the pasture";
        this.administration.restoreData("TestIssueNotificationsAnonymous.xml");
        this.configureAndStartSmtpServer();
        this.editIssue("This text will be soon edited", "henry.ford", "COW-1", "comment-issue");
        this.editIssueInForm("The administrator just edited this text", "admin", "COW-1", "edit_comment_10000", "comment-edit", "The administrator just edited this text");
        this.editIssueInForm("The administrator just edited this text", null, "COW-1", "edit_comment_10000", "comment-edit", "An anonymous user just edited this text");
        this.navigation.login("admin");
        this.flushMailQueueAndWait(6);
        MimeMessage[] messages = this.getGreenMail().getReceivedMessages();
        TestIssueNotifications.assertEquals((int)6, (int)messages.length);
        Date firstDate = messages[0].getSentDate();
        boolean notInOrder = false;
        for (MimeMessage message : messages) {
            notInOrder = message.getSentDate().before(firstDate);
        }
        TestIssueNotifications.assertFalse((boolean)notInOrder);
    }

    private void assertMailProperties(MimeMessage message, String issueId, String subject) throws MessagingException {
        TestIssueNotifications.assertEquals((String)subject, (String)message.getHeader("Subject")[0]);
        TestIssueNotifications.assertEquals((String)"\"admin (JIRA)\" <jiratest@atlassian.com>", (String)message.getHeader("From")[0]);
        String body = GreenMailUtil.getBody((Part)message);
        TestIssueNotifications.assertTrue((body.indexOf("admin deleted " + issueId) >= 0 ? 1 : 0) != 0);
    }

    private String getPrefUrl(String body) {
        String path = "/secure/ViewProfile.jspa";
        TestIssueNotifications.assertTrue((String)("Could not find link to User Preferences in email body: \n-----\n" + body + "\n-----\n"), (body.indexOf("/secure/ViewProfile.jspa") >= 0 ? 1 : 0) != 0);
        return "/secure/ViewProfile.jspa";
    }
}

