/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard;

import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.dashboard.DashboardPageInfo;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.sharing.ProjectTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.lang.StringUtils;

public class TestSearchDashboardPages
extends FuncTestCase {
    private static final String NEXT_LINK_TEXT = "Next >>";
    private static final String PREVIOUS_LINK_TEXT = "<< Previous";
    private static final int PAGE_SIZE = 20;
    private static final String GROUP_SHAREWITH = "sharewith-group";
    private static final String GROUP_ALICE = "alicegroup";
    private static final int PROJECT_HOMOSAPIEN = 10000;
    private static final String PROJECT_HOMOSAPIEN_NAME = "homosapien";
    private static final int PROJECT_MONKEY = 10001;
    private static final String PROJECT_MONKEY_NAME = "monkey";
    private static final int ROLE_USERS = 10000;
    private static final int ROLE_DEVELOPERS = 10001;
    private static final int ROLE_ADMINISTRATORS = 10002;
    private static final String ROLE_USERS_NAME = "Users";
    private static final String ROLE_DEVELOPERS_NAME = "Developers";
    private static final String USER_ALICE = "alice";
    private static final String USER_ADMIN = "admin";
    private static final String USER_FRED = "fred";
    private static final DashboardPageInfo PAGE_ALICE_GROUP = new DashboardPageInfo(10040L, "alicegroup", null, false, TestSharingPermissionUtils.createGroupPermissions("sharewith-group"), "alice", 1, null);
    private static final DashboardPageInfo PAGE_ALICE_ROLE = new DashboardPageInfo(10060L, "alice role", null, true, Collections.singleton(new ProjectTestSharingPermission(10000L, 10001L, "homosapien", "Developers")), "alice", 1, null);
    private static final DashboardPageInfo PAGE_FRED_PROJECT = new DashboardPageInfo(10042L, "fredproject", null, true, Collections.singleton(new ProjectTestSharingPermission(10000L, "homosapien")), "fred", 3, null);
    private static final DashboardPageInfo PAGE_FRED_ROLE = new DashboardPageInfo(10043L, "fred role", null, false, Collections.singleton(new ProjectTestSharingPermission(10000L, "homosapien")), "fred", 1, null);
    private static final DashboardPageInfo PAGE_FRED_PROJECT_MONEY = new DashboardPageInfo(10116L, "fredmonkey", "fredmonkey description", false, Collections.singleton(new ProjectTestSharingPermission(10001L, "monkey")), "fred", 1, null);
    private static final DashboardPageInfo PAGE_ADMIN_PRIVATE = new DashboardPageInfo(10050L, "privateadmin", null, false, TestSharingPermissionUtils.createPrivatePermissions(), "admin", 0, null);
    private static final DashboardPageInfo PAGE_SYSTEM_DEFAULT = new DashboardPageInfo(null, "System Dashboard", null, false, TestSharingPermissionUtils.createPublicPermissions(), "System", (Integer)0, null);
    private static final DashboardPageInfo PAGE_ADMIN_AZ = new DashboardPageInfo(10010L, "a", "z", false, TestSharingPermissionUtils.createPublicPermissions(), "admin", 0, null);

    @Override
    protected void setUpTest() {
        this.administration.restoreData("sharedpages/SimpleDashboardSearch.xml");
    }

    public void testInitialState() {
        this.navigation.dashboard().navigateToSearch();
        this.tester.assertFormElementEquals("searchName", "");
        this.tester.assertFormElementEquals("searchOwnerUserName", "");
        this.tester.assertFormElementEquals("searchShareType", "any");
    }

    public void testAllSearch() {
        ArrayList<DashboardPageInfo> pages = new ArrayList<DashboardPageInfo>();
        this.addAdminPages(pages);
        this.executeSimpleSearch(null, null);
        this.assertSearchResults(pages);
    }

    public void testNameSearch() {
        ArrayList<DashboardPageInfo> pages = new ArrayList<DashboardPageInfo>();
        pages.add(PAGE_ADMIN_AZ);
        pages.add(PAGE_FRED_PROJECT);
        pages.add(PAGE_FRED_ROLE);
        pages.add(PAGE_FRED_PROJECT_MONEY);
        pages.add(new DashboardPageInfo(10035L, "z", null, false, TestSharingPermissionUtils.createPublicPermissions(), USER_ADMIN, 0, null));
        this.executeSimpleSearch("fred* z*", null);
        this.assertSearchResults(pages);
    }

    public void testNameSearchNoResults() {
        this.executeSimpleSearch("zoobars", null);
        this.assertNoMatch();
    }

    public void testUserSearch() {
        ArrayList<DashboardPageInfo> pages = new ArrayList<DashboardPageInfo>();
        this.addAdminPublic(pages);
        pages.add(PAGE_ADMIN_PRIVATE);
        this.executeSimpleSearch(null, USER_ADMIN);
        this.assertSearchResults(pages);
    }

    public void testUserNotExistSearch() {
        this.executeSimpleSearch(null, "userWhoDoesNotExit");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("The user 'userWhoDoesNotExit' does not exist.");
    }

    public void testNameAndUserSearch() {
        ArrayList<DashboardPageInfo> pages = new ArrayList<DashboardPageInfo>();
        pages.add(PAGE_FRED_PROJECT);
        pages.add(PAGE_FRED_ROLE);
        pages.add(PAGE_FRED_PROJECT_MONEY);
        this.executeSimpleSearch("fred* z*", USER_FRED);
        this.assertSearchResults(pages);
    }

    public void testGroupSearch() {
        ArrayList<DashboardPageInfo> pages = new ArrayList<DashboardPageInfo>();
        pages.add(PAGE_ALICE_GROUP);
        this.executeGroupSearch(null, null, GROUP_SHAREWITH);
        this.assertSearchResults(pages);
    }

    public void testGroupSearchNoMatch() {
        this.executeGroupSearch(null, null, "jira-users");
        this.assertNoMatch();
    }

    public void testGroupAndNameSearch() {
        this.executeGroupSearch(USER_FRED, null, GROUP_SHAREWITH);
        this.assertNoMatch();
    }

    public void testGroupDoesNotExist() {
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa?view=search&searchName=&searchOwnerUserName=&searchShareType=group&groupShare=somerandomgroup&Search=Search");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("Group: 'somerandomgroup' does not exist.");
    }

    public void testGroupNotMember() {
        this.navigation.login(USER_ALICE);
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa?view=search&searchName=&searchOwnerUserName=&searchShareType=group&groupShare=jira-developers&Search=Search");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("You are not a member of Group: 'jira-developers'.");
    }

    public void testGroupExact() {
        this.navigation.login(USER_ALICE);
        ArrayList<DashboardPageInfo> pages = new ArrayList<DashboardPageInfo>();
        this.addDashboardPages(pages, GROUP_ALICE, 'a', 't', 10070L, USER_ALICE, TestSharingPermissionUtils.createGroupPermissions(GROUP_ALICE));
        this.executeGroupSearch(null, null, GROUP_ALICE);
        this.assertSearchResults(pages);
    }

    public void testProjectSearch() {
        ArrayList<DashboardPageInfo> pages = new ArrayList<DashboardPageInfo>();
        pages.add(PAGE_FRED_PROJECT);
        pages.add(PAGE_FRED_ROLE);
        this.executeProjectSearch(null, null, 10000, -1);
        this.assertSearchResults(pages);
    }

    public void testProjectSearchAlice() {
        this.navigation.login(USER_ALICE);
        HashSet<ProjectTestSharingPermission> permissions = new HashSet<ProjectTestSharingPermission>();
        permissions.add(new ProjectTestSharingPermission(10000L, PROJECT_HOMOSAPIEN_NAME));
        permissions.add(new ProjectTestSharingPermission(10000L, 10000L, PROJECT_HOMOSAPIEN_NAME, ROLE_USERS_NAME));
        ArrayList<DashboardPageInfo> pages = new ArrayList<DashboardPageInfo>();
        DashboardPageInfo pageInfo = new DashboardPageInfo(PAGE_FRED_PROJECT);
        pageInfo.setFavourite(true);
        pages.add(pageInfo);
        pageInfo = new DashboardPageInfo(PAGE_FRED_ROLE);
        pageInfo.setFavourite(true);
        pageInfo.setSharingPermissions(permissions);
        pages.add(pageInfo);
        pages.add(PAGE_ALICE_ROLE);
        this.executeProjectSearch(null, null, 10000, -1);
        this.assertSearchResults(pages);
    }

    public void testProjectSearchNoMatch() {
        this.executeProjectSearch("alice in wonderland", null, 10000, -1);
        this.assertNoMatch();
    }

    public void testProjectSearchWithAuthorAndName() {
        ArrayList<DashboardPageInfo> pages = new ArrayList<DashboardPageInfo>();
        pages.add(PAGE_FRED_ROLE);
        this.executeProjectSearch("role", USER_FRED, 10000, -1);
        this.assertSearchResults(pages);
    }

    public void testProjectSearchOnProjectThatDoesNotExist() {
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa?view=search&searchName=&searchOwnerUserName=&searchShareType=project&groupShare=jira-administrators&projectShare=10006&roleShare=&Search=Search");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("The project with identifier '10,006' does not exist.");
    }

    public void testProjectSearchNoPermission() {
        this.navigation.login(USER_ALICE);
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa?view=search&searchName=&searchOwnerUserName=&searchShareType=project&groupShare=jira-administrators&projectShare=10001&roleShare=&Search=Search");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("You do not have permission to view the project.");
    }

    public void testProjectSearchPaging() {
        this.navigation.login(USER_FRED);
        ArrayList<DashboardPageInfo> pages = new ArrayList<DashboardPageInfo>();
        DashboardPageInfo info = new DashboardPageInfo(PAGE_FRED_PROJECT_MONEY);
        info.setFavourite(true);
        pages.add(info);
        this.addDashboardPages(pages, "fredmonkeyrole", 'a', 'z', 10090L, USER_FRED, TestSharingPermissionUtils.createProjectPermissions(10001L, 10000L, PROJECT_MONKEY_NAME, ROLE_USERS_NAME));
        this.executeProjectSearch(null, null, 10001, -1);
        this.assertSearchResults(pages);
    }

    public void testProjectBadArgument() {
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa?view=search&searchName=&searchOwnerUserName=&searchShareType=project&groupShare=jira-administrators&projectShare=10000a&roleShare=10001&Search=Search");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("Illegal search parameters.");
    }

    public void testRoleSearch() {
        this.navigation.login(USER_ALICE);
        HashSet<ProjectTestSharingPermission> permissions = new HashSet<ProjectTestSharingPermission>();
        permissions.add(new ProjectTestSharingPermission(10000L, PROJECT_HOMOSAPIEN_NAME));
        permissions.add(new ProjectTestSharingPermission(10000L, 10000L, PROJECT_HOMOSAPIEN_NAME, ROLE_USERS_NAME));
        ArrayList<DashboardPageInfo> pages = new ArrayList<DashboardPageInfo>();
        DashboardPageInfo pageInfo = new DashboardPageInfo(PAGE_FRED_ROLE);
        pageInfo.setSharingPermissions(permissions);
        pageInfo.setFavourite(true);
        pages.add(pageInfo);
        this.executeProjectSearch(null, null, 10000, 10000);
        this.assertSearchResults(pages);
    }

    public void testRoleSearchNoResults() {
        this.executeProjectSearch(null, null, 10000, 10002);
        this.assertNoMatch();
    }

    public void testRoleSearchComplex() {
        this.navigation.login(USER_ALICE);
        ArrayList<DashboardPageInfo> pages = new ArrayList<DashboardPageInfo>();
        pages.add(PAGE_ALICE_ROLE);
        this.executeProjectSearch("role bad", USER_ALICE, 10000, 10001);
        this.assertSearchResults(pages);
    }

    public void testRoleSearchComplexNoResults() {
        this.navigation.login(USER_ALICE);
        this.executeProjectSearch("role", USER_ALICE, 10000, 10000);
        this.assertNoMatch();
    }

    public void testRolePaging() {
        this.navigation.login(USER_FRED);
        ArrayList<DashboardPageInfo> pages = new ArrayList<DashboardPageInfo>();
        this.addDashboardPages(pages, "fredmonkeyrole", 'a', 'z', 10090L, USER_FRED, TestSharingPermissionUtils.createProjectPermissions(10001L, 10000L, PROJECT_MONKEY_NAME, ROLE_USERS_NAME));
        this.executeProjectSearch(null, null, 10001, 10000);
        this.assertSearchResults(pages);
    }

    public void testRoleRoleDoesNotExist() {
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa?view=search&searchName=&searchOwnerUserName=&searchShareType=project&groupShare=jira-administrators&projectShare=10000&roleShare=100222&Search=Search");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("The project role with identifier '100,222' does not exist.");
    }

    public void testRoleNotMember() {
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa?view=search&searchName=&searchOwnerUserName=&searchShareType=project&groupShare=jira-administrators&projectShare=10000&roleShare=10001&Search=Search");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("You are not in the specified project role.");
    }

    public void testRoleIllegalRole() {
        this.tester.gotoPage("secure/ConfigurePortalPages!default.jspa?view=search&searchName=&searchOwnerUserName=&searchShareType=project&groupShare=jira-administrators&projectShare=10000&roleShare=10001s&Search=Search");
        ArrayList<DashboardPageInfo> pages = new ArrayList<DashboardPageInfo>();
        pages.add(PAGE_FRED_PROJECT);
        pages.add(PAGE_FRED_ROLE);
        this.assertSearchResults(pages);
    }

    public void testSortRestart() {
        this.executeSimpleSearch(null, null);
        this.tester.clickLinkWithText(NEXT_LINK_TEXT);
        this.tester.clickLink("page_sort_popularity");
        ArrayList<DashboardPageInfo> pages = new ArrayList<DashboardPageInfo>();
        this.addAdminPages(pages);
        Collections.sort(pages, this.createPopularComparator(true));
        this.checkNext(pages);
    }

    private void executeProjectSearch(String name, String author, int projectId, int roleId) {
        this.setSimpleSearch(name, author);
        this.tester.setFormElement("searchShareType", "project");
        this.tester.setFormElement("projectShare", String.valueOf(projectId));
        if (roleId >= 0) {
            this.tester.setFormElement("roleShare", String.valueOf(roleId));
        }
        this.tester.submit("Search");
    }

    private void executeGroupSearch(String text, String userName, String group) {
        this.setSimpleSearch(text, userName);
        this.tester.setFormElement("searchShareType", "group");
        this.tester.setFormElement("groupShare", group);
        this.tester.submit("Search");
    }

    private void executeSimpleSearch(String text, String userName) {
        this.setSimpleSearch(text, userName);
        this.tester.submit("Search");
    }

    private void setSimpleSearch(String text, String userName) {
        this.navigation.dashboard().navigateToSearch();
        this.tester.setWorkingForm("pageSearchForm");
        if (StringUtils.isNotBlank((String)text)) {
            this.tester.setFormElement("searchName", text);
        }
        if (StringUtils.isNotBlank((String)userName)) {
            this.tester.setFormElement("searchOwnerUserName", userName);
        }
    }

    private Comparator<DashboardPageInfo> createPopularComparator(boolean reverse) {
        Comparator<DashboardPageInfo> authorComparator = PopularComparator.POPULAR_COMPARATOR;
        if (reverse) {
            authorComparator = ComparatorUtils.reversedComparator((Comparator)authorComparator);
        }
        return ComparatorUtils.chainedComparator((Comparator)authorComparator, (Comparator)NameComparator.NAME_COMPARATOR);
    }

    private Comparator<DashboardPageInfo> createAuthorComparator(boolean reverse) {
        Comparator<DashboardPageInfo> authorComparator = AuthorComparator.AUTHOR_COMPARATOR;
        if (reverse) {
            authorComparator = ComparatorUtils.reversedComparator((Comparator)authorComparator);
        }
        return ComparatorUtils.chainedComparator((Comparator)authorComparator, (Comparator)NameComparator.NAME_COMPARATOR);
    }

    private void addAdminPublic(List<DashboardPageInfo> pages) {
        this.addAdminPublicDashboardPages(pages, "", 'b', 'z', 10011L);
        pages.add(PAGE_ADMIN_AZ);
    }

    private void addAdminPages(List<DashboardPageInfo> pages) {
        this.addAdminPublic(pages);
        pages.add(PAGE_ALICE_GROUP);
        pages.add(PAGE_FRED_PROJECT);
        pages.add(PAGE_FRED_ROLE);
        pages.add(PAGE_ADMIN_PRIVATE);
        pages.add(PAGE_SYSTEM_DEFAULT);
        pages.add(PAGE_FRED_PROJECT_MONEY);
    }

    private void addAdminPublicDashboardPages(List<DashboardPageInfo> items, String name, char startChar, char endChar, long initialId) {
        this.addDashboardPages(items, name, startChar, endChar, initialId, USER_ADMIN, TestSharingPermissionUtils.createPublicPermissions());
    }

    private void addDashboardPages(List<DashboardPageInfo> items, String name, char startChar, char endChar, long initialId, String user, Set<TestSharingPermission> shares) {
        long currentId = initialId;
        for (char currentChar = startChar; currentChar <= endChar; currentChar = (char)(currentChar + '\u0001')) {
            items.add(new DashboardPageInfo(currentId, name + currentChar, null, false, shares, user, 0, null));
            ++currentId;
        }
    }

    private void assertNoMatch() {
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Your search criteria did not match any dashboards.");
        TableLocator locator = new TableLocator(this.tester, Dashboard.Table.SEARCH.getTableId());
        TestSearchDashboardPages.assertNull((String)"Search results should not be present.", (Object)locator.getNode());
    }

    private void assertSearchResults(List<DashboardPageInfo> expectedItems) {
        Collections.sort(expectedItems, NameComparator.NAME_COMPARATOR);
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
        this.tester.clickLink("page_sort_name");
        Collections.sort(expectedItems, ComparatorUtils.reversedComparator((Comparator)NameComparator.NAME_COMPARATOR));
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
        this.tester.clickLink("page_sort_owner");
        Collections.sort(expectedItems, this.createAuthorComparator(false));
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
        this.tester.clickLink("page_sort_owner");
        Collections.sort(expectedItems, this.createAuthorComparator(true));
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
        this.tester.clickLink("page_sort_popularity");
        Collections.sort(expectedItems, this.createPopularComparator(true));
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
        this.tester.clickLink("page_sort_popularity");
        Collections.sort(expectedItems, this.createPopularComparator(false));
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
    }

    private void checkNext(List<DashboardPageInfo> items) {
        int iterations = items.size() / 20;
        int remainder = items.size() % 20;
        if (iterations == 0 || items.size() == 20) {
            this.tester.assertLinkNotPresentWithText(PREVIOUS_LINK_TEXT);
            this.tester.assertLinkNotPresentWithText(NEXT_LINK_TEXT);
            this.assertPageResults("All filters not on first screen.", items);
        } else {
            for (int i = 1; i <= iterations; ++i) {
                int startPos = (i - 1) * 20;
                int endPos = i * 20;
                List<DashboardPageInfo> expectedItems = items.subList(startPos, endPos);
                this.assertPageResults("Page " + i + " did not contain expected pages.", expectedItems);
                if (i == 1) {
                    this.tester.assertLinkNotPresentWithText(PREVIOUS_LINK_TEXT);
                } else {
                    this.tester.assertLinkPresentWithText(PREVIOUS_LINK_TEXT);
                }
                this.tester.assertTextPresent("" + (startPos + 1) + " - " + endPos);
                if (remainder == 0 && i == iterations) {
                    this.tester.assertLinkNotPresent(NEXT_LINK_TEXT);
                    continue;
                }
                this.tester.assertLinkPresentWithText(NEXT_LINK_TEXT);
                this.tester.clickLinkWithText(NEXT_LINK_TEXT);
            }
            if (remainder != 0) {
                this.tester.assertLinkPresentWithText(PREVIOUS_LINK_TEXT);
                this.tester.assertLinkNotPresentWithText(NEXT_LINK_TEXT);
                int startPos = iterations * 20;
                this.tester.assertTextPresent("" + (startPos + 1) + " - " + items.size());
                List<DashboardPageInfo> expectedItems = items.subList(startPos, items.size());
                this.assertPageResults("Last page did not contain expected pages.", expectedItems);
            }
        }
    }

    private void checkPrevious(List<DashboardPageInfo> items) {
        int iterations = items.size() / 20;
        int remainder = items.size() % 20;
        if (iterations == 0 || items.size() == 20) {
            this.tester.assertLinkNotPresentWithText(PREVIOUS_LINK_TEXT);
            this.tester.assertLinkNotPresentWithText(NEXT_LINK_TEXT);
            this.assertPageResults("All filters not on first screen.", items);
        } else {
            if (remainder != 0) {
                this.tester.assertLinkNotPresentWithText(NEXT_LINK_TEXT);
                int startPos = iterations * 20;
                this.tester.assertTextPresent("" + (startPos + 1) + " - " + items.size());
                List<DashboardPageInfo> expectedItems = items.subList(startPos, items.size());
                this.assertPageResults("Last page did not contain expected pages.", expectedItems);
                this.tester.clickLinkWithText(PREVIOUS_LINK_TEXT);
            }
            for (int i = iterations; i > 0; --i) {
                int startPos = (i - 1) * 20;
                int endPos = i * 20;
                List<DashboardPageInfo> expectedItems = items.subList(startPos, endPos);
                this.assertPageResults("Page " + i + " did not contain expected pages.", expectedItems);
                this.tester.assertTextPresent("" + (startPos + 1) + " - " + endPos);
                if (i == 1) {
                    this.tester.assertLinkNotPresentWithText(PREVIOUS_LINK_TEXT);
                } else {
                    this.tester.clickLinkWithText(PREVIOUS_LINK_TEXT);
                }
                if (remainder == 0 && i == iterations) {
                    this.tester.assertLinkNotPresent(NEXT_LINK_TEXT);
                    continue;
                }
                this.tester.assertLinkPresentWithText(NEXT_LINK_TEXT);
            }
        }
    }

    private void assertPageResults(String errorMessage, List<DashboardPageInfo> items) {
        try {
            this.assertions.getDashboardAssertions().assertDashboardPages(items, Dashboard.Table.SEARCH);
        }
        catch (AssertionFailedError e) {
            if (errorMessage != null) {
                AssertionFailedError error = new AssertionFailedError(errorMessage);
                error.initCause((Throwable)e);
                throw error;
            }
            throw e;
        }
    }

    private static class NameComparator
    implements Comparator<DashboardPageInfo> {
        public static final NameComparator NAME_COMPARATOR = new NameComparator();

        private NameComparator() {
        }

        @Override
        public int compare(DashboardPageInfo item1, DashboardPageInfo item2) {
            return item1.getName().compareToIgnoreCase(item2.getName());
        }
    }

    private static class PopularComparator
    implements Comparator<DashboardPageInfo> {
        public static final PopularComparator POPULAR_COMPARATOR = new PopularComparator();

        private PopularComparator() {
        }

        @Override
        public int compare(DashboardPageInfo item1, DashboardPageInfo item2) {
            return (int)(item1.getFavCount().longValue() - item2.getFavCount().longValue());
        }
    }

    private static class AuthorComparator
    implements Comparator<DashboardPageInfo> {
        public static final AuthorComparator AUTHOR_COMPARATOR = new AuthorComparator();

        private AuthorComparator() {
        }

        private static String getName(String authorName) {
            if ("System".equals(authorName)) {
                return null;
            }
            return authorName;
        }

        @Override
        public int compare(DashboardPageInfo o1, DashboardPageInfo o2) {
            String author1 = AuthorComparator.getName(o1.getOwner());
            String author2 = AuthorComparator.getName(o2.getOwner());
            if (author1 == null) {
                if (author2 == null) {
                    return 0;
                }
                return 1;
            }
            if (author2 == null) {
                return -1;
            }
            return author1.compareTo(author2);
        }
    }
}

