/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.matcher;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.TypeSafeMatcher;

public class ContainsStringThatStartsWith<T extends Iterable<String>>
extends TypeSafeMatcher<T> {
    private final String startsWith;

    public static <T extends Iterable<String>> Matcher<T> containsStringThatStartsWith(String startsWith) {
        return new ContainsStringThatStartsWith<T>(startsWith);
    }

    public ContainsStringThatStartsWith(String startsWith) {
        if (startsWith == null) {
            throw new NullPointerException("startsWith");
        }
        this.startsWith = startsWith;
    }

    public boolean matchesSafely(T item) {
        for (String string : item) {
            if (!string.startsWith(this.startsWith)) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText(String.format("An Iterable containing a string that starts with \"%s\"", this.startsWith));
    }
}

