/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client;

import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Attachment;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Comment;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Component;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueLink;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueType;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Priority;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Project;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Resolution;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Status;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.TimeTracking;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.User;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Version;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Vote;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Watchers;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Worklog;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.codehaus.jackson.annotate.JsonAnySetter;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

public class Issue {
    public String self;
    public String key;
    public Fields fields;
    public Html html;
    public String expand;
    public String transitions;

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public static enum Expand {
        html;

    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Html {
        public String description;
        public String environment;
        public List<String> comment;
        public List<String> worklog;

        public int length() {
            int len = 0;
            for (Field field : Html.class.getFields()) {
                try {
                    if (field.get(this) == null) continue;
                    ++len;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return len;
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }
    }

    public static class IssueField<T> {
        public String name;
        public String type;
        public T value;

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Fields {
        public IssueField<List<Attachment>> attachment;
        public IssueField<List<Comment>> comment;
        public IssueField<String> description;
        public IssueField<String> environment;
        public IssueField<String> summary;
        public IssueField<Vote> votes;
        public IssueField<String> security;
        public IssueField<String> resolutiondate;
        public IssueField<String> updated;
        public IssueField<String> created;
        public IssueField<String> duedate;
        public IssueField<TimeTracking> timetracking;
        public IssueField<List<String>> labels;
        public IssueField<IssueType> issuetype;
        public IssueField<List<Version>> fixVersions;
        public IssueField<List<Version>> versions;
        public IssueField<List<Component>> components;
        public IssueField<Priority> priority;
        public IssueField<Project> project;
        public IssueField<Resolution> resolution;
        public IssueField<User> assignee;
        public IssueField<User> reporter;
        public IssueField<Status> status;
        public IssueField<List<Worklog>> worklog;
        public IssueField<List<IssueLink>> links;
        public IssueField<Watchers> watcher;
        @JsonProperty(value="sub-tasks")
        public IssueField<List<IssueLink>> subtasks;
        public IssueField<IssueLink> parent;
        private Map<String, IssueField<Object>> customFields;

        @JsonAnySetter
        public void addCustomField(String key, IssueField<Object> value) {
            if (this.customFields == null) {
                this.customFields = Maps.newHashMap();
            }
            this.customFields.put(key, value);
        }

        public <T> IssueField<T> get(String fieldID) throws IllegalArgumentException {
            IssueField<Object> customFieldValue = this.customFields.get(fieldID);
            if (customFieldValue != null) {
                return customFieldValue;
            }
            return this.reflectiveGet(fieldID);
        }

        public boolean has(String fieldID) {
            boolean hasCustomField = this.customFields.containsKey(fieldID);
            if (!hasCustomField) {
                return this.getPublicField(fieldID) != null;
            }
            return hasCustomField;
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        private IssueField reflectiveGet(String fieldID) {
            Field f = this.getPublicField(fieldID);
            if (f != null) {
                try {
                    f.get(this);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Couldn't get field value", e);
                }
            }
            throw new IllegalStateException("Field does not exist: " + fieldID);
        }

        private Field getPublicField(String fieldID) {
            try {
                Field f = Fields.class.getDeclaredField(fieldID);
                if (Modifier.isPublic(f.getModifiers())) {
                    return f;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

