/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Project;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.matcher.IsCollectionOf;
import com.google.common.collect.Lists;
import java.util.List;
import org.junit.Assert;

public class TestProjectResource
extends RestFuncTest {
    private ProjectClient projectClient;

    public void testViewProject() throws Exception {
        Project project = this.projectClient.get("HSP");
        TestProjectResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/project/HSP"), (String)project.self);
        TestProjectResource.assertEquals((String)"HSP", (String)project.key);
        TestProjectResource.assertEquals((String)"homosapien", (String)project.name);
        TestProjectResource.assertEquals((String)"project for homosapiens", (String)project.description);
    }

    public void testViewProjectsForAdminUser() throws Exception {
        Assert.assertThat((Object)Lists.newArrayList((Object[])new String[]{"HSP", "MKY", "ATL"}), IsCollectionOf.ofProjectKeys(this.projectClient.getProjects()));
    }

    public void testViewProjectsForAnonymousAccess() throws Exception {
        List<Project> projects = ((ProjectClient)this.projectClient.anonymous()).getProjects();
        Assert.assertThat((Object)Lists.newArrayList((Object[])new String[]{"ATL"}), IsCollectionOf.ofProjectKeys(projects));
    }

    public void testViewProjectDoesNotExist() throws Exception {
        Response respXXX = this.projectClient.getResponse("XXX");
        TestProjectResource.assertEquals((int)404, (int)respXXX.statusCode);
        TestProjectResource.assertEquals((int)1, (int)respXXX.entity.errorMessages.size());
        TestProjectResource.assertTrue((boolean)respXXX.entity.errorMessages.contains("No project could be found with key 'XXX'."));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.projectClient = new ProjectClient(this.getEnvironmentData());
        this.administration.restoreData("TestProjectResource.xml");
    }
}

