/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueType;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueTypeClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;

public class TestIssueTypeResource
extends RestFuncTest {
    private static final String TASK_ISSUE_TYPE_ID = "3";
    private IssueTypeClient issueTypeClient;

    public void testIssueTypeVisible() throws Exception {
        IssueType issueType = this.issueTypeClient.get(TASK_ISSUE_TYPE_ID);
        TestIssueTypeResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issueType/" + TASK_ISSUE_TYPE_ID), (String)issueType.self);
        TestIssueTypeResource.assertEquals((String)"A task that needs to be done.", (String)issueType.description);
        TestIssueTypeResource.assertEquals((String)(this.getBaseUrl() + "/images/icons/task.gif"), (String)issueType.iconUrl);
        TestIssueTypeResource.assertEquals((String)"Task", (String)issueType.name);
        TestIssueTypeResource.assertEquals((boolean)false, (boolean)issueType.subtask);
    }

    public void testIssueTypeNotFound() throws Exception {
        Response response = ((IssueTypeClient)this.issueTypeClient.loginAs("fred")).getResponse(TASK_ISSUE_TYPE_ID);
        TestIssueTypeResource.assertTrue((boolean)response.entity.errorMessages.contains("The issue type with id '3' does not exist"));
        Response responseZzz = ((IssueTypeClient)this.issueTypeClient.loginAs("fred")).getResponse("zzz");
        TestIssueTypeResource.assertEquals((int)404, (int)responseZzz.statusCode);
        TestIssueTypeResource.assertTrue((boolean)responseZzz.entity.errorMessages.contains("The issue type with id 'zzz' does not exist"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueTypeClient = new IssueTypeClient(this.getEnvironmentData());
        this.administration.restoreData("TestIssueTypeResource.xml");
    }
}

