/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Issue;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueClient;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TestIssueResourceCustomFields
extends RestFuncTest {
    private IssueClient issueClient;

    public void testTextField() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Issue.IssueField textField = issue.fields.get("customfield_10021");
        TestIssueResourceCustomFields.assertNotNull(textField);
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:textfield", (String)textField.type);
        TestIssueResourceCustomFields.assertEquals((String)"this is text", (String)((String)textField.value));
    }

    public void testTextArea() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Issue.IssueField textArea = issue.fields.get("customfield_10013");
        TestIssueResourceCustomFields.assertNotNull(textArea);
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:textarea", (String)textArea.type);
        TestIssueResourceCustomFields.assertEquals((String)"lots of text here, brother!", (String)((String)textArea.value));
    }

    public void testDatePicker() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Issue.IssueField datePickerCF = issue.fields.get("customfield_10012");
        TestIssueResourceCustomFields.assertNotNull(datePickerCF);
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:datepicker", (String)datePickerCF.type);
        TestIssueResourceCustomFields.assertEquals((String)"2010-06-23", (String)((String)datePickerCF.value));
    }

    public void testDateTime() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue.IssueField dateTimeCF = this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.get("customfield_10001");
        TestIssueResourceCustomFields.assertNotNull(dateTimeCF);
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:datetime", (String)dateTimeCF.type);
        this.assertEqualDateStrings("2010-06-16T15:26:00.000+1000", (String)dateTimeCF.value);
    }

    public void testFloat() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Issue.IssueField floatCF = issue.fields.get("customfield_10018");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:float", (String)floatCF.type);
        TestIssueResourceCustomFields.assertEquals((Object)42.0, floatCF.value);
    }

    public void testImportId() throws Exception {
        this.administration.restoreData("TestIssueLinkCheck.xml");
        Issue issue = this.issueClient.get("ANOT-1", new Issue.Expand[0]);
        Issue.IssueField bugzillaId = issue.fields.get("customfield_10000");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:importid", (String)bugzillaId.type);
        TestIssueResourceCustomFields.assertEquals((Object)2.0, bugzillaId.value);
    }

    public void testSelect() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue.IssueField selectList = this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.get("customfield_10020");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:select", (String)selectList.type);
        TestIssueResourceCustomFields.assertEquals((String)"Select!", (String)((String)selectList.value));
    }

    public void testRadioButtons() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue.IssueField radioButtons = this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.get("customfield_10019");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons", (String)radioButtons.type);
        TestIssueResourceCustomFields.assertEquals((String)"Radio Ga Ga", (String)((String)radioButtons.value));
    }

    public void testProject() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue.IssueField projectPicker = this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.get("customfield_10007");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:project", (String)projectPicker.type);
        TestIssueResourceCustomFields.assertEquals((Object)(this.getBaseUrl() + "/rest/api/2.0.alpha1/project/MKY"), ((Map)projectPicker.value).get("self"));
        TestIssueResourceCustomFields.assertEquals((Object)"MKY", ((Map)projectPicker.value).get("key"));
    }

    public void testMultiVersion() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue.IssueField multiVersion = this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.get("customfield_10011");
        List versions = (List)multiVersion.value;
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:multiversion", (String)multiVersion.type);
        TestIssueResourceCustomFields.assertEquals((int)2, (int)versions.size());
        Map v1 = (Map)versions.get(0);
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/version/10000"), (String)((String)v1.get("self")));
        TestIssueResourceCustomFields.assertEquals((String)"New Version 1", (String)((String)v1.get("name")));
        Map v5 = (Map)versions.get(1);
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/version/10002"), (String)((String)v5.get("self")));
        TestIssueResourceCustomFields.assertEquals((String)"New Version 5", (String)((String)v5.get("name")));
    }

    public void testVersion() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue.IssueField version = this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.get("customfield_10009");
        Map v4 = (Map)version.value;
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:version", (String)version.type);
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/version/10001"), (String)((String)v4.get("self")));
        TestIssueResourceCustomFields.assertEquals((String)"New Version 4", (String)((String)v4.get("name")));
    }

    public void testUserPicker() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue.IssueField userPicker = this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.get("customfield_10022");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:userpicker", (String)userPicker.type);
        Map fred = (Map)userPicker.value;
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/user?username=fred"), (String)((String)fred.get("self")));
        TestIssueResourceCustomFields.assertEquals((String)"fred", (String)((String)fred.get("name")));
        TestIssueResourceCustomFields.assertEquals((String)"Fred Normal", (String)((String)fred.get("displayName")));
    }

    public void testUrl() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue.IssueField url = this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.get("customfield_10010");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:url", (String)url.type);
        TestIssueResourceCustomFields.assertEquals((String)"http://www.atlassian.com", (String)((String)url.value));
    }

    public void testMultiSelect() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue.IssueField multiSelect = this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.get("customfield_10017");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:multiselect", (String)multiSelect.type);
        TestIssueResourceCustomFields.assertEquals(Arrays.asList("Option 2", "Option 3"), multiSelect.value);
    }

    public void testMultiCheckboxes() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue.IssueField multiCheckbox = this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.get("customfield_10016");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes", (String)multiCheckbox.type);
        TestIssueResourceCustomFields.assertEquals(Arrays.asList("check out my stats"), multiCheckbox.value);
    }

    public void testMultiUserPicker() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue.IssueField multiUser = this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.get("customfield_10006");
        List users = (List)multiUser.value;
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker", (String)multiUser.type);
        TestIssueResourceCustomFields.assertEquals((int)2, (int)users.size());
        Map admin = (Map)users.get(0);
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)((String)admin.get("self")));
        TestIssueResourceCustomFields.assertEquals((String)"admin", (String)((String)admin.get("name")));
        TestIssueResourceCustomFields.assertEquals((String)"Administrator", (String)((String)admin.get("displayName")));
        Map fred = (Map)users.get(1);
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/user?username=fred"), (String)((String)fred.get("self")));
        TestIssueResourceCustomFields.assertEquals((String)"fred", (String)((String)fred.get("name")));
        TestIssueResourceCustomFields.assertEquals((String)"Fred Normal", (String)((String)fred.get("displayName")));
    }

    public void testMultiGroupPicker() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue.IssueField multiGroup = this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.get("customfield_10005");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker", (String)multiGroup.type);
        TestIssueResourceCustomFields.assertEquals((String)"jira-developers", (String)((String)((List)multiGroup.value).get(0)));
        TestIssueResourceCustomFields.assertEquals((String)"jira-users", (String)((String)((List)multiGroup.value).get(1)));
    }

    public void testGroupPicker() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue.IssueField group = this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.get("customfield_10002");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:grouppicker", (String)group.type);
        TestIssueResourceCustomFields.assertEquals((String)"jira-developers", (String)((String)group.value));
    }

    public void testCascadingSelect() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue.IssueField cascadingSelect = this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.get("customfield_10000");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect", (String)cascadingSelect.type);
        TestIssueResourceCustomFields.assertEquals(Arrays.asList("Option 2", "Sub-option I"), cascadingSelect.value);
    }

    public void testLabels() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue.IssueField labels = this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.get("customfield_10004");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:labels", (String)labels.type);
        TestIssueResourceCustomFields.assertEquals(Arrays.asList("wack", "whoa"), labels.value);
    }

    public void testEmptyFieldsReturned() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        this.navigation.issue().createIssue("homosapien", "Bug", "some issue");
        Issue issue = this.issueClient.get("HSP-2", new Issue.Expand[0]);
        Issue.Fields fields = issue.fields;
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10000"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10000").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10012"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10012").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10001"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10001").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10013"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10013").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10002"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10002").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10003"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10003").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10016"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10016").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10017"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10017").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10005"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10005").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10006"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10006").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10018"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10018").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10007"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10007").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10019"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10019").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10008"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10008").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10020"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10020").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10009"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10009").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10021"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10021").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10010"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10010").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10022"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10022").value);
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10011"));
        TestIssueResourceCustomFields.assertNull(fields.get((String)"customfield_10011").value);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient(this.getEnvironmentData());
    }
}

