/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueLinkType;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueLinkTypeClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueLinkTypes;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;
import java.util.List;

public class TestIssueLinkTypeResource
extends RestFuncTest {
    private IssueLinkTypeClient issueLinkTypeClient;

    public void testGetAllIssueLinkTypes() throws Exception {
        IssueLinkTypes issueLinkTypes = this.issueLinkTypeClient.getIssueLinkTypes();
        List<IssueLinkType> list = issueLinkTypes.issueLinkTypes;
        TestIssueLinkTypeResource.assertEquals((int)2, (int)list.size());
        IssueLinkType type = list.get(0);
        TestIssueLinkTypeResource.assertEquals((String)type.name, (String)"Blocks");
        TestIssueLinkTypeResource.assertEquals((String)"Blocks", (String)type.outward);
        TestIssueLinkTypeResource.assertEquals((String)"Blocked by", (String)type.inward);
        TestIssueLinkTypeResource.assertEquals((int)new Long(10100L).intValue(), (int)type.id.intValue());
        TestIssueLinkTypeResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/issueLinkType/10100"), (String)type.self.toString());
        type = list.get(1);
        TestIssueLinkTypeResource.assertEquals((String)type.name, (String)"Duplicate");
        TestIssueLinkTypeResource.assertEquals((String)"Duplicates", (String)type.outward);
        TestIssueLinkTypeResource.assertEquals((String)"Duplicated by", (String)type.inward);
        TestIssueLinkTypeResource.assertEquals((int)new Long(10000L).intValue(), (int)type.id.intValue());
        TestIssueLinkTypeResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/issueLinkType/10000"), (String)type.self.toString());
    }

    public void testGetAllIssueLinkTypesReturns404WhenIssueLinkingDisabled() throws Exception {
        this.oldway_consider_porting.deactivateIssueLinking();
        TestIssueLinkTypeResource.assertEquals((int)404, (int)this.issueLinkTypeClient.getResponseForAllLinkTypes().statusCode);
    }

    public void testGetAllIssueLinkTypesAnonymousUserAllowed() throws Exception {
        IssueLinkTypes issueLinkTypes = ((IssueLinkTypeClient)this.issueLinkTypeClient.anonymous()).getIssueLinkTypes();
        List<IssueLinkType> list = issueLinkTypes.issueLinkTypes;
        TestIssueLinkTypeResource.assertEquals((int)2, (int)list.size());
    }

    public void testGetIssueLinkTypeReturns404WhenIssueLinkingDisabled() throws Exception {
        this.oldway_consider_porting.deactivateIssueLinking();
        TestIssueLinkTypeResource.assertEquals((int)404, (int)this.issueLinkTypeClient.getResponseForLinkType((String)"10000").statusCode);
    }

    public void testGetIssueLinkType() throws Exception {
        IssueLinkType type = ((IssueLinkTypeClient)this.issueLinkTypeClient.anonymous()).getIssueLinkType("10000");
        TestIssueLinkTypeResource.assertEquals((String)type.name, (String)"Duplicate");
        TestIssueLinkTypeResource.assertEquals((String)"Duplicates", (String)type.outward);
        TestIssueLinkTypeResource.assertEquals((String)"Duplicated by", (String)type.inward);
        TestIssueLinkTypeResource.assertEquals((int)new Long(10000L).intValue(), (int)type.id.intValue());
    }

    public void testGetIssueLinkTypeIssueLinkTypeNotFound() throws Exception {
        Response response = this.issueLinkTypeClient.getResponseForLinkType("10012");
        TestIssueLinkTypeResource.assertEquals((int)404, (int)response.statusCode);
        TestIssueLinkTypeResource.assertEquals((String)"No issue link type with id '10012' found.", (String)response.entity.errorMessages.get(0));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueLinkTypeClient = new IssueLinkTypeClient(this.getEnvironmentData());
        this.administration.restoreData("TestIssueLinkType.xml");
    }
}

