/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Attachment;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.AttachmentClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Response;

public class TestAttachmentResource
extends RestFuncTest {
    private AttachmentClient attachmentClient;

    public void testViewAttachment() throws Exception {
        Attachment attachment1 = this.attachmentClient.get("10000");
        TestAttachmentResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/attachment/10000"), (String)attachment1.self);
        TestAttachmentResource.assertEquals((String)"attachment.txt", (String)attachment1.filename);
        TestAttachmentResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)attachment1.author.self);
        TestAttachmentResource.assertEquals((String)"admin", (String)attachment1.author.name);
        TestAttachmentResource.assertEquals((String)"Administrator", (String)attachment1.author.displayName);
        this.assertEqualDateStrings("2010-06-09T15:59:34.602+1000", attachment1.created);
        TestAttachmentResource.assertEquals((long)19L, (long)attachment1.size);
        TestAttachmentResource.assertEquals((String)"text/plain", (String)attachment1.mimeType);
        TestAttachmentResource.assertEquals((String)(this.getBaseUrl() + "/secure/attachment/10000/attachment.txt"), (String)attachment1.content);
    }

    public void testViewAttachmentNotFound() throws Exception {
        Response response123 = this.attachmentClient.getResponse("123");
        TestAttachmentResource.assertEquals((int)404, (int)response123.statusCode);
        TestAttachmentResource.assertEquals((int)1, (int)response123.entity.errorMessages.size());
        TestAttachmentResource.assertTrue((boolean)response123.entity.errorMessages.contains("The attachment with id '123' does not exist"));
        Response responseAbc = this.attachmentClient.getResponse("abc");
        TestAttachmentResource.assertEquals((int)404, (int)responseAbc.statusCode);
        TestAttachmentResource.assertEquals((int)1, (int)responseAbc.entity.errorMessages.size());
        TestAttachmentResource.assertTrue((boolean)responseAbc.entity.errorMessages.contains("The attachment with id 'abc' does not exist"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.attachmentClient = new AttachmentClient(this.getEnvironmentData());
        this.administration.restoreData("TestIssueResourceAttachments.xml");
    }
}

