/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HeaderOnlyWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public abstract class RestFuncTest
extends FuncTestCase {
    private String baseUrl;

    protected RestFuncTest() {
    }

    protected String getBaseUrl() {
        return this.baseUrl;
    }

    protected String getBaseUrlPlus(String ... paths) {
        String path = paths != null ? StringUtils.join((Object[])paths, (char)'/') : "";
        return String.format("%s/%s", this.getBaseUrl(), path);
    }

    public JSONObject getJSON(String url, String ... expand) throws JSONException {
        String queryString = expand != null && expand.length > 0 ? "?expand=" + StringUtils.join((Object[])expand, (char)',') : "";
        this.tester.gotoPage(url + queryString);
        return new JSONObject(this.tester.getDialog().getResponseText());
    }

    public WebResponse GET(String url) throws IOException, SAXException {
        return this.GET(url, Collections.<String, String>emptyMap());
    }

    public WebResponse GET(String url, Map<String, String> headers) throws IOException, SAXException {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        for (Map.Entry<String, String> headerField : headers.entrySet()) {
            this.tester.getDialog().getWebClient().setHeaderField(headerField.getKey(), headerField.getValue());
        }
        GetMethodWebRequest request = new GetMethodWebRequest(this.getBaseUrlPlus(url));
        return this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
    }

    public WebResponse DELETE(String url) throws IOException, SAXException {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        HeaderOnlyWebRequest delete = new HeaderOnlyWebRequest(this.getBaseUrlPlus(url)){

            public String getMethod() {
                return "DELETE";
            }

            protected void completeRequest(URLConnection connection) throws IOException {
                ((HttpURLConnection)connection).setRequestMethod(this.getMethod());
                super.completeRequest(connection);
            }
        };
        return this.tester.getDialog().getWebClient().sendRequest((WebRequest)delete);
    }

    public WebResponse POST(String url, JSONObject json) throws IOException, SAXException {
        return this.POST(url, json.toString());
    }

    public WebResponse POST(String url, String postBody) throws IOException, SAXException {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        PostMethodWebRequest request = new PostMethodWebRequest(this.getBaseUrlPlus(url), (InputStream)new ByteArrayInputStream(postBody.getBytes()), "application/json");
        return this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.baseUrl = this.getEnvironmentData().getBaseUrl().toExternalForm();
    }

    @Override
    protected void setUpHttpUnitOptions() {
        HttpUnitOptions.setDefaultCharacterSet((String)"UTF-8");
    }

    @Override
    protected void tearDownTest() {
        HttpUnitOptions.resetDefaultCharacterSet();
        super.tearDownTest();
    }

    protected void assertEqualDateStrings(String expected, String actual) {
        String[] expected_split = expected.split("(\\+|\\-)\\d{4}$");
        String[] actual_split = actual.split("(\\+|\\-)\\d{4}$");
        RestFuncTest.assertEquals((String)expected_split[0], (String)actual_split[0]);
    }
}

