/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestIssueFileAttachments
extends FuncTestCase {
    private static final String ATTACHMENT_SETTINGS_TABLE_ID = "AttachmentSettings";
    private static final int ALLOW_ATTACHMENTS_VALUE_COLUMN_NUMBER = 1;
    private static final int ALLOW_ATTACHMENTS_ROW_NUMBER = 1;
    private static final int ENABLE_THUMBNAILS_ROW_NUMBER = 4;
    private static final int ENABLE_THUMBNAILS_VALUE_COLUMN_NUMBER = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueFileAttachmentEnableThumbnailsAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.attachments().enable();
            this.navigation.logout();
            this.navigation.login("admin", "admin");
            this.navigation.gotoAdminSection("attachments");
            this.assertThatAttachmentsAreEnabled();
            this.navigation.clickLinkWithExactText("Edit Configuration");
            this.tester.checkCheckbox("thumbnailsEnabled", "false");
            this.tester.submit("Update");
            this.assertThatThumbnailsAreDisabled();
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    public void testCreateAttachmentsWhenAttachmentsAreDisabled() {
        this.administration.restoreData("TestDeleteAttachments.xml");
        this.tester.gotoPage("/secure/AttachFile!default.jspa?id=10000");
        this.tester.setWorkingForm("attach-file");
        this.tester.submit();
        this.text.assertTextPresent(this.locator.page(), "Attachments have been disabled for this instance of JIRA.");
    }

    private void assertThatAttachmentsAreEnabled() {
        this.text.assertTextPresent(this.locator.cell(ATTACHMENT_SETTINGS_TABLE_ID, 1, 1), "ON");
    }

    private void assertThatThumbnailsAreDisabled() {
        this.text.assertTextSequence(this.locator.cell(ATTACHMENT_SETTINGS_TABLE_ID, 4, 1), "OFF", new String[0]);
    }
}

