/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.assertions.HTMLAssertionsImpl;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.HttpUnitOptions;

public class TestIssueFileAttachmentErrors
extends JIRAWebTest {
    public TestIssueFileAttachmentErrors(String name) {
        super(name);
    }

    @Override
    protected void setUpHttpUnitOptions() {
        TestIssueFileAttachmentErrors.log("not running normal test setup for " + this.getName());
        JIRAEnvironmentData jiraEnvironmentData = this.getEnvironmentData();
        this.tester.getTestContext().setBaseUrl(jiraEnvironmentData.getBaseUrl().toExternalForm());
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestDeleteAttachments.xml");
        this.administration.attachments().enable();
    }

    @Override
    public void tearDown() {
        TestIssueFileAttachmentErrors.log("not running normal test teardown for " + this.getName());
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)true);
    }

    public void testViewAttachmentWithNonNumericId() {
        this.assertErrorResponse("/secure/attachment/idontparse/DummyAttachment", 404, "Attachment not found (id idontparse)");
    }

    public void testViewAttachmentWithNoPath() {
        this.assertErrorResponse("/secure/attachment/", 400, "Invalid attachment path");
    }

    public void testTryDownloadAsZipWhenZipDisabled() throws Exception {
        this.administration.attachments().disableZipSupport();
        this.assertErrorResponse("/secure/attachmentzip/10000.zip", 404, "Attachments as ZIP support is disabled");
    }

    private void assertErrorResponse(String url, int errorCode, String message) {
        this.tester.beginAt(url);
        TestIssueFileAttachmentErrors.assertEquals((int)errorCode, (int)this.tester.getDialog().getResponse().getResponseCode());
        new HTMLAssertionsImpl().assertResponseContains(this.tester, message);
    }
}

