/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigation.issue.AttachmentsBlock;
import com.atlassian.jira.functest.framework.navigation.issue.FileAttachmentsList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class TestAttachmentEncoding
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestAttachmentEncoding.xml");
        this.removeAttachmentFilesFromJiraHome();
        this.copyAttachmentFilesToJiraHome();
    }

    public void testCheckVariousAttachmentFilenames() {
        AttachmentsBlock attachments = this.navigation.issue().attachments("HSP-1");
        List<FileAttachmentsList.FileAttachmentItem> attachmentsList = attachments.list().get();
        TestAttachmentEncoding.assertEquals((int)3, (int)attachmentsList.size());
        this.tester.gotoPage("/secure/attachment/10000/clover.license");
        this.tester.gotoPage("/secure/attachment/10001/sqltool.rc");
        this.tester.gotoPage("/secure/attachment/10002/svn");
    }

    public void testMoveIssue() throws Exception {
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLink("move-issue");
        this.tester.selectOption("pid", "monkey");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit("Move");
        for (FileAttachmentsList.FileAttachmentItem fileAttachmentItem : this.navigation.issue().attachments("MKY-1").list().get()) {
            this.tester.gotoPage("/secure/attachment/" + fileAttachmentItem.getId() + "/" + fileAttachmentItem.getName());
        }
    }

    @Override
    protected void tearDownTest() {
        this.navigation.gotoDashboard();
        this.removeAttachmentFilesFromJiraHome();
        super.tearDownTest();
    }

    protected final void copyAttachmentFilesToJiraHome() {
        File jiraAttachmentsPath = new File(this.administration.getCurrentAttachmentPath());
        File testAttachmentsPath = new File(this.environmentData.getXMLDataLocation(), "TestAttachmentEncoding/attachments");
        try {
            FileUtils.copyDirectory((File)testAttachmentsPath, (File)jiraAttachmentsPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void removeAttachmentFilesFromJiraHome() {
        File jiraAttachmentsPath = new File(this.administration.getCurrentAttachmentPath());
        try {
            FileUtils.cleanDirectory((File)jiraAttachmentsPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

