/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.services;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.meterware.httpunit.WebTable;
import java.io.File;

public class TestBackupService
extends FuncTestCase {
    public void testAddAndEditBackupService() throws Exception {
        this.administration.restoreData("TestBackupService.xml");
        this.navigation.gotoAdminSection("services");
        this.tester.assertTextPresent("Add a new service by entering a name and class below. You can then edit it to set properties");
        this.tester.setFormElement("name", "My Backup Service");
        this.tester.setFormElement("clazz", "com.atlassian.jira.service.services.export.ExportService");
        this.tester.setFormElement("delay", "100");
        this.tester.submit("Add Service");
        this.tester.assertTextPresent("Edit Service: My Backup Service");
        this.tester.assertFormElementEquals("delay", "100");
        this.tester.checkCheckbox("USE_DEFAULT_DIRECTORY", "true");
        this.tester.selectOption("USEZIP", "XML");
        this.tester.setFormElement("delay", "99");
        this.tester.submit("Update");
        WebTable tbl_services = this.tester.getDialog().getWebTableBySummaryOrId("tbl_services");
        TestBackupService.assertEquals((String)"Cell (0, 0) in table 'tbl_services' should be 'Name / Class'.", (String)"Name / Class", (String)tbl_services.getCellAsText(0, 0).trim());
        TestBackupService.assertEquals((String)"Cell (0, 1) in table 'tbl_services' should be 'Properties'.", (String)"Properties", (String)tbl_services.getCellAsText(0, 1).trim());
        TestBackupService.assertEquals((String)"Cell (0, 2) in table 'tbl_services' should be 'Delay (mins)'.", (String)"Delay (mins)", (String)tbl_services.getCellAsText(0, 2).trim());
        TestBackupService.assertEquals((String)"Cell (0, 3) in table 'tbl_services' should be 'Operations'.", (String)"Operations", (String)tbl_services.getCellAsText(0, 3).trim());
        TableLocator tableLocator = new TableLocator(this.tester, "tbl_services");
        this.text.assertTextSequence(tableLocator, "My Backup Service", "com.atlassian.jira.service.services.export.ExportService", "USE_DEFAULT_DIRECTORY", "true", "99");
        this.text.assertTextPresent(tableLocator, "USEZIP");
        this.text.assertTextPresent(tableLocator, "XML");
        this.text.assertTextNotPresent(tableLocator, "DIR_NAME");
        this.tester.clickLink("edit_10020");
        this.tester.uncheckCheckbox("USE_DEFAULT_DIRECTORY");
        this.tester.selectOption("USEZIP", "Zip");
        this.tester.setFormElement("delay", "3600");
        this.tester.submit("Update");
        tableLocator = new TableLocator(this.tester, "tbl_services");
        this.text.assertTextSequence(tableLocator, "My Backup Service", "com.atlassian.jira.service.services.export.ExportService", "3600");
        this.text.assertTextPresent(tableLocator, "USEZIP");
        this.text.assertTextPresent(tableLocator, "Zip");
        this.text.assertTextNotPresent(tableLocator, "USE_DEFAULT_DIRECTORY");
    }

    public void testWhenDataHasLegacyPathInIt() throws Exception {
        this.createPaths(new String[]{"/tmp/custom/attachment/path", "/tmp/custom/indexes/path"});
        this.administration.restoreData("TestCustomPathInLegacyData.xml");
        this.navigation.gotoAdminSection("services");
        TableLocator tableLocator = new TableLocator(this.tester, "tbl_services");
        this.text.assertTextSequence(tableLocator, "File Service", "com.atlassian.jira.service.services.file.FileService", "directory", "/tmp/custom/fileservice/path", "handler", "Non Quoted Comment Handler");
        this.text.assertTextSequence(tableLocator, "Backup Service", "com.atlassian.jira.service.services.export.ExportService", "DIR_NAME", "/tmp/custom/backup/path");
        this.navigation.gotoPage(this.page.addXsrfToken("secure/admin/EditService!default.jspa?id=10021"));
        this.text.assertTextPresent("/tmp/custom/fileservice/path");
        this.tester.submit("Update");
        this.navigation.gotoPage(this.page.addXsrfToken("secure/admin/EditService!default.jspa?id=10001"));
        this.text.assertTextPresent("/tmp/custom/backup/path");
        this.tester.submit("Update");
        this.text.assertTextSequence(tableLocator, "File Service", "com.atlassian.jira.service.services.file.FileService", "directory", "/tmp/custom/fileservice/path", "handler", "Non Quoted Comment Handler");
        this.text.assertTextSequence(tableLocator, "Backup Service", "com.atlassian.jira.service.services.export.ExportService", "DIR_NAME", "/tmp/custom/backup/path");
    }

    private void createPaths(String[] paths) throws Exception {
        for (String path : paths) {
            this.setupDirectory(path);
        }
    }

    private void setupDirectory(String directoryName) throws Exception {
        File directory = new File(directoryName);
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }
}

