/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class TestXsrfWorkflow
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    String createWorkflow() {
        String workflowId = "WK_" + System.currentTimeMillis();
        this.navigation.gotoAdminSection("workflows");
        this.tester.setFormElement("newWorkflowName", workflowId);
        this.tester.setFormElement("description", "My description");
        return workflowId;
    }

    public void testWorkflows() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add Workflow", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.createWorkflow();
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Delete Workflow", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String workflowId = TestXsrfWorkflow.this.createWorkflow();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLink("del_" + workflowId);
            }
        }, new XsrfCheck.FormSubmission("Delete")), new XsrfCheck("Copy Workflow", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String workflowId = TestXsrfWorkflow.this.createWorkflow();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLink("copy_" + workflowId);
            }
        }, new XsrfCheck.FormSubmission("Copy")), new XsrfCheck("Edit Workflow", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String workflowId = TestXsrfWorkflow.this.createWorkflow();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLink("edit_live_" + workflowId);
                TestXsrfWorkflow.this.tester.setFormElement("description", "My new description");
            }
        }, new XsrfCheck.FormSubmission("Edit"))).run(this.funcTestHelperFactory);
    }

    private void addTransition() {
        String workflowId = this.createWorkflow();
        this.tester.submit("Add");
        this.tester.clickLink("steps_live_" + workflowId);
        this.tester.clickLink("add_trans_1");
        this.tester.setFormElement("transitionName", "My transition");
        this.tester.setFormElement("description", "My description");
    }

    public void testWorkflowSteps() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add New Step", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String workflowId = TestXsrfWorkflow.this.createWorkflow();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLink("steps_live_" + workflowId);
                TestXsrfWorkflow.this.tester.setFormElement("stepName", "My step");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Delete Step", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String workflowId = TestXsrfWorkflow.this.createWorkflow();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLink("steps_live_" + workflowId);
                TestXsrfWorkflow.this.tester.setFormElement("stepName", "My step");
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLink("delete_step_2");
            }
        }, new XsrfCheck.FormSubmission("Delete")), new XsrfCheck("Edit Step", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String workflowId = TestXsrfWorkflow.this.createWorkflow();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLink("steps_live_" + workflowId);
                TestXsrfWorkflow.this.tester.clickLink("edit_step_1");
                TestXsrfWorkflow.this.tester.setFormElement("stepName", "My new Step name");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Add Transition", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addTransition();
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Delete Transition from list", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addTransition();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLink("del_trans_1");
                TestXsrfWorkflow.this.tester.selectOption("transitionIds", "My transition");
            }
        }, new XsrfCheck.FormSubmission("Delete")), new XsrfCheck("Edit Transition", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addTransition();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLinkWithText("My transition");
                TestXsrfWorkflow.this.tester.clickLink("edit_transition");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Delete this Transition", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addTransition();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLinkWithText("My transition");
                TestXsrfWorkflow.this.tester.clickLink("delete_transition");
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.funcTestHelperFactory);
    }

    private void addCondition() {
        this.addTransition();
        this.tester.submit("Add");
        this.tester.clickLinkWithText("My transition");
        this.tester.clickLink("view_all_trans");
        this.tester.clickLinkWithText("Conditions");
        this.tester.clickLinkWithText("Add");
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:permission-condition");
        this.tester.submit("Add");
    }

    private void addValidator() {
        this.addTransition();
        this.tester.submit("Add");
        this.tester.clickLinkWithText("My transition");
        this.tester.clickLink("view_all_trans");
        this.tester.clickLinkWithText("Validators");
        this.tester.clickLinkWithText("Add");
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:permission-validator");
        this.tester.submit("Add");
    }

    private void addFunction() {
        this.addTransition();
        this.tester.submit("Add");
        this.tester.clickLinkWithText("My transition");
        this.tester.clickLink("view_all_trans");
        this.tester.clickLinkWithText("Functions");
        this.tester.clickLinkWithText("Add");
        this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:assigntocurrentuser-function");
    }

    public void testWorkflowTransition() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add Condition", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addCondition();
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Delete Condition", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addCondition();
                TestXsrfWorkflow.this.tester.submit("Add");
            }
        }, new XsrfCheck.XPathLinkSubmission("//div[@class='single-leaf']/a[contains(text(), 'Delete')]")), new XsrfCheck("Edit Condition", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addCondition();
                TestXsrfWorkflow.this.tester.submit("Add");
                XPathLocator locator = new XPathLocator(TestXsrfWorkflow.this.getTester(), "//div[@class='single-leaf']/a[contains(text(), 'Edit')]");
                Node node = locator.getNode();
                TestXsrfWorkflow.this.tester.gotoPage(((Attr)node.getAttributes().getNamedItem("href")).getValue());
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Switch group condition to OR", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addCondition();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLinkWithText("Add");
                TestXsrfWorkflow.this.tester.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:permission-condition");
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.submit("Add");
            }
        }, new XsrfCheck.XPathLinkSubmission("//div[@class='operator']/a[contains(text(), 'Switch to OR')]")), new XsrfCheck("Add Validator", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addValidator();
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Delete Validator", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addValidator();
                TestXsrfWorkflow.this.tester.submit("Add");
            }
        }, new XsrfCheck.XPathLinkSubmission("//div[@class='single-leaf']/a[contains(text(), 'Delete')]")), new XsrfCheck("Edit Validator", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addValidator();
                TestXsrfWorkflow.this.tester.submit("Add");
                XPathLocator locator = new XPathLocator(TestXsrfWorkflow.this.getTester(), "//div[@class='single-leaf']/a[contains(text(), 'Edit')]");
                Node node = locator.getNode();
                TestXsrfWorkflow.this.tester.gotoPage(((Attr)node.getAttributes().getNamedItem("href")).getValue());
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Delete Function", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addFunction();
                TestXsrfWorkflow.this.tester.submit("Add");
            }
        }, new XsrfCheck.XPathLinkSubmission("//div[@class='highlighted-leaf']/a[contains(text(), 'Delete')]")), new XsrfCheck("Move Function Up", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addFunction();
                TestXsrfWorkflow.this.tester.submit("Add");
            }
        }, new XsrfCheck.XPathLinkSubmission("//div[@class='highlighted-leaf']/a[contains(text(), 'Move Up')]")), new XsrfCheck("Move Function Down", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addFunction();
                TestXsrfWorkflow.this.tester.submit("Add");
            }
        }, new XsrfCheck.XPathLinkSubmission("//div[@class='highlighted-leaf']/a[contains(text(), 'Move Down')]")), new XsrfCheck("Edit Generic Function", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.addFunction();
                TestXsrfWorkflow.this.tester.submit("Add");
                XPathLocator locator = new XPathLocator(TestXsrfWorkflow.this.getTester(), "//div[@class='leaf']/a[contains(text(), 'Edit')]");
                Node node = locator.getNode();
                TestXsrfWorkflow.this.tester.gotoPage(((Attr)node.getAttributes().getNamedItem("href")).getValue());
            }
        }, new XsrfCheck.FormSubmission("Update"))).run(this.funcTestHelperFactory);
    }

    public void testWorkflowProperties() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add New Property", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String workflowId = TestXsrfWorkflow.this.createWorkflow();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLink("steps_live_" + workflowId);
                TestXsrfWorkflow.this.tester.clickLinkWithText("View Properties");
                TestXsrfWorkflow.this.tester.setFormElement("attributeKey", "key");
                TestXsrfWorkflow.this.tester.setFormElement("attributeValue", "value");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Delete Property", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String workflowId = TestXsrfWorkflow.this.createWorkflow();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLink("steps_live_" + workflowId);
                TestXsrfWorkflow.this.tester.clickLinkWithText("View Properties");
                TestXsrfWorkflow.this.tester.setFormElement("attributeKey", "myKey");
                TestXsrfWorkflow.this.tester.setFormElement("attributeValue", "value");
                TestXsrfWorkflow.this.tester.submit("Add");
            }
        }, new XsrfCheck.LinkWithIdSubmission("del_meta_myKey"))).run(this.funcTestHelperFactory);
    }

    String createStatus() {
        String statusId = "ST_" + System.currentTimeMillis();
        this.navigation.gotoPage("secure/admin/workflows/ViewStatuses.jspa");
        this.navigation.checkWebSudoWithLastPassword();
        this.tester.setFormElement("name", statusId);
        this.tester.setFormElement("description", "My description");
        return statusId;
    }

    public void testWorkflowStatuses() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add New Status", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.createStatus();
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("Delete Status", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.createStatus();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLinkWithText("Delete");
            }
        }, new XsrfCheck.FormSubmission("Delete")), new XsrfCheck("Edit Status", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.createStatus();
                TestXsrfWorkflow.this.tester.submit("Add");
                TestXsrfWorkflow.this.tester.clickLinkWithText("Edit");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("Translate Status", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.createStatus();
                TestXsrfWorkflow.this.tester.clickLink("view-translation");
                TestXsrfWorkflow.this.tester.setFormElement("jira.translation.Status.1.name", "My Name");
                TestXsrfWorkflow.this.tester.setFormElement("jira.translation.Status.1.desc", "My description");
            }
        }, new XsrfCheck.FormSubmission("update"))).run(this.funcTestHelperFactory);
    }

    public void testXmlImport() throws Exception {
        this.navigation.gotoAdminSection("workflows");
        this.tester.clickLink("xml_jira");
        final String xml = this.tester.getDialog().getResponseText();
        new XsrfTestSuite(new XsrfCheck("Import XML", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.navigation.gotoAdminSection("workflows");
                TestXsrfWorkflow.this.tester.clickLinkWithText("import a workflow from XML");
                TestXsrfWorkflow.this.tester.setFormElement("name", "myName");
                TestXsrfWorkflow.this.tester.setFormElement("workflowXML", xml);
            }
        }, new XsrfCheck.FormSubmission("Import"))).run(this.funcTestHelperFactory);
    }

    public void testCreateDraftAndPublishWorkflow() throws Exception {
        this.administration.restoreData("TestDraftWorkflow.xml");
        new XsrfTestSuite(new XsrfCheck("Create Draft", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.navigation.gotoAdminSection("workflows");
            }
        }, new XsrfCheck.LinkWithIdSubmission("createDraft_Workflow1")), new XsrfCheck("Publish Draft", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfWorkflow.this.navigation.gotoAdminSection("workflows");
                TestXsrfWorkflow.this.tester.clickLink("del_Workflow1");
                TestXsrfWorkflow.this.tester.submit("Delete");
                TestXsrfWorkflow.this.tester.clickLink("createDraft_Workflow1");
                TestXsrfWorkflow.this.tester.clickLink("publish_draft_workflow");
                TestXsrfWorkflow.this.tester.checkCheckbox("enableBackup", "false");
            }
        }, new XsrfCheck.FormSubmission("Publish"))).run(this.funcTestHelperFactory);
    }
}

