/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import java.util.ArrayList;
import java.util.Arrays;

public class TestXsrfProjectRoles
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testProjectRoleAdministration() throws Exception {
        ArrayList<XsrfCheck> checks = new ArrayList<XsrfCheck>();
        checks.add(new XsrfCheck("AddProjectRole", new ProjectRoleSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfProjectRoles.this.tester.setWorkingForm("jiraform");
                TestXsrfProjectRoles.this.tester.setFormElement("name", "New Role");
            }
        }, new XsrfCheck.FormSubmission("Add Project Role")));
        checks.add(new XsrfCheck("EditProjectRole", new ProjectRoleSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfProjectRoles.this.tester.clickLink("edit_New Role");
                TestXsrfProjectRoles.this.tester.setFormElement("description", "This is the new Role");
            }
        }, new XsrfCheck.FormSubmission("Update")));
        checks.addAll(Arrays.asList(new ChangeActorsCheckFactory().getChecks("Default", new ChangeDefaultRoleActorsSetup())));
        checks.addAll(Arrays.asList(new ChangeActorsCheckFactory().getChecks("ExistingProject", new ChangeExistingProjectRoleActorsSetup())));
        checks.add(new XsrfCheck("DeleteProjectRole", new ProjectRoleSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfProjectRoles.this.tester.clickLink("delete_New Role");
            }
        }, new XsrfCheck.FormSubmission("Delete")));
        new XsrfTestSuite(checks).run(this.funcTestHelperFactory);
    }

    private class ChangeActorsCheckFactory {
        private ChangeActorsCheckFactory() {
        }

        private XsrfCheck[] getChecks(String descPrefix, final XsrfCheck.Setup preSetup) {
            return new XsrfCheck[]{new XsrfCheck(descPrefix + "AddUsers", new XsrfCheck.Setup(){

                @Override
                public void setup() {
                    preSetup.setup();
                    TestXsrfProjectRoles.this.tester.clickLink("edit_New Role_atlassian-user-role-actor");
                    TestXsrfProjectRoles.this.tester.setWorkingForm("startform");
                    TestXsrfProjectRoles.this.tester.setFormElement("userNames", "admin");
                }
            }, new XsrfCheck.FormSubmission("add")), new XsrfCheck(descPrefix + "RemoveUsers", new XsrfCheck.Setup(){

                @Override
                public void setup() {
                    preSetup.setup();
                    TestXsrfProjectRoles.this.tester.clickLink("edit_New Role_atlassian-user-role-actor");
                    TestXsrfProjectRoles.this.tester.setWorkingForm("stopform");
                    TestXsrfProjectRoles.this.tester.checkCheckbox("removeusers_admin", ".");
                }
            }, new XsrfCheck.FormSubmission("remove")), new XsrfCheck(descPrefix + "AddGroups", new XsrfCheck.Setup(){

                @Override
                public void setup() {
                    preSetup.setup();
                    TestXsrfProjectRoles.this.tester.clickLink("edit_New Role_atlassian-group-role-actor");
                    TestXsrfProjectRoles.this.tester.setWorkingForm("startform");
                    TestXsrfProjectRoles.this.tester.setFormElement("groupNames", "jira-users");
                }
            }, new XsrfCheck.FormSubmission("add")), new XsrfCheck(descPrefix + "RemoveGroups", new XsrfCheck.Setup(){

                @Override
                public void setup() {
                    preSetup.setup();
                    TestXsrfProjectRoles.this.tester.clickLink("edit_New Role_atlassian-group-role-actor");
                    TestXsrfProjectRoles.this.tester.setWorkingForm("stopform");
                    TestXsrfProjectRoles.this.tester.checkCheckbox("removegroups_jira-users", ".");
                }
            }, new XsrfCheck.FormSubmission("remove"))};
        }
    }

    private class ChangeExistingProjectRoleActorsSetup
    implements XsrfCheck.Setup {
        private ChangeExistingProjectRoleActorsSetup() {
        }

        @Override
        public void setup() {
            TestXsrfProjectRoles.this.administration.project().viewProject("homosapien");
            TestXsrfProjectRoles.this.tester.clickLinkWithText("View members");
        }
    }

    private class ChangeDefaultRoleActorsSetup
    extends ProjectRoleSetup {
        private ChangeDefaultRoleActorsSetup() {
        }

        @Override
        public void setup() {
            super.setup();
            TestXsrfProjectRoles.this.tester.clickLink("manage_New Role");
        }
    }

    private class ProjectRoleSetup
    implements XsrfCheck.Setup {
        private ProjectRoleSetup() {
        }

        @Override
        public void setup() {
            TestXsrfProjectRoles.this.navigation.gotoAdminSection("project_role_browser");
            TestXsrfProjectRoles.this.navigation.checkWebSudoWithLastPassword();
        }
    }
}

