/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;

public class TestXsrfProject
extends FuncTestCase {
    private static final String PROJECT_MONKEY = "monkey";
    private static final String SUBMIT_ASSOCIATE = "Associate";
    private static final String SUBMIT_SELECT = "Select";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestXsrfProject.xml");
    }

    public void testProjectAdministration() throws Exception {
        new XsrfTestSuite(new XsrfCheck("DeleteProject", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfProject.this.tester.gotoPage("/secure/admin/DeleteProject!default.jspa?pid=10000");
                TestXsrfProject.this.navigation.checkWebSudoWithLastPassword();
            }
        }, new XsrfCheck.FormSubmission("Delete")), new XsrfCheck("AddProject", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfProject.this.navigation.gotoAdminSection("view_projects");
                TestXsrfProject.this.tester.clickLink("add_project");
                TestXsrfProject.this.tester.setFormElement("name", "Test Project");
                TestXsrfProject.this.tester.setFormElement("key", "TST");
                TestXsrfProject.this.tester.setFormElement("lead", "admin");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("EditProject", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfProject.this.tester.gotoPage("/secure/project/EditProject!default.jspa?pid=10001");
                TestXsrfProject.this.tester.setFormElement("description", "PROJECT FOR MONKEYS");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("EditProjectEmail", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfProject.this.tester.gotoPage("/secure/project/ProjectEmail!default.jspa?projectId=10001");
                TestXsrfProject.this.tester.setFormElement("fromAddress", "mailserver@mailserver");
            }
        }, new XsrfCheck.FormSubmission("Confirm")), new ProjectAssociationXsrfCheck("SelectIssueTypeScheme", "selectIssueTypeScheme", "schemeId", "Copy of Default Issue Type Scheme", null, " OK "), new ProjectAssociationXsrfCheck("SelectNotificationScheme", "select_notification_scheme", "schemeIds", "Default Notification Scheme", null, SUBMIT_ASSOCIATE), new ProjectAssociationXsrfCheck("SelectPermissionScheme", "select_permission_scheme", "schemeIds", "Copy of Default Permission Scheme", null, SUBMIT_ASSOCIATE), new ProjectAssociationXsrfCheck("SelectIssueSecurityScheme", "select_security_scheme", "newSchemeId", "Test Scheme", "Next >>", SUBMIT_ASSOCIATE), new ProjectAssociationXsrfCheck("SelectFieldConfigurationScheme", "select_fieldlayoutscheme", "schemeId", "New Field Config Scheme", null, SUBMIT_ASSOCIATE), new ProjectAssociationXsrfCheck("SelectIssueTypeScreenScheme", "select_issuetypescreenscheme", "schemeId", "Copy of Default Issue Type Screen Scheme", null, SUBMIT_ASSOCIATE), new ProjectAssociationXsrfCheck("SelectWorkflowScheme", "select_workflow_scheme", "schemeId", "New Workflow Scheme", SUBMIT_ASSOCIATE, SUBMIT_ASSOCIATE), new ProjectAssociationXsrfCheck("SelectCvsModules", "select_cvs_modules", "multipleRepositoryIds", "dummy", null, SUBMIT_SELECT), new ProjectAssociationXsrfCheck("SelectProjectCategory", "select_category", "pcid", "Category One", null, SUBMIT_SELECT)).run(this.funcTestHelperFactory);
    }

    class ProjectAssociationSetup
    implements XsrfCheck.Setup {
        private final String linkId;
        private final String inputName;
        private final String inputValue;
        private final String optionalStepSubmit;

        ProjectAssociationSetup(String linkId, String inputName, String inputValue, String optionalStepSubmit) {
            this.linkId = linkId;
            this.inputName = inputName;
            this.inputValue = inputValue;
            this.optionalStepSubmit = optionalStepSubmit;
        }

        @Override
        public void setup() {
            TestXsrfProject.this.administration.project().viewProject(TestXsrfProject.PROJECT_MONKEY);
            TestXsrfProject.this.tester.clickLink(this.linkId);
            TestXsrfProject.this.tester.selectOption(this.inputName, this.inputValue);
            if (this.optionalStepSubmit != null) {
                TestXsrfProject.this.tester.submit(this.optionalStepSubmit);
            }
        }
    }

    class ProjectAssociationXsrfCheck
    extends XsrfCheck {
        public ProjectAssociationXsrfCheck(String description, String linkId, String inputName, String inputValue, String optionalStepSubmit, String formSubmit) {
            super(description, new ProjectAssociationSetup(linkId, inputName, inputValue, optionalStepSubmit), new XsrfCheck.FormSubmission(formSubmit));
        }
    }
}

