/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Element;

public class TestXsrfImportAndExport
extends FuncTestCase {
    public void testProjectImportExport() throws Exception {
        this.administration.restoreBlankInstance();
        final String tempFilePath = this.getTempFilePath(".xml");
        new XsrfTestSuite(new XsrfCheck("ExportXmlData", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfImportAndExport.this.navigation.gotoAdminSection("backup_data");
                TestXsrfImportAndExport.this.tester.setFormElement("filename", tempFilePath);
            }
        }, new BackupFormSubmission()), new XsrfCheck("ImportXmlData", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfImportAndExport.this.navigation.gotoAdminSection("restore_data");
                TestXsrfImportAndExport.this.tester.setFormElement("filename", tempFilePath);
            }
        }, new XsrfCheck.FormSubmission("Restore"))).run(this.funcTestHelperFactory);
    }

    public void testExternalSystemImport() throws Exception {
        this.administration.restoreData("TestCsvImport.xml");
        File jiraImportDirectory = new File(this.administration.getJiraHomeDirectory(), "import/csv");
        final File importFile = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/trivial.csv");
        final File configFile = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/trivial.properties");
        FileUtils.copyFileToDirectory((File)importFile, (File)jiraImportDirectory);
        FileUtils.copyFileToDirectory((File)configFile, (File)jiraImportDirectory);
        final String tempFilePath = this.getTempFilePath(".properties");
        new XsrfTestSuite(new XsrfCheck("CsvImportWithConfigFile", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfImportAndExport.this.navigation.gotoAdminSection("external_import");
                TestXsrfImportAndExport.this.tester.clickLink("import_csv");
                TestXsrfImportAndExport.this.tester.setFormElement("importLocation", importFile.getName());
                TestXsrfImportAndExport.this.tester.setFormElement("configFileLocation", configFile.getName());
                TestXsrfImportAndExport.this.tester.submit("Import");
                TestXsrfImportAndExport.this.tester.checkCheckbox("importer/settings/userImportEnabled", "true");
            }
        }, new XsrfCheck.FormSubmission("Begin Import")), new XsrfCheck("CsvImportWizardWriteConfigFile", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfImportAndExport.this.navigation.gotoAdminSection("external_import");
                TestXsrfImportAndExport.this.tester.clickLink("import_csv");
                TestXsrfImportAndExport.this.tester.clickLink("csv_forward");
                TestXsrfImportAndExport.this.tester.setFormElement("importLocation", importFile.getName());
                TestXsrfImportAndExport.this.tester.submit("Start Import Wizard");
                TestXsrfImportAndExport.this.tester.checkCheckbox("/bean/selectedProjectOption", "importsingleproject");
                TestXsrfImportAndExport.this.tester.setFormElement("project.name", "Test Test");
                TestXsrfImportAndExport.this.tester.setFormElement("project.key", "TSTTST");
                TestXsrfImportAndExport.this.tester.setFormElement("project.lead", "admin");
                TestXsrfImportAndExport.this.tester.submit("nextBtn");
                TestXsrfImportAndExport.this.tester.selectOption("field.Title", "Summary");
                TestXsrfImportAndExport.this.tester.submit("nextBtn");
                TestXsrfImportAndExport.this.tester.submit("nextBtn");
                TestXsrfImportAndExport.this.tester.submit("nextBtn");
                TestXsrfImportAndExport.this.tester.setFormElement("configFileLocation", tempFilePath);
            }
        }, new XsrfCheck.FormSubmission("nextBtn"))).run(this.funcTestHelperFactory);
    }

    public void testProjectImport() throws Exception {
        new XsrfTestSuite(new XsrfCheck("ProjectImport", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfImportAndExport.this.administration.projectImport().doImportToSummary("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataNoProject.xml", null);
            }
        }, new XsrfCheck.FormSubmission("Import"))).run(this.funcTestHelperFactory);
    }

    private String getTempFilePath(String suffix) {
        File tempFile;
        try {
            tempFile = File.createTempFile("TestXsrfImportAndExport_Export", suffix);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tempFile.getAbsolutePath();
    }

    private class BackupFormSubmission
    extends XsrfCheck.FormSubmission {
        public BackupFormSubmission() {
            super("Backup");
        }

        @Override
        public void submitRequest() {
            super.submitRequest();
            Element replaceSubmit = TestXsrfImportAndExport.this.tester.getDialog().getElement("Replace File");
            if (replaceSubmit != null) {
                TestXsrfImportAndExport.this.tester.submit("Replace File");
            }
        }
    }
}

