/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.ViewServices;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class TestSystemAdminAndAdminPermissions
extends FuncTestCase {
    private static final String MAIL_SERVER_ADMINISTRATION_URL = "/secure/admin/ViewMailServers.jspa";
    private static final String SETUP_MAIL_SERVER_WARNING_LINK_TEXT = "mail server";
    private static final String NO_MAIL_SERVER_SETUP_WARNING_CONTAINER_LOCATOR = "//*[@id='no-mail-server-setup-warning']";
    private static final String SETUP_MAIL_SERVER_WARNING_LINK_LOCATOR = "//*[@id='no-mail-server-setup-warning']/a";
    private static final String CONFIGURE_MAIL_SERVER_LINK_CONTAINER_LOCATOR = "//*[@id='configure_mail_server']/../..[@class='desc-wrap']";
    private static final String CONFIGURE_MAIL_SERVER_LINK_TEXT = "configure";
    private static final String VIEW_SERVICES_PAGE_FORM_TITLES_LOCATOR = ".jiraform .formtitle";

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestSystemAdminAndAdminPermissions.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveAdminFromJiraUsers() {
        try {
            this.administration.usersAndGroups().removeUserFromGroup("nonsystemadmin", "jira-users");
            this.navigation.login("nonsystemadmin", "nonsystemadmin");
            this.tester.assertLinkPresent("log_out");
        }
        finally {
            this.navigation.login("admin", "admin");
        }
    }

    public void testRemoveSysAdminFromJiraUsers() {
        this.administration.usersAndGroups().removeUserFromGroup("admin", "jira-users");
        this.navigation.logout();
        this.navigation.login("admin");
        this.tester.assertLinkPresent("log_out");
    }

    public void testRemoveSysAdminFromAdminsAndJiraUsers() {
        this.administration.usersAndGroups().addGroup("systemadmins");
        this.administration.addGlobalPermission(44, "systemadmins");
        this.administration.usersAndGroups().addUserToGroup("admin", "systemadmins");
        this.administration.usersAndGroups().removeUserFromGroup("admin", "jira-users");
        this.administration.usersAndGroups().removeUserFromGroup("admin", "jira-administrators");
        this.navigation.logout();
        this.navigation.login("admin");
        this.tester.assertLinkPresent("log_out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotificationSchemeMailServerWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdminSection("notification_schemes");
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText(NO_MAIL_SERVER_SETUP_WARNING_CONTAINER_LOCATOR, SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotificationSchemeMailServerWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection("notification_schemes");
            this.assertions.getLinkAssertions().assertLinkPresentWithExactText(NO_MAIL_SERVER_SETUP_WARNING_CONTAINER_LOCATOR, SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
            this.assertions.getLinkAssertions().assertLinkAtNodeContains(SETUP_MAIL_SERVER_WARNING_LINK_LOCATOR, MAIL_SERVER_ADMINISTRATION_URL);
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditNotificationSchemeMailServerWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdminSection("notification_schemes");
            this.tester.clickLinkWithText("Default Notification Scheme");
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText(NO_MAIL_SERVER_SETUP_WARNING_CONTAINER_LOCATOR, SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditNotificationSchemeMailServerWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdminSection("notification_schemes");
            this.tester.clickLinkWithText("Default Notification Scheme");
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
            this.assertions.getLinkAssertions().assertLinkPresentWithExactText(NO_MAIL_SERVER_SETUP_WARNING_CONTAINER_LOCATOR, SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
            this.assertions.getLinkAssertions().assertLinkAtNodeContains(SETUP_MAIL_SERVER_WARNING_LINK_LOCATOR, MAIL_SERVER_ADMINISTRATION_URL);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendBulkMailMailServerWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdmin();
            this.tester.clickLink("send_email");
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText(CONFIGURE_MAIL_SERVER_LINK_CONTAINER_LOCATOR, CONFIGURE_MAIL_SERVER_LINK_TEXT);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendBulkMailMailServerWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdmin();
            this.tester.clickLink("send_email");
            this.assertions.getLinkAssertions().assertLinkPresentWithExactText(CONFIGURE_MAIL_SERVER_LINK_CONTAINER_LOCATOR, CONFIGURE_MAIL_SERVER_LINK_TEXT);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSupportRequestMailServerWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdmin();
            this.tester.clickLink("support_request");
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText(CONFIGURE_MAIL_SERVER_LINK_CONTAINER_LOCATOR, CONFIGURE_MAIL_SERVER_LINK_TEXT);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSupportRequestMailServerWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdmin();
            this.tester.clickLink("support_request");
            this.assertions.getLinkAssertions().assertLinkPresentWithExactText(CONFIGURE_MAIL_SERVER_LINK_CONTAINER_LOCATOR, CONFIGURE_MAIL_SERVER_LINK_TEXT);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailQueueMailServerWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdmin();
            this.tester.clickLink("mail_queue");
            this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//*[@class='jiraformheader']//*[@class='warning']/../..", SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailQueueMailServerWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdmin();
            this.tester.clickLink("mail_queue");
            this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//*[@class='jiraformheader']//*[@class='warning']/../..", SETUP_MAIL_SERVER_WARNING_LINK_TEXT);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteProjectBackupWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdmin();
            this.tester.clickLink("view_projects");
            this.tester.clickLinkWithText("Delete");
            this.tester.assertLinkNotPresentWithText("back it up first");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteProjectBackupWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdmin();
            this.tester.clickLink("view_projects");
            this.tester.clickLinkWithText("Delete");
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
            this.tester.assertLinkPresentWithText("back it up first");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testActivateWorkflowBackupWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.createNewWorkflowSchemeAndGotoAssociateProject();
            this.tester.assertLinkNotPresentWithText("backup");
            this.tester.selectOption("schemeId", "Test");
            this.tester.submit("Associate");
            this.tester.assertTextPresent("2 of 3");
            this.tester.assertLinkNotPresentWithText("backup");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testActivateWorkflowBackupWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.createNewWorkflowSchemeAndGotoAssociateProject();
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
            this.tester.assertLinkPresentWithText("backup");
            this.tester.selectOption("schemeId", "Test");
            this.tester.submit("Associate");
            this.tester.assertTextPresent("2 of 3");
            this.tester.assertLinkPresentWithText("backup");
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteWorkflowBackupWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.administration.workflows().goTo().copyWorkflow("jira", "Copy of jira");
            this.tester.clickLink("del_Copy of jira");
            this.tester.assertLinkNotPresentWithText("do a full backup");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteWorkflowBackupWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.workflows().goTo().copyWorkflow("jira", "Copy of jira");
            this.tester.clickLink("del_Copy of jira");
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
            this.tester.assertLinkPresentWithText("do a full backup");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchemeToolsBackupWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdmin();
            this.tester.clickLink("scheme_tools");
            this.tester.assertLinkNotPresentWithText("backupf");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchemeToolsBackupWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdmin();
            this.tester.clickLink("scheme_tools");
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
            this.tester.assertLinkPresentWithText("backup");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchemePurgePreviewBackupWarningAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdmin();
            this.tester.clickLink("permission_schemes");
            this.tester.clickLinkWithText("Copy");
            this.tester.clickLink("scheme_tools");
            this.tester.clickLink("delete_tool");
            this.tester.checkCheckbox("selectedSchemeIds", "10000");
            this.tester.submit("Preview");
            this.tester.assertLinkNotPresentWithText("backup");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchemePurgePreviewBackupWarningAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdmin();
            this.tester.clickLink("permission_schemes");
            this.tester.clickLinkWithText("Copy");
            this.tester.clickLink("scheme_tools");
            this.tester.clickLink("delete_tool");
            this.tester.checkCheckbox("selectedSchemeIds", "10000");
            this.tester.submit("Preview");
            this.tester.assertLinkNotPresentWithText("contact a System Administrator");
            this.tester.assertLinkPresentWithText("backup");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testViewGroupEditLinkNotPresentAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdmin();
            this.tester.clickLink("group_browser");
            this.tester.clickLinkWithText("jira-sys-admins");
            this.tester.assertLinkNotPresent("edit_members_of_jira-sys-admins");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testViewGroupEditLinkPresentAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdmin();
            this.tester.clickLink("group_browser");
            this.tester.clickLinkWithText("jira-sys-admins");
            this.tester.assertLinkPresent("edit_members_of_jira-sys-admins");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserBrowserEditAndDeleteLinkNotPresentAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdmin();
            this.tester.clickLink("user_browser");
            this.tester.assertLinkNotPresent("edituser_link_root");
            this.tester.assertLinkNotPresent("deleteuser_link_root");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserBrowserEditAndDeleteLinkPresentAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdmin();
            this.tester.clickLink("user_browser");
            this.tester.assertLinkPresent("edituser_link_root");
            this.tester.assertLinkPresent("deleteuser_link_root");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachmentEditLinkNotPresentAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.gotoAdmin();
            this.tester.clickLink("attachments");
            this.tester.assertLinkNotPresentWithText("Edit Configuration");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachmentEditAsAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/jira/EditAttachmentSettings.jspa?thumbnailsEnabled=true"));
            this.navigation.checkWebSudoWithLastPassword();
            this.tester.assertTextPresent("Attachments must be enabled to enable thumbnails.");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachmentEditLinkPresentAsSysAdmin() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.navigation.gotoAdmin();
            this.tester.clickLink("attachments");
            this.tester.assertLinkPresentWithText("Edit Configuration");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCanNotElevateHisPrivilegesBySettingSysAdminPassword() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=root");
            this.navigation.checkWebSudoWithLastPassword();
            this.text.assertTextNotPresent(this.locator.page(), "Set Password");
            this.text.assertTextPresent(this.locator.page(), "This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.tester.gotoPage("/secure/admin/user/SetPassword!default.jspa?name=root");
            this.navigation.checkWebSudoWithLastPassword();
            this.tester.setFormElement("password", "newpassword");
            this.tester.setFormElement("confirm", "newpassword");
            this.tester.clickButton("update_submit");
            this.text.assertTextNotPresent(this.locator.page(), "has successfully been set ");
            this.assertions.getJiraFormAssertions().assertFormErrMsg("Must be a System Administrator to reset a System Administrator's password");
            this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=admin");
            this.navigation.checkWebSudoWithLastPassword();
            this.text.assertTextPresent(this.locator.page(), "Set Password");
            this.tester.gotoPage("secure/admin/user/SetPassword!default.jspa?name=admin");
            this.tester.setFormElement("password", "newpassword");
            this.tester.setFormElement("confirm", "newpassword");
            this.tester.clickButton("update_submit");
            this.assertions.getJiraFormAssertions().assertFormNotificationMsg("has successfully been set");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminUsersCanAccessTheServicesAdministrationPage() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.administration.services().goTo();
            this.assertThatTheCurrentPageIsViewServices();
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSysAdminUsersCanAccessTheServicesAdministrationPage() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.services().goTo();
            this.assertThatTheCurrentPageIsViewServices();
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSysAdminUsersCanViewAllServices() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            ImmutableSet expectedListOfServices = ImmutableSet.of((Object[])new ViewServices.Service[]{new ViewServices.Service("An IMAP Service", "com.atlassian.jira.service.services.imap.ImapService"), new ViewServices.Service("A Debugging Service", "com.atlassian.jira.service.services.DebugService"), new ViewServices.Service("Backup JIRA", "com.atlassian.jira.service.services.export.ExportService"), new ViewServices.Service("A Pop Service", "com.atlassian.jira.service.services.pop.PopService"), new ViewServices.Service("Service Provider Token Remover", "com.atlassian.sal.jira.scheduling.JiraPluginSchedulerService"), new ViewServices.Service("Mail Queue Service", "com.atlassian.jira.service.services.mail.MailQueueService")});
            this.navigation.logout();
            this.navigation.login("root", "root");
            Set<ViewServices.Service> actualListOfServices = this.administration.services().goTo().list();
            TestSystemAdminAndAdminPermissions.assertTrue((boolean)expectedListOfServices.equals(actualListOfServices));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminUsersCanOnlySeePopAndImapServices() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            ImmutableSet expectedListOfServices = ImmutableSet.of((Object)new ViewServices.Service("An IMAP Service", "com.atlassian.jira.service.services.imap.ImapService"), (Object)new ViewServices.Service("A Pop Service", "com.atlassian.jira.service.services.pop.PopService"));
            Set<ViewServices.Service> actualListOfServices = this.administration.services().goTo().list();
            TestSystemAdminAndAdminPermissions.assertTrue((boolean)expectedListOfServices.equals(actualListOfServices));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSysAdminUsersCanAddABuiltInServiceThatIsNeitherAnImapNorPop() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            ViewServices.Service serviceToAdd = new ViewServices.Service("Another Backup JIRA", "com.atlassian.jira.service.services.export.ExportService");
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.services().goTo().add(serviceToAdd, "10");
            Set<ViewServices.Service> existingServices = this.administration.services().goTo().list();
            TestSystemAdminAndAdminPermissions.assertTrue((boolean)existingServices.contains(serviceToAdd));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminUsersCanOnlyAddPopAndImapServices() throws Exception {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            ViewServices.Service serviceToAdd = new ViewServices.Service("Another Backup JIRA", "com.atlassian.jira.service.services.export.ExportService");
            try {
                this.administration.services().goTo().add(serviceToAdd, "10");
                TestSystemAdminAndAdminPermissions.fail((String)"Jira Administrators should only be able to add Pop And Imap Services");
            }
            catch (ViewServices.UnableToAddServiceException e) {
                this.text.assertTextPresent(this.locator.page(), "Access Denied");
            }
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    public void testAdminUsersCanOnlySeePopServices() throws Exception {
    }

    public void testSysAdminUsersCanSeeSmtpAndPopServers() throws Exception {
    }

    public void testAdminUsersCanAddAPopServer() throws Exception {
    }

    public void testAdminUsersCanEditAPopServer() throws Exception {
    }

    public void testAdminUsersCanDeleteAPopServer() throws Exception {
    }

    public void testSysAdminUsersCanAddASmtpServer() throws Exception {
    }

    public void testSysAdminUsersCanEditASmtpServer() throws Exception {
    }

    public void testSysAdminUsersCanDeleteASmtpServer() throws Exception {
    }

    public void testSysAdminUsersCanAddAPopServer() throws Exception {
    }

    public void testSysAdminUsersCanEditAPopServer() throws Exception {
    }

    public void testSysAdminUsersCanDeleteAPopServer() throws Exception {
    }

    private void assertThatTheCurrentPageIsViewServices() {
        this.text.assertTextSequence(this.locator.css(VIEW_SERVICES_PAGE_FORM_TITLES_LOCATOR), "Services", "Add Service");
    }

    private void createNewWorkflowSchemeAndGotoAssociateProject() {
        this.navigation.gotoAdmin();
        this.administration.workflows().goTo().copyWorkflow("jira", "Copy of jira");
        this.tester.clickLink("workflow_schemes");
        this.tester.clickLink("add_workflowscheme");
        this.tester.setFormElement("name", "Test");
        this.tester.submit("Add");
        this.tester.clickLinkWithText("Assign a workflow");
        this.tester.selectOption("workflow", "Copy of jira");
        this.tester.submit("Add");
        this.tester.clickLink("view_projects");
        this.tester.clickLinkWithText("homosapien");
        this.tester.clickLink("select_workflow_scheme");
    }
}

