/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestManageTrackbacks
extends FuncTestCase {
    private static final String ISSUE_WITH_TRACKBACKS = "HSP-1";

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestTrackback.xml");
    }

    public void testManageTrackbacks() {
        this._testManageTrackbackPermission();
        this._testTrackbackDelete();
    }

    private void _testManageTrackbackPermission() {
        this.log("Test manage trackback link visibility");
        this.administration.usersAndGroups().addUser("user", "pass", "pass", "user@invalid.com");
        this.navigation.logout();
        this.navigation.login("user", "pass");
        this.navigation.issue().gotoIssue(ISSUE_WITH_TRACKBACKS);
        this.text.assertTextNotPresent(this.locator.page(), "Manage Trackbacks");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(ISSUE_WITH_TRACKBACKS);
        this.text.assertTextSequence(this.locator.page(), "Manage Trackbacks", "Trackbacks");
    }

    private void _testTrackbackDelete() {
        this.log("Test delete trackbacks");
        this.navigation.issue().gotoIssue(ISSUE_WITH_TRACKBACKS);
        this.navigation.clickLinkWithExactText("Manage Trackbacks");
        this.text.assertTextPresent(this.locator.page(), "This page allows you to manage the trackback links for a particular issue.");
        this.tester.clickLink("del_10000");
        this.tester.submit("Delete");
        this.tester.clickLink("del_10001");
        this.tester.submit("Delete");
        this.text.assertTextPresent(this.locator.page(), "There are no trackbacks for this issue.");
        this.navigation.issue().viewIssue(ISSUE_WITH_TRACKBACKS);
        this.text.assertTextNotPresent(this.locator.page(), "Trackbacks");
        this.text.assertTextNotPresent(this.locator.page(), "Manage Trackbacks");
    }
}

