/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;

public class TestLookAndFeel
extends FuncTestCase {
    private static final String VERSION_ELEMENT_STR = "<dl style=\"display:none;\" id=\"jira.webresource.flushcounter\">";

    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection("lookandfeel");
    }

    public void testHasDefaults() throws Exception {
        this.assertHasDefaultLookAndFeel();
    }

    public void testEditLookAndFeelIncrementsWebResourceUrl() {
        this.tester.clickLinkWithText("Edit Configuration");
        String responseText = this.tester.getDialog().getResponseText();
        String oldVersionNumber = responseText.substring(responseText.indexOf(VERSION_ELEMENT_STR) + VERSION_ELEMENT_STR.length(), responseText.indexOf("</dl>"));
        this.tester.setFormElement("topBgColour", "#010101");
        this.tester.submit("Update");
        long newVersionNum = Long.parseLong(oldVersionNumber) + 1L;
        TestLookAndFeel.assertTrue((boolean)this.tester.getDialog().getResponseText().contains("/" + newVersionNum + "/1.0/_/download/batch/jira.webresources:global-static/jira.webresources:global-static.css"));
    }

    private void assertHasDefaultLookAndFeel() {
        TableLocator tableLocatorLogo = new TableLocator(this.tester, "lookAndFeelLogo");
        this.text.assertTextSequence(tableLocatorLogo, new String[]{"URL", "<default>", "Preview", "<N/A>", "Logo Width", "<default>", "Logo Height", "<default>"});
        TableLocator tableLocatorColors = new TableLocator(this.tester, "lookAndFeelColors");
        String textStr = tableLocatorColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Header Background Colour", "<default>", "Header Highlight Background Colour", "<default>", "Header Text Colour", "<default>", "Header Text Highlight Colour", "<default>", "Header Separator Color", "<default>", "Navigation Bar Background Colour", "<default>", "Navigation Bar Text Colour", "<default>", "Navigation Bar Separator Colour", "<default>", "Link Colour", "<default>", "Link Active Colour", "<default>", "Heading Colour", "<default>"});
        TableLocator tableLocatorGadgetColors = new TableLocator(this.tester, "lookAndFeelGadgetChromeColours");
        textStr = tableLocatorGadgetColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Colour 1", "<default>", "Colour 2", "<default>", "Colour 3", "<default>", "Colour 4", "<default>", "Colour 5", "<default>", "Colour 6", "<default>", "Colour 7", "<default>"});
        TableLocator tableLocatorFormats = new TableLocator(this.tester, "lookAndFeelFormats");
        this.text.assertTextSequence(tableLocatorFormats, new String[]{"Time Format", "h:mm a", "Day Format", "EEEE h:mm a", "Complete Date/Time Format", "dd/MMM/yy h:mm a", "Day/Month/Year Format", "dd/MMM/yy", "Date Picker Format (javascript format)", "d/MMM/yy (%e/%b/%y)", "Date Time Picker Format (javascript format)", "dd/MMM/yy h:mm a (%e/%b/%y %I:%M %p)", "Use ISO8601 standard in Date Picker", "OFF"});
    }

    public void testReflectsEdits() throws Exception {
        this.tester.clickLinkWithText("Edit Configuration");
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(pageLocator.getHTML(), new String[]{"Header Background Colour", "#114070", "Header Highlight Background Colour", "#325c82", "Header Text Colour", "#ffffff", "Header Text Highlight Colour", "#f0f0f0", "Header Separator Color", "#114070", "Navigation Bar Background Colour", "#3c78b5", "Navigation Bar Text Colour", "#ffffff", "Navigation Bar Separator Colour", "#f0f0f0", "Link Colour", "#3c78b5", "Link Active Colour", "#3c78b5", "Heading Colour", "#3c78b5"});
        this.tester.setFormElement("logoUrl", "logoURL");
        this.tester.setFormElement("logoWidth", "666");
        this.tester.setFormElement("logoHeight", "9");
        this.tester.setFormElement("topBgColour", "#010101");
        this.tester.setFormElement("topTextColour", "#020202");
        this.tester.setFormElement("topHighlightBgColour", "#030303");
        this.tester.setFormElement("topTextHighlightColour", "#040404");
        this.tester.setFormElement("topSeparatorColor", "#050505");
        this.tester.setFormElement("menuBgColour", "#060606");
        this.tester.setFormElement("menuTextColour", "#070707");
        this.tester.setFormElement("menuSeparatorColour", "#080808");
        this.tester.setFormElement("linkColour", "#101010");
        this.tester.setFormElement("linkAColour", "#111111");
        this.tester.setFormElement("headingColour", "#121212");
        this.tester.setFormElement("gadgetChromeColorcolor1", "#313131");
        this.tester.setFormElement("gadgetChromeColorcolor2", "#323131");
        this.tester.setFormElement("gadgetChromeColorcolor3", "#333131");
        this.tester.setFormElement("gadgetChromeColorcolor4", "#343131");
        this.tester.setFormElement("gadgetChromeColorcolor5", "#353131");
        this.tester.setFormElement("gadgetChromeColorcolor6", "#363131");
        this.tester.setFormElement("gadgetChromeColorcolor7", "#373131");
        this.tester.setFormElement("formatTime", "h:m:s");
        this.tester.setFormElement("formatDay", "d:M:y");
        this.tester.setFormElement("formatComplete", "d:M:y h:m:s");
        this.tester.setFormElement("formatDMY", "d/M/y");
        this.tester.checkCheckbox("useISO8601", "true");
        this.tester.submit("Update");
        TableLocator tableLocatorLogo = new TableLocator(this.tester, "lookAndFeelLogo");
        this.text.assertTextSequence(tableLocatorLogo, new String[]{"URL", "logoURL", "Logo Width", "666", "Logo Height", "9"});
        TableLocator tableLocatorColors = new TableLocator(this.tester, "lookAndFeelColors");
        String textStr = tableLocatorColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Header Background Colour", "#010101", "Header Highlight Background Colour", "#030303", "Header Text Colour", "#020202", "Header Text Highlight Colour", "#040404", "Header Separator Color", "#050505", "Navigation Bar Background Colour", "#060606", "Navigation Bar Text Colour", "#070707", "Navigation Bar Separator Colour", "#080808", "Link Colour", "#101010", "Link Active Colour", "#111111", "Heading Colour", "#121212"});
        TableLocator tableLocatorGadgetColors = new TableLocator(this.tester, "lookAndFeelGadgetChromeColours");
        textStr = tableLocatorGadgetColors.getText();
        this.text.assertTextSequence(textStr, new String[]{"Colour 1", "#313131", "Colour 2", "#323131", "Colour 3", "#333131", "Colour 4", "#343131", "Colour 5", "#353131", "Colour 6", "#363131", "Colour 7", "#373131"});
        TableLocator tableLocatorFormats = new TableLocator(this.tester, "lookAndFeelFormats");
        this.text.assertTextSequence(tableLocatorFormats, new String[]{"Time Format", "h:m:s", "Day Format", "d:M:y", "Complete Date/Time Format", "d:M:y h:m:s", "Day/Month/Year Format", "d/M/y", "Date Picker Format (javascript format)", "d/MMM/yy (%e/%b/%y)", "Date Time Picker Format (javascript format)", "dd/MMM/yy h:mm a (%e/%b/%y %I:%M %p)", "Use ISO8601 standard in Date Picker", "ON"});
        this.tester.gotoPage(this.page.addXsrfToken("EditLookAndFeel!reset.jspa"));
        this.assertHasDefaultLookAndFeel();
    }

    public void testNegativeWidths() throws Exception {
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.setFormElement("logoWidth", "-1");
        this.tester.setFormElement("logoHeight", "-28292");
        this.tester.submit("Update");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("Logo width must be a whole number greater than or equal to zero");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("Logo height must be a whole number greater than or equal to zero");
        this.tester.setFormElement("logoWidth", "-1");
        this.tester.setFormElement("logoHeight", "");
        this.tester.submit("Update");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("Logo width must be a whole number greater than or equal to zero");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("If you specify a logo URL, you must specify a logo height");
        this.tester.setFormElement("logoWidth", "0");
        this.tester.setFormElement("logoHeight", "0");
        this.tester.submit("Update");
        this.assertions.getTextAssertions().assertTextSequence(new TableLocator(this.tester, "lookAndFeelLogo"), "Logo Width", "0", "Logo Height", "0");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.setFormElement("logoUrl", "");
        this.tester.setFormElement("logoWidth", "-1");
        this.tester.setFormElement("logoHeight", "272");
        this.tester.submit("Update");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("Logo width must be a whole number greater than or equal to zero");
        this.tester.setFormElement("logoUrl", "");
        this.tester.setFormElement("logoWidth", "");
        this.tester.setFormElement("logoHeight", "");
        this.tester.submit("Update");
        this.assertions.getTextAssertions().assertTextSequence(new TableLocator(this.tester, "lookAndFeelLogo"), "URL", "<default>", "Logo Width", "<default>", "Logo Height", "<default>");
    }
}

