/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.webtests.JIRAWebTest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.Assert;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TestDataExport
extends JIRAWebTest {
    private static final String BS_BACKUP_TEST_FILE_XML = "BS_BackupTestFile.xml";

    public TestDataExport(String name) {
        super(name);
    }

    public void testNoFilename() throws Exception {
        this.gotoPage("secure/admin/XmlBackup!default.jspa");
        this.navigation.checkWebSudoWithLastPassword();
        this.assertTextNotPresent("You must enter a file name to export to");
        this.setWorkingForm("jiraform");
        this.setFormElement("filename", "");
        this.submit();
        this.assertTextPresent("You must enter a file name to export to");
    }

    public void testInvalidFilename() throws Exception {
        EnvironmentUtils utils = new EnvironmentUtils(this.tester, this.getEnvironmentData());
        if (utils.isOnWindows()) {
            this.gotoPage("secure/admin/XmlBackup!default.jspa");
            this.navigation.checkWebSudoWithLastPassword();
            this.assertTextNotPresent("Filename 'C:\\te:st.xml' is invalid");
            this.setWorkingForm("jiraform");
            this.setFormElement("filename", "C:\\te:st.xml");
            this.submit();
            this.assertTextPresent("Filename &#39;C:\\te:st.xml&#39; is invalid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDataExportDoesNotAnonymise() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        File backupFile = null;
        try {
            this.restoreData("TestDataExport.xml");
            this.deleteBackupFileIfPresent(BS_BACKUP_TEST_FILE_XML);
            backupFile = this.getAdministration().exportDataToFile(BS_BACKUP_TEST_FILE_XML);
            TestDataExport.assertTrue((String)"The backup file must exist", (boolean)backupFile.exists());
            Document doc = XMLUnit.buildControlDocument((InputSource)new InputSource(new FileInputStream(backupFile)));
            XMLAssert.assertXpathEvaluatesTo((String)"This is a test summary to make sure that the xml backup does not anonymise this data", (String)"/entity-engine-xml/Issue[@id=10000]/@summary", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"This is a test description to make sure that the xml backup does not anonymise this data", (String)"/entity-engine-xml/Issue[@id=10000]/@description", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"This is a comment to make sure that the xml backup does not anonymise this data", (String)"/entity-engine-xml/Action[@id=10000]/@body", (Document)doc);
        }
        finally {
            if (backupFile != null) {
                backupFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidCharactersInComments() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        File backupFile = null;
        try {
            this.restoreData("TestXmlBackupInvalidCommentCharacters.xml");
            this.deleteBackupFileIfPresent(BS_BACKUP_TEST_FILE_XML);
            backupFile = this.getAdministration().exportDataToFile(BS_BACKUP_TEST_FILE_XML);
            TestDataExport.assertTrue((String)"The backup file must exist", (boolean)backupFile.exists());
            Document doc = XMLUnit.buildControlDocument((InputSource)new InputSource(new FileInputStream(backupFile)));
            this.checkForValidComments(doc.getChildNodes());
            NodeList topNode = doc.getElementsByTagName("entity-engine-xml");
            Assert.assertNotNull((Object)topNode);
            Assert.assertEquals((int)1, (int)topNode.getLength());
            this.checkForValidComments(topNode.item(0).getChildNodes());
            this.restoreData(backupFile);
        }
        finally {
            if (backupFile != null) {
                backupFile.delete();
            }
        }
    }

    private void checkForValidComments(NodeList nodes) {
        boolean hasComments = false;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 8) continue;
            String commentText = node.getNodeValue();
            Assert.assertTrue((String)("Comment text has at least one -- in it : '" + commentText), (commentText.indexOf("--") == -1 ? 1 : 0) != 0);
            hasComments = true;
        }
        Assert.assertTrue((String)"There should be comments in the data export nowdays", (boolean)hasComments);
    }

    private void deleteBackupFileIfPresent(String fileName) {
        File backupFile = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + fileName);
        if (backupFile.exists()) {
            backupFile.delete();
        }
    }
}

