/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.AdministrationImpl;
import com.atlassian.jira.functest.framework.DefaultFuncTestHttpUnitOptions;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.FormImpl;
import com.atlassian.jira.functest.framework.FuncTestWebClientListener;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.ParserImpl;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.AssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.functest.framework.dump.FuncTestTimer;
import com.atlassian.jira.functest.framework.dump.TestCaseDumpKit;
import com.atlassian.jira.functest.framework.dump.TestInformationKit;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.log.FuncTestLogger;
import com.atlassian.jira.functest.framework.log.FuncTestLoggerImpl;
import com.atlassian.jira.functest.framework.log.LogOnBothSides;
import com.atlassian.jira.functest.framework.setup.JiraSetupInstanceHelper;
import com.atlassian.jira.functest.framework.util.AsynchronousTasks;
import com.atlassian.jira.webtests.AbstractAtlassianWebTestCase;
import com.atlassian.jira.webtests.CustomFieldValue;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.WebTesterFactory;
import com.atlassian.jira.webtests.table.ImageCell;
import com.atlassian.jira.webtests.table.SimpleCell;
import com.atlassian.jira.webtests.util.EnvironmentAware;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebImage;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import net.sourceforge.jwebunit.HttpUnitDialog;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Deprecated
public abstract class JIRAWebTest
extends AbstractAtlassianWebTestCase
implements EnvironmentAware,
FunctTestConstants {
    protected JIRAEnvironmentData environmentData;
    protected Navigation navigation;
    protected Form form;
    protected HtmlPage page;
    protected Parser parse;
    protected Administration administration;
    protected Assertions assertions;
    protected TextAssertions text;
    protected FuncTestLogger log;
    protected LocatorFactory locator;
    private FuncTestWebClientListener webClientListener;
    private long startTime;
    private StopWatch stopWatch = new StopWatch();
    private static final int FIELD_TABLE_FIELD_NAME_COLUMN_INDEX = 0;
    private static final int FIELD_TABLE_OPERATIONS_COLUMN_INDEX = 2;
    private static final String HIDE_FIELD_OPERATION_NAME = "Hide";
    private static final String SHOW_FIELD_OPERATION_NAME = "Show";
    private static final String OPTIONAL_FIELD_OPERATION_NAME = "Optional";
    public static final String FIELD_SCOPE_GLOBAL = "global";
    public static final String PAGE_ENTERPRISE_ISSUE_TYPE_SCREEN_SCHEMES = "/secure/admin/ViewIssueTypeScreenSchemes.jspa";
    public static final String PAGE_ENTERPRISE_FIELD_CONFIGURATIONS = "/secure/admin/ViewFieldLayouts.jspa";
    public static final String PAGE_USER_BROWSER = "/secure/admin/user/UserBrowser.jspa";
    public static final String PAGE_NOT_STANDARD_VIEW_FIELD_SCREEN_SCHEMES = "/secure/admin/ViewFieldScreenSchemes.jspa";
    private static final String PAGE_TIME_TRACKING = "/secure/admin/jira/TimeTrackingAdmin!default.jspa";
    private static final String PAGE_LINK_TYPES = "/secure/admin/jira/ViewLinkTypes.jspa";
    private static final String PAGE_CUSTOM_FIELDS = "/secure/admin/ViewCustomFields.jspa";
    public static final float JDK_1_5_VERSION = 1.5f;
    public static final String BULK_TRANSITION_ELEMENT_NAME = "wftransition";
    private final String EVENT_TYPE_TABLE = "eventTypeTable";
    private final int EVENT_TYPE_TABLE_NAME_COL = 0;
    private AsynchronousTasks asyncronousTasks;

    public JIRAWebTest(String name) {
        super(name);
        this.tester = new WebTester();
    }

    public WebTester getTester() {
        return this.tester;
    }

    public HtmlPage getPage() {
        if (this.page == null) {
            this.page = new HtmlPage(this.tester);
        }
        return this.page;
    }

    public JIRAEnvironmentData getEnvironmentData() {
        if (this.environmentData == null) {
            this.environmentData = new LocalTestEnvironmentData();
        }
        return this.environmentData;
    }

    @Override
    public void setEnvironmentData(JIRAEnvironmentData environmentData) {
        this.environmentData = environmentData;
    }

    public Administration getAdministration() {
        if (this.administration == null) {
            this.administration = new AdministrationImpl(this.getTester(), this.getEnvironmentData(), this.getNavigation(), this.getAssertions());
        }
        return this.administration;
    }

    protected Assertions getAssertions() {
        if (this.assertions == null) {
            this.assertions = new AssertionsImpl(this.getTester(), this.getEnvironmentData(), this.getNavigation(), this.getLocatorFactory());
        }
        return this.assertions;
    }

    public Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = new NavigationImpl(this.getTester(), this.getEnvironmentData());
        }
        return this.navigation;
    }

    public FuncTestWebClientListener getWebClientListener() {
        return this.webClientListener;
    }

    public String getRedirect() {
        URL url = this.getDialog().getResponse().getURL();
        String queryString = url.getQuery() != null ? '?' + url.getQuery() : "";
        return url.getPath() + queryString;
    }

    public void assertRedirect(String path) {
        JIRAWebTest.assertEquals((String)path, (String)this.getRedirect());
    }

    public void assertRedirectPath(String s) {
        URL url = this.getDialog().getResponse().getURL();
        JIRAWebTest.assertEquals((String)s, (String)url.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jiraLog(String message, boolean testStarted) {
        String originalUrl = null;
        HttpUnitDialog dialog = this.tester.getDialog();
        if (dialog != null && testStarted) {
            originalUrl = dialog.getWebClient().getCurrentPage().getURL().toString();
            String jiraContext = this.getEnvironmentData().getBaseUrl().toExternalForm();
            originalUrl = originalUrl.substring(originalUrl.indexOf(jiraContext) + jiraContext.length());
        }
        try {
            super.gotoPage("/secure/admin/debug/logMessage.jsp?message=" + URLEncoder.encode(message, "UTF-8"));
        }
        catch (RuntimeException ignored) {
        }
        catch (UnsupportedEncodingException ignored) {
        }
        finally {
            if (originalUrl != null) {
                super.gotoPage(originalUrl);
            }
        }
    }

    public void dumpScreen(String filename) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(new File(this.getEnvironmentData().getWorkingDirectory().getAbsolutePath() + FS + filename + ".htm")));
            this.dumpResponse(printStream);
            printStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void login(String usernameAndPassword) {
        this.login(usernameAndPassword, usernameAndPassword);
    }

    public void login(String username, String password) {
        this.getNavigation().login(username, password);
    }

    public void logout() {
        this.getNavigation().logout();
    }

    private Object invoke(Object subject, String methodName, Object[] methodArgs) {
        Class[] params = new Class[methodArgs.length];
        for (int i = 0; i < methodArgs.length; ++i) {
            params[i] = methodArgs[i].getClass();
        }
        Method method = null;
        Class<?> clazz = subject.getClass();
        while (method == null) {
            try {
                method = clazz.getDeclaredMethod(methodName, params);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        }
        method.setAccessible(true);
        try {
            return method.invoke(subject, methodArgs);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getFormElement(String form, String elementId) {
        WebForm jiraform = null;
        try {
            jiraform = this.getDialog().getResponse().getFormWithName(form);
        }
        catch (SAXException se) {
            // empty catch block
        }
        if (jiraform == null) {
            try {
                jiraform = this.getDialog().getResponse().getFormWithID(form);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
        return this.invoke(jiraform, "getControlWithID", new String[]{elementId});
    }

    public Map getFormParameters(String form) {
        try {
            WebForm jiraform = this.getDialog().getResponse().getFormWithName(form);
            if (jiraform == null) {
                jiraform = this.getDialog().getResponse().getFormWithID(form);
            }
            return (Map)this.invoke(jiraform, "getFormParameters", new Object[0]);
        }
        catch (SAXException se) {
            throw new RuntimeException(se);
        }
    }

    public Object getFormParameter(String form, String elementName) {
        Map params = this.getFormParameters(form);
        Object formParameter = params.get(elementName);
        return formParameter;
    }

    public String[] getFormParameterValues(String form, String elementName) {
        return (String[])this.invoke(this.getFormParameter(form, elementName), "getValues", new Object[0]);
    }

    public String getFormElementValue(String form, String elementId) {
        Object formControl = this.getFormElement(form, elementId);
        return (String)this.invoke(formControl, "getValueAttribute", new Object[0]);
    }

    public boolean isFormElementDisabled(String form, String elementId) {
        Object formControl = this.getFormElement(form, elementId);
        return (Boolean)this.invoke(formControl, "isDisabled", new Object[0]);
    }

    public String[] getFormElementValues(String form, String elementId) {
        Object formControl = this.getFormElement(form, elementId);
        return (String[])this.invoke(formControl, "getValues", new Object[0]);
    }

    public void assertOptionSelected(String elementId, String expectedValue) {
        List<String> selectedOptionIds = Arrays.asList(this.getDialog().getForm().getParameterValues(elementId));
        String[] optionValues = this.getDialog().getOptionsFor(elementId);
        for (int i = 0; i < optionValues.length; ++i) {
            String optionValue = optionValues[i];
            if (!optionValue.equals(expectedValue)) continue;
            String expectedValueId = this.getDialog().getOptionValuesFor(elementId)[i];
            JIRAWebTest.assertTrue((String)("Expected option '" + expectedValue + "' for element '" + elementId + "' was not selected"), (boolean)selectedOptionIds.contains(expectedValueId));
            return;
        }
        JIRAWebTest.fail((String)("Expected option value: '" + expectedValue + "' is not a selected value option for '" + elementId + "'"));
    }

    public void assertOptionsEqualIgnoreOrder(String selectName, String[] expectedOptions) {
        List<String> expectedOptionsList = Arrays.asList(expectedOptions);
        List<String> actualOptionsList = Arrays.asList(this.getDialog().getOptionsFor(selectName));
        JIRAWebTest.assertTrue((String)("The expected options '" + expectedOptionsList + "' does not equal '" + actualOptionsList + "'"), (expectedOptionsList.containsAll(actualOptionsList) && actualOptionsList.containsAll(expectedOptionsList) ? 1 : 0) != 0);
    }

    public void assertOptionSelectedById(String elementId, String expectedId) {
        List<String> selectedOptionIds = Arrays.asList(this.getDialog().getForm().getParameterValues(elementId));
        JIRAWebTest.assertTrue((String)("Expected selected option '" + expectedId + "' for element '" + elementId + "'."), (boolean)selectedOptionIds.contains(expectedId));
    }

    public void assertFormElementHasValue(String fieldId, String expectedValue) {
        this.assertFormElementHasValue("jiraform", fieldId, expectedValue);
    }

    public void assertFormElementHasValue(String formNameOrId, String fieldId, String expectedValue) {
        JIRAWebTest.assertEquals((String)expectedValue, (String)this.getFormElementValue(formNameOrId, fieldId));
    }

    public void assertFormElementWithNameHasValue(String fieldName, String expectedValue) {
        this.assertFormElementWithNameHasValue("jiraform", fieldName, expectedValue);
    }

    public void assertFormElementWithNameHasValue(String formNameOrId, String fieldName, String expectedValue) {
        String[] formParameterValues = this.getFormParameterValues(formNameOrId, fieldName);
        if (formParameterValues != null && formParameterValues.length > 0) {
            JIRAWebTest.assertEquals((String)expectedValue, (String)formParameterValues[0]);
        } else {
            JIRAWebTest.fail((String)("Field with name '" + fieldName + "' is null and does not have the expected value '" + expectedValue + "'"));
        }
    }

    public void assertFormTextAreaHasValue(String fieldId, String expectedValue) {
        this.assertFormTextAreaHasValue("jiraform", fieldId, expectedValue);
    }

    public void assertFormTextAreaHasValue(String formNameOrId, String fieldId, String expectedValue) {
        String[] values = this.getFormElementValues(formNameOrId, fieldId);
        if (values != null && values.length > 0) {
            JIRAWebTest.assertEquals((String)values[0].trim(), (String)expectedValue);
            return;
        }
        JIRAWebTest.fail((String)("no values found for '" + fieldId + "'"));
    }

    @Deprecated
    public void clickOnAdminPanel(String adminsubject, String adminpage) {
        this.gotoAdmin();
        if (this.getDialog().isLinkPresent(adminpage)) {
            this.clickLink(adminpage);
        } else {
            this.clickLink(adminsubject);
            this.getNavigation().checkWebSudoWithLastPassword();
        }
    }

    @Deprecated
    public String addProject(String name, String key, String lead) {
        return this.addProject(name, key, "", lead, "");
    }

    public String addProject(String name, String key, String url, String lead, String description) {
        return this.addProject(name, key, url, lead, description, null);
    }

    public String addProject(String name, String key, String url, String lead, String description, String securitySchemeName) {
        String projectId;
        if (this.projectExists(name)) {
            JIRAWebTest.log("Project " + name + " exists ");
            this.gotoAdmin();
            this.clickLinkWithText(name);
            this.assertRedirectPath(this.getEnvironmentData().getContext() + "/secure/project/ViewProject.jspa");
        } else {
            JIRAWebTest.log("Adding project " + name);
            this.gotoAdmin();
            this.clickLink("add_project");
            this.assertTextPresent("action=\"AddProject.jspa\"");
            this.setFormElement("name", name);
            this.setFormElement("key", key);
            this.setFormElement("url", url);
            this.setFormElement("lead", lead);
            this.setFormElement("description", description);
            if (securitySchemeName != null) {
                this.selectOption("issueSecurityScheme", securitySchemeName);
            }
            this.submit();
            this.assertRedirectPath(this.getEnvironmentData().getContext() + "/secure/admin/ViewProject.jspa");
        }
        try {
            String text = this.getDialog().getResponse().getText();
            int projectIdLocation = text.indexOf("projectId=") + "projectId=".length();
            projectId = text.substring(projectIdLocation, projectIdLocation + 5);
        }
        catch (IOException e) {
            JIRAWebTest.fail((String)("Unable to retrieve issue key" + e.getMessage()));
            return "fail";
        }
        return projectId;
    }

    public void deleteAllProjects() {
        this.gotoAdmin();
        this.clickLink("view_projects");
        JIRAWebTest.log("Deleting all Projects");
        while (this.getDialog().isLinkPresentWithText("Delete")) {
            this.clickLinkWithText("Delete");
            this.submit("Delete");
        }
    }

    public void deleteProject(String project) {
        this.goToProject(project);
        this.clickLinkWithText("Delete Project");
        this.assertTextPresent("Delete Project: " + project);
        this.submit("Delete");
    }

    public String addComponent(String projectName, String name) {
        return this.addComponent(projectName, name, null);
    }

    public String addComponent(String projectName, String name, String componentLead) {
        String componentId;
        JIRAWebTest.log("Adding component '" + name + "' to projectName '" + projectName + "'");
        this.goToProject(projectName);
        this.clickLink("add_component");
        this.setFormElement("name", name);
        if (componentLead != null) {
            this.setFormElement("componentLead", componentLead);
        }
        this.submit();
        this.goToProject(projectName);
        try {
            String text = this.getDialog().getResponse().getText();
            String paramName = "id=\"edit_comp_" + name + "\" href=\"EditComponent!default.jspa?atl_token=" + this.page.getXsrfToken() + "&amp;id=";
            int startIndex = text.indexOf(paramName);
            if (startIndex == -1) {
                JIRAWebTest.fail((String)"component wasn't added");
            }
            int componentIdLocation = startIndex + paramName.length();
            componentId = text.substring(componentIdLocation, componentIdLocation + 5);
        }
        catch (IOException e) {
            JIRAWebTest.fail((String)("Unable to retrieve component id" + e.getMessage()));
            return "fail";
        }
        return componentId;
    }

    public void deleteComponent(String project, String name) {
        this.goToProject(project);
        this.assertLinkPresent("del_comp_" + name);
        this.clickLink("del_comp_" + name);
        this.submit("Delete");
    }

    public String addVersion(String project, String name, String description) {
        String projectKey;
        JIRAWebTest.log("Adding version '" + name + "' to project '" + project + "'");
        this.goToProject(project);
        this.clickLink("manage_versions");
        this.setFormElement("name", name);
        this.setFormElement("description", description);
        this.submit();
        try {
            String text = this.getDialog().getResponse().getText();
            String paramName = "id=\"del_" + name + "\" href=\"DeleteVersion!default.jspa?versionId=";
            int versionIdLocation = text.indexOf(paramName) + paramName.length();
            projectKey = text.substring(versionIdLocation, versionIdLocation + 5);
        }
        catch (IOException e) {
            JIRAWebTest.fail((String)("Unable to retrieve version key" + e.getMessage()));
            return "fail";
        }
        return projectKey;
    }

    public void deleteVersion(String project, String name) {
        this.goToProject(project);
        this.clickLink("manage_versions");
        this.clickLink("del_" + name);
        this.submit("Delete");
    }

    public void addIssueOnly(String project, String projectKey, String issueType, String summary, String priority, String[] components, String[] affectsVersions, String[] fixVersions, String assignTo, String environment, String description, String originalEstimate, String securityLevel, String dueDate) {
        int i;
        JIRAWebTest.log("Create Issue: Adding issue " + description);
        this.clickLink("create_link");
        this.assertTextPresent("Create Issue");
        if (project != null) {
            this.selectOption("pid", project);
        }
        if (issueType != null) {
            this.selectOption("issuetype", issueType);
        }
        this.setWorkingForm("issue-create");
        this.submit();
        this.assertTextPresent("CreateIssueDetails.jspa");
        this.setWorkingForm("issue-create");
        this.setFormElement("summary", summary);
        if (priority != null) {
            this.selectOption("priority", priority);
        }
        if (components != null && components.length > 0) {
            for (i = 0; i < components.length; ++i) {
                this.selectMultiOption("components", components[i]);
            }
        }
        if (affectsVersions != null && affectsVersions.length > 0) {
            for (i = 0; i < affectsVersions.length; ++i) {
                this.selectMultiOption("versions", affectsVersions[i]);
            }
        }
        if (fixVersions != null && fixVersions.length > 0) {
            for (i = 0; i < fixVersions.length; ++i) {
                this.selectMultiOption("fixVersions", fixVersions[i]);
            }
        }
        if (assignTo != null) {
            this.selectOption("assignee", assignTo);
        }
        if (originalEstimate != null) {
            this.setFormElement("timetracking", originalEstimate);
        }
        if (environment != null) {
            this.setFormElement("environment", environment);
        }
        if (description != null) {
            this.setFormElement("description", description);
        }
        if (dueDate != null) {
            this.setFormElement("duedate", dueDate);
        }
        if (securityLevel != null) {
            this.selectOption("security", securityLevel);
        }
        this.assertSubmitButtonPresent("Create");
        this.submit();
    }

    public String addIssue(String project, String projectKey, String issueType, String summary) {
        return this.addIssue(project, projectKey, issueType, summary, "Major", null, null, null, null, null, null, null, null, null);
    }

    public String addIssue(String project, String projectKey, String issueType, String summary, String priority, String[] components, String[] affectsVersions, String[] fixVersions, String assignTo, String environment, String description, String originalEstimate, String securityLevel, String dueDate) {
        String issueKey;
        this.addIssueOnly(project, projectKey, issueType, summary, priority, components, affectsVersions, fixVersions, assignTo, environment, description, originalEstimate, securityLevel, dueDate);
        try {
            issueKey = this.extractIssueKey(projectKey);
        }
        catch (Exception e) {
            JIRAWebTest.fail((String)("Unable to retrieve issue key" + e.getMessage()));
            return "fail";
        }
        return issueKey;
    }

    public String extractIssueKey(String projectKey) throws IOException {
        int endOfIssueKey;
        int projectIdLocation;
        String text = this.getDialog().getResponse().getText();
        String issueKey = text.substring(projectIdLocation = text.indexOf(projectKey), endOfIssueKey = text.indexOf("]", projectIdLocation));
        if (!issueKey.matches(projectKey + "-\\d+")) {
            JIRAWebTest.fail((String)("Invalid issue key: " + issueKey));
        }
        JIRAWebTest.log("issueKey = " + issueKey);
        return issueKey;
    }

    public String getIssueKeyWithSummary(String summary, String projectKey) {
        String issueKey;
        this.displayAllIssues();
        try {
            while (!this.getDialog().isLinkPresentWithText(summary) && this.getDialog().isLinkPresentWithText("Next >>")) {
                this.clickLinkWithText("Next >>");
            }
            this.clickLinkWithText(summary);
        }
        catch (Throwable t) {
            JIRAWebTest.fail((String)("Issue with " + summary + " not found. " + t));
            return "fail";
        }
        try {
            String text = this.getDialog().getResponse().getText();
            int projectIdLocation = text.indexOf(projectKey);
            int endOfIssueKey = text.indexOf("]", projectIdLocation);
            issueKey = text.substring(projectIdLocation, endOfIssueKey);
            JIRAWebTest.log("issueKey = " + issueKey);
        }
        catch (IOException e) {
            JIRAWebTest.fail((String)("Unable to retrieve issue key" + e.getMessage()));
            return "fail";
        }
        return issueKey;
    }

    @Deprecated
    public String getIssueIdWithIssueKey(String issueKey) {
        String issueId;
        this.gotoIssue(issueKey);
        try {
            String text = this.getDialog().getResponse().getText();
            String paramName = "ViewVoters!default.jspa?id=";
            int issueIdLocation = text.indexOf(paramName) + paramName.length();
            issueId = text.substring(issueIdLocation, issueIdLocation + 5);
            JIRAWebTest.log("issueId = " + issueId);
        }
        catch (IOException e) {
            JIRAWebTest.fail((String)("Unable to retrieve issue id" + e.getMessage()));
            return "fail";
        }
        return issueId;
    }

    public void deleteIssue(String issueKey) {
        this.gotoIssue(issueKey);
        this.deleteCurrentIssue();
    }

    protected final void deleteCurrentIssue() {
        this.clickLink("delete-issue");
        this.setWorkingForm("delete-issue");
        this.submit("Delete");
    }

    public void progressWorkflow(String issueKey, int actionKey, String comment) {
        JIRAWebTest.log(actionKey + ": " + issueKey);
        this.changeWorkflow(issueKey, actionKey);
        this.setWorkingForm("issue-workflow-transition");
        this.setFormElement("comment", comment);
        this.submit("Transition");
        this.assertTextPresent(comment);
    }

    public void progressAndResolve(String issueKey, int actionKey, String comment) {
        JIRAWebTest.log(actionKey + ": " + issueKey);
        this.changeWorkflow(issueKey, actionKey);
        this.setWorkingForm("issue-workflow-transition");
        this.setFormElement("comment", comment);
        this.selectOption("resolution", "Fixed");
        this.submit("Transition");
        this.assertTextPresent(comment);
    }

    public void changeWorkflow(String issueKey, int actionKey) {
        this.gotoIssue(issueKey);
        this.clickLink("action_id_" + actionKey);
    }

    public void assignIssue(String issueKey, String comment, String userFullName) {
        this.gotoIssue(issueKey);
        this.clickLink("assign-issue");
        this.selectOption("assignee", userFullName);
        if (comment != null) {
            this.setFormElement("comment", comment);
        }
        this.clickButton("assign-issue-submit");
        this.assertTextPresent(userFullName);
        if (comment != null) {
            this.assertTextPresent(comment);
        }
    }

    public void addUser(String username) {
        this.addUser(username, username, username, username + "@example.com");
    }

    public void addUser(String username, String password, String fullname, String emailAddress) {
        JIRAWebTest.log("Adding User " + username);
        this.gotoPage(PAGE_USER_BROWSER);
        this.navigation.checkWebSudoWithLastPassword();
        this.clickLink("add_user");
        this.setFormElement("username", username);
        this.setFormElement("password", password);
        this.setFormElement("confirm", password);
        this.setFormElement("fullname", fullname);
        this.setFormElement("email", emailAddress);
        this.submit();
    }

    public void navigateToUser(String username) {
        JIRAWebTest.log("Navigating in UserBrowser to User " + username);
        this.gotoPage(PAGE_USER_BROWSER);
        this.navigation.checkWebSudoWithLastPassword();
        this.clickLink(username);
    }

    public void deleteUser(String username) {
        JIRAWebTest.log("Deleting User " + username);
        this.navigateToUser(username);
        this.clickLink("deleteuser_link");
        this.submit("Delete");
        this.assertTextNotPresent(username);
    }

    public void runQuickSearch(String searchInput) {
        this.setWorkingForm("quicksearch");
        this.setFormElement("searchString", searchInput);
        this.submit("quicksearch");
    }

    public void displayAllIssues() {
        this.setWorkingForm("quicksearch");
        this.setFormElement("searchString", "");
        this.submit("quicksearch");
        this.assertTextPresent("Issue Navigator");
    }

    public void assertIssueNavigatorDisplaying(String from, String to, String of) {
        this.assertTextSequence(new String[]{"Displaying issues", from, "to", to, "of", of, "matching issues"});
    }

    public void gotoIssue(String issueKey) {
        this.setWorkingForm("quicksearch");
        this.setFormElement("searchString", issueKey);
        this.submit("quicksearch");
    }

    public void goToProject(String project_name) {
        this.gotoPage("/secure/project/ViewProjects.jspa");
        this.clickLinkWithText(project_name);
    }

    @Deprecated
    public void gotoAdmin() {
        this.getNavigation().gotoAdmin();
    }

    public void gotoNavigator() {
        HTMLElement element = null;
        try {
            element = this.getDialog().getResponse().getElementWithID("searchButton");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        if (element == null) {
            JIRAWebTest.log("going to Navigator page");
            this.clickLink("find_link");
        } else {
            JIRAWebTest.log("already at Navigator");
        }
    }

    public void releaseVersion(String projectName, String versionName) {
        this.goToProject(projectName);
        this.clickLink("manage_versions");
        this.clickLink("release_" + versionName);
        this.submit("Release");
    }

    public void unreleaseVersion(String projectName, String versionName) {
        this.goToProject(projectName);
        this.clickLink("manage_versions");
        this.clickLink("unrelease_" + versionName);
        this.submit("Unrelease");
    }

    @Deprecated
    public void addUserToGroup(String userName, String groupName) {
        this.navigateToUser(userName);
        this.clickLink("editgroups_link");
        try {
            this.tester.selectOption("groupsToJoin", groupName);
            this.submit("join");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.clickLink("return_link");
        this.assertTextPresent(groupName);
    }

    public void addUserToProjectRole(String userName, String projectName, String roleName) {
        this.goToProject(projectName);
        this.clickLinkWithText("View members");
        this.clickLink("edit_" + roleName + "_atlassian-user-role-actor");
        this.assertTextPresent("Assign Users to Project Role: " + roleName);
        this.setFormElement("userNames", userName);
        this.submit("add");
        this.assertTextPresent("(" + userName + ")");
    }

    public void addGroupToProjectRole(String groupName, String projectName, String roleName) {
        this.goToProject(projectName);
        this.clickLinkWithText("View members");
        this.clickLink("edit_" + roleName + "_atlassian-group-role-actor");
        this.assertTextPresent("Assign Groups to Project Role: " + roleName);
        this.setFormElement("groupNames", groupName);
        this.submit("add");
        this.assertLinkPresentWithText(groupName);
    }

    public void removeUserFromProjectRole(String userName, String projectName, String roleName) {
        this.goToProject(projectName);
        this.clickLinkWithText("View members");
        this.clickLink("edit_" + roleName + "_atlassian-user-role-actor");
        this.assertTextPresent("Assign Users to Project Role: " + roleName);
        this.checkCheckbox("removeusers_" + userName, ".");
        this.submit("remove");
        this.assertFormElementNotPresent("removeusers_" + userName);
    }

    public void removeGroupFromProjectRole(String groupName, String projectName, String roleName) {
        this.goToProject(projectName);
        this.clickLinkWithText("View members");
        this.clickLink("edit_" + roleName + "_atlassian-group-role-actor");
        this.assertTextPresent("Assign Groups to Project Role: " + roleName);
        this.checkCheckbox("removegroups_" + groupName, ".");
        this.submit("remove");
        this.assertFormElementNotPresent("removegroups_" + groupName);
    }

    public void assertUserIsMemberOfGroups(String username, Collection expectedGroupNames) {
        this.navigateToUser(username);
        this.clickLink("editgroups_link");
        this.setWorkingForm("jiraform");
        List<String> userGroupNames = Arrays.asList(this.getDialog().getOptionValuesFor("groupsToLeave"));
        JIRAWebTest.assertEquals((String)("Expected user '" + username + "' to be member of group(s) '" + expectedGroupNames + "' but was '" + userGroupNames + "'"), (int)expectedGroupNames.size(), (int)userGroupNames.size());
        for (String expectedGroupName : expectedGroupNames) {
            JIRAWebTest.assertTrue((String)("Expected user '" + username + "' to be member of group(s) '" + expectedGroupNames + "' but was '" + userGroupNames + "'"), (boolean)userGroupNames.contains(expectedGroupName));
        }
    }

    protected void gotoDashboard() {
        this.clickLink("home_link");
    }

    @Deprecated
    public void removeUserFromGroup(String userName, String groupName) {
        this.navigateToUser(userName);
        this.clickLink("editgroups_link");
        this.selectOption("groupsToLeave", groupName);
        this.submit("leave");
        this.clickLink("return_link");
        this.assertTextNotPresent(groupName);
    }

    @Deprecated
    public void createGroup(String groupName) {
        this.gotoPage("/secure/admin/user/GroupBrowser.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
        if (this.getDialog().isLinkPresentWithText(groupName)) {
            this.clickLinkWithText(groupName);
            this.clickLink("del_" + groupName);
            this.submit("Delete");
        }
        this.setFormElement("addName", groupName);
        this.submit();
        this.assertLinkPresentWithText(groupName);
    }

    @Deprecated
    public void removeGroup(String groupName) {
        this.gotoPage("/secure/admin/user/GroupBrowser.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
        if (this.getDialog().isLinkPresent("del_" + groupName)) {
            this.clickLink("del_" + groupName);
            this.submit("Delete");
        }
    }

    public void addColumnToIssueNavigator(String[] fieldNames) {
        this.clickOnUserProfile();
        this.clickLink("view_nav_columns");
        for (int i = 0; i < fieldNames.length; ++i) {
            try {
                this.selectOption("fieldId", fieldNames[i]);
                this.submit("add");
                continue;
            }
            catch (Throwable t) {
                JIRAWebTest.log("Field already added to Issue Navigator");
            }
        }
    }

    public void restoreColumnDefaults() {
        this.clickOnUserProfile();
        this.clickLink("view_nav_columns");
        this.clickLinkWithText("Restore Defaults");
    }

    public void createIssueStep1() {
        this.clickLink("create_link");
        this.assertTextPresent("Create Issue");
        this.selectOption("pid", "homosapien");
        this.selectOption("issuetype", "Bug");
        this.submit();
        this.assertTextPresent("CreateIssueDetails.jspa");
    }

    public void createIssueStep1(String project, String issueType) {
        this.clickLink("create_link");
        this.assertTextPresent("Create Issue");
        this.selectOption("pid", project);
        this.selectOption("issuetype", issueType);
        this.setWorkingForm("issue-create");
        this.submit();
        this.assertTextPresent("CreateIssueDetails.jspa");
    }

    public void gotoFieldLayoutSchemes() {
        this.gotoPage("/secure/admin/ViewFieldLayoutSchemes.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
        this.assertTextPresent("View Field Configuration Schemes");
    }

    public void addFieldLayoutScheme(String scheme_name, String scheme_desc) {
        this.gotoFieldLayoutSchemes();
        this.setFormElement("fieldLayoutSchemeName", scheme_name);
        this.setFormElement("fieldLayoutSchemeDescription", scheme_desc);
        this.submit("Add");
    }

    public void deleteFieldLayoutScheme(String scheme_name) {
        this.gotoFieldLayoutSchemes();
        this.clickLink("del_" + scheme_name);
        this.assertTextPresent("Delete Field Configuration Scheme");
        this.assertTextPresent(scheme_name);
        this.submit("Delete");
    }

    public void copyFieldLayout(String fieldLayoutName) {
        this.gotoPage(PAGE_ENTERPRISE_FIELD_CONFIGURATIONS);
        this.assertTextPresent("View Field Configurations");
        this.clickLinkWithText("Copy");
        this.assertTextPresent("Copy Field Configuration:");
        this.setFormElement("fieldLayoutName", fieldLayoutName);
        this.submit();
    }

    public void addFieldLayoutSchemeEntry(String issueTypeName, String fieldLayoutName, String schemeName) {
        this.gotoFieldLayoutSchemes();
        this.clickLinkWithText(schemeName);
        this.selectOption("issueTypeId", issueTypeName);
        this.selectOption("fieldConfigurationId", fieldLayoutName);
        this.submit();
        this.assertTextPresent(issueTypeName);
    }

    public void associateFieldLayoutScheme(String project, String issue_type, String scheme_name) {
        this.goToProject(project);
        this.clickLink("select_fieldlayoutscheme");
        this.assertTextPresent("Field Layout Configuration Association");
        this.selectOption("schemeId", scheme_name);
        this.submit("Associate");
        this.assertTextPresent(scheme_name);
    }

    public void removeAssociationWithFieldLayoutScheme(String project, String issue_type, String scheme_name) {
        this.goToProject(project);
        this.clickLink("select_fieldlayoutscheme");
        this.assertTextPresent("Field Layout Configuration Association");
        this.selectOption("schemeId", "None");
        this.submit("Associate");
    }

    public void setHiddenFieldsOnEnterprise(String fieldLayoutName, String fieldName) {
        this.gotoFieldLayoutOnEnterprise(fieldLayoutName);
        this.assertViewIssueFields();
        this.doFieldOperation(fieldName, HIDE_FIELD_OPERATION_NAME);
    }

    private void gotoFieldLayoutOnEnterprise(String fieldLayoutName) {
        this.gotoPage(PAGE_ENTERPRISE_FIELD_CONFIGURATIONS);
        this.assertTextPresent("View Field Configurations");
        this.clickLinkWithText(fieldLayoutName);
    }

    public void setShownFieldsOnEnterprise(String fieldLayoutName, String fieldName) {
        this.gotoFieldLayoutOnEnterprise(fieldLayoutName);
        this.assertViewIssueFields();
        this.doFieldOperation(fieldName, SHOW_FIELD_OPERATION_NAME);
    }

    public void setRequiredFieldsOnEnterprise(String fieldLayoutName, String fieldName) {
        this.gotoFieldLayoutOnEnterprise(fieldLayoutName);
        this.assertViewIssueFields();
        this.setRequiredField(fieldName);
    }

    public void setOptionalFieldsOnEnterprise(String fieldLayoutName, String fieldName) {
        this.gotoFieldLayoutOnEnterprise(fieldLayoutName);
        this.assertViewIssueFields();
        this.doFieldOperation(fieldName, OPTIONAL_FIELD_OPERATION_NAME);
    }

    public void setRequiredField(String fieldName) {
        this.assertViewIssueFields();
        try {
            WebTable fieldTable = this.getDialog().getResponse().getTableWithID("field_table");
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                String field = fieldTable.getCellAsText(i, 0);
                if (field.indexOf(fieldName) <= -1) continue;
                TableCell linkCell = fieldTable.getTableCell(i, 2);
                WebLink requiredLink = linkCell.getLinkWith("Required");
                if (requiredLink == null) {
                    JIRAWebTest.fail((String)("Cannot find 'required' link for field '" + fieldName + "'."));
                    continue;
                }
                requiredLink.click();
                return;
            }
            JIRAWebTest.fail((String)("Cannot find field with id '" + fieldName + "'."));
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)"Cannot find table with id 'field_table'.");
            e.printStackTrace();
        }
        catch (IOException e) {
            JIRAWebTest.fail((String)("Cannot click 'required' link for field id '" + fieldName + "'."));
        }
    }

    private void gotoViewIssueFields() {
        this.gotoPage(PAGE_ENTERPRISE_FIELD_CONFIGURATIONS);
        this.assertTextPresent("View Field Configurations");
        this.clickLinkWithText("Configure");
        this.assertTextPresent("View Field Configuration");
    }

    public void setRequiredFields() {
        this.resetFields();
        JIRAWebTest.log("Set fields to be required");
        this.gotoViewIssueFields();
        this.setRequiredField("Affects Version/s");
        this.setRequiredField("Fix Version/s");
        this.setRequiredField("Component/s");
    }

    public void setHiddenFields(String fieldName) {
        JIRAWebTest.log("Hide field " + fieldName);
        this.gotoViewIssueFields();
        this.assertViewIssueFields();
        this.doFieldOperation(fieldName, HIDE_FIELD_OPERATION_NAME);
    }

    public void setShownFields(String fieldName) {
        JIRAWebTest.log("Show field " + fieldName);
        this.gotoViewIssueFields();
        this.assertViewIssueFields();
        this.doFieldOperation(fieldName, SHOW_FIELD_OPERATION_NAME);
    }

    public void doFieldOperation(String fieldName, String linkName) {
        this.assertViewIssueFields();
        try {
            WebTable fieldTable = this.getDialog().getResponse().getTableWithID("field_table");
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                String field = fieldTable.getCellAsText(i, 0);
                if (field.indexOf(fieldName) <= -1) continue;
                TableCell linkCell = fieldTable.getTableCell(i, 2);
                WebLink link = linkCell.getLinkWith(linkName);
                if (link == null) {
                    JIRAWebTest.log("Link with name '" + linkName + "' does not exist.");
                    return;
                }
                link.click();
                return;
            }
            JIRAWebTest.fail((String)("Cannot find field with id '" + fieldName + "'."));
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)"Cannot find table with id 'field_table'.");
            e.printStackTrace();
        }
        catch (IOException e) {
            JIRAWebTest.fail((String)("Cannot click '" + linkName + "' link for field id '" + fieldName + "'."));
        }
    }

    public void resetFields() {
        JIRAWebTest.log("Restore default field settings");
        this.gotoViewIssueFields();
        if (this.getDialog().isLinkPresentWithText("Restore Defaults")) {
            this.clickLinkWithText("Restore Defaults");
        }
    }

    public void setDueDateToRequried() {
        this.resetFields();
        JIRAWebTest.log("Set 'Due Date' Field to required");
        this.gotoViewIssueFields();
        this.setRequiredField("Due Date");
    }

    public void setSecurityLevelToRequried() {
        this.resetFields();
        JIRAWebTest.log("Set 'Security Level' Field to required");
        this.gotoViewIssueFields();
        this.setRequiredField("Security Level");
    }

    @Deprecated
    public void grantGlobalPermission(int permissionCode, String groupName) {
        String deleteLink = "del_" + permissionCode + "_" + groupName;
        this.clickOnAdminPanel("admin.globalsettings", "global_permissions");
        if (!this.getDialog().isLinkPresent(deleteLink)) {
            if (permissionCode == 33) {
                this.selectOption("permType", "Bulk Change");
            } else if (permissionCode == 22) {
                this.selectOption("permType", "Create Shared Objects");
            } else if (permissionCode == 1) {
                this.selectOption("permType", "JIRA Users");
            } else if (permissionCode == 0) {
                this.selectOption("permType", "JIRA Administrators");
            } else if (permissionCode == 0) {
                this.selectOption("permType", "JIRA Administrators");
            } else if (permissionCode == 44) {
                this.selectOption("permType", "JIRA System Administrators");
            }
            this.selectOption("groupName", groupName);
            this.submit("Add");
        }
    }

    @Deprecated
    public void removeGlobalPermission(int permissionCode, String groupName) {
        String deleteLink = "del_" + permissionCode + "_" + groupName;
        this.clickOnAdminPanel("admin.globalsettings", "global_permissions");
        if (this.getDialog().isLinkPresent(deleteLink)) {
            this.clickLink(deleteLink);
            this.submit("Delete");
        }
    }

    public void createPermissionScheme(String permission_name, String permission_desc) {
        this.gotoPermissionSchemes();
        this.clickLinkWithText("Add Permission Scheme");
        this.setFormElement("name", permission_name);
        this.setFormElement("description", permission_desc);
        this.submit("Add");
    }

    public void deletePermissionScheme(String permission_name) {
        this.gotoPermissionSchemes();
        this.clickLink("del_" + permission_name);
        this.submit("Delete");
    }

    public void associatePermSchemeToProject(String project, String permission_name) {
        this.goToProject(project);
        this.clickLink("select_permission_scheme");
        this.selectOption("schemeIds", permission_name);
        this.submit("Associate");
    }

    public void removeGroupPermission(String permission_scheme, int permission, String groupName) {
        this.gotoPermissionSchemes();
        this.clickLinkWithText(permission_scheme);
        this.assertTextPresent("Edit Permissions &mdash; " + permission_scheme);
        if (this.getDialog().isLinkPresent("del_perm_" + permission + "_" + groupName)) {
            this.clickLink("del_perm_" + permission + "_" + groupName);
            this.submit("Delete");
            this.assertTextPresent("Edit Permissions &mdash; " + permission_scheme);
            this.assertLinkNotPresent("del_perm_" + permission + "_" + groupName);
        }
    }

    public void grantGroupPermission(String permission_scheme, int permission, String groupName) {
        this.gotoPermissionSchemes();
        this.clickLinkWithText(permission_scheme);
        this.assertTextPresent("Edit Permissions &mdash; " + permission_scheme);
        if (!this.getDialog().isLinkPresent("del_perm_" + permission + "_" + groupName)) {
            this.clickLink("add_perm_" + permission);
            this.getDialog().setFormParameter("type", "group");
            this.assertRadioOptionSelected("type", "group");
            this.assertOptionValuesEqual("group", new String[]{"", "jira-administrators", "jira-developers", "jira-users"});
            this.selectOption("group", groupName);
            this.getDialog().setFormParameter("type", "group");
            this.assertRadioOptionSelected("type", "group");
            this.submit();
        }
    }

    public void grantGroupAllPermissions(String permission_scheme, String groupName) {
        this.gotoPermissionSchemes();
        this.clickLinkWithText(permission_scheme);
        this.assertTextPresent("Edit Permissions &mdash; " + permission_scheme);
        this.clickLinkWithText("Add");
        this.checkCheckbox("type", "group");
        this.selectOption("group", "jira-administrators");
        String[] optionValues = this.getDialog().getOptionValuesFor("permissions");
        for (int i = 0; i < optionValues.length; ++i) {
            this.selectMultiOptionByValue("permissions", optionValues[i]);
        }
        this.submit();
    }

    public void removeGroupPermission(int permission, String groupName) {
        this.gotoPermissionSchemes();
        this.clickLinkWithText("Default Permission Scheme");
        this.assertTextPresent("Edit Permissions &mdash; Default Permission Scheme");
        if (this.getDialog().isLinkPresent("del_perm_" + permission + "_" + groupName)) {
            this.clickLink("del_perm_" + permission + "_" + groupName);
            this.submit("Delete");
        }
        this.assertTextPresent("Edit Permissions &mdash; Default Permission Scheme");
        this.assertLinkNotPresent("del_perm_" + permission + "_" + groupName);
    }

    public void removeRolePermission(int permission, int role) {
        this.gotoPermissionSchemes();
        this.clickLinkWithText("Default Permission Scheme");
        this.assertTextPresent("Edit Permissions &mdash; Default Permission Scheme");
        if (this.getDialog().isLinkPresent("del_perm_" + permission + "_" + role)) {
            this.clickLink("del_perm_" + permission + "_" + role);
            this.submit("Delete");
        }
        this.assertTextPresent("Edit Permissions &mdash; Default Permission Scheme");
        this.assertLinkNotPresent("del_perm_" + permission + "_" + role);
    }

    public void grantGroupPermission(int permission, String groupName) {
        this.gotoPermissionSchemes();
        this.clickLinkWithText("Default Permission Scheme");
        this.assertTextPresent("Edit Permissions &mdash; Default Permission Scheme");
        if (!this.getDialog().isLinkPresent("del_perm_" + permission + "_" + groupName)) {
            this.clickLink("add_perm_" + permission);
            this.getDialog().setFormParameter("type", "group");
            this.assertRadioOptionSelected("type", "group");
            this.assertOptionValuesEqual("group", new String[]{"", "jira-administrators", "jira-developers", "jira-users"});
            this.selectOption("group", groupName);
            this.getDialog().setFormParameter("type", "group");
            this.assertRadioOptionSelected("type", "group");
            this.submit();
        }
    }

    public void grantRolePermission(int permission, int role) {
        this.gotoPermissionSchemes();
        this.clickLinkWithText("Default Permission Scheme");
        this.assertTextPresent("Edit Permissions &mdash; Default Permission Scheme");
        if (!this.getDialog().isLinkPresent("del_perm_" + permission + "_" + role)) {
            this.clickLink("add_perm_" + permission);
            this.getDialog().setFormParameter("type", "projectrole");
            this.assertRadioOptionSelected("type", "projectrole");
            this.assertOptionValuesEqual("projectrole", new String[]{"", "10002", "10001", "10000"});
            this.checkCheckbox("projectrole", Integer.toString(role));
            this.getDialog().setFormParameter("type", "projectrole");
            this.assertRadioOptionSelected("type", "projectrole");
            this.submit();
        }
    }

    public void gotoPermissionSchemes() {
        this.gotoPage("/secure/admin/ViewPermissionSchemes.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
    }

    public void grantPermissionToUserCustomField(String permissionScheme, String customFieldName, int permission) {
        this.gotoPermissionSchemes();
        this.clickLinkWithText(permissionScheme);
        this.clickLink("add_perm_" + permission);
        this.checkCheckbox("type", "userCF");
        this.selectOption("userCF", customFieldName);
        this.submit(" Add ");
        this.assertTextPresent("(" + customFieldName + ")");
    }

    public void grantPermissionToReporter(int permission) {
        this.gotoPermissionSchemes();
        this.clickLinkWithText("Default Permission Scheme");
        this.clickLink("add_perm_" + permission);
        this.checkCheckbox("type", "reporter");
        this.submit(" Add ");
    }

    public void removePermissionFromUserCustomField(String permissionScheme, String customFieldId, int permission) {
        this.gotoPermissionSchemes();
        this.clickLinkWithText(permissionScheme);
        this.clickLink("del_perm_" + permission + "_customfield_" + customFieldId);
        this.submit("Delete");
    }

    public void gotoSchemeTools() {
        this.gotoAdmin();
        this.clickLink("scheme_tools");
    }

    public void gotoGroupToRoleMappingToolSchemeSelection() {
        this.gotoSchemeTools();
        this.clickLink("mapping_tool");
        this.assertTextPresent("Map Groups to Project Roles: Select Schemes");
    }

    public void gotoGroupToRoleMappingToolMappingSelection(String schemeType, String schemeName) {
        this.gotoGroupToRoleMappingToolSchemeSelection();
        this.selectOption("selectedSchemeType", schemeType);
        this.selectOption("selectedSchemeIds", schemeName);
        this.submit("Map Groups to Roles");
        this.assertTextPresent("Map Groups to Project Roles: Select Mappings");
    }

    public void mapGroupToRoles(String schemeType, String schemeName, Map groupToRoleMapping) {
        this.gotoGroupToRoleMappingToolMappingSelection(schemeType, schemeName);
        for (String groupName : groupToRoleMapping.keySet()) {
            this.selectOption(groupName + "_project_role", (String)groupToRoleMapping.get(groupName));
        }
        this.submit("Preview Mappings");
        try {
            WebTable groupToRoleTable = this.getDialog().getResponse().getTableWithID("group_to_role_mappings");
            for (String groupName : groupToRoleMapping.keySet()) {
                String roleName;
                boolean containsNonGlobalUsePermissionedGroup = this.tableIndexOf(groupToRoleTable, EasyList.build((Object)groupName, (Object)new ImageCell("/images/icons/arrow_right_small.gif"), (Object)(roleName = (String)groupToRoleMapping.get(groupName)))) != -1;
                boolean containsGlobalUsePermissionedGroup = this.tableIndexOf(groupToRoleTable, EasyList.build((Object)groupName, (Object)new ImageCell("/images/icons/arrow_right_yellow.gif"), (Object)roleName)) != -1;
                JIRAWebTest.assertTrue((String)("Did not find a row matching: " + groupName + ", [arrow icon] , " + roleName), (containsGlobalUsePermissionedGroup || containsNonGlobalUsePermissionedGroup ? 1 : 0) != 0);
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        this.submit("Save");
        this.assertTextPresent("Map Groups to Project Roles: Results of Transformation for Schemes");
    }

    @Deprecated
    public void activateTimeTracking() {
        this.submitAtPage(PAGE_TIME_TRACKING, "Activate", "time tracking already activated");
    }

    @Deprecated
    public void deactivateTimeTracking() {
        this.submitAtPage(PAGE_TIME_TRACKING, "Deactivate", "time tracking already deactivated");
    }

    public void reconfigureTimetracking(String format) {
        this.gotoPage(PAGE_TIME_TRACKING);
        this.getNavigation().checkWebSudoWithLastPassword();
        this.submit("Deactivate");
        this.checkCheckbox("timeTrackingFormat", format);
        this.submit("Activate");
    }

    public void submitAtPage(String url, String button, String logOnFail) {
        this.gotoPage(url);
        this.getNavigation().checkWebSudoWithLastPassword();
        if (this.getDialog().hasSubmitButton(button)) {
            this.submit(button);
        } else if (logOnFail != null) {
            JIRAWebTest.log(logOnFail);
        }
    }

    public void logWorkOnIssue(String issueKey, String timeLogged) {
        this.logWorkOnIssueWithComment(issueKey, timeLogged, null);
    }

    public void logWorkOnIssueWithComment(String issueKey, String timeLogged, String comment) {
        this.gotoIssue(issueKey);
        this.clickLink("log-work");
        this.setFormElement("timeLogged", timeLogged);
        if (comment != null) {
            this.setFormElement("comment", comment);
        }
        this.submit();
    }

    public void activateIssueLinking() {
        this.submitAtPage(this.getPage().addXsrfToken(PAGE_LINK_TYPES), "Activate", "linking already activated");
    }

    public void deactivateIssueLinking() {
        this.submitAtPage(this.getPage().addXsrfToken(PAGE_LINK_TYPES), "Deactivate", "linking already deactivated");
    }

    public String getComponentId(String project, String component) {
        this.goToProject(project);
        this.clickLink("edit_comp_" + component);
        return this.getDialog().getFormParameterValue("id");
    }

    public String getProjectId(String project) {
        this.goToProject(project);
        this.clickLink("edit_project");
        return this.getDialog().getFormParameterValue("pid");
    }

    public void setComponentLead(String project, String userName, String fullName, String component) {
        this.goToProject(project);
        this.clickLink("edit_comp_" + component);
        this.setFormElement("componentLead", userName);
        this.submit();
        this.assertTextPresent("(<b>Lead:</b> " + fullName + ")");
    }

    public void setComponentName(String project, String oldComponentName, String newComponentName) {
        this.goToProject(project);
        this.clickLink("edit_comp_" + oldComponentName);
        this.setFormElement("name", newComponentName);
        this.submit();
        this.assertTextPresent(newComponentName);
        this.assertTextNotPresent(oldComponentName);
    }

    public void clearComponentLead(String project, String component) {
        this.goToProject(project);
        this.clickLink("edit_comp_" + component);
        this.setFormElement("componentLead", "");
        this.submit("Update");
    }

    public void setComponentAssigneeOptions(String project, String component, String option) {
        String componentId = this.getComponentId(project, component);
        this.goToProject(project);
        this.clickLink("select_component_assignees");
        this.getDialog().setFormParameter("component_" + componentId, option);
        this.assertRadioOptionSelected("component_" + componentId, option);
        this.submit();
    }

    public void setUnassignedIssuesOption(boolean enable) {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        if (enable) {
            this.getDialog().setFormParameter("allowUnassigned", "true");
            this.assertRadioOptionSelected("allowUnassigned", "true");
        } else {
            this.getDialog().setFormParameter("allowUnassigned", "false");
            this.assertRadioOptionSelected("allowUnassigned", "false");
        }
        this.submit("Update");
    }

    public void setProjectLead(String project, String username) {
        this.goToProject(project);
        this.clickLinkWithText("Edit Project");
        this.setFormElement("lead", username);
        this.submit();
    }

    public void setDefaultProjectAssigneeToUnassigned(String project) {
        this.goToProject(project);
        this.clickLinkWithText("Edit Project");
        this.selectOption("assigneeType", "Unassigned");
        this.submit();
    }

    public void voteForIssue(String issueKey) {
        this.gotoIssue(issueKey);
        if (this.getDialog().getResponseText().contains("icon-vote-off")) {
            this.clickLink("toggle-vote-issue");
        }
        JIRAWebTest.assertTrue((boolean)this.getDialog().getResponseText().contains("icon-vote-on"));
        this.assertLinkPresent("toggle-vote-issue");
    }

    public void unvoteForIssue(String issueKey) {
        this.gotoIssue(issueKey);
        if (this.getDialog().getResponseText().contains("icon-vote-on")) {
            this.clickLink("toggle-vote-issue");
        }
        JIRAWebTest.assertTrue((boolean)this.getDialog().getResponseText().contains("icon-vote-off"));
        this.assertLinkPresent("toggle-vote-issue");
    }

    public void startWatchingAnIssue(String issueKey) {
        this.gotoIssue(issueKey);
        if (this.getDialog().getResponseText().contains("icon-watch-off")) {
            this.clickLink("toggle-watch-issue");
        }
        JIRAWebTest.assertTrue((boolean)this.getDialog().getResponseText().contains("icon-watch-on"));
        this.assertLinkPresent("toggle-watch-issue");
    }

    public void startWatchingAnIssue(String issueKey, String[] userNames) {
        int i;
        this.gotoIssue(issueKey);
        this.clickLink("manage-watchers");
        this.assertTextPresent("Watchers");
        StringBuffer userNameList = new StringBuffer();
        int n = userNames.length;
        for (i = 0; i < n; ++i) {
            if (i != n - 1) {
                userNameList.append(userNames[i]).append(",");
                continue;
            }
            userNameList.append(userNames[i]);
        }
        this.setFormElement("userNames", userNameList.toString());
        this.submit();
        for (i = 0; i < userNames.length; ++i) {
            this.assertLinkPresent("watcher_link_" + userNames[i]);
        }
    }

    public void stopWatchingAnIssue(String issueKey) {
        this.gotoIssue(issueKey);
        if (this.getDialog().getResponseText().contains("icon-watch-on")) {
            this.clickLink("toggle-watch-issue");
        }
        JIRAWebTest.assertTrue((boolean)this.getDialog().getResponseText().contains("icon-watch-off"));
        this.assertLinkPresent("toggle-watch-issue");
    }

    public void removeAllWatchers(String issueKey) {
        this.gotoIssue(issueKey);
        this.clickLink("view-watcher-list");
        this.checkCheckbox("all");
        this.getDialog().setWorkingForm("stopform");
        this.submit();
        this.assertTextPresent("There are currently no watchers associated with this issue.");
    }

    @Deprecated
    public void activateSubTasks() {
        this.gotoPage("/secure/admin/subtasks/ManageSubTasks.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
        if (this.getDialog().isLinkPresentWithText("Enable")) {
            this.clickLinkWithText("Enable");
        } else {
            JIRAWebTest.log("Subtasks already enabled");
        }
    }

    @Deprecated
    public boolean deactivateSubTasks() {
        JIRAWebTest.log("Deactivating Sub-tasks");
        this.gotoPage("/secure/admin/subtasks/ManageSubTasks.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
        if (this.getDialog().isLinkPresentWithText("Disable")) {
            this.clickLinkWithText("Disable");
        } else {
            JIRAWebTest.log("Sub-tasks already disabled");
        }
        if (this.getDialog().isTextInResponse("Cannot disable subtasks.")) {
            this.deleteAllIssuesInAllPages();
            this.deactivateSubTasks();
            return true;
        }
        this.assertLinkPresentWithText("Enable");
        return false;
    }

    public String addSubTaskToIssue(String issueKey, String subTaskType, String subTaskSummary, String subTaskDescription, String originalEstimate) {
        String subTaskKey;
        this.createSubTaskStep1(issueKey, subTaskType);
        this.setFormElement("summary", subTaskSummary);
        this.setFormElement("description", subTaskDescription);
        if (originalEstimate != null) {
            this.setFormElement("timetracking", "2h");
        }
        this.submit("Create");
        String projectKey = issueKey.substring(0, issueKey.indexOf(45));
        try {
            String text = this.getDialog().getResponse().getText();
            int projectIdLocation = text.indexOf(projectKey);
            int endOfSubTaskKey = text.indexOf("]", projectIdLocation);
            subTaskKey = text.substring(projectIdLocation, endOfSubTaskKey);
            JIRAWebTest.log("subTaskKey = " + subTaskKey);
        }
        catch (IOException e) {
            JIRAWebTest.fail((String)("Unable to retrieve issue key" + e.getMessage()));
            return "fail";
        }
        return subTaskKey;
    }

    @Deprecated
    public String addSubTaskToIssue(String issueKey, String subTaskType, String subTaskSummary, String subTaskDescription) {
        return this.addSubTaskToIssue(issueKey, subTaskType, subTaskSummary, subTaskDescription, null);
    }

    public void createSubTaskType(String sub_task_name, String sub_task_description) {
        this.activateSubTasks();
        this.setFormElement("name", sub_task_name);
        this.setFormElement("description", sub_task_description);
        this.submit("Add");
        this.deactivateSubTasks();
    }

    public void deleteSubTaskType(String sub_task_name) {
        this.activateSubTasks();
        this.clickLink("del_" + sub_task_name);
        this.submit("Delete");
        this.deactivateSubTasks();
    }

    public void createSubTaskStep1(String issueKey, String task_type) {
        this.activateSubTasks();
        this.gotoIssue(issueKey);
        this.clickLink("create-subtask");
        this.assertTextPresent("Create Sub-Task");
        if (this.getDialog().getElement("issuetype") == null) {
            JIRAWebTest.log("Bypassing step 1 of sub task creation");
        } else {
            this.setWorkingForm("subtask-create-start");
            this.selectOption("issuetype", task_type);
            this.submit("Create");
        }
        this.assertElementPresent("subtask-create-details");
    }

    public void gotoIssueSecuritySchemes() {
        this.clickOnAdminPanel("admin.schemes", "security_schemes");
    }

    public void createSecurityScheme(String scheme_name, String scheme_description) {
        this.gotoIssueSecuritySchemes();
        this.clickLink("add_securityscheme");
        this.assertTextPresent("Add Issue Security Scheme");
        this.setFormElement("name", scheme_name);
        this.setFormElement("description", scheme_description);
        this.submit("Add");
    }

    public void createSecurityLevel(String scheme_name, String level_name, String level_description) {
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText(scheme_name);
        this.setFormElement("name", level_name);
        this.setFormElement("description", level_description);
        this.submit("Add Security Level");
        this.assertLinkPresent("add_" + level_name);
    }

    public void addGroupToSecurityLevel(String scheme_name, String level_name, String groupName) {
        this.addGroupToSecurityLevel(scheme_name, level_name, groupName, new String[]{"", "jira-administrators", "jira-developers", "jira-users"});
    }

    public void addGroupToSecurityLevel(String scheme_name, String level_name, String groupName, String[] expectedGroups) {
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText(scheme_name);
        this.clickLink("add_" + level_name);
        this.getDialog().setFormParameter("type", "group");
        this.assertRadioOptionSelected("type", "group");
        this.assertOptionValuesEqual("group", expectedGroups);
        this.selectOption("group", groupName);
        this.getDialog().setFormParameter("type", "group");
        this.assertRadioOptionSelected("type", "group");
        this.submit();
    }

    public void addRoleToSecurityLevel(String scheme_name, String level_name, String roleName) {
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText(scheme_name);
        this.clickLink("add_" + level_name);
        this.getDialog().setFormParameter("type", "projectrole");
        this.assertRadioOptionSelected("type", "projectrole");
        this.selectOption("projectrole", roleName);
        this.submit();
    }

    public void removeGroupFromSecurityLevel(String scheme_name, String level_name, String groupName) {
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText(scheme_name);
        this.clickLink("delGroup_" + groupName + "_" + level_name);
        this.submit("Delete");
    }

    public void removeRoleFromSecurityLevel(String scheme_name, String level_name, String roleId) {
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText(scheme_name);
        this.clickLink("delGroup_" + roleId + "_" + level_name);
        this.submit("Delete");
    }

    public void deleteSecurityScheme(String scheme_name) {
        this.gotoIssueSecuritySchemes();
        this.clickLink("del_" + scheme_name);
        this.assertTextPresent("Delete Issue Security Scheme");
        this.assertTextPresent("Scheme: " + scheme_name);
        this.submit("Delete");
    }

    public void deleteSecurityLevel(String scheme_name, String level_name) {
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText(scheme_name);
        this.clickLink("delLevel_" + level_name);
        this.assertTextPresent("Delete Issue Security Level: " + level_name);
        this.submit("Delete");
    }

    public void removeAssociationOfSecuritySchemeFromProject(String project_name) {
        this.associateSecuritySchemeToProject(project_name, "None");
    }

    public void associateSecuritySchemeToProject(String project_name, String scheme_name) {
        this.grantGroupPermission(26, "jira-administrators");
        this.goToProject(project_name);
        this.clickLink("select_security_scheme");
        this.selectOption("newSchemeId", scheme_name);
        this.submit();
        this.assertTextPresent("Step 2 of 2");
        this.submit("Associate");
        this.removeGroupPermission(26, "jira-administrators");
    }

    public void gotoWorkFlowScheme() {
        this.gotoPage("/secure/admin/ViewWorkflowSchemes.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
    }

    public void gotoWorkFlow() {
        this.gotoPage("/secure/admin/workflows/ListWorkflows.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
    }

    public void addWorkFlowScheme(String workflowscheme_name, String workflowscheme_desc) {
        this.gotoWorkFlowScheme();
        this.clickLink("add_workflowscheme");
        this.setFormElement("name", workflowscheme_name);
        this.setFormElement("description", workflowscheme_desc);
        this.submit("Add");
    }

    public void deleteWorkFlowScheme(String workflowscheme_name) {
        this.gotoWorkFlowScheme();
        String linkId = "del_" + workflowscheme_name;
        if (this.getDialog().isLinkPresent(linkId)) {
            this.clickLink(linkId);
            this.submit("Delete");
        } else {
            JIRAWebTest.log("Workflow Scheme" + workflowscheme_name + " already deleted.");
        }
    }

    public void addWorkFlow(String workflow_name, String workflow_desc) {
        this.gotoWorkFlow();
        this.setFormElement("newWorkflowName", workflow_name);
        this.setFormElement("description", workflow_desc);
        this.submit("Add");
    }

    public void deleteWorkFlow(String workflow_name) {
        this.gotoWorkFlow();
        String linkId = "del_" + workflow_name;
        if (this.getDialog().isLinkPresent(linkId)) {
            this.clickLink(linkId);
            this.submit("Delete");
        } else {
            JIRAWebTest.log("Workflow " + workflow_name + " already deleted.");
        }
    }

    @Deprecated
    public void copyWorkFlow(String original_workflow_name, String new_workflow_name, String new_workflow_desc) {
        this.gotoWorkFlow();
        this.clickLink("copy_" + original_workflow_name);
        this.setFormElement("newWorkflowName", new_workflow_name);
        this.setFormElement("description", new_workflow_desc);
        this.submit("Copy");
    }

    public void addLinkedStatus(String status_name, String status_desc) {
        this.gotoPage("/secure/admin/ViewStatuses.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
        this.setFormElement("name", status_name);
        this.setFormElement("description", status_desc);
        this.submit("Add");
    }

    public void deleteLinkedStatus(String statusId) {
        this.gotoPage("/secure/admin/ViewStatuses.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
        this.clickLink("del_" + statusId);
        this.submit("Delete");
    }

    public void addStep(String workflow_name, String step_name, String linked_status) {
        this.gotoWorkFlow();
        this.clickLink("steps_live_" + workflow_name);
        this.setFormElement("stepName", step_name);
        if (linked_status != null) {
            this.selectOption("stepStatus", linked_status);
        }
        this.submit("Add");
    }

    public void deleteStep(String workflow_name, String step_name) {
        this.gotoWorkFlow();
        this.clickLink("steps_live_" + workflow_name);
        this.clickLinkWithText(step_name);
        this.clickLink("del_step");
        this.submit("Delete");
    }

    @Deprecated
    public void addTransition(String workflow_name, String step_name, String transition_name, String transition_desc, String destination_step, String transitionFieldScreen) {
        this.gotoWorkFlow();
        this.clickLink("steps_live_" + workflow_name);
        this.clickLinkWithText(step_name);
        this.clickLink("add_transition");
        this.setFormElement("transitionName", transition_name);
        this.setFormElement("description", transition_desc);
        this.selectOption("destinationStep", destination_step);
        if (transitionFieldScreen != null) {
            this.selectOption("view", transitionFieldScreen);
        }
        this.submit("Add");
    }

    public void editTransitionScreen(String workflow_name, String transition_name, String transitionFieldScreen) {
        this.gotoWorkFlow();
        this.clickLink("steps_live_" + workflow_name);
        this.clickLinkWithText(transition_name);
        this.clickLink("edit_transition");
        this.setFormElement("transitionName", transition_name);
        if (transitionFieldScreen != null) {
            this.selectOption("view", transitionFieldScreen);
        }
        this.submit();
    }

    public void deleteTransition(String workflow_name, String step_name, String transition_name) {
        this.gotoWorkFlow();
        this.clickLink("steps_live_" + workflow_name);
        this.clickLinkWithText(step_name);
        this.clickLink("del_transition");
        this.selectOption("transitionIds", transition_name);
        this.submit("Delete");
    }

    public void activateWorkflow(String workflow_name) {
        this.gotoWorkFlow();
        this.clickLink("activate_" + workflow_name);
        this.submit("Activate");
    }

    public void assignWorkflowScheme(String workflowscheme_name, String issuetype, String workflow_name) {
        this.gotoWorkFlowScheme();
        this.clickLinkWithText(workflowscheme_name);
        this.clickLinkWithText("Assign a workflow");
        this.selectOption("type", issuetype);
        this.selectOption("workflow", workflow_name);
        this.submit();
    }

    public void unassignWorkflowScheme(String workflowscheme_name, String issuetype, String workflow_name) {
        this.gotoWorkFlowScheme();
        this.clickLinkWithText(workflowscheme_name);
        this.clickLink("del_" + issuetype + "_" + workflow_name);
        this.submit("Delete");
    }

    @Deprecated
    public void associateWorkFlowSchemeToProject(String project, String workflow_scheme) {
        this.goToProject(project);
        this.clickLink("select_workflow_scheme");
        try {
            this.assertLinkNotPresentWithText("Add");
            this.assertTextNotPresent("There are currently no workflow schemes setup.");
        }
        catch (AssertionFailedError e) {
            JIRAWebTest.log("No workflows to remove");
            return;
        }
        this.selectOption("schemeId", workflow_scheme);
        this.submit("Associate");
        try {
            this.assertTextPresent("Step 2 of 3");
            this.submit("Associate");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertIndexedFieldCorrect(String path, Map expectedItemNodes, Map unexpectedItemNodes, String issueKey) {
        try {
            String xpathExpression;
            String expectedValue;
            String itemNode;
            this.gotoPage("/si/jira.issueviews:issue-xml/" + issueKey + "/" + issueKey + ".xml?jira.issue.searchlocation=index");
            String responseText = this.getDialog().getResponse().getText();
            Document doc = XMLUnit.buildControlDocument((String)responseText);
            JIRAWebTest.assertEquals((String)"text/xml", (String)this.getDialog().getResponse().getContentType());
            if (expectedItemNodes != null) {
                for (Map.Entry pairs : expectedItemNodes.entrySet()) {
                    itemNode = pairs.getKey().toString();
                    expectedValue = pairs.getValue().toString();
                    xpathExpression = path + "[" + itemNode + "= &quot;" + expectedValue + "&quot; ] ";
                    JIRAWebTest.log("Searching for existence of xpath " + xpathExpression);
                    XMLAssert.assertXpathExists((String)xpathExpression, (Document)doc);
                }
            }
            if (unexpectedItemNodes != null) {
                for (Map.Entry pairs : unexpectedItemNodes.entrySet()) {
                    itemNode = pairs.getKey().toString();
                    expectedValue = pairs.getValue().toString();
                    xpathExpression = path + "[" + itemNode + "= &quot;" + expectedValue + "&quot; ] ";
                    JIRAWebTest.log("Searching for nonexistence of xpath " + xpathExpression);
                    XMLAssert.assertXpathNotExists((String)xpathExpression, (Document)doc);
                }
            }
        }
        catch (Throwable e) {
            JIRAWebTest.raiseRuntimeException(e);
        }
        finally {
            this.gotoPage("/secure/Dashboard.jspa");
        }
    }

    private void _setupValidLicense(String formElementName, String licenseKey, String buildType) {
        this.setFormElement(formElementName, licenseKey);
        this.submit();
        this.assertTextNotPresent("Invalid license type for this edition of JIRA. License should be of type " + buildType + ".");
    }

    public void gotoPageNoLog(String url) {
        super.gotoPage(url);
    }

    public void gotoPage(String url) {
        JIRAWebTest.log("going to page " + url);
        super.gotoPage(url);
    }

    public void assertPageDoesNotExist(String assertionMessage, String url) {
        JIRAWebTest.log("asserting that the page does not exist. [" + url + "]");
        try {
            super.gotoPage(url);
            JIRAWebTest.fail((String)("Page unexpectedly exists - " + assertionMessage + " [" + url + "]"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void gotoCustomFields() {
        this.gotoPage(PAGE_CUSTOM_FIELDS);
    }

    public String addCustomField(String fieldType, String fieldName) {
        String desc = "a custom field called " + fieldName + " of type " + fieldType;
        return this.addCustomField(fieldType, FIELD_SCOPE_GLOBAL, fieldName, desc, null, null, null);
    }

    public String addCustomField(String fieldType, String fieldScope, String fieldName, String fieldDescription, String issueType, String project, String searcher) {
        return this.addCustomFieldWithMultipleIssueTypes(fieldType, fieldScope, fieldName, fieldDescription, new String[]{issueType}, project, searcher);
    }

    public String addCustomFieldWithMultipleIssueTypes(String fieldType, String fieldScope, String fieldName, String fieldDescription, String[] issueTypes, String project, String searcher) {
        if (!this.getDialog().isLinkPresentWithText("Add Custom Field")) {
            this.gotoCustomFields();
        }
        this.clickLinkWithText("Add Custom Field");
        this.getDialog().setFormParameter("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:" + fieldType);
        this.assertRadioOptionSelected("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:" + fieldType);
        this.submit("nextBtn");
        this.assertTextPresent("Step 2 of 2");
        this.assertTextPresent(fieldType);
        this.setFormElement("fieldName", fieldName);
        this.setFormElement("description", fieldDescription);
        if (searcher != null) {
            this.selectOption("searcher", searcher);
        }
        if (FIELD_SCOPE_GLOBAL.equalsIgnoreCase(fieldScope)) {
            this.setFormElement(FIELD_SCOPE_GLOBAL, "true");
        } else {
            if (issueTypes != null) {
                for (int i = 0; i < issueTypes.length; ++i) {
                    String issueType = issueTypes[i];
                    if (issueType == null) continue;
                    this.selectMultiOption("issuetypes", issueType);
                }
            }
            if (project != null) {
                this.setFormElement(FIELD_SCOPE_GLOBAL, "false");
                this.selectOption("projects", project);
            }
        }
        this.submit("nextBtn");
        this.gotoCustomFields();
        this.clickLink("edit_" + fieldName);
        return this.getDialog().getFormParameterValue("id");
    }

    public void deleteCustomField(String fieldId) {
        this.gotoCustomFields();
        this.clickLink("del_customfield_" + fieldId);
        this.submit("Delete");
    }

    public void addCustomFieldOption(String fieldId, String fieldOption) {
        if (!this.getDialog().isTextInResponse("Edit Custom Field Options") || !this.getDialog().isTextInResponse(fieldId)) {
            this.gotoCustomFields();
            this.clickLink("config_" + fieldId);
            this.clickLinkWithText("Edit Options");
            this.assertTextPresent("Edit Custom Field Options");
        }
        this.setFormElement("addValue", fieldOption);
        this.submit("Add");
    }

    public void configureCustomFieldOption(String fieldId, String fieldOption) {
        if (!this.getDialog().isTextInResponse("Edit Custom Field Options") || !this.getDialog().isTextInResponse(fieldId)) {
            this.gotoCustomFields();
            this.clickLink("config_customfield_" + fieldId);
            this.clickLinkWithText("Edit Options");
            this.assertTextPresent("Edit Custom Field Options");
        }
        this.setFormElement("addValue", fieldOption);
        this.submit("Add");
    }

    public void configureDefaultCustomFieldValue(String fieldId, String fieldOption) {
        this.gotoDefaultValue(fieldId);
        this.setFormElement("customfield_" + fieldId, fieldOption);
        this.submit("Set Default");
    }

    public void configureDefaultCheckBoxCustomFieldValue(String fieldId, String fieldOption) {
        this.gotoDefaultValue(fieldId);
        this.setFormElement("customfield_" + fieldId, "MultiCheckBox Two");
        this.submit("Set Default");
    }

    public void configureDefaultMultiCustomFieldValue(String fieldId, String fieldOption, String fieldOption2) {
        this.gotoDefaultValue(fieldId);
        this.selectOption("customfield_" + fieldId, fieldOption);
        this.selectOption("customfield_" + fieldId + ":1", fieldOption2);
        this.submit("Set Default");
    }

    private void gotoDefaultValue(String fieldId) {
        if (!this.getDialog().isTextInResponse("Set Custom Field Defaults") || !this.getDialog().isTextInResponse(fieldId)) {
            this.gotoCustomFields();
            this.clickLink("config_customfield_" + fieldId);
            this.clickLinkWithText("Edit Default Value");
            this.assertTextPresent("Set Custom Field Defaults");
        }
    }

    public void delCustomFieldOption(String fieldId, String fieldOption) {
        if (!this.getDialog().isTextInResponse("Edit Custom Field Options") || !this.getDialog().isTextInResponse(fieldId)) {
            this.gotoCustomFields();
            this.clickLink("config_" + fieldId);
            this.clickLinkWithText("Edit Options");
            this.assertTextPresent("Edit Custom Field Options");
        }
        this.clickLink("del_" + fieldOption);
        this.submit("Delete");
    }

    public void removeAllCustomFields() {
        while (true) {
            this.gotoCustomFields();
            if (!this.getDialog().isLinkPresentWithText("Del")) break;
            this.clickLinkWithText("Del");
            this.submit("Delete");
        }
    }

    public String createCustomFields(String fieldType, String fieldScope, String fieldName, String fieldDescription, String issueType, String projectType, String[] fieldOptions) {
        String fieldId = this.addCustomField(fieldType, fieldScope, fieldName, fieldDescription, issueType, projectType, null);
        if (fieldOptions != null) {
            for (int i = 0; i < fieldOptions.length; ++i) {
                this.addCustomFieldOption("customfield_" + fieldId, fieldOptions[i]);
            }
        }
        return fieldId;
    }

    public void editIssueWithCustomFields(String issueKey, List cfValues) {
        this.gotoIssue(issueKey);
        this.clickLink("editIssue");
        for (CustomFieldValue cfValue : cfValues) {
            if ("radiobuttons".equals(cfValue.getCfType())) {
                this.getDialog().setFormParameter("customfield_" + cfValue.getCfId(), cfValue.getCfValue());
                this.assertRadioOptionSelected("customfield_" + cfValue.getCfId(), cfValue.getCfValue());
            }
            if ("textfield".equals(cfValue.getCfType()) || "userpicker".equals(cfValue.getCfType()) || "datepicker".equals(cfValue.getCfType())) {
                this.setFormElement("customfield_" + cfValue.getCfId(), cfValue.getCfValue());
            }
            if ("select".equals(cfValue.getCfType())) {
                this.selectOption("customfield_" + cfValue.getCfId(), cfValue.getCfValue());
            }
            if ("multiselect".equals(cfValue.getCfType())) {
                this.selectOption("customfield_" + cfValue.getCfId(), cfValue.getCfValue());
            }
            if (!"multicheckboxes".equals(cfValue.getCfType())) continue;
            this.checkCheckbox("customfield_" + cfValue.getCfId(), cfValue.getCfValue());
        }
        this.submit("Update");
    }

    public void editIssueWithCustomFields(String issueKey, String customFieldId, String customFieldValue, String customFieldType) {
        this.gotoIssue(issueKey);
        this.clickLink("editIssue");
        if ("radiobuttons".equals(customFieldType)) {
            this.getDialog().setFormParameter("customfield_" + customFieldId, customFieldValue);
            this.assertRadioOptionSelected("customfield_" + customFieldId, customFieldValue);
        }
        if ("textfield".equals(customFieldType) || "userpicker".equals(customFieldType) || "datepicker".equals(customFieldType)) {
            this.setFormElement("customfield_" + customFieldId, customFieldValue);
        }
        if ("select".equals(customFieldType)) {
            this.selectOption("customfield_" + customFieldId, customFieldValue);
        }
        if ("multiselect".equals(customFieldType)) {
            this.selectOption("customfield_" + customFieldId, customFieldValue);
        }
        if ("multicheckboxes".equals(customFieldType)) {
            this.checkCheckbox("customfield_" + customFieldId, customFieldValue);
        }
        this.submit("Update");
    }

    public Collection<String> createIssuesInBulk(int numberOfIssues, String project, String projectKey, String issueType, String summary, String priority, String[] components, String[] affectsVersions, String[] fixVersions, String assignTo, String environment, String description, String originalEstimate, String securityLevel) {
        ArrayList<String> issuesTemp = new ArrayList<String>();
        for (int i = 0; i < numberOfIssues; ++i) {
            issuesTemp.add(this.addIssue(project, projectKey, issueType, summary + i, priority, components, affectsVersions, fixVersions, assignTo, environment, description, originalEstimate, securityLevel, null));
        }
        return issuesTemp;
    }

    public void sortIssues(String field, String direction) {
        this.gotoPage("/secure/IssueNavigator.jspa?sorter/field=" + field + "&sorter/order=" + direction);
    }

    public void sortIssues(String page, String field, String direction) {
        this.gotoPage("/secure/" + page + "?sorter/field=" + field + "&sorter/order=" + direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllIssuesInAllPages() {
        boolean mailServerExists = this.isMailServerExists();
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        try {
            JIRAWebTest.log("Deleting all issues");
            this.grantGlobalPermission(33, "jira-users");
            this.gotoIssue("");
            try {
                this.assertTextNotPresent("No matching issues found");
            }
            catch (Throwable t) {
                HttpUnitOptions.setScriptingEnabled((boolean)false);
                HttpUnitOptions.setScriptingEnabled((boolean)false);
                return;
            }
            this.clickLink("bulkedit_all");
            this.assertTextPresent("Bulk Operation: Choose Issues");
            this.checkCheckbox("all");
            this.assertCheckboxSelected("all");
            this.submit("Next");
            this.assertTextPresent("Bulk Operation: Choose Operation");
            this.setFormElement("operation", "bulk.delete.operation.name");
            this.assertRadioOptionSelected("operation", "bulk.delete.operation.name");
            this.submit("Next");
            if (mailServerExists) {
                this.submit("Next");
            }
            this.assertTextPresent("Bulk Operation: Confirmation");
            this.submit("Confirm");
            this.removeGlobalPermission(33, "jira-users");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    public boolean userExists(String userName) {
        this.gotoPage(PAGE_USER_BROWSER);
        return this.getDialog().isLinkPresentWithText(userName);
    }

    public boolean fieldSchemeExists(String fieldSchemeName) {
        this.gotoFieldLayoutSchemes();
        return this.getDialog().isTextInResponse(fieldSchemeName);
    }

    public boolean customFieldExists(String fieldName) {
        this.gotoCustomFields();
        return this.getDialog().isTextInResponse(fieldName);
    }

    public boolean subTaskTypeExists(String subTaskType) {
        this.activateSubTasks();
        boolean exists = this.getDialog().isLinkPresent("del_" + subTaskType);
        this.deactivateSubTasks();
        return exists;
    }

    public boolean securtiySchemeExists(String securityScheme) {
        this.clickOnAdminPanel("admin.schemes", "security_schemes");
        return this.getDialog().isTextInResponse(securityScheme);
    }

    public boolean securtiyLevelExists(String securityScheme, String securityLevel) {
        this.clickOnAdminPanel("admin.schemes", "security_scheme");
        this.clickLinkWithText(securityScheme);
        return this.getDialog().isLinkPresent("add_" + securityLevel);
    }

    public boolean permissionSchemeExists(String permissionScheme) {
        this.clickOnAdminPanel("admin.schemes", "permission_schemes");
        return this.getDialog().isLinkPresentWithText(permissionScheme);
    }

    public boolean workflowSchemeExists(String workflowScheme) {
        this.clickOnAdminPanel("admin.schemes", "workflow_schemes");
        return this.getDialog().isLinkPresentWithText(workflowScheme);
    }

    public boolean workflowExists(String workflow) {
        this.clickOnAdminPanel("admin.globalsettings", "workflows");
        return this.getDialog().isLinkPresent("steps_" + workflow);
    }

    public boolean linkedStatusExists(String linkedStatus) {
        this.clickOnAdminPanel("admin.issuesettings", "statuses");
        return this.getDialog().isLinkPresent("del_" + linkedStatus);
    }

    public boolean componentExists(String component, String project) {
        this.goToProject(project);
        return this.getDialog().isTextInResponse(component);
    }

    public boolean versionExists(String version, String project) {
        this.goToProject(project);
        return this.getDialog().isTextInResponse(version);
    }

    public boolean projectExists(String project) {
        this.gotoAdmin();
        this.clickLink("view_projects");
        return this.getDialog().isLinkPresentWithText(project);
    }

    public void gotoFieldScreens() {
        this.gotoPage("/secure/admin/ViewFieldScreens.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
    }

    public void gotoFieldScreen(String screenName) {
        this.gotoFieldScreens();
        this.assertTextPresent("View Screens");
        this.assertLinkPresent("configure_fieldscreen_" + screenName);
        this.clickLink("configure_fieldscreen_" + screenName);
    }

    public void gotoFieldScreenScheme() {
        this.gotoIssueTypeScreenSchemes();
        this.clickLink("configure_fieldscreenscheme_Default Screen Scheme");
    }

    public void addFieldToFieldScreen(String screenName, String fieldName) {
        JIRAWebTest.log("Adding " + fieldName + " to field screen.");
        this.gotoFieldScreen(screenName);
        this.assertTextPresent("Configure Screen");
        try {
            this.setWorkingForm("jiraform");
            this.selectOption("fieldId", fieldName);
        }
        catch (RuntimeException e) {
            JIRAWebTest.log("Already added.");
        }
        this.submit();
    }

    public void addFieldsToFieldScreen(String screenName, String[] fieldNames) {
        JIRAWebTest.log("Adding fields to field screen.");
        this.gotoFieldScreen(screenName);
        this.assertTextPresent("Configure Screen");
        for (int i = 0; i < fieldNames.length; ++i) {
            try {
                this.setWorkingForm("jiraform");
                this.selectOption("fieldId", fieldNames[i]);
                this.submit("Add");
                continue;
            }
            catch (RuntimeException e) {
                JIRAWebTest.log("Already added.");
            }
        }
    }

    public void addFieldToFieldScreen(String screenName, String fieldName, String position) {
        JIRAWebTest.log("Adding " + fieldName + " to field screen.");
        this.gotoFieldScreen(screenName);
        this.assertTextPresent("Configure Screen");
        try {
            this.selectOption("fieldId", fieldName);
            this.setFormElement("fieldPosition", position);
        }
        catch (RuntimeException e) {
            JIRAWebTest.log("Already added.");
        }
        this.submit("Add");
    }

    public void removeFieldFromFieldScreen(String screenName, String[] fieldNames) {
        JIRAWebTest.log("Removing Fields from field screen.");
        this.gotoFieldScreen(screenName);
        this.assertTextPresent("Configure Screen");
        for (int i = 0; i < fieldNames.length; ++i) {
            String indexName = this.findRowWithName("field_table", 1, fieldNames[i]);
            if (indexName != null) {
                int index = Integer.parseInt(indexName);
                this.setWorkingForm("tabFormOperations");
                this.checkCheckbox("removeField_" + index);
                this.assertCheckboxSelected("removeField_" + index);
                continue;
            }
            JIRAWebTest.log("Field " + fieldNames[i] + " not present");
        }
        this.submit("deleteFieldsFromTab");
    }

    public String findRowWithName(String fieldTableName, int column, String fieldName) {
        try {
            WebTable fieldTable = this.getDialog().getResponse().getTableWithID(fieldTableName);
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                String field = fieldTable.getCellAsText(i, column);
                if (field.indexOf(fieldName) <= -1) continue;
                return Integer.toString(i - 1);
            }
            return null;
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)"Cannot find table with id 'field_table'.");
            e.printStackTrace();
            return null;
        }
    }

    public void addScreen(String screenName, String screenDescription) {
        this.gotoFieldScreens();
        this.setFormElement("fieldScreenName", screenName);
        this.setFormElement("fieldScreenDescription", screenDescription);
        this.submit("Add");
    }

    public void copyScreen(String copiedScreenName, String newScreenName, String screenDescription) {
        this.gotoFieldScreens();
        this.clickLink("copy_fieldscreen_" + copiedScreenName);
        this.setFormElement("fieldScreenName", newScreenName);
        this.setFormElement("fieldScreenDescription", screenDescription);
        this.submit("Copy");
    }

    public void deleteScreen(String screenName) {
        this.gotoFieldScreens();
        this.clickLink("delete_fieldscreen_" + screenName);
        this.submit("Delete");
    }

    public void removeAllFieldScreens() {
        while (true) {
            this.gotoFieldScreens();
            try {
                this.assertLinkNotPresentWithText("Delete");
            }
            catch (Throwable t) {
                this.clickLinkWithText("Delete");
                this.submit("Delete");
                continue;
            }
            break;
        }
    }

    public void removeAllFieldScreenSchemes() {
        while (true) {
            this.gotoIssueTypeScreenSchemes();
            try {
                this.assertLinkNotPresentWithText("Delete");
            }
            catch (Throwable t) {
                this.clickLinkWithText("Delete");
                this.submit("Delete");
                continue;
            }
            break;
        }
    }

    public void removeAllScreenAssociationsFromDefault() {
        while (true) {
            this.gotoViewFieldScreenSchemes();
            this.clickLink("configure_fieldscreenscheme_Default Screen Scheme");
            try {
                this.assertLinkNotPresentWithText("Delete");
            }
            catch (Throwable t) {
                this.clickLinkWithText("Delete");
                continue;
            }
            break;
        }
    }

    public void gotoFieldScreenScheme(String schemeName) {
        this.gotoViewFieldScreenSchemes();
        this.clickLink("configure_fieldscreenscheme_" + schemeName);
    }

    private void gotoViewFieldScreenSchemes() {
        this.gotoPage(PAGE_NOT_STANDARD_VIEW_FIELD_SCREEN_SCHEMES);
    }

    public void addFieldScreenScheme(String schemeName, String schemeDescription, String fieldScreenDefault) {
        this.gotoViewFieldScreenSchemes();
        this.setFormElement("fieldScreenSchemeName", schemeName);
        this.setFormElement("fieldScreenSchemeDescription", schemeDescription);
        this.selectOption("fieldScreenId", fieldScreenDefault);
        this.submit("Add");
    }

    public void copyFieldScreenScheme(String copiedSchemeName, String schemeName, String schemeDescription) {
        this.gotoViewFieldScreenSchemes();
        this.clickLink("copy_fieldscreenscheme_" + copiedSchemeName);
        this.setFormElement("fieldScreenSchemeName", schemeName);
        this.setFormElement("fieldScreenSchemeDescription", schemeDescription);
        this.submit("Copy");
    }

    public void deleteFieldScreenScheme(String schemeName) {
        this.gotoViewFieldScreenSchemes();
        try {
            this.assertLinkPresent("configure_fieldscreenscheme_" + schemeName);
        }
        catch (AssertionError e) {
            JIRAWebTest.log("Scheme does not exist");
        }
        this.clickLink("delete_fieldscreenscheme_" + schemeName);
        this.submit("Delete");
    }

    public void addIssueOperationToScreenAssociation(String schemeName, String issueOperation, String screenName) {
        JIRAWebTest.log("Adding screen " + screenName + " to operation '" + issueOperation + "'.");
        this.gotoFieldScreenScheme(schemeName);
        this.selectOption("issueOperationId", issueOperation);
        this.selectOption("fieldScreenId", screenName);
        this.submit("Add");
    }

    public void deleteIssueOperationFromScreenAssociation(String schemeName, String issueOperation) {
        JIRAWebTest.log("Deleting operation '" + issueOperation + "' from scheme " + schemeName + ".");
        this.gotoFieldScreenScheme(schemeName);
        try {
            this.clickLink("delete_fieldscreenscheme_" + issueOperation);
        }
        catch (AssertionError e) {
            JIRAWebTest.log("Issue Operation not configured");
        }
    }

    public void removeAllFieldScreenAssociation(String schemeName) {
        while (true) {
            this.gotoFieldScreenScheme(schemeName);
            try {
                this.assertLinkNotPresentWithText("Delete");
            }
            catch (Throwable t) {
                this.clickLinkWithText("Delete");
                continue;
            }
            break;
        }
    }

    public void removeAllIssueTypeScreenSchemes() {
        while (true) {
            this.gotoIssueTypeScreenSchemes();
            try {
                this.assertLinkNotPresentWithText("Delete");
            }
            catch (Throwable t) {
                this.clickLinkWithText("Delete");
                this.submit("Delete");
                continue;
            }
            break;
        }
    }

    public void associateScreenSchemeToProject(String project, String screenScheme) {
        this.goToProject(project);
        this.clickLink("select_screenscheme");
        this.selectOption("schemeId", screenScheme);
        this.submit("Associate");
    }

    public void gotoIssueTypeScreenScheme(String schemeName) {
        this.gotoIssueTypeScreenSchemes();
        this.clickLink("configure_issuetypescreenscheme_" + schemeName);
    }

    public void addIssueTypeFieldScreenScheme(String schemeName, String schemeDescription, String defaultScreenScheme) {
        this.gotoIssueTypeScreenSchemes();
        this.setFormElement("schemeName", schemeName);
        this.setFormElement("schemeDescription", schemeDescription);
        this.selectOption("fieldScreenSchemeId", defaultScreenScheme);
        this.submit("Add");
    }

    public void deleteIssueTypeFieldScreenScheme(String schemeName) {
        this.gotoIssueTypeScreenSchemes();
        this.clickLink("delete_issuetypescreenscheme_" + schemeName);
        this.submit("Delete");
    }

    public void copyIssueTypeFieldScreenSchemeName(String copiedSchemeName, String schemeName, String schemeDescription) {
        this.gotoIssueTypeScreenSchemes();
        this.clickLink("copy_issuetypescreenscheme_" + copiedSchemeName);
        this.setFormElement("schemeName", schemeName);
        this.setFormElement("schemeDescription", schemeDescription);
        this.submit("Copy");
    }

    private void gotoIssueTypeScreenSchemes() {
        this.gotoPage(PAGE_ENTERPRISE_ISSUE_TYPE_SCREEN_SCHEMES);
    }

    public void addIssueTypeToScreenAssociation(String issueTypeSchemeName, String issueType, String screenSchemeName) {
        this.gotoIssueTypeScreenScheme(issueTypeSchemeName);
        this.selectOption("issueTypeId", issueType);
        this.selectOption("fieldScreenSchemeId", screenSchemeName);
        this.submit("Add");
    }

    public void deleteIssueTypeFromScreenAssociation(String issueTypeSchemeName, String issueType) {
        this.gotoIssueTypeScreenScheme(issueTypeSchemeName);
        try {
            this.clickLink("delete_issuetypescreenschemeentity_" + issueType);
        }
        catch (AssertionError e) {
            JIRAWebTest.log("No association between issue type " + issueType + " and scheme " + issueTypeSchemeName);
        }
    }

    public void associateIssueTypeScreenSchemeToProject(String project, String screenScheme) {
        this.goToProject(project);
        this.clickLink("select_issuetypescreenscheme");
        this.selectOption("schemeId", screenScheme);
        this.submit("Associate");
    }

    public void addTabToScreen(String screenName, String tabName) {
        this.gotoFieldScreen(screenName);
        this.setFormElement("newTabName", tabName);
        this.submit("Add");
    }

    public void gotoFieldScreenTab(String screenName, String tabName) {
        this.gotoFieldScreen(screenName);
        try {
            this.assertTextPresent("Add one or more fields to the");
            this.assertTextPresentBeforeText("<b>" + tabName + "</b>", "tab.");
        }
        catch (AssertionFailedError e) {
            this.clickLinkWithText(tabName);
        }
    }

    public void deleteTabFromScreen(String screenName, String tabName) {
        this.gotoFieldScreenTab(screenName, tabName);
        this.clickLinkWithText("Delete");
        this.submit("Delete");
    }

    public void addFieldToFieldScreenTab(String screenName, String tabName, String fieldName, String position) {
        this.gotoFieldScreenTab(screenName, tabName);
        this.assertTextPresent("Configure Screen");
        try {
            this.selectOption("fieldId", fieldName);
        }
        catch (RuntimeException e) {
            JIRAWebTest.log("Already added.");
        }
        this.setFormElement("fieldPosition", position);
        this.submit("Add");
    }

    public void removeFieldFromFieldScreenTab(String screenName, String tabName, String[] fieldNames) {
        this.gotoFieldScreenTab(screenName, tabName);
        this.assertTextPresent("Configure Screen");
        for (int i = 0; i < fieldNames.length; ++i) {
            String indexName = this.findRowWithName("field_table", 1, fieldNames[i]);
            if (indexName != null) {
                int index = Integer.parseInt(indexName);
                this.checkCheckbox("removeField_" + index);
                this.assertCheckboxSelected("removeField_" + index);
                continue;
            }
            JIRAWebTest.log("Field " + fieldNames[i] + " not present");
        }
        this.submit("deleteFieldsFromTab");
    }

    public void restoreDefaultDashboard() {
        this.clickLink("home_link");
        this.clickLinkWithText("Manage Dashboard");
        if (this.getDialog().isLinkPresentWithText("Restore Defaults")) {
            this.clickLinkWithText("Restore Defaults");
            this.submit("Restore");
        }
    }

    public void startDashboardConfiguration() {
        this.clickLink("home_link");
        if (this.getDialog().isLinkPresent("configure_on")) {
            this.clickLink("configure_on");
        }
    }

    public void browseToFullConfigure() {
        this.clickLink("home_link");
        this.clickLinkWithText("Manage Dashboard");
        this.clickLinkWithText("Full configure");
    }

    public void addPortlet(String portlet) {
        this.startDashboardConfiguration();
        this.clickLink("home_link");
        this.clickLinkWithText("Add a new portlet.");
        this.setFormElement("portletId", "com.atlassian.jira.plugin.system.portlets:" + portlet);
        this.assertRadioOptionSelected("portletId", "com.atlassian.jira.plugin.system.portlets:" + portlet);
        this.submit(" Add ");
    }

    public void addPortlet(String portlet, Map configFields) {
        this.addPortlet(portlet);
        for (Map.Entry entry : configFields.entrySet()) {
            this.setFormElement((String)entry.getKey(), (String)entry.getValue());
        }
        this.submit("Save");
    }

    public int saveFilter(String filterName, String filterDesc) {
        this.clickLinkWithText("Save");
        this.setFormElement("filterName", filterName);
        this.setFormElement("filterDescription", filterDesc);
        this.submit("saveasfilter_submit");
        this.gotoManageFilter();
        this.assertLinkPresentWithText(filterName);
        int filterId = Integer.parseInt(this.extractFilterId(filterName));
        JIRAWebTest.log("Saved filter: '" + filterName + "' [" + filterId + "]");
        return filterId;
    }

    public int saveFilterAs(String filterName, String copyName, String copyDesc, String saveColumnOrder) {
        this.gotoManageFilter();
        String filterId = this.extractFilterId(filterName);
        this.clickLinkWithText(filterName);
        if (!saveColumnOrder.equalsIgnoreCase("ignore")) {
            this.clickLinkWithText("Use your default Column Order");
        }
        this.clickLinkWithText("Save as");
        this.setFormElement("filterName", copyName);
        this.setFormElement("filterDescription", copyDesc);
        if (!saveColumnOrder.equalsIgnoreCase("ignore")) {
            this.setFormElement("saveColumnLayout", String.valueOf(saveColumnOrder));
        } else {
            this.assertFormElementNotPresent("saveColumnLayout");
        }
        this.submit("saveasfilter_submit");
        this.gotoManageFilter();
        this.assertLinkPresentWithText(copyName);
        int copyFilterId = Integer.parseInt(this.extractFilterId(copyName));
        JIRAWebTest.log("Saved filter: '" + filterName + "' [" + filterId + "] as filter: '" + copyName + "' [" + copyFilterId + "]");
        return copyFilterId;
    }

    public String extractFilterId(String filterName) {
        try {
            filterName = "\">" + filterName + "</a>";
            String text = this.getDialog().getResponse().getText();
            int endOfFilterId = text.indexOf(filterName);
            int startOfFilterId = text.substring(0, endOfFilterId).lastIndexOf("requestId=") + "requestId=".length();
            String filterId = text.substring(startOfFilterId, endOfFilterId);
            JIRAWebTest.log("filterId = " + filterId);
            return filterId;
        }
        catch (IOException e) {
            JIRAWebTest.fail((String)("Could not retrieve id for filter: '" + filterName + "'"));
            return null;
        }
    }

    public void deleteAllFilter() {
        this.gotoManageFilter();
        this.clickOnMyFiltersTab();
        JIRAWebTest.log("Deleting all filters");
        while (this.getDialog().isLinkPresentWithText("Delete")) {
            this.clickLinkWithText("Delete");
            this.submit("Delete");
        }
    }

    private void clickOnMyFiltersTab() {
        XPathLocator loc = new XPathLocator(this.tester, "//ul[@id='filter_type_table']/li/a/strong");
        if (loc.getText().contains("My")) {
            this.getNavigation().clickLinkWithExactText("My");
        }
        loc = new XPathLocator(this.tester, "//li[@class='active']/a");
        this.text.assertTextPresent(loc, "My");
    }

    public void deleteFilter(String filterName) {
        this.gotoManageFilter();
        this.clickOnMyFiltersTab();
        if (this.getDialog().isLinkPresent("delete_" + filterName)) {
            this.clickLink("delete_" + filterName);
            this.submit("Delete");
            this.assertLinkNotPresent("delete_" + filterName);
        }
    }

    public void gotoFilterById(long filterId) {
        this.gotoManageFilter();
        this.clickLink("filterlink_" + filterId);
    }

    public void gotoFilter(String filtername) {
        this.gotoManageFilter();
        this.clickLinkWithText(filtername);
    }

    private void gotoManageFilter() {
        this.tester.gotoPage("secure/ManageFilters.jspa?filterView=search&pressedSearchButton=true&searchName=&searchOwner=&Search=");
    }

    public void assertViewIssueFields() {
        this.assertTextPresent("View Field Configuration");
    }

    public void moveOptionsToPositions(String[] optionValue, String[] optionId, String itemType, Map moveToPosition) {
        for (String currentPosition : moveToPosition.keySet()) {
            int newIntPos;
            String newPosition = (String)moveToPosition.get(currentPosition);
            int currIntPos = Integer.parseInt(currentPosition);
            if (currIntPos < (newIntPos = Integer.parseInt(newPosition))) {
                this.assertTextPresentBeforeText("<b>" + optionValue[currIntPos] + "</b>", "<b>" + optionValue[newIntPos] + "</b>");
            } else if (currIntPos > newIntPos) {
                this.assertTextPresentBeforeText("<b>" + optionValue[newIntPos] + "</b>", "<b>" + optionValue[currIntPos] + "</b>");
            }
            JIRAWebTest.log("      Moving item at position " + currIntPos + " to position " + newPosition);
            this.setFormElement("new" + itemType + "Position_" + optionId[currIntPos], newPosition);
        }
        this.clickButtonWithValue("Move");
        for (int i = 1; i < optionValue.length; ++i) {
            int k;
            if (moveToPosition.containsKey(String.valueOf(i))) continue;
            for (k = 1; k <= i && moveToPosition.containsValue(String.valueOf(k)); ++k) {
            }
            moveToPosition.put(String.valueOf(i), String.valueOf(k));
        }
        for (String currentOption : moveToPosition.keySet()) {
            String newCurrentPos;
            String otherOption = newCurrentPos = (String)moveToPosition.get(currentOption);
            String newReplacedPos = (String)moveToPosition.get(newCurrentPos);
            int currentOptionInt = Integer.parseInt(currentOption);
            int newCurrentPosInt = Integer.parseInt(newCurrentPos);
            int otherOptionInt = Integer.parseInt(otherOption);
            int newReplacedPosInt = Integer.parseInt(newReplacedPos);
            if (newCurrentPosInt < newReplacedPosInt) {
                this.assertTextPresentBeforeText("<b>" + optionValue[currentOptionInt] + "</b>", "<b>" + optionValue[otherOptionInt] + "</b>");
                continue;
            }
            if (newCurrentPosInt <= newReplacedPosInt) continue;
            this.assertTextPresentBeforeText("<b>" + optionValue[otherOptionInt] + "</b>", "<b>" + optionValue[currentOptionInt] + "</b>");
        }
    }

    public void checkOrderingUsingArrows(String[] optionValue, String[] optionId) {
        int i;
        JIRAWebTest.log("Testing reordering using the option ordering arrows");
        JIRAWebTest.log("  checking moveToLast arrows");
        for (i = 1; i < optionValue.length; ++i) {
            this.clickLink("moveToLast_" + optionId[i]);
            this.assertLinkNotPresent("moveDown_" + optionId[i]);
            this.assertLinkNotPresent("moveToLast_" + optionId[i]);
        }
        this.checkItemsAreInAscendingOrder(optionValue);
        JIRAWebTest.log("  checking moveToFirst arrows");
        for (i = optionValue.length - 1; i >= 1; --i) {
            this.clickLink("moveToFirst_" + optionId[i]);
            this.assertLinkNotPresent("moveUp_" + optionId[i]);
            this.assertLinkNotPresent("moveToFirst_" + optionId[i]);
        }
        this.checkItemsAreInAscendingOrder(optionValue);
        JIRAWebTest.log("  checking moveDown arrows");
        for (i = 1; i < optionValue.length - 1; ++i) {
            this.clickLink("moveDown_" + optionId[i]);
        }
        this.checkItemsAreInAscendingOrder(optionValue);
        JIRAWebTest.log("  checking moveUp arrows");
        for (i = optionValue.length - 1; i >= 2; --i) {
            this.clickLink("moveUp_" + optionId[i]);
        }
        this.checkItemsAreInAscendingOrder(optionValue);
    }

    public String checkOrderingUsingMoveToPos(String[] optionValue, String[] optionId, String itemType) {
        JIRAWebTest.log("  Testing reordering using 'Move To Position' field inputs");
        JIRAWebTest.log("    Test moving one item");
        this.resetInAscendingOrdering(optionId, itemType);
        this.moveOptionsToPositions(optionValue, optionId, itemType, JIRAWebTest.easyMapBuild("1", "2"));
        JIRAWebTest.log("    Test moving two items");
        this.resetInAscendingOrdering(optionId, itemType);
        this.moveOptionsToPositions(optionValue, optionId, itemType, JIRAWebTest.easyMapBuild("1", "3", "2", "4"));
        JIRAWebTest.log("    Test moving three items");
        this.resetInAscendingOrdering(optionId, itemType);
        this.moveOptionsToPositions(optionValue, optionId, itemType, JIRAWebTest.easyMapBuild("1", "3", "2", "5", "3", "4"));
        return optionValue[1];
    }

    public void resetInAscendingOrdering(String[] optionId, String itemType) {
        if ("Field".equals(itemType)) {
            this.createNewFieldScreen(optionId);
        } else {
            this.clickLinkWithText("Sort options alphabetically");
        }
    }

    public void createNewFieldScreen(String[] optionId) {
        this.removeAllFieldScreens();
        this.gotoFieldScreens();
        this.setFormElement("fieldScreenName", "new screen for reordering tests");
        this.submit("Add");
        this.clickLink("configure_fieldscreen_new screen for reordering tests");
        for (int i = 1; i < optionId.length; ++i) {
            this.setFormElement("fieldId", optionId[i]);
            this.submit("Add");
        }
    }

    public void checkItemsAreInAscendingOrder(String[] optionValue) {
        for (int i = 1; i < optionValue.length - 1; ++i) {
            this.assertTextPresentBeforeText("<b>" + optionValue[i] + "</b>", "<b>" + optionValue[i + 1] + "</b>");
        }
    }

    public static Map easyMapBuild(Object key1, Object value1) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(1);
        map.put(key1, value1);
        return map;
    }

    public static Map easyMapBuild(Object key1, Object value1, Object key2, Object value2) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(2);
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static Map easyMapBuild(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(3);
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        return map;
    }

    public void setupHomoSapienProject() {
        this.addProject("homosapien", "HSP", "", "admin", "project for homosapiens");
        this.addHomoSapienComponents();
        this.addHomoSapienVersions();
    }

    public void setupMonkeyProject() {
        this.addProject("monkey", "MKY", "", "admin", "project for monkeys");
    }

    public void addHomoSapienComponents() {
        this.addComponent("homosapien", "New Component 1");
        this.addComponent("homosapien", "New Component 2");
        this.addComponent("homosapien", "New Component 3");
    }

    public void addHomoSapienVersions() {
        this.addVersion("homosapien", "New Version 1", "Test Version Description 1");
        this.addVersion("homosapien", "New Version 4", "Test Version Description 4");
        this.addVersion("homosapien", "New Version 5", "Test Version Description 5");
    }

    public void viewChangeHistoryOfIssue(String issueKey) {
        this.gotoIssue(issueKey);
        if (this.getDialog().isLinkPresentWithText("History")) {
            this.gotoPage("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:changehistory-tabpanel");
            this.assertLinkNotPresent("History");
        } else {
            this.assertTextPresent("History");
        }
    }

    public void assertNoChangesForIssue(String issueKey) {
        this.viewChangeHistoryOfIssue(issueKey);
        this.assertTextPresent("No changes have yet been made on this issue.");
    }

    public void assertLastChangeHistoryIs(String issueKey, String field, String originalValue, String newValue) {
        String text;
        this.viewChangeHistoryOfIssue(issueKey);
        try {
            text = this.getDialog().getResponse().getText();
        }
        catch (IOException e) {
            e.printStackTrace();
            JIRAWebTest.fail((String)e.getMessage());
            return;
        }
        String CHANGE_HISTORY_ID_PREFIX = "changehistory_";
        int startOfLastChangeHistoryTableId = text.lastIndexOf("id=\"changehistory_");
        int lastChangeHistoryTableId = -1;
        if (startOfLastChangeHistoryTableId != -1) {
            int endOfLastChangeHistoryTableId = text.substring(startOfLastChangeHistoryTableId += "id=\"changehistory_".length()).indexOf(34) + startOfLastChangeHistoryTableId;
            lastChangeHistoryTableId = Integer.parseInt(text.substring(startOfLastChangeHistoryTableId, endOfLastChangeHistoryTableId));
        }
        if (lastChangeHistoryTableId == -1) {
            JIRAWebTest.fail((String)"Could not find the last change history table");
        }
        try {
            WebTable changeHistoryTable = this.getDialog().getResponse().getTableWithID("changehistory_" + lastChangeHistoryTableId);
            for (int row = 0; row < changeHistoryTable.getRowCount(); ++row) {
                if (!this.tableCellHasStrictText(changeHistoryTable, row, 0, field) || !this.tableCellHasStrictText(changeHistoryTable, row, 1, originalValue) || !this.tableCellHasStrictText(changeHistoryTable, row, 2, newValue)) continue;
                return;
            }
            JIRAWebTest.fail((String)("The last change history for issue: " + issueKey + " did not have the change item: " + field + "[" + originalValue + "][" + newValue + "]"));
        }
        catch (SAXException e) {
            JIRAWebTest.raiseRuntimeException(e);
        }
    }

    public void assertLastChangeNotMadeToField(String issueKey, String field) {
        this.viewChangeHistoryOfIssue(issueKey);
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//div[@id=\"issue_actions_container\"]/div[last()]"), field);
    }

    public void assertErrorMsgFieldRequired(String fieldId, String project, String fieldDisplayName) {
        this.assertTextPresent("&quot;" + fieldId + "&quot; field is required and the project &quot;" + project + "&quot; does not have any " + fieldDisplayName);
    }

    public void bulkChangeIncludeAllPages() {
        this.assertTextPresent("Bulk Change:");
        this.clickLink("bulkedit_all");
    }

    public void bulkChangeIncludeCurrentPage() {
        this.clickLink("bulkedit_curr_pg");
    }

    public void isStepChooseIssues() {
        this.assertTextPresent("Bulk Operation: Choose Issues");
        JIRAWebTest.log("Step 1 of 4");
    }

    public void isStepChooseOperation() {
        this.assertTextPresent("Bulk Operation: Choose Operation");
        JIRAWebTest.log("Step 2 of 4");
    }

    public void isStepOperationDetails() {
        this.assertTextPresent("Bulk Operation: Operation Details");
        JIRAWebTest.log("Step 3 of 4");
    }

    public void isStepConfirmation() {
        this.assertTextPresent("Confirmation");
        JIRAWebTest.log("Step 4 of 4");
    }

    public void selectCheckbox(String cbox) {
        this.assertCheckboxNotSelected(cbox);
        this.checkCheckbox(cbox);
        this.assertCheckboxSelected(cbox);
    }

    public void bulkChangeChooseIssuesAll() {
        this.isStepChooseIssues();
        this.getDialog().setWorkingForm("bulkedit");
        String[] paramNames = this.getDialog().getForm().getParameterNames();
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            if (!paramName.startsWith("bulkedit_")) continue;
            this.selectCheckbox(paramName);
        }
        this.clickOnNext();
    }

    public void bulkChangeChooseOperationDelete(boolean mailServerExists) {
        this.isStepChooseOperation();
        this.setFormElement("operation", "bulk.delete.operation.name");
        this.assertRadioOptionSelected("operation", "bulk.delete.operation.name");
        JIRAWebTest.log("Operation Selected: Delete Issues");
        this.clickOnNext();
        if (mailServerExists) {
            this.clickOnNext();
        }
    }

    public void bulkChangeChooseOperationEdit() {
        this.isStepChooseOperation();
        this.setFormElement("operation", "bulk.edit.operation.name");
        this.assertRadioOptionSelected("operation", "bulk.edit.operation.name");
        JIRAWebTest.log("Operation Selected: Edit Issues");
        this.clickOnNext();
    }

    public void chooseOperationBulkMove() {
        this.isStepChooseOperation();
        this.setFormElement("operation", "bulk.move.operation.name");
        this.assertRadioOptionSelected("operation", "bulk.move.operation.name");
        JIRAWebTest.log("Operation Selected: Move Issues");
        this.clickOnNext();
    }

    public void chooseOperationExecuteWorfklowTransition() {
        this.isStepChooseOperation();
        this.setFormElement("operation", "bulk.workflowtransition.operation.name");
        this.assertRadioOptionSelected("operation", "bulk.workflowtransition.operation.name");
        JIRAWebTest.log("Operation Selected: Move Issues");
        this.clickOnNext();
    }

    public void clickOnNext() {
        this.submit("Next");
        JIRAWebTest.log("Next");
    }

    public void bulkChangeCancel() {
        this.assertFormElementPresent("Cancel");
        this.clickButton("Cancel");
        this.assertTextPresent("Issue Navigator");
        JIRAWebTest.log("Canceled");
    }

    public void bulkChangeConfirm() {
        this.isStepConfirmation();
        this.submit("Confirm");
        JIRAWebTest.log("Confirmed");
    }

    public float getJiraJavaVersion() {
        String JVM__HTML_TABLE_TD;
        this.gotoPage("/secure/admin/jira/ViewSystemInfo.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
        String responseText = this.getDialog().getResponseText();
        int idx = responseText.indexOf("<b>Java Version</b>");
        if (idx != -1 && (idx = responseText.indexOf(JVM__HTML_TABLE_TD = "<td valign=\"top\" width=\"60%\">", idx)) != -1) {
            int lastDecimalIdx;
            int firstDecimalIdx;
            String jvmVersion;
            if ((jvmVersion = responseText.substring(idx += JVM__HTML_TABLE_TD.length(), responseText.indexOf("</td>", idx))).indexOf("_") != -1) {
                jvmVersion = jvmVersion.substring(0, jvmVersion.indexOf("_"));
            }
            if ((firstDecimalIdx = jvmVersion.indexOf(".")) != (lastDecimalIdx = jvmVersion.lastIndexOf("."))) {
                jvmVersion = jvmVersion.substring(0, lastDecimalIdx);
            }
            try {
                return Float.parseFloat(jvmVersion);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public boolean isBeforeJdk15() {
        return this.getJiraJavaVersion() < 1.5f;
    }

    public void restoreData(String fileName) {
        this.restoreData(new File(this.getEnvironmentData().getXMLDataLocation(), fileName));
    }

    public void restoreDataWithFullRefresh(String fileName) {
        this.restoreData(new File(this.getEnvironmentData().getXMLDataLocation(), fileName), false);
    }

    protected void copyFileToJiraImportDirectory(File file) {
        File jiraImportDirectory = new File(this.administration.getJiraHomeDirectory(), "import");
        try {
            FileUtils.copyFileToDirectory((File)file, (File)jiraImportDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy file " + file.getAbsolutePath() + " to the import directory in jira home " + jiraImportDirectory, e);
        }
    }

    public void restoreData(File file) {
        this.restoreData(file, true);
    }

    public void restoreData(File file, boolean quickImport) {
        this.getNavigation().gotoAdminSection("system_info");
        this.getNavigation().checkWebSudoWithLastPassword();
        FuncTestTimer timer = TestInformationKit.pullTimer("XML Restore");
        this.copyFileToJiraImportDirectory(file);
        this.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
        this.setWorkingForm("jiraform");
        this.setFormElement("filename", file.getName());
        this.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        if (quickImport) {
            this.checkCheckbox("quickImport", "true");
        }
        this.submit();
        try {
            this.assertTextPresent("Your project has been successfully imported");
        }
        catch (AssertionFailedError e) {
            this.assertCauseOfError("The xml data you are trying to import seems to be from a newer version of JIRA. This will not work.");
            this.assertCauseOfError("You must enter the location of an XML file.");
            this.assertCauseOfError("Could not find file at this location.", file.getName());
            this.assertCauseOfError("Invalid license key specified.");
            this.assertCauseOfError("The current license is too old to install this version of JIRA");
            this.assertCauseOfError("Invalid license type for this edition of JIRA. License should be of type Standard.");
            this.assertCauseOfError("Invalid license type for this edition of JIRA. License should be of type Professional.");
            this.assertCauseOfError("Invalid license type for this edition of JIRA. License should be of type Enterprise.");
            this.assertCauseOfError("You must specify an index for the restore process.");
            this.assertCauseOfError("Error parsing export file. Your export file is invalid.");
            JIRAWebTest.fail((String)"Your JIRA data failed to restore successfully. See logs for details");
        }
        timer.end();
        this.login("admin", "admin");
        this.fixBaseURL();
        this.beginAt("/");
    }

    public void restoreI18nData(String fileName) {
        this.restoreI18nData(new File(this.getEnvironmentData().getXMLDataLocation(), fileName));
    }

    public void restoreI18nData(File file) {
        FuncTestTimer timer = TestInformationKit.pullTimer("XML Restore");
        this.copyFileToJiraImportDirectory(file);
        this.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
        this.setWorkingForm("jiraform");
        this.setFormElement("filename", file.getName());
        this.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.checkCheckbox("quickImport", "true");
        this.submit();
        try {
            JIRAWebTest.assertNotNull((Object)new XPathLocator(this.tester, "//*[@id=\"login\"]").getNode());
        }
        catch (AssertionFailedError e) {
            JIRAWebTest.fail((String)"Your JIRA data failed to restore successfully. See logs for details");
        }
        timer.end();
        this.login("admin", "admin");
        String baseUrl = this.getEnvironmentData().getBaseUrl().toString();
        JIRAWebTest.log("Setting baseurl to '" + baseUrl + "'");
        this.gotoAdmin();
        this.tester.gotoPage("/secure/admin/jira/EditApplicationProperties!default.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
        this.tester.setFormElement("baseURL", baseUrl);
        this.tester.submit();
        this.beginAt("/");
    }

    private void assertCauseOfError(String errorMessage) {
        this.assertCauseOfError(errorMessage, null);
    }

    private void assertCauseOfError(String errorMessage, String params) {
        try {
            this.assertTextNotPresent(errorMessage);
        }
        catch (AssertionFailedError e) {
            JIRAWebTest.fail((String)("Failed to restore JIRA data. Cause: " + errorMessage + (params != null ? " [" + params + "]" : "")));
        }
    }

    public void restoreDataWithLicense(String fileName, String licenseKey) {
        FuncTestTimer timer = TestInformationKit.pullTimer("XML Restore");
        File file = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + fileName);
        this.copyFileToJiraImportDirectory(file);
        this.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
        this.setWorkingForm("jiraform");
        this.setFormElement("filename", file.getName());
        this.setFormElement("license", licenseKey);
        this.checkCheckbox("quickImport", "true");
        this.submit();
        this.assertTextPresent("Your project has been successfully imported");
        timer.end();
        this.login("admin", "admin");
        this.fixBaseURL();
        this.beginAt("/");
    }

    private void fixBaseURL() {
        String baseUrl = this.getEnvironmentData().getBaseUrl().toString();
        JIRAWebTest.log("Setting baseurl to '" + baseUrl + "'");
        this.gotoAdmin();
        this.tester.clickLink("general_configuration");
        this.getNavigation().checkWebSudoWithLastPassword();
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.setFormElement("baseURL", baseUrl);
        this.tester.submit("Update");
    }

    public void start() {
        this.stopWatch.start();
    }

    public void split() {
        this.stopWatch.split();
        JIRAWebTest.log("Stop watch split at: " + this.stopWatch.toSplitString());
    }

    public void stop() {
        this.stopWatch.stop();
        JIRAWebTest.log("Stop watch stopped at: " + this.stopWatch.toString());
    }

    public void restoreBlankInstance() {
        this.restoreData("blankprojects.xml");
    }

    public void enableUnassignedIssues() {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        this.checkCheckbox("allowUnassigned", "true");
        this.submit("Update");
    }

    public void disableUnassignedIssues() {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        this.checkCheckbox("allowUnassigned", "false");
        this.submit("Update");
    }

    public void setBaseUrl() {
        this.setBaseUrl(this.getEnvironmentData().getBaseUrl().toExternalForm());
    }

    public void setBaseUrl(String baseUrl) {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        this.setFormElement("baseURL", baseUrl);
        this.submit("Update");
    }

    public void addIssueTypeStatsPortlet(String filterName) {
        this.browseToFullConfigure();
        this.submit("addButton");
        this.checkCheckbox("portletId", "com.atlassian.jira.plugin.system.portlets:filterstats");
        this.submit(" Add ");
        this.selectOption("filterid", filterName);
        this.selectOption("statistictype", "Issue Type");
        this.submit("Save");
    }

    public void createProjectCategory(String categoryName, String categoryDescription) {
        this.gotoProjectCategories();
        this.setFormElement("name", categoryName);
        this.setFormElement("description", categoryDescription);
        this.submit("Add");
    }

    public void deleteProjectCategory(String categoryName) {
        this.gotoProjectCategories();
        this.clickLink("del_" + categoryName);
        this.submit("Delete");
    }

    public void gotoProjectCategories() {
        this.gotoPage("/secure/admin/projectcategories/ViewProjectCategories!default.jspa");
        this.getNavigation().checkWebSudoWithLastPassword();
    }

    public void placeProjectInCategory(String projectName, String categoryName) {
        this.goToProject(projectName);
        this.clickLink("select_category");
        this.selectOption("pcid", categoryName);
        this.submit("Select");
    }

    public boolean projectCategoryExists(String categoryName) {
        this.gotoProjectCategories();
        try {
            this.assertTextPresent(categoryName);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public void gotoProjectBrowse(String key) {
        this.gotoPage("browse/" + key);
    }

    public void gotoVersionBrowse(String projectKey, String versionName) {
        this.gotoProjectBrowse(projectKey + "?selectedTab=com.atlassian.jira.plugin.system.project:versions-panel");
        this.clickLinkWithText(versionName);
        if (this.getDialog().isLinkPresentWithText("Select:")) {
            this.clickLinkWithText("Select:");
        }
    }

    public void gotoComponentBrowse(String projectKey, String componentName) {
        this.gotoProjectBrowse(projectKey + "?selectedTab=com.atlassian.jira.plugin.system.project:components-panel");
        this.clickLinkWithText(componentName);
        if (this.getDialog().isLinkPresentWithText("Select:")) {
            this.clickLinkWithText("Select:");
        }
    }

    public void gotoIssueTabPanel(String issueKey, String issueTabName) {
        if ("All".equals(issueTabName)) {
            this.gotoPage("browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:all-tabpanel");
        } else if ("Comments".equals(issueTabName)) {
            this.gotoPage("browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel");
        } else if ("Work Log".equals(issueTabName)) {
            this.gotoPage("browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:worklog-tabpanel");
        } else if ("History".equals(issueTabName)) {
            this.gotoPage("browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:changehistory-tabpanel");
        } else {
            JIRAWebTest.fail((String)"Invalid issue tab panel specified");
        }
    }

    public void gotoProjectTabPanel(String projectKey, String projectTabName) {
        if ("Open Issues".equals(projectTabName)) {
            this.gotoPage("browse/" + projectKey + "?selectedTab=com.atlassian.jira.plugin.system.project:openissues-panel");
        } else if ("Road Map".equals(projectTabName)) {
            this.gotoPage("browse/" + projectKey + "?selectedTab=com.atlassian.jira.plugin.system.project:roadmap-panel");
        } else if ("Change Log".equals(projectTabName)) {
            this.gotoPage("browse/" + projectKey + "?selectedTab=com.atlassian.jira.plugin.system.project:changelog-panel");
        } else if ("Popular Issues".equals(projectTabName)) {
            this.gotoPage("browse/" + projectKey + "?selectedTab=com.atlassian.jira.plugin.system.project:popularissues-panel");
        } else if ("Versions".equals(projectTabName)) {
            this.gotoPage("browse/" + projectKey + "?selectedTab=com.atlassian.jira.plugin.system.project:versions-panel");
        } else if ("Components".equals(projectTabName)) {
            this.gotoPage("browse/" + projectKey + "?selectedTab=com.atlassian.jira.plugin.system.project:components-panel");
        } else {
            JIRAWebTest.fail((String)"Invalid project tab panel specified");
        }
        this.assertTextPresentBeforeText(projectTabName, projectTabName);
    }

    public void setFieldConfigurationFieldToRenderer(String configuration, String fieldId, String renderer) {
        this.setFieldConfigurationFieldToRenderer(configuration, fieldId, renderer, false);
    }

    public void setFieldConfigurationFieldToRenderer(String configuration, String fieldId, String renderer, boolean assertWarningNotPresent) {
        this.gotoFieldLayoutConfiguration(configuration);
        this.clickLink("renderer_" + fieldId);
        this.assertTextPresent("Edit Field Renderer");
        this.selectOption("selectedRendererType", renderer);
        if (assertWarningNotPresent) {
            this.assertTextNotPresent("Changing the renderer will effect the display of all ");
        }
        this.submit("Update");
        this.assertTextPresent("Edit Field Renderer Confirmation");
        this.assertTextPresent(renderer);
        this.submit("Update");
        JIRAWebTest.log("Set " + fieldId + " to renderer type " + renderer + " in the " + configuration + " configuration.");
    }

    public void gotoFieldLayoutConfiguration(String configuration) {
        this.gotoFieldLayouts();
        this.clickLink("configure-" + configuration);
        this.assertTextPresent(configuration);
    }

    public void gotoPluginsScreen() {
        this.clickOnAdminPanel("admin.system_body", "plugins");
        this.assertTextPresent("Current Plugins");
    }

    public void gotoFieldLayouts() {
        this.gotoPage(PAGE_ENTERPRISE_FIELD_CONFIGURATIONS);
        this.getNavigation().checkWebSudoWithLastPassword();
        this.assertTextPresent("View Field Configurations");
    }

    public void addEventType(String name, String description, String template) {
        this.gotoAdmin();
        this.clickLink("eventtypes");
        this.setFormElement("name", name);
        this.setFormElement("description", description);
        this.selectOption("templateId", template);
        this.submit("Add");
        this.checkEventTypeDetails(name, description, "Inactive", template, null, null);
        try {
            WebTable fieldTable = this.getDialog().getResponse().getTableWithID("eventTypeTable");
            String eventTypeCellText = fieldTable.getCellAsText(fieldTable.getRowCount() - 1, 0);
            JIRAWebTest.assertTrue((eventTypeCellText.indexOf(name) != -1 ? 1 : 0) != 0);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void deleteEventType(String name) {
        this.gotoAdmin();
        this.clickLink("eventtypes");
        this.clickLink("del_" + name);
        this.assertTextPresent("Please confirm that you wish to delete the event: <b>" + name + "</b>.");
        this.submit("Delete");
        this.assertTextNotPresent(name);
    }

    public String getEventTypeIDWithName(String name) {
        this.gotoAdmin();
        this.clickLink("eventtypes");
        this.clickLink("edit_" + name);
        return this.getDialog().getFormParameterValue("eventTypeId");
    }

    public void checkEventTypeDetails(String eventTypeName, String eventTypeDesc, String status, String template, String notificationScheme, String workflow) {
        this.gotoAdmin();
        this.clickLink("eventtypes");
        try {
            WebTable fieldTable = this.getDialog().getResponse().getTableWithID("eventTypeTable");
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                String field = fieldTable.getCellAsText(i, 0);
                if (field.indexOf(eventTypeName) <= -1) continue;
                int EVENT_TYPE_TABLE_DESC_COL = 1;
                String eventTypeCellText = fieldTable.getCellAsText(i, EVENT_TYPE_TABLE_DESC_COL);
                JIRAWebTest.assertTrue((eventTypeCellText.indexOf(eventTypeDesc) != -1 ? 1 : 0) != 0);
                int EVENT_TYPE_TABLE_STATUS_COL = 2;
                eventTypeCellText = fieldTable.getCellAsText(i, EVENT_TYPE_TABLE_STATUS_COL);
                JIRAWebTest.assertTrue((eventTypeCellText.indexOf(status) != -1 ? 1 : 0) != 0);
                int EVENT_TYPE_TABLE_TEMPLATE_COL = 3;
                eventTypeCellText = fieldTable.getCellAsText(i, EVENT_TYPE_TABLE_TEMPLATE_COL);
                JIRAWebTest.assertTrue((eventTypeCellText.indexOf(template) != -1 ? 1 : 0) != 0);
                if (notificationScheme != null && !notificationScheme.equals("")) {
                    int EVENT_TYPE_TABLE_NOTIFIC_COL = 4;
                    eventTypeCellText = fieldTable.getCellAsText(i, EVENT_TYPE_TABLE_NOTIFIC_COL);
                    JIRAWebTest.assertTrue((eventTypeCellText.indexOf(notificationScheme) != -1 ? 1 : 0) != 0);
                }
                if (workflow == null || workflow.equals("")) continue;
                int EVENT_TYPE_TABLE_WORKFLOW_COL = 5;
                eventTypeCellText = fieldTable.getCellAsText(i, EVENT_TYPE_TABLE_WORKFLOW_COL);
                JIRAWebTest.assertTrue((eventTypeCellText.indexOf(workflow) != -1 ? 1 : 0) != 0);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void checkNotificationForEvent(String eventTypeName, String notificationType, String template) {
        this.gotoAdmin();
        this.clickLink("notification_schemes");
        this.clickLinkWithText("Default Notification Scheme");
        try {
            String NOTIFICATION_SCHEME_TABLE = "notificationSchemeTable";
            WebTable fieldTable = this.getDialog().getResponse().getTableWithID("notificationSchemeTable");
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                int NOTIFICATION_TABLE_NAME_COL = 0;
                String field = fieldTable.getCellAsText(i, NOTIFICATION_TABLE_NAME_COL);
                if (field.indexOf(eventTypeName) <= -1) continue;
                int NOTIFICATION_TABLE_TYPE_COL = 1;
                TableCell notificationCell = fieldTable.getTableCell(i, NOTIFICATION_TABLE_TYPE_COL);
                if (notificationType == null) {
                    JIRAWebTest.assertTrue((notificationCell.asText().indexOf(notificationType) == -1 ? 1 : 0) != 0);
                    continue;
                }
                JIRAWebTest.assertTrue((notificationCell.asText().indexOf(notificationType) != -1 ? 1 : 0) != 0);
            }
            this.gotoAdmin();
            this.clickLink("eventtypes");
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void disableIssueLinks() {
        this.clickOnAdminPanel("admin.globalsettings", "linking");
        this.assertTextPresent("Issue Linking");
        this.assertTextPresent("ON");
        this.submit("Deactivate");
        this.assertTextPresent("OFF");
    }

    public void createClonersLinkType() {
        this.clickOnAdminPanel("admin.globalsettings", "linking");
        this.assertTextPresent("Issue Linking");
        this.assertTextPresent("ON");
        this.setFormElement("name", "Cloners");
        this.setFormElement("outward", "Cloners Outward");
        this.setFormElement("inward", "Cloners Inward");
        this.submit("Add");
    }

    public void setBulkEditFieldTo(String field, String listValue) {
        JIRAWebTest.log("Set " + field + " To: \"" + listValue + "\"");
        this.checkCheckbox("actions", field);
        this.selectOption(field, listValue);
        this.assertOptionEquals(field, listValue);
    }

    public void bulkEditOperationDetailsSetAs(Map fields) {
        this.isStepOperationDetails();
        this.assertFormElementEquals("actions", null);
        for (String fieldName : fields.keySet()) {
            if ("fixVersions".equals(fieldName)) {
                this.setBulkEditFieldTo("fixVersions", (String)fields.get(fieldName));
            }
            if ("versions".equals(fieldName)) {
                this.setBulkEditFieldTo("versions", (String)fields.get(fieldName));
            }
            if ("components".equals(fieldName)) {
                this.setBulkEditFieldTo("components", (String)fields.get(fieldName));
            }
            if ("assignee".equals(fieldName)) {
                this.setBulkEditFieldTo("assignee", (String)fields.get(fieldName));
            }
            if (!"priority".equals(fieldName)) continue;
            this.setBulkEditFieldTo("priority", (String)fields.get(fieldName));
        }
        this.clickOnNext();
    }

    public void bulkEditConfirmEdit(Map fields) {
        this.isStepConfirmation();
        for (String fieldName : fields.keySet()) {
            if ("fixVersions".equals(fieldName)) {
                this.assertTextPresent("<b>Fix Version/s</b>");
                this.assertTextPresent((String)fields.get(fieldName));
            }
            if ("versions".equals(fieldName)) {
                this.assertTextPresent("<b>Affects Version/s</b>");
                this.assertTextPresent((String)fields.get(fieldName));
            }
            if ("components".equals(fieldName)) {
                this.assertTextPresent("<b>Component/s</b>");
                this.assertTextPresent((String)fields.get(fieldName));
            }
            if ("assignee".equals(fieldName)) {
                this.assertTextPresent("<b>Assignee</b>");
                this.assertTextPresent((String)fields.get(fieldName));
            }
            if (!"priority".equals(fieldName)) continue;
            this.assertTextPresent("<b>Priority</b>");
            this.assertTextPresent((String)fields.get(fieldName));
        }
    }

    public void bulkChangeSelectIssue(String key) {
        this.isStepChooseIssues();
        this.bulkOperationCheckIssues(Arrays.asList(key));
        this.clickOnNext();
    }

    public void bulkChangeSelectIssues(Collection keys) {
        this.isStepChooseIssues();
        this.bulkOperationCheckIssues(keys);
        this.clickOnNext();
    }

    private void bulkOperationCheckIssues(Collection keys) {
        try {
            int checkBoxColumn = 0;
            WebTable table = this.getDialog().getResponse().getTableWithID("issuetable");
            int keyColumn = -1;
            for (int i = 0; i < table.getColumnCount(); ++i) {
                String headerCell = table.getCellAsText(0, i);
                if (!headerCell.trim().equals("Key")) continue;
                keyColumn = i;
            }
            if (keyColumn < 0) {
                JIRAWebTest.fail((String)"Could not find column for Key");
            }
            int checkBoxesChecked = 0;
            for (int i = 0; i < table.getRowCount(); ++i) {
                String key = table.getCellAsText(i, keyColumn);
                if (!keys.contains(key.trim())) continue;
                TableCell checkBoxCell = table.getTableCell(i, checkBoxColumn);
                String[] elementNames = checkBoxCell.getElementNames();
                boolean foundCheckbox = false;
                for (int j = 0; j < elementNames.length; ++j) {
                    String elementName = elementNames[j];
                    if (!elementName.startsWith("bulkedit_")) continue;
                    this.checkCheckbox(elementName);
                    if (++checkBoxesChecked >= keys.size()) {
                        return;
                    }
                    foundCheckbox = true;
                    break;
                }
                if (foundCheckbox) continue;
                JIRAWebTest.fail((String)("Could not find the check box for issue with key '" + key + "'."));
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
            JIRAWebTest.fail((String)"Error occurred selecting issues.");
        }
    }

    public String createIssueLinkType(String name, String outwardLinkName, String inwardLinkName) {
        String linkTypeId;
        this.activateIssueLinking();
        this.setFormElement("name", name);
        this.setFormElement("outward", outwardLinkName);
        this.setFormElement("inward", inwardLinkName);
        this.submit();
        try {
            String text = this.getDialog().getResponse().getText();
            int linkIdLocation = text.indexOf("del_" + name);
            int endOfLinkIdLocation = text.indexOf(">Del", linkIdLocation);
            String deleteLinkLocation = text.substring(linkIdLocation, endOfLinkIdLocation);
            linkIdLocation = deleteLinkLocation.indexOf("id=");
            endOfLinkIdLocation = deleteLinkLocation.indexOf("\"", linkIdLocation);
            linkTypeId = deleteLinkLocation.substring(linkIdLocation + "id=".length(), endOfLinkIdLocation);
        }
        catch (Exception e) {
            JIRAWebTest.fail((String)("Unable to retrieve Link Id for link type " + name + " : " + e.getMessage()));
            return "fail";
        }
        return linkTypeId;
    }

    public void linkIssueWithComment(String currentIssueKey, String link, String destinationIssueKey, String comment, String commentLevel) {
        JIRAWebTest.log("Link Issue: test linking an issue");
        this.activateIssueLinking();
        StringBuilder url = new StringBuilder().append("/secure/LinkExistingIssue.jspa?atl_token=").append(this.getPage().getXsrfToken()).append("&id=").append(this.getIssueIdWithIssueKey(currentIssueKey)).append("&linkDesc=").append(link).append("&currentIssueKey=").append(currentIssueKey).append("&linkKey=").append(destinationIssueKey);
        if (comment != null) {
            url.append("&comment=").append(comment).append("&commentLevel=").append(commentLevel);
        }
        this.gotoPage(url.toString());
        this.assertTextPresent(destinationIssueKey);
    }

    public boolean isMailServerExists() {
        this.gotoAdmin();
        this.clickLink("mail_servers");
        try {
            this.assertTextPresent("You do not currently have an SMTP server configured. No outgoing mail will be sent.");
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public String getRegexMatch(String regex) throws MalformedPatternException {
        Perl5Compiler compiler;
        Pattern pattern;
        Perl5Matcher matcher = new Perl5Matcher();
        String html = this.getDialog().getResponseText();
        if (!matcher.contains(html, pattern = (compiler = new Perl5Compiler()).compile(regex, 40))) {
            return null;
        }
        MatchResult mr = matcher.getMatch();
        return mr.group(1);
    }

    public void assertRegexMatch(String regex, boolean multiline) {
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        int flags = 32;
        if (multiline) {
            flags |= 8;
            JIRAWebTest.log("Asserting regular expression \"" + regex + "\" matches the page.");
        } else {
            JIRAWebTest.log("Asserting regular expression \"" + regex + "\" matches line on the page.");
        }
        try {
            pattern = compiler.compile(regex, flags);
        }
        catch (MalformedPatternException e) {
            JIRAWebTest.fail((String)("Regular expression '" + regex + "' is not valid: " + e.getMessage()));
        }
        String html = this.getDialog().getResponseText();
        Perl5Matcher matcher = new Perl5Matcher();
        if (matcher.contains(html, pattern)) {
            JIRAWebTest.fail((String)("Regular expression '" + regex + "' did not match page."));
        }
    }

    public void gotoProjectRolesScreen() {
        this.gotoAdmin();
        this.clickLink("project_role_browser");
    }

    public void editIssueType(String issueTypeId, String name, String description, String iconUrl) {
        this.gotoPage("/secure/admin/EditIssueType!default.jspa?id=" + issueTypeId);
        this.getNavigation().checkWebSudoWithLastPassword();
        this.setFormElement("name", name);
        this.setFormElement("description", description);
        this.setFormElement("iconurl", iconUrl);
        this.submit("Update");
    }

    public String addIssueType(String name, String desc, String iconUrl) {
        this.gotoAdmin();
        this.clickLink("issue_types");
        this.setFormElement("name", name);
        this.setFormElement("description", desc);
        this.setFormElement("iconurl", iconUrl);
        this.submit("Add");
        this.assertTextPresent(name);
        this.assertTextPresent(desc);
        this.assertTextPresent(iconUrl);
        String response = this.getDialog().getResponseText();
        String editlinkBase = "EditIssueType!default.jspa?id=";
        int lastEditLinkIndex = response.lastIndexOf(editlinkBase);
        JIRAWebTest.assertTrue((lastEditLinkIndex > -1 ? 1 : 0) != 0);
        int endOfIdIndex = response.indexOf("\"", lastEditLinkIndex + 1);
        JIRAWebTest.assertTrue((endOfIdIndex > -1 ? 1 : 0) != 0);
        return response.substring(lastEditLinkIndex + editlinkBase.length(), endOfIdIndex);
    }

    public final void associateWorkFlowSchemeToProject(String project, String workflow_scheme, Map statusMapping) {
        this.goToProject(project);
        this.clickLink("select_workflow_scheme");
        this.assertLinkNotPresentWithText("Add");
        this.assertTextNotPresent("There are currently no workflow schemes setup.");
        this.selectOption("schemeId", workflow_scheme);
        this.submit("Associate");
        this.assertTextPresent("Step 2 of 3");
        this.assertTextPresent("Migrate statuses from the old workflow scheme to the new one.");
        for (Map.Entry entry : statusMapping.entrySet()) {
            this.selectOption((String)entry.getKey(), (String)entry.getValue());
        }
        this.submit("Associate");
    }

    protected void enableCommentGroupVisibility(Boolean enable) {
        this.clickLink("admin_link");
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        this.setFormElement("title", "jWebTest JIRA installation");
        this.checkCheckbox("groupVisibility", enable.toString());
        this.submit("Update");
        if (enable.booleanValue()) {
            this.assertTextPresent("Groups &amp; Project Roles");
            this.assertTextNotPresent("Project Roles only");
        } else {
            this.assertTextNotPresent("Groups &amp; Project Roles");
            this.assertTextPresent("Project Roles only");
        }
    }

    @Deprecated
    protected void addCommentOnCurrentIssue(String comment) {
        this.addCommentOnCurrentIssue(comment, null);
    }

    @Deprecated
    protected void addCommentOnCurrentIssue(String comment, String roleLevel) {
        this.clickLink("comment-issue");
        this.setFormElement("comment", comment);
        if (roleLevel != null) {
            this.selectOption("commentLevel", roleLevel);
        }
        this.submit();
    }

    public String getTitle(String responseHtml) {
        return this.getTagBody("<title>", "</title>", responseHtml);
    }

    public String getTagBody(String startTag, String endTag, String html) {
        int start = html.indexOf(startTag) + startTag.length();
        int end = html.indexOf(endTag, start);
        return html.substring(start, end);
    }

    protected boolean tableCellHasText(WebTable table, int row, int col, String text) {
        boolean result;
        JIRAWebTest.log("Checking cell on row [" + row + "] col [" + col + "] for text [" + text + "]");
        String cellContent = table.getCellAsText(row, col);
        boolean bl = result = cellContent.indexOf(text) != -1;
        if (!result) {
            JIRAWebTest.log("Expected '" + text + "' but was not found in '" + cellContent + "'");
        }
        return result;
    }

    protected boolean tableCellDoesNotHaveText(WebTable table, int row, int col, String text) {
        boolean result;
        JIRAWebTest.log("Checking cell on row [" + row + "] col [" + col + "] for text [" + text + "]");
        String cellContent = table.getCellAsText(row, col);
        boolean bl = result = cellContent.indexOf(text) == -1;
        if (!result) {
            JIRAWebTest.log("Didn't expect '" + text + "' but was found in '" + cellContent + "'");
        }
        return result;
    }

    protected boolean tableCellHasStrictText(WebTable table, int row, int col, String text) {
        boolean result;
        String cellContent = table.getCellAsText(row, col);
        if ("".equals(text)) {
            result = "".equals(cellContent.trim());
        } else {
            boolean bl = result = cellContent.indexOf(text) != -1;
        }
        if (!result) {
            // empty if block
        }
        return result;
    }

    protected boolean tableCellHasLinkThatContains(WebTable table, int row, int col, String link) {
        if (link == null) {
            return this.tableCellHasNoLinks(table, row, col);
        }
        JIRAWebTest.log("Checking cell on row [" + row + "] col [" + col + "] for link [" + link + "]");
        TableCell tableCell = table.getTableCell(row, col);
        WebLink[] links = tableCell.getLinks();
        if (links != null) {
            for (int i = 0; i < links.length; ++i) {
                WebLink webLink = links[i];
                String urlString = webLink.getURLString();
                if (urlString == null || urlString.indexOf(link) < 0) continue;
                return true;
            }
        }
        JIRAWebTest.log("Expected '" + link + "' but was not found in '" + table.getCellAsText(row, col) + "'");
        return false;
    }

    protected void assertTableCellHasImage(WebTable table, int row, int col, String stringInImageSource) {
        JIRAWebTest.assertTrue((String)"Expected image not found. Please see logs for details.", (boolean)new ImageCell(stringInImageSource).equals(table, row, col));
    }

    protected void assertTableCellHasNoImage(WebTable table, int row, int col) {
        WebImage[] webImages = table.getTableCell(row, col).getImages();
        if (webImages != null && webImages.length > 0) {
            JIRAWebTest.fail((String)("An image was found in a cell where it wasn't expected. First image = '" + webImages[0].getSource() + "'."));
        }
    }

    protected boolean tableCellHasNoLinks(WebTable table, int row, int col) {
        boolean result;
        JIRAWebTest.log("Checking cell on row [" + row + "] col [" + col + "] for no links");
        TableCell tableCell = table.getTableCell(row, col);
        WebLink[] links = tableCell.getLinks();
        boolean bl = result = links == null || links.length == 0;
        if (!result) {
            JIRAWebTest.log("Links were not expected but were found in '" + table.getTableCell(row, col).asText() + "'");
        }
        return result;
    }

    private boolean tableRowEquals(WebTable table, int row, Object[] expectedRow) {
        return this.tableRowEquals(table, row, Arrays.asList(expectedRow));
    }

    private boolean tableRowEquals(WebTable table, int row, List expectedRow) {
        if (expectedRow.isEmpty()) {
            JIRAWebTest.log("expected row is empty");
            return false;
        }
        int maxCol = table.getColumnCount();
        for (int col = 0; col < expectedRow.size() && col < maxCol; ++col) {
            Object expectedCell = expectedRow.get(col);
            if (expectedCell == null) continue;
            if (expectedCell instanceof SimpleCell) {
                SimpleCell simpleCell = (SimpleCell)expectedCell;
                if (simpleCell.equals(table, row, col)) continue;
                String cellContent = simpleCell.getCellAsText(table, row, col);
                JIRAWebTest.log("table '" + table.getID() + "' row '" + row + "' does not match expected row because cell [" + row + ", " + col + "] = [" + cellContent + "] does not match [" + expectedCell.toString() + "]");
                return false;
            }
            if (this.tableCellHasStrictText(table, row, col, expectedCell.toString())) continue;
            String cellContent = table.getCellAsText(row, col).trim();
            JIRAWebTest.log("table '" + table.getID() + "' row '" + row + "' does not match expected row because cell [" + row + ", " + col + "] = [" + cellContent + "] does not match [" + expectedCell.toString() + "]");
            return false;
        }
        return true;
    }

    public void assertTableRowEquals(WebTable table, int row, Object[] expectedRow) {
        JIRAWebTest.assertTrue((String)("Expected row '" + this.prettyParseRow(expectedRow) + "' does not match '" + this.getTableRowAsList(table, row) + "' (row '" + row + "' of table '" + table.getID() + "')"), (boolean)this.tableRowEquals(table, row, expectedRow));
    }

    public List getTableRowAsList(WebTable table, int row) {
        ArrayList<String> tableRow = new ArrayList<String>();
        int maxCol = table.getColumnCount();
        for (int col = 0; col < maxCol; ++col) {
            tableRow.add(table.getCellAsText(row, col).trim());
        }
        return tableRow;
    }

    public void assertTableHasNoMatchingRow(WebTable table, Object[] expectedRow) {
        JIRAWebTest.assertTrue((String)("Found a row matching: '" + this.prettyParseRow(expectedRow) + "' on table '" + table.getID() + "' when unexpected"), (this.tableIndexOf(table, Arrays.asList(expectedRow)) == -1 ? 1 : 0) != 0);
    }

    public void assertTableHasNoMatchingRow(WebTable table, int minRow, Object[] expectedRow) {
        this.assertTableHasNoMatchingRowFromTo(table, minRow, table.getRowCount(), expectedRow);
    }

    public void assertTableHasNoMatchingRowFromTo(WebTable table, int minRow, int maxRow, Object[] expectedRow) {
        int rowIndex;
        if (minRow > maxRow) {
            int temp = maxRow;
            maxRow = minRow;
            minRow = temp;
        }
        if ((rowIndex = this.tableIndexOf(table, Arrays.asList(expectedRow))) != -1) {
            if (rowIndex < minRow || rowIndex >= maxRow) {
                return;
            }
            JIRAWebTest.fail((String)("Found a row matching: '" + this.prettyParseRow(expectedRow) + "' on table '" + table.getID() + "' between min index [" + minRow + "] and max index [" + maxRow + "] when unexpected"));
        }
    }

    public void assertTableHasOnlyNMatchingRows(WebTable table, int n, Object[] expectedRow) {
        if (n > 0) {
            int lastMatchingRow = 0;
            List<Object> rowList = Arrays.asList(expectedRow);
            for (int c = 0; c < n; ++c) {
                lastMatchingRow = this.tableIndexOf(table, lastMatchingRow, rowList);
                JIRAWebTest.assertTrue((String)("Found '" + c + "' of '" + n + "' rows of '" + rowList + "' on table '" + table.getID() + "'"), (lastMatchingRow != -1 ? 1 : 0) != 0);
                ++lastMatchingRow;
            }
            JIRAWebTest.assertTrue((String)("Found more than '" + n + "' rows of '" + rowList + "' on table '" + table.getID() + "'"), (this.tableIndexOf(table, lastMatchingRow, rowList) == -1 ? 1 : 0) != 0);
        } else {
            this.assertTableHasNoMatchingRow(table, expectedRow);
        }
    }

    public void assertTableHasMatchingRow(WebTable table, Object[] expectedRow) {
        JIRAWebTest.assertTrue((String)("Did not find a row matching: '" + this.prettyParseRow(expectedRow) + "' on table '" + table.getID() + "'"), (this.tableIndexOf(table, Arrays.asList(expectedRow)) != -1 ? 1 : 0) != 0);
    }

    public void assertTableHasMatchingRowFrom(WebTable table, int minRow, Object[] expectedRow) {
        JIRAWebTest.log("Asserting table '" + table.getID() + "' has a row from '" + minRow + "' that matches '" + this.prettyParseRow(expectedRow) + "'");
        String message = "Did not find a row matching: '" + this.prettyParseRow(expectedRow) + "' on table '" + table.getID() + "' from row '" + minRow + "'";
        JIRAWebTest.assertTrue((String)message, (this.tableIndexOf(table, minRow, table.getRowCount(), Arrays.asList(expectedRow)) != -1 ? 1 : 0) != 0);
    }

    public void assertTableHasMatchingRowFromTo(WebTable table, int minRow, int maxRow, Object[] expectedRow) {
        JIRAWebTest.log("Asserting table '" + table.getID() + "' has a row from '" + minRow + "' to '" + maxRow + "' that matches '" + this.prettyParseRow(expectedRow) + "'");
        String message = "Did not find a row matching: '" + this.prettyParseRow(expectedRow) + "' on table '" + table.getID() + "' from row '" + minRow + "' to '" + maxRow + "'";
        int index = this.tableIndexOf(table, minRow, maxRow, Arrays.asList(expectedRow));
        JIRAWebTest.assertTrue((String)message, (index != -1 ? 1 : 0) != 0);
    }

    public String prettyParseRow(Object[] expectedRow) {
        return this.prettyParseRow(Arrays.asList(expectedRow));
    }

    public String prettyParseRow(List expectedRow) {
        StringBuffer sb = new StringBuffer("\n");
        int col = 0;
        for (Object o : expectedRow) {
            sb.append("  Column '").append(col).append("' = ").append(o).append("\n");
            ++col;
        }
        return sb.toString();
    }

    public int tableIndexOf(WebTable table, Object[] expectedRow) {
        return this.tableIndexOf(table, Arrays.asList(expectedRow));
    }

    public int tableIndexOf(WebTable table, int minRow, Object[] expectedRow) {
        return this.tableIndexOf(table, minRow, Arrays.asList(expectedRow));
    }

    public int tableIndexOf(WebTable table, List expectedRow) {
        return this.tableIndexOf(table, 0, table.getRowCount(), expectedRow);
    }

    public int tableIndexOf(WebTable table, int minRow, List expectedRow) {
        return this.tableIndexOf(table, minRow, table.getRowCount(), expectedRow);
    }

    public int tableIndexOf(WebTable table, int minRow, int maxRow, List expectedRow) {
        JIRAWebTest.log("Scanning table '" + table.getID() + "' from row '" + minRow + "' (inclusive) to row '" + maxRow + "' (exclusive) for '" + expectedRow + "'");
        if (minRow < 0) {
            return -1;
        }
        int lastRow = table.getRowCount() < maxRow ? table.getRowCount() : maxRow;
        for (int row = minRow; row < lastRow; ++row) {
            if (!this.tableRowEquals(table, row, expectedRow)) continue;
            JIRAWebTest.log("Found expected row on row '" + row + "' of table '" + table.getID() + "'");
            return row;
        }
        return -1;
    }

    public boolean tableHasSubTable(WebTable table, Object[][] expectedSubTable) {
        int maxRow = table.getRowCount();
        for (int row = 0; row < maxRow; ++row) {
            if (!this.tableRowEquals(table, row, expectedSubTable[0])) continue;
            boolean isSubTable = true;
            for (int subRow = 1; subRow < maxRow && subRow < expectedSubTable.length && isSubTable; ++subRow) {
                if (this.tableRowEquals(table, row + subRow, expectedSubTable[subRow])) continue;
                isSubTable = false;
            }
            if (!isSubTable) continue;
            return true;
        }
        return false;
    }

    public void assertTableHasSubTable(WebTable table, Object[][] expectedSubTable) {
        StringBuffer sb = new StringBuffer("Table:");
        sb.append(table.getID());
        sb.append(": does not contain expected subTable : \n");
        for (int i = 0; i < expectedSubTable.length; ++i) {
            Object[] arr = expectedSubTable[i];
            if (arr == null || !arr.getClass().isArray()) continue;
            sb.append("[");
            sb.append(i);
            sb.append("] ");
            Object[] innerArr = arr;
            for (int j = 0; j < innerArr.length; ++j) {
                Object o = innerArr[j];
                sb.append("'");
                sb.append(String.valueOf(o));
                sb.append("'");
                sb.append(",");
            }
            sb.append("\n");
        }
        JIRAWebTest.assertTrue((String)sb.toString(), (boolean)this.tableHasSubTable(table, expectedSubTable));
    }

    public void assertTextListPresent(Iterable<String> iterable) {
        if (iterable != null) {
            for (String text : iterable) {
                this.assertTextPresent(text);
            }
        }
    }

    public void assertTextListNotPresent(Iterable<String> iterable) {
        if (iterable != null) {
            for (String text : iterable) {
                this.assertTextNotPresent(text);
            }
        }
    }

    @Deprecated
    public void checkCommentVisibility(String usernameAndPassword, String issueKey, Iterable<String> expectedPresentComments, Iterable<String> expectedAbsentComments) {
        this.logout();
        this.login(usernameAndPassword, usernameAndPassword);
        this.gotoIssue(issueKey);
        this.assertTextListPresent(expectedPresentComments);
        this.assertTextListNotPresent(expectedAbsentComments);
        this.login("admin", "admin");
    }

    public void toggleExternalUserManagement(boolean enable) {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        if (enable) {
            this.checkCheckbox("externalUM", "true");
            this.tester.selectOption("mode", "Private");
        } else {
            this.checkCheckbox("externalUM", "false");
        }
        this.submit("Update");
    }

    protected void assertSubTaskConversionPanelSteps(String key, int currentStep) {
        this.assertTextSequence(new String[]{"Convert Issue to Sub-task: " + key, "1.", "Select Parent and Sub-task Type", "2.", "Select New Status", "3.", "Update Fields", "4.", "Confirmation"});
        String[] icons = new String[4];
        for (int i = 1; i <= 4; ++i) {
            if (i == currentStep) {
                this.assertTextPresent("<strong>" + i + ".</strong>");
            } else {
                this.assertTextNotPresent("<strong>" + i + ".</strong>");
            }
            icons[i - 1] = i < currentStep ? "bullet_done.gif" : (i > currentStep ? "bullet_notdone.gif" : "bullet_inprogress.gif");
        }
        this.assertTextSequence(icons);
        if (currentStep == 1) {
            this.assertTextNotPresent("<strong>Note:</strong> Select a link above to return to a previous step.");
        } else {
            this.assertTextPresent("<strong>Note:</strong> Select a link above to return to a previous step.");
        }
    }

    protected void assertSubTaskConversionPanelStepsProfessional(String key, int currentStep) {
        this.assertTextSequence(new String[]{"Convert Issue to Sub-task: " + key, "1.", "Select Parent and Sub-task Type", "2.", "Update Fields", "3.", "Confirmation"});
        String[] icons = new String[3];
        for (int i = 1; i <= 3; ++i) {
            if (i == currentStep) {
                this.assertTextPresent("<strong>" + i + ".</strong>");
            } else {
                this.assertTextNotPresent("<strong>" + i + ".</strong>");
            }
            icons[i - 1] = i < currentStep ? "bullet_done.gif" : (i > currentStep ? "bullet_notdone.gif" : "bullet_inprogress.gif");
        }
        this.assertTextSequence(icons);
        if (currentStep == 1) {
            this.assertTextNotPresent("<strong>Note:</strong> Select a link above to return to a previous step.");
        } else {
            this.assertTextPresent("<strong>Note:</strong> Select a link above to return to a previous step.");
        }
    }

    protected void assertIssueIsSubtask(String issueName, String issueKey, String parentName, String parentKey, String issueType) {
        this.assertTextPresent(issueName);
        this.assertTextPresent(issueKey);
        this.assertTextPresentBeforeText(parentName, parentKey);
        this.assertTextPresentBeforeText("Type", issueType);
    }

    public void gotoConvertIssue(String issueId) {
        this.gotoPage("/secure/ConvertIssue.jspa?id=" + issueId);
    }

    public void gotoConvertIssueStep2(String issueId, String parent, String issueType) {
        this.gotoPage("/secure/ConvertIssueSetIssueType.jspa?id=" + issueId + "&parentIssueKey=" + parent + "&issuetype=" + issueType);
    }

    public void gotoConvertSubTask(String issueId) {
        this.gotoPage("/secure/ConvertSubTask.jspa?id=" + issueId);
    }

    public void gotoConvertSubTaskStep2(String issueId, String issueType) {
        this.gotoPage("/secure/ConvertSubTaskSetIssueType.jspa?id=" + issueId + "&issuetype=" + issueType);
    }

    protected void gotoConvertIssueStep3(String issueId, String parentKey, String issueType, String status) {
        this.gotoPage("/secure/ConvertIssueSetStatus.jspa?id=" + issueId + "&parentIssueKey=" + parentKey + "&issuetype=" + issueType + "&targetStatusId=" + status);
    }

    public void assertLinkPresentWithSubString(String linkId, String urlSubString) {
        try {
            WebLink link = this.getDialog().getResponse().getLinkWithID(linkId);
            JIRAWebTest.assertNotNull((Object)link);
            if (StringUtils.isEmpty((String)link.getURLString())) {
                JIRAWebTest.fail((String)("No URL for link with id [" + linkId + "]"));
            }
            boolean foundSubString = link.getURLString().indexOf(urlSubString) != -1;
            JIRAWebTest.assertTrue((String)(link.getURLString() + " does not have substring " + urlSubString), (boolean)foundSubString);
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)("Error locating weblink with id [" + linkId + "]"));
        }
    }

    public void assertLinkPresentWithoutSubString(String linkId, String urlSubString) {
        try {
            WebLink link = this.getDialog().getResponse().getLinkWithID(linkId);
            JIRAWebTest.assertNotNull((Object)link);
            if (StringUtils.isEmpty((String)link.getURLString())) {
                JIRAWebTest.fail((String)("No URL for link with id [" + linkId + "]"));
            }
            boolean substringNotFound = link.getURLString().indexOf(urlSubString) == -1;
            JIRAWebTest.assertTrue((String)(link.getURLString() + " does not have substring " + urlSubString), (boolean)substringNotFound);
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)("Error locating weblink with id [" + linkId + "]"));
        }
    }

    public void assertLinkPresentWithURL(String linkId, String urlSuffix) {
        try {
            WebLink link = this.getDialog().getResponse().getLinkWithID(linkId);
            JIRAWebTest.assertNotNull((Object)link);
            if (StringUtils.isEmpty((String)link.getURLString())) {
                JIRAWebTest.fail((String)("No URL for link with id [" + linkId + "]"));
            }
            boolean foundSuffix = link.getURLString().endsWith(urlSuffix);
            JIRAWebTest.assertTrue((String)(link.getURLString() + " does not have suffix " + urlSuffix), (boolean)foundSuffix);
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)("Error locating weblink with id [" + linkId + "]"));
        }
    }

    public void assertLinkWithTextUrlEndsWith(String linkText, String urlSuffix) {
        try {
            WebLink[] links = this.getDialog().getResponse().getLinks();
            JIRAWebTest.assertFalse((links.length == 0 ? 1 : 0) != 0);
            boolean foundLink = false;
            StringBuffer foundLinksSummary = new StringBuffer();
            int candidateLinks = 0;
            for (int i = 0; i < links.length; ++i) {
                WebLink link = links[i];
                if (link.getURLString() == null || link.asText() == null || !link.asText().equals(linkText)) continue;
                ++candidateLinks;
                String urlString = link.getURLString();
                foundLinksSummary.append("\n" + urlString);
                foundLink = urlString.endsWith(urlSuffix);
                if (foundLink) break;
            }
            if (!foundLink) {
                StringBuffer mesg = new StringBuffer();
                mesg.append("Could not find link with text '");
                mesg.append(linkText);
                mesg.append("' that has a url that ends with '");
                mesg.append(urlSuffix);
                mesg.append("'. ");
                if (candidateLinks > 0) {
                    mesg.append(candidateLinks);
                    mesg.append(" rejected candidates: [ ");
                    mesg.append(foundLinksSummary);
                    mesg.append("]");
                }
                JIRAWebTest.fail((String)mesg.toString());
            }
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)("Error locating link with text " + linkText));
        }
    }

    public void assertLinkWithTextUrlContains(String linkText, String[] strings) {
        try {
            WebLink[] links = this.getDialog().getResponse().getLinks();
            JIRAWebTest.assertFalse((links.length == 0 ? 1 : 0) != 0);
            boolean foundLink = false;
            StringBuffer foundLinksSummary = new StringBuffer();
            int candidateLinks = 0;
            for (int i = 0; i < links.length; ++i) {
                WebLink link = links[i];
                if (link.getURLString() == null || link.asText() == null || !link.asText().equals(linkText)) continue;
                ++candidateLinks;
                String urlString = link.getURLString();
                foundLinksSummary.append("\n" + urlString);
                for (int j = 0; j < strings.length; ++j) {
                    String string = strings[j];
                    if (urlString.indexOf(string) < 0) {
                        foundLink = false;
                        break;
                    }
                    foundLink = true;
                }
                if (foundLink) break;
            }
            if (!foundLink) {
                StringBuffer mesg = new StringBuffer();
                mesg.append("Could not find link with text '");
                mesg.append(linkText);
                mesg.append("' that contains all ");
                for (int i = 0; i < strings.length; ++i) {
                    String string = strings[i];
                    mesg.append("'").append(string).append("' ");
                }
                mesg.append(". ");
                if (candidateLinks > 0) {
                    mesg.append(candidateLinks);
                    mesg.append(" rejected candidates: [ ");
                    mesg.append(foundLinksSummary);
                    mesg.append("]");
                }
                JIRAWebTest.fail((String)mesg.toString());
            }
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)("Error locating link with text " + linkText));
        }
    }

    public void assertTableCellHasText(String tableId, int row, int column, String text) {
        try {
            WebTable table = this.getDialog().getResponse().getTableWithID(tableId);
            JIRAWebTest.assertNotNull((Object)table);
            boolean hasText = this.tableCellHasText(table, row, column, text);
            String actualText = table.getCellAsText(row, column);
            JIRAWebTest.assertTrue((String)("expected to find [" + text + "], somewhere in [" + actualText + "] but obviously couldn't."), (boolean)hasText);
        }
        catch (SAXException e) {
            JIRAWebTest.fail((String)("Error locating table with id [" + tableId + "]"));
        }
    }

    protected void assertResponseCanBeCached() {
        String cacheControl = this.getDialog().getResponse().getHeaderField("Cache-control");
        String[] values = new String[]{"no-cache", "no-store"};
        if (cacheControl != null && StringUtils.isNotEmpty((String)cacheControl)) {
            for (int i = 0; i < values.length; ++i) {
                JIRAWebTest.assertFalse((String)("Response cannot be cached: found '" + values[i] + "' in Cache-control header"), (cacheControl.indexOf(values[i]) >= 0 ? 1 : 0) != 0);
            }
        }
    }

    protected void assertResponseCannotBeCached() {
        String cacheControl = this.getDialog().getResponse().getHeaderField("Cache-control");
        String[] values = new String[]{"no-cache", "no-store", "must-revalidate"};
        if (cacheControl != null && StringUtils.isNotEmpty((String)cacheControl)) {
            boolean found = false;
            for (int i = 0; i < values.length; ++i) {
                found = found || cacheControl.indexOf(values[i]) >= 0;
            }
            if (!found) {
                JIRAWebTest.fail((String)"Cache-control header was set, but was not set to 'no-cache', 'no-store' or 'must-revalidate'");
            }
        } else {
            JIRAWebTest.fail((String)"No Cache-control header was set in the response");
        }
    }

    protected void archiveVersion(String project, String version) {
        this.gotoAdmin();
        this.clickLink("view_projects");
        this.clickLinkWithText(project);
        this.clickLink("manage_versions");
        this.clickLink("archive_" + version);
    }

    protected void gotoDefaultPermissionScheme() {
        this.clickLink("admin_link");
        this.clickLink("permission_schemes");
        this.clickLinkWithText("Default Permission Scheme");
    }

    protected void grantPermissionToUserInEnterprise(int permission, String username) {
        this.gotoDefaultPermissionScheme();
        this.clickLink("add_perm_" + permission);
        this.checkCheckbox("type", "user");
        this.setFormElement("user", username);
        this.submit(" Add ");
    }

    public void addProjectAdminPermission(int permission, String group) {
        this.clickLink("admin_link");
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("add_perm_" + permission);
        this.checkCheckbox("type", "group");
        this.selectOption("group", group);
        this.submit(" Add ");
    }

    protected void gotoFieldConfigurationDefault() {
        this.gotoAdmin();
        this.clickLink("field_configuration");
        this.clickLink("configure-Default Field Configuration");
        this.assertTextPresent("View Field Configuration");
    }

    protected void assertTableCellContainsFixVersionsLinks(TableCell fixVersionsCell, int expectedLinkCount) {
        WebLink[] links = fixVersionsCell.getLinks();
        JIRAWebTest.assertNotNull((Object)links);
        JIRAWebTest.assertEquals((int)expectedLinkCount, (int)links.length);
    }

    protected void assertTableCellContainsNoFixVersionsLinks(TableCell fixVersionsCell) {
        WebLink[] links = fixVersionsCell.getLinks();
        JIRAWebTest.assertTrue((links == null || links.length == 0 ? 1 : 0) != 0);
    }

    protected void assertTableCellContainsPriorityIcon(TableCell tableCell) {
        WebImage[] images = tableCell.getImages();
        JIRAWebTest.assertNotNull((Object)images);
        JIRAWebTest.assertEquals((int)1, (int)images.length);
        WebImage icon = images[0];
        JIRAWebTest.assertTrue((icon.getSource().indexOf("/images/icons") >= 0 ? 1 : 0) != 0);
    }

    protected void assertTableCellContainsNoPriorityIcon(TableCell tableCell) {
        WebImage[] images = tableCell.getImages();
        JIRAWebTest.assertTrue((images == null || images.length == 0 ? 1 : 0) != 0);
    }

    @Override
    public void dumpResponse() {
        this.dumpResponse(new RuntimeException("HTML Dump Invoked : invoked around"));
    }

    @Override
    public void dumpResponse(Throwable t) {
        TestCaseDumpKit.dumpTestInformation((TestCase)this, new Date(), t);
    }

    protected void logWork(String issueKey, String timeLogged, String newEstimate) {
        this.gotoIssue(issueKey);
        this.logWork(timeLogged, newEstimate);
    }

    private void logWork(String timeLogged, String newEstimate) {
        this.clickLink("log-work");
        this.setFormElement("timeLogged", timeLogged);
        this.checkCheckbox("adjustEstimate", "new");
        this.setFormElement("newEstimate", newEstimate);
        this.clickButton("log-work-submit");
    }

    protected void setEstimate(String time) {
        this.clickLink("editIssue");
        this.setFormElement("timetracking", time);
        this.submit("Update");
    }

    protected void waitForSuccessfulWorkflowSchemeMigration(String projectName, String targetWorkflowName) {
        int MAX_ITERATIONS = 100;
        int its = 0;
        while (true) {
            if (++its > 100) {
                JIRAWebTest.fail((String)"The Workflow Migration took longer than 100 attempts!  Why?");
            }
            if (this.getResponseText().indexOf("type=\"submit\" name=\"Refresh\"") != -1) {
                this.submit("Refresh");
            } else {
                if (this.getResponseText().indexOf("type=\"submit\" name=\"Done\"") != -1) {
                    this.validateProgressBarUI("Done");
                    this.submit("Done");
                    JIRAWebTest.assertTrue((this.getDialog().getResponsePageTitle().indexOf("Project: " + projectName) != -1 ? 1 : 0) != 0);
                    String schemeName = "Default".equalsIgnoreCase(targetWorkflowName) ? "None" : targetWorkflowName;
                    this.assertCollapsedTextSequence(new String[]{"Workflow Scheme:", schemeName});
                    return;
                }
                if (this.getResponseText().indexOf("input type=\"submit\" name=\"Acknowledge\"") != -1) {
                    this.validateProgressBarUI("Acknowledge");
                    this.submit("Acknowledge");
                    JIRAWebTest.assertTrue((this.getDialog().getResponsePageTitle().indexOf("Project: " + projectName) != -1 ? 1 : 0) != 0);
                    String schemeName = "Default".equalsIgnoreCase(targetWorkflowName) ? "None" : targetWorkflowName;
                    this.assertCollapsedTextSequence(new String[]{"Workflow Scheme:", schemeName});
                    return;
                }
                if (this.getResponseText().indexOf("<h3 class=\"formtitle\">Project: " + projectName + "</h3>") != -1) {
                    return;
                }
                JIRAWebTest.fail((String)("Page encountered during migration that was not expected : PROJECT:" + projectName + " - WORKFLOW SCHEME NAME" + targetWorkflowName));
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                JIRAWebTest.fail((String)"Test interupted");
                continue;
            }
            break;
        }
    }

    protected long getSubmittedTaskId() {
        this.waitForStableTaskPage();
        return this.getTaskIdFromProgressBarUI();
    }

    protected void switchToPersonalLicense() {
        String licenseTitle = this.getEdition();
        String licenseKey = LicenseKeys.V2_PERSONAL.getLicenseString();
        this.switchLicense(licenseKey, "JIRA " + licenseTitle + ": Personal");
    }

    protected void switchLicense(String licenseKey, String licenseDescription) {
        this.gotoAdmin();
        this.clickLink("license_details");
        this.setFormElement("license", licenseKey);
        this.submit("Add");
        this.assertTextPresent("License Information");
        this.assertTextPresent(licenseDescription);
    }

    protected void waitForTaskAcknowledgement(long taskId) {
        this.waitForTaskState(taskId, "Acknowledge");
    }

    private void waitForTaskState(long taskId, String desiredTaskState) {
        String taskState;
        do {
            taskState = this.waitForStableTaskPage();
            long taskIdTest = this.getSubmittedTaskId();
            if (taskId != taskIdTest) {
                JIRAWebTest.fail((String)("Expecting taskid <" + taskId + "> but got <" + taskIdTest + ">"));
            }
            if (taskState.equals(desiredTaskState)) {
                return;
            }
            if (!taskState.equals("Refresh")) continue;
            this.submit("Refresh");
        } while (!desiredTaskState.equalsIgnoreCase(taskState));
    }

    private String waitForStableTaskPage() {
        int MAX_ITERATIONS = 100;
        int its = 0;
        while (true) {
            if (++its > 100) {
                JIRAWebTest.fail((String)"The task took longer than 100 attempts!  Why?");
            }
            if (this.getResponseText().indexOf("type=\"submit\" name=\"Refresh\"") != -1) {
                return "Refresh";
            }
            if (this.getResponseText().indexOf("type=\"submit\" name=\"Done\"") != -1) {
                this.validateProgressBarUI("Done");
                return "Done";
            }
            if (this.getResponseText().indexOf("input type=\"submit\" name=\"Acknowledge\"") != -1) {
                this.validateProgressBarUI("Acknowledge");
                return "Acknowledge";
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                JIRAWebTest.fail((String)"Test interupted");
                continue;
            }
            break;
        }
    }

    private long getTaskIdFromProgressBarUI() {
        String taskLocatorStr = "<div class=\"pb_border\" id=\"pb_taskid_";
        int startIndex = this.getResponseText().indexOf(taskLocatorStr);
        if (startIndex == -1) {
            JIRAWebTest.fail((String)"Failed to find task progress bar as expected");
        }
        int endIndex = this.getResponseText().indexOf("\">", startIndex += taskLocatorStr.length());
        String taskId = this.getResponseText().substring(startIndex, endIndex);
        return Long.parseLong(taskId);
    }

    protected void validateProgressBarUI(String desiredTaskState) {
        String tmp;
        Integer leftPrecentage = null;
        Integer rightPercentage = null;
        try {
            tmp = this.getRegexMatch("pb_barlefttd.+style\\s*=\\s*\"[^\"]*width\\s*\\:\\s+(\\d+)%.*\"");
            if (tmp != null) {
                leftPrecentage = new Integer(tmp);
            }
        }
        catch (MalformedPatternException e) {
            JIRAWebTest.fail((String)"Left table regular expression is invalid.");
        }
        try {
            tmp = this.getRegexMatch("pb_barrighttd.+style\\s*=\\s*\"[^\"]*width\\s*\\:\\s+(\\d+)%.*\"");
            if (tmp != null) {
                rightPercentage = new Integer(tmp);
            }
        }
        catch (MalformedPatternException e) {
            JIRAWebTest.fail((String)"Right table regular expression is invalid.");
        }
        if ("Acknowledge".equalsIgnoreCase(desiredTaskState) || "Done".equalsIgnoreCase(desiredTaskState)) {
            this.assertTextPresent("Task completed");
            this.assertTextPresent("Started");
            this.assertTextPresent("Finished");
            JIRAWebTest.assertNull((Object)rightPercentage);
            JIRAWebTest.assertEquals((int)100, (int)leftPrecentage);
            if ("Done".equalsIgnoreCase(desiredTaskState)) {
                this.assertTextPresent("<span>Started");
                this.assertRegexMatch("by <a href=\"/.*/secure/admin/user/ViewUser.jspa?name=", false);
                this.assertTextSequence(new String[]{"<div class=\"infoBox\">", "This task has finished running", "<a", "</a>", "who started this task should acknowledge it.", "</div>"});
            }
        } else {
            this.assertTextNotPresent("Task completed");
            this.assertTextNotPresent("Finished");
            if (leftPrecentage == null) {
                JIRAWebTest.assertEquals((int)100, (int)rightPercentage);
            } else if (rightPercentage == null) {
                JIRAWebTest.assertEquals((int)100, (int)leftPrecentage);
            } else {
                JIRAWebTest.assertFalse((100 == leftPrecentage ? 1 : 0) != 0);
                JIRAWebTest.assertFalse((100 == rightPercentage ? 1 : 0) != 0);
                JIRAWebTest.assertEquals((int)leftPrecentage, (int)(100 - rightPercentage));
            }
        }
    }

    protected void waitForSuccessfulWorkflowActivation(String targetWorkflowName) {
        int MAX_ITERATIONS = 100;
        int its = 0;
        while (true) {
            if (++its > 100) {
                JIRAWebTest.fail((String)"The Workflow Migration took longer than 100 attempts!  Why?");
            }
            if (this.getResponseText().indexOf("type=\"submit\" name=\"Refresh\"") != -1) {
                this.submit("Refresh");
            } else {
                if (this.getResponseText().indexOf("type=\"submit\" name=\"Done\"") != -1) {
                    this.validateProgressBarUI("Done");
                    this.submit("Done");
                    return;
                }
                if (this.getResponseText().indexOf("input type=\"submit\" name=\"Acknowledge\"") != -1) {
                    this.validateProgressBarUI("Acknowledge");
                    this.submit("Acknowledge");
                    return;
                }
                JIRAWebTest.fail((String)("Page encountered during migration that was not expected - " + targetWorkflowName));
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                JIRAWebTest.fail((String)"Test interupted");
                continue;
            }
            break;
        }
    }

    protected void associateIssueLevelSecuritySchemeToProject(String projectName, String schemeName) {
        this.gotoAdmin();
        this.clickLink("view_projects");
        this.clickLinkWithText(projectName);
        this.clickLink("select_security_scheme");
        this.selectOption("newSchemeId", schemeName);
        this.submit("Next >>");
        this.submit("Associate");
    }

    public void setIntroduction(String intro) {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        this.setFormElement("introduction", intro);
        this.submit("Update");
    }

    protected void deleteAllDefaultPortlets() {
        this.gotoDashboard();
        this.gotoPortletConfig();
        this.selectOption("selectedRightPortlets", "Favourite Filters");
        this.submit("deleteButton");
        this.selectOption("selectedRightPortlets", "Assigned to me");
        this.submit("deleteButton");
        this.selectOption("selectedRightPortlets", "Issues in progress");
        this.submit("deleteButton");
        this.selectOption("selectedRightPortlets", "Quick links");
        this.submit("deleteButton");
        this.selectOption("selectedRightPortlets", "Admin");
        this.submit("deleteButton");
        this.selectOption("selectedLeftPortlets", "Introduction");
        this.submit("deleteButton");
        this.selectOption("selectedLeftPortlets", "Projects");
        this.submit("deleteButton");
    }

    protected void gotoPortletConfig() {
        this.clickLinkWithText("Manage Dashboard");
        this.clickLink("config_0");
    }

    protected void assertHelpLinkWithStringInUrlPresent(String linkPart) {
        JIRAWebTest.assertTrue((boolean)this.hasHelpLink(linkPart));
    }

    private boolean hasHelpLink(String linkPart) {
        try {
            WebLink[] links = this.getDialog().getResponse().getLinks();
            if (links != null) {
                for (int i = 0; i < links.length; ++i) {
                    WebLink link = links[i];
                    String urlString = link.getURLString();
                    if (urlString == null || urlString.indexOf(linkPart) < 0) continue;
                    return true;
                }
            }
            return false;
        }
        catch (SAXException e) {
            return false;
        }
    }

    protected void assertTextNotInColumn(String tableId, int column, String text) throws SAXException {
        WebTable table = this.getDialog().getResponse().getTableWithID(tableId);
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            String operationsCell = table.getCellAsText(i, column);
            JIRAWebTest.log("Checking cell on row[" + i + "] col[" + column + "] doesn't have text [" + text + "]");
            JIRAWebTest.assertTrue((operationsCell.indexOf(text) == -1 ? 1 : 0) != 0);
        }
    }

    protected void assertTableCellHasNotText(String tableId, int row, int col, String text) throws SAXException {
        WebTable table = this.getDialog().getResponse().getTableWithID(tableId);
        JIRAWebTest.assertTrue((table.getCellAsText(row, col).indexOf(text) == -1 ? 1 : 0) != 0);
    }

    protected String getEdition() {
        return "Enterprise";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertRedirectAndFollow(String url, String redirectRegex) {
        try {
            this.getTester().getTestContext().getWebClient().getClientProperties().setAutoRedirect(false);
            this.gotoPage(url);
            String redirectTo = this.getDialog().getResponse().getHeaderField("Location");
            boolean redirectingToCreateIssueStep2 = redirectTo.matches(redirectRegex);
            JIRAWebTest.assertTrue((String)("expected redirect to create issue, location header is: " + redirectTo), (boolean)redirectingToCreateIssueStep2);
            this.gotoPage(redirectTo);
        }
        finally {
            this.getTester().getTestContext().getWebClient().getClientProperties().setAutoRedirect(true);
        }
    }

    public void enableRemoteApi() {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        this.checkCheckbox("allowRpc", "true");
        this.submit("Update");
    }

    public void addWorkflowPostfunction(String workflowName, String stepName, String transitionName, String postFunctionName) {
        this.gotoWorkFlow();
        this.clickLink("steps_live_" + workflowName);
        this.clickLinkWithText(stepName);
        this.clickLinkWithText(transitionName);
        this.clickLinkWithText("Post Functions");
        this.clickLinkWithText("Add");
        this.selectMultiOptionByValue("type", postFunctionName);
        this.submit();
    }

    protected void addWorkflowCondition(String workflowName, String stepName, String condition) {
        this.addWorkflowCondition(workflowName, stepName, condition, null);
    }

    protected void addWorkflowCondition(String workflowName, String stepName, String condition, ParameterEnterer paramEnterer) {
        this.gotoWorkFlow();
        this.clickLink("steps_live_" + workflowName);
        this.clickLinkWithText(stepName);
        this.clickLinkWithText("Add");
        this.checkCheckbox("type", condition);
        this.submit("Add");
        if (paramEnterer != null) {
            paramEnterer.enterParameters();
        }
    }

    protected void addWorkflowValidator(String workflowName, String stepName, String validator) {
        this.addWorkflowValidator(workflowName, stepName, validator, null);
    }

    protected void addWorkflowValidator(String workflowName, String stepName, String validator, ParameterEnterer paramEnterer) {
        this.gotoWorkFlow();
        this.clickLink("steps_live_" + workflowName);
        this.clickLinkWithText(stepName);
        this.clickLinkWithText("Validators");
        this.clickLinkWithText("Add");
        this.checkCheckbox("type", validator);
        this.submit("Add");
        if (paramEnterer != null) {
            paramEnterer.enterParameters();
        }
    }

    public void enableWorkflow(String workflowName) {
        this.addWorkFlowScheme("New Workflow Scheme", "Test workflow scheme.");
        this.assignWorkflowScheme("New Workflow Scheme", "Bug", workflowName);
        this.associateWorkFlowSchemeToProject("homosapien", "New Workflow Scheme");
        this.waitForSuccessfulWorkflowSchemeMigration("homosapien", "New Workflow Scheme");
    }

    @Deprecated
    protected String getBuild() {
        this.gotoAdmin();
        XPathLocator poweredByLocator = new XPathLocator(this.tester, "//div[@class='poweredbymessage']//span[@id='footer-build-information']");
        String poweredByText = poweredByLocator.getRawText();
        java.util.regex.Pattern p = java.util.regex.Pattern.compile("\\((.*)\\)");
        Matcher m = p.matcher(poweredByText);
        if (!m.find()) {
            JIRAWebTest.fail((String)"Could not find version footer in expected location");
        }
        String versionFooter = m.group(1);
        String[] footerParts = versionFooter.split("\\#");
        return footerParts[footerParts.length - 1];
    }

    public boolean usingHsqlDb() throws IOException {
        this.gotoAdmin();
        this.clickLink("system_info");
        try {
            WebTable systemInfoTable = this.getDialog().getResponse().getTableWithID("system_info_table");
            return this.tableIndexOf(systemInfoTable, EasyList.build((Object)"Database type", (Object)"hsql")) != -1;
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    protected XPathLocator xpath(String xpathExpression) {
        return this.locator.xpath(xpathExpression);
    }

    public void setUp() {
        this.init();
    }

    public void init() {
        DefaultFuncTestHttpUnitOptions.setDefaultOptions();
        this.setUpHttpUnitOptions();
        this.startTime = System.currentTimeMillis();
        this.webClientListener = new FuncTestWebClientListener();
        JIRAEnvironmentData environmentData = this.getEnvironmentData();
        WebTesterFactory.setupWebTester(this.tester, environmentData);
        new JiraSetupInstanceHelper(this.tester, environmentData).ensureJIRAIsReadyToGo(this.webClientListener);
        this.getAdministration();
        this.getAssertions();
        this.getNavigation();
        this.getPage();
    }

    protected void setUpHttpUnitOptions() {
    }

    public boolean isJiraSetup() {
        this.beginAt("/");
        boolean hasBeenSetUp = (this.getEnvironmentData().getContext() + "/secure/Dashboard.jspa").equals(this.getDialog().getResponse().getURL().getPath());
        return hasBeenSetUp;
    }

    @Override
    public void tearDown() {
        this.logout();
        super.tearDown();
    }

    protected void runTest() throws Throwable {
        this.initFuncTestCaseLikeProtectedVariables();
        try {
            super.runTest();
        }
        catch (Throwable throwable) {
            try {
                TestCaseDumpKit.dumpTestInformation((TestCase)this, new Date(), throwable);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void runBare() throws Throwable {
        this.startTime = System.currentTimeMillis();
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        LogOnBothSides.log(this.getEnvironmentData(), TestInformationKit.getStartMsg((TestCase)this));
        try {
            super.runBare();
            LogOnBothSides.log(this.getEnvironmentData(), TestInformationKit.getEndMsg((TestCase)this, System.currentTimeMillis() - this.startTime, this.webClientListener));
        }
        catch (Throwable throwable) {
            LogOnBothSides.log(this.getEnvironmentData(), TestInformationKit.getEndMsg((TestCase)this, System.currentTimeMillis() - this.startTime, this.webClientListener, throwable));
            throw throwable;
        }
        finally {
            this.clearTestCaseVariables();
        }
    }

    private void initFuncTestCaseLikeProtectedVariables() {
        this.getNavigation();
        this.getAdministration();
        this.getAssertions();
        this.getEnvironmentData();
        this.form = new FormImpl(this.tester);
        this.page = new HtmlPage(this.tester);
        this.text = new TextAssertionsImpl(this.tester);
        this.parse = new ParserImpl(this.tester, this.getEnvironmentData());
        this.locator = this.getLocatorFactory();
        this.log = new FuncTestLoggerImpl(3);
    }

    private LocatorFactory getLocatorFactory() {
        if (this.locator == null) {
            return new LocatorFactoryImpl(this.tester);
        }
        return this.locator;
    }

    private void clearTestCaseVariables() {
        this.tester = null;
        this.environmentData = null;
        this.navigation = null;
        this.form = null;
        this.page = null;
        this.parse = null;
        this.administration = null;
        this.assertions = null;
        this.text = null;
        this.log = null;
        this.locator = null;
        this.webClientListener = null;
    }

    public static interface ParameterEnterer {
        public void enterParameters();
    }
}

