/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.webtests.JIRAGreenMailSetup;
import com.atlassian.jira.webtests.JIRAServerSetup;
import com.icegreen.greenmail.AbstractServer;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;

public class EmailFuncTestCase
extends FuncTestCase
implements FunctTestConstants {
    public static final String DEAFULT_FROM_ADDRESS = "jiratest@atlassian.com";
    public static final String DEFAULT_SUBJECT_PREFIX = "[JIRATEST]";
    public static final String newline = "\r\n";
    private GreenMail greenMail;

    @Override
    public void tearDownTest() {
        if (this.greenMail != null) {
            this.greenMail.stop();
            this.greenMail = null;
        }
    }

    public GreenMail getGreenMail() {
        if (this.greenMail == null) {
            EmailFuncTestCase.fail((String)"GreenMail has not been setup.");
        }
        return this.greenMail;
    }

    protected GreenMail configureAndStartSmtpServer() {
        return this.configureAndStartSmtpServer(DEAFULT_FROM_ADDRESS, DEFAULT_SUBJECT_PREFIX);
    }

    protected GreenMail configureAndStartSmtpServer(String from, String prefix) {
        this.assertSendingMailIsEnabled();
        this.configureAndStartGreenMailSmtp();
        this.setupJiraMailServer(from, prefix, String.valueOf(this.greenMail.getSmtp().getPort()));
        return this.greenMail;
    }

    protected Collection<String> parseEmailAddresses(String emails) {
        StringTokenizer st = new StringTokenizer(emails, ",");
        ArrayList<String> emailList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String email = st.nextToken().trim();
            if (!TextUtils.stringSet((String)email)) continue;
            emailList.add(email.trim());
        }
        return emailList;
    }

    protected void assertRecipientsHaveMessages(Collection recipients) throws MessagingException {
        for (String recipient : recipients) {
            EmailFuncTestCase.assertFalse((String)("Recipient '" + recipient + "' did not receive any messages"), (boolean)this.getMessagesForRecipient(recipient).isEmpty());
        }
    }

    protected List<MimeMessage> getMessagesForRecipient(String recipient) throws MessagingException {
        MimeMessage[] messages = this.getGreenMail().getReceivedMessages();
        ArrayList<MimeMessage> ret = new ArrayList<MimeMessage>();
        for (int i = 0; i < messages.length; ++i) {
            MimeMessage message = messages[i];
            if (!Arrays.asList(message.getHeader("To")).contains(recipient)) continue;
            ret.add(message);
        }
        return ret;
    }

    protected void assertSendingMailIsEnabled() {
        this.navigation.gotoAdmin();
        this.tester.clickLink("mail_queue");
        try {
            String responseText = this.tester.getDialog().getResponse().getText();
            if (responseText.indexOf("Sending mail is disabled") != -1) {
                EmailFuncTestCase.fail((String)"Mail sending is disabled. Please restart your server without -Datlassian.mail.senddisabled=true.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setupJiraMailServer(String from, String prefix, String smtpPort) {
        this.navigation.gotoAdmin();
        this.tester.clickLink("mail_servers");
        if (this.tester.getDialog().isLinkPresent("deleteSMTP")) {
            this.tester.clickLink("deleteSMTP");
            this.tester.submit("Delete");
        }
        this.tester.clickLinkWithText("Configure new SMTP mail server");
        this.tester.setFormElement("name", "Local Test Server");
        this.tester.setFormElement("from", from);
        this.tester.setFormElement("prefix", prefix);
        this.tester.setFormElement("serverName", "localhost");
        this.log("Setting SMTP server to 'localhost:" + smtpPort + "'");
        this.tester.setFormElement("port", smtpPort);
        this.tester.submit(" Add ");
        this.tester.assertLinkNotPresentWithText("Configure new SMTP mail server");
        this.tester.assertTextPresent("Local Test Server");
    }

    protected void setupJiraImapPopServer() {
        this.tester.clickLink("admin_link");
        this.tester.clickLink("mail_servers");
        this.tester.clickLinkWithText("Configure new POP / IMAP mail server");
        this.tester.setFormElement("name", "Local Test Pop/Imap Server");
        this.tester.setFormElement("serverName", "localhost");
        this.tester.setFormElement("username", "admin");
        this.tester.setFormElement("password", "admin");
        this.tester.submit(" Add ");
    }

    protected void setupPopService() {
        this.setupPopService("project=MKY, issue=1, createusers=true");
    }

    protected void setupPopService(String handlerParameters) {
        String popPort = String.valueOf(this.getGreenMail().getPop3().getPort());
        this.tester.clickLink("admin_link");
        this.tester.clickLink("services");
        this.tester.setFormElement("name", "pop");
        this.tester.setFormElement("clazz", "com.atlassian.jira.service.services.pop.PopService");
        this.tester.setFormElement("delay", "1");
        this.tester.submit("Add Service");
        this.tester.setFormElement("handler.params", handlerParameters);
        this.tester.setFormElement("port", popPort);
        this.tester.setFormElement("delay", "1");
        this.tester.submit("Update");
    }

    protected void setupImapService() {
        this.setupImapService("project=MKY, issue=1, createusers=true");
    }

    protected void setupImapService(String handlerParameters) {
        String imapPort = String.valueOf(this.getGreenMail().getImap().getPort());
        this.tester.clickLink("admin_link");
        this.tester.clickLink("services");
        this.tester.setFormElement("name", "imap");
        this.tester.setFormElement("clazz", "com.atlassian.jira.service.services.imap.ImapService");
        this.tester.setFormElement("delay", "1");
        this.tester.submit("Add Service");
        this.tester.setFormElement("handler.params", handlerParameters);
        this.tester.setFormElement("port", imapPort);
        this.tester.setFormElement("delay", "1");
        this.tester.submit("Update");
    }

    protected GreenMail configureAndStartGreenMailSmtp() {
        return this.configureAndStartGreenMail(new JIRAServerSetup[]{JIRAServerSetup.SMTP});
    }

    protected GreenMail configureAndStartGreenMail(JIRAServerSetup[] serverSetups) {
        return this.configureAndStartGreenMail(new JIRAGreenMailSetup(serverSetups));
    }

    private GreenMail configureAndStartGreenMail(JIRAGreenMailSetup jiraGreenMailSetup) {
        this.log("Configuring and starting JIRA green mail server");
        this.greenMail = null;
        boolean hasFailedService = false;
        for (int setupRetries = 0; setupRetries < 10; ++setupRetries) {
            this.greenMail = new GreenMail((ServerSetup[])jiraGreenMailSetup.getServerSetups());
            this.greenMail.start();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            ArrayList<Object> servers = new ArrayList<Object>();
            servers.add(this.greenMail.getSmtp());
            servers.add(this.greenMail.getPop3());
            servers.add(this.greenMail.getImap());
            Iterator iterator = servers.iterator();
            while (iterator.hasNext() && !hasFailedService) {
                AbstractServer server = (AbstractServer)iterator.next();
                hasFailedService = !this.isServerRunning(server);
            }
            if (hasFailedService) {
                this.log("Some servers did not start properly. Incrementing ports and trying again... '" + setupRetries + "'");
                hasFailedService = false;
                this.greenMail.stop();
                jiraGreenMailSetup.incrementPorts();
                continue;
            }
            this.log("Successfully started green mail server");
            break;
        }
        EmailFuncTestCase.assertTrue((String)"Error: Could not start green mail server. See log for details.", (!hasFailedService ? 1 : 0) != 0);
        return this.greenMail;
    }

    private boolean isServerRunning(AbstractServer server) {
        if (server != null) {
            if (server.isAlive()) {
                this.log("Running '" + server.getProtocol() + "' server on port '" + server.getPort() + "'.");
            } else {
                this.log("Error trying to start '" + server.getProtocol() + "' server on port '" + server.getPort() + "'.");
                return false;
            }
        }
        return true;
    }

    protected MailFolder getUserInbox(String userEmail) throws FolderException {
        GreenMailUser mailUser = this.getGreenMail().setUser(userEmail, "password");
        return this.getGreenMail().getManagers().getImapHostManager().getInbox(mailUser);
    }

    protected void flushMailQueueAndWait(int emailCount) throws InterruptedException {
        this.flushMailQueueAndWait(emailCount, 500);
    }

    protected void flushMailQueueAndWait(int emailCount, int waitPeriodMillis) throws InterruptedException {
        this.navigation.gotoAdmin();
        this.tester.clickLink("mail_queue");
        this.tester.clickLinkWithText("Flush mail queue");
        this.log("Flushed mail queue. Waiting for '" + waitPeriodMillis + "' ms...");
        boolean receivedAllMail = this.greenMail.waitForIncomingEmail((long)waitPeriodMillis, emailCount);
        String msg = "Did not recieve all expected emails (" + emailCount + ") within the timeout.";
        if (this.greenMail.getReceivedMessages() != null) {
            msg = msg + " Only received " + this.greenMail.getReceivedMessages().length + " message(s).";
        }
        EmailFuncTestCase.assertTrue((String)msg, (boolean)receivedAllMail);
    }

    protected void waitForMail(int emailCount) throws InterruptedException {
        int waitPeriodMillis = 500;
        EmailFuncTestCase.assertTrue((String)"Did not recieve all expected emails within the timeout", (boolean)this.greenMail.waitForIncomingEmail(500L, emailCount));
    }

    protected void assertEmailBodyContains(MimeMessage email, String bodySubString) throws MessagingException, IOException {
        String emailBody = GreenMailUtil.getBody((Part)email);
        EmailFuncTestCase.assertTrue((String)("The string '" + bodySubString + "' was not found in the e-mail body [" + emailBody + "]"), (emailBody.indexOf(bodySubString) != -1 ? 1 : 0) != 0);
    }

    protected void assertEmailBodyContainsLine(MimeMessage email, String linePattern) throws MessagingException, IOException {
        String line;
        String emailBody = GreenMailUtil.getBody((Part)email);
        String[] lines = emailBody.split("\\n");
        boolean match = false;
        for (int i = 0; i < lines.length && !(match = (line = lines[i]).matches(linePattern)); ++i) {
        }
        EmailFuncTestCase.assertTrue((String)("The line '" + linePattern + "' was not found in the e-mail body [" + emailBody + "]"), (boolean)match);
    }

    protected void assertEmailBodyDoesntContain(MimeMessage email, String bodySubString) throws MessagingException, IOException {
        String emailBody = GreenMailUtil.getBody((Part)email);
        EmailFuncTestCase.assertTrue((String)("The string '" + bodySubString + "' was found (shouldn't exist) in the e-mail body [" + emailBody + "]"), (emailBody.indexOf(bodySubString) == -1 ? 1 : 0) != 0);
    }

    protected void assertEmailBodyContains(String emailBody, String bodySubString) throws MessagingException, IOException {
        EmailFuncTestCase.assertTrue((String)("Expected '" + bodySubString + "' to be present in email body '" + emailBody + "'"), (emailBody.indexOf(bodySubString) != -1 ? 1 : 0) != 0);
    }

    protected void assertEmailHasNumberOfParts(MimeMessage email, int expectedNumOfParts) throws MessagingException, IOException {
        Object emailContent = email.getContent();
        if (emailContent instanceof Multipart) {
            Multipart multiPart = (Multipart)emailContent;
            EmailFuncTestCase.assertEquals((int)expectedNumOfParts, (int)multiPart.getCount());
        } else {
            EmailFuncTestCase.fail((String)"Cannot assert number of parts for email. Email is not a multipart type.");
        }
    }

    protected void assertEmailToEquals(MimeMessage email, String expectedTo) throws MessagingException {
        this.assertEmailToEquals(email, this.parseEmailAddresses(expectedTo));
    }

    protected void assertEmailToEquals(MimeMessage email, Collection expectedToAddresses) throws MessagingException {
        String[] toHeader = email.getHeader("to");
        EmailFuncTestCase.assertEquals((int)1, (int)toHeader.length);
        Collection<String> actualAddresses = this.parseEmailAddresses(toHeader[0]);
        this.assertEmailsEquals(expectedToAddresses, actualAddresses);
    }

    protected void assertEmailCcEquals(MimeMessage email, Collection expectedCcAddresses) throws MessagingException {
        String[] ccHeader = email.getHeader("cc");
        if (ccHeader != null) {
            EmailFuncTestCase.assertEquals((int)1, (int)ccHeader.length);
            Collection<String> actualAddresses = this.parseEmailAddresses(ccHeader[0]);
            this.assertEmailsEquals(expectedCcAddresses, actualAddresses);
        } else {
            EmailFuncTestCase.assertTrue((String)"Expected Cc address but was null", (boolean)expectedCcAddresses.isEmpty());
        }
    }

    private void assertEmailsEquals(Collection expectedAddresses, Collection actualAddresses) {
        EmailFuncTestCase.assertEquals((String)("Expected '" + expectedAddresses.size() + "' email addresses but only found '" + actualAddresses.size() + "'"), (int)expectedAddresses.size(), (int)actualAddresses.size());
        EmailFuncTestCase.assertEquals((Object)expectedAddresses, (Object)actualAddresses);
    }

    protected void assertEmailFromEquals(MimeMessage email, String expectedTo) throws MessagingException {
        String[] addresses = email.getHeader("from");
        EmailFuncTestCase.assertEquals((int)1, (int)addresses.length);
        EmailFuncTestCase.assertEquals((String)expectedTo, (String)addresses[0]);
    }

    protected void assertEmailSubjectEquals(MimeMessage email, String subject) throws MessagingException {
        EmailFuncTestCase.assertEquals((String)subject, (String)email.getSubject());
    }

    protected void assertEmailSent(String recipient, String subject, String issueComment) throws MessagingException, IOException {
        List<MimeMessage> emails = this.getMessagesForRecipient(recipient);
        EmailFuncTestCase.assertEquals((String)("Incorrect number of e-mails received for '" + recipient + "'"), (int)1, (int)emails.size());
        MimeMessage emailMessage = emails.get(0);
        this.assertEmailBodyContains(emailMessage, issueComment);
        this.assertEmailSubjectEquals(emailMessage, subject);
    }

    protected void assertCorrectNumberEmailsSent(int numOfMessages) throws MessagingException {
        MimeMessage[] messages = this.getGreenMail().getReceivedMessages();
        if (messages.length != numOfMessages) {
            for (int i = 0; i < messages.length; ++i) {
                MimeMessage message = messages[i];
                this.log("Mail sent to '" + message.getHeader("to")[0] + "' with SUBJECT '" + message.getSubject() + "'");
            }
            EmailFuncTestCase.fail((String)("Invalid number of e-mails received.  Was " + messages.length + " but should have been " + numOfMessages + "."));
        }
    }
}

