/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests;

import com.atlassian.jira.webtests.JIRAWebTest;

public abstract class AbstractTestWorkflowNameEditing
extends JIRAWebTest {
    public AbstractTestWorkflowNameEditing(String name) {
        super(name);
    }

    public void testDefaultSystemWorkflowIsNotEditable() {
        this.gotoPage(this.page.addXsrfToken("/secure/admin/workflows/EditWorkflow.jspa?workflowMode=live&workflowName=jira"));
        this.assertWorkflowIsNotEditable();
    }

    public void testActiveWorkflowsAreNotEditable() {
        this.gotoPage(this.page.addXsrfToken("/secure/admin/workflows/EditWorkflow.jspa?workflowMode=live&workflowName=Active+workflow"));
        this.assertWorkflowIsNotEditable();
    }

    public void testEditWorkflowNameValidation() {
        this.gotoWorkFlow();
        this.clickLink("edit_live_editable workflow");
        this.assertFormElementWithNameHasValue("newWorkflowName", "editable workflow");
        this.setFormElement("newWorkflowName", "");
        this.submit("Edit");
        this.assertTextPresent("You must specify a workflow name.");
        this.setFormElement("newWorkflowName", "Active workflow");
        this.submit("Edit");
        this.assertTextPresent("A workflow with this name already exists.");
        this.setFormElement("newWorkflowName", "non-ascii char: \u1234");
        this.submit("Edit");
        this.assertTextPresent("Please use only ASCII characters for the workflow name.");
    }

    private void assertWorkflowIsNotEditable() {
        this.assertTextPresent("Workflow cannot be edited as it is not editable.");
        this.submit("Edit");
        this.assertTextPresent("Edit Workflow");
        this.assertTextPresent("Workflow cannot be edited as it is not editable.");
        this.setFormElement("newWorkflowName", "name change");
        this.setFormElement("description", "desc change");
        this.submit("Edit");
        this.assertTextPresent("Edit Workflow");
        this.assertTextPresent("Workflow cannot be edited as it is not editable.");
    }

    public void testEditDraftWorkflow() {
        this.gotoWorkFlow();
        this.clickLink("createDraft_Active workflow");
        this.clickLinkWithText("workflows.");
        this.clickLink("edit_draft_Active workflow");
        this.assertFormElementNotPresent("newWorkflowName");
        this.setFormElement("description", "well not really since its a draft");
        this.submit("Edit");
        this.assertTableCellHasText("workflows_table", 2, 1, "This workflow is active");
        this.assertTableCellHasText("workflows_table", 3, 1, "well not really since its a draft");
    }
}

