/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
class TransformingMap<K, V, I>
extends AbstractMap<K, V> {
    private final Map<K, I> map;
    private final Function<I, V> transformer;

    TransformingMap(@NotNull Map<K, I> map, @NotNull Function<I, V> transformer) {
        this.map = Assertions.notNull("map", map);
        this.transformer = Assertions.notNull("transformer", transformer);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Transformed.set(Collections.unmodifiableSet(this.map.entrySet()), new Function<Map.Entry<K, I>, Map.Entry<K, V>>(){

            @Override
            public Map.Entry<K, V> get(Map.Entry<K, I> entry) {
                return Transformed.entry(entry, TransformingMap.this.transformer);
            }
        });
    }

    @Override
    public V get(Object key) {
        return this.transformer.get(this.map.get(key));
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    static class DecoratedEntry<K, I, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<? extends K, ? extends I> entry;
        private final Function<I, V> transformer;
        private V value;

        DecoratedEntry(@NotNull Map.Entry<? extends K, ? extends I> entry, @NotNull Function<I, V> transformer) {
            this.entry = Assertions.notNull("entry", entry);
            this.transformer = Assertions.notNull("transformer", transformer);
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            if (this.value == null) {
                this.value = this.transformer.get(this.entry.getValue());
            }
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return DecoratedEntry.eq(this.getKey(), e.getKey()) && DecoratedEntry.eq(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }
}

