/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapBuilder<K, V> {
    private final Map<K, V> map = new LinkedHashMap();

    public static <K, V> MapBuilder<K, V> newBuilder() {
        return new MapBuilder<K, V>();
    }

    public MapBuilder<K, V> add(K key, V value) {
        this.map.put(key, value);
        return this;
    }

    public MapBuilder<K, V> addIfValueNotNull(K key, V value) {
        if (value != null) {
            this.map.put(key, value);
        }
        return this;
    }

    public Map<K, V> toImmutableMap() {
        return Collections.unmodifiableMap(new HashMap<K, V>(this.map));
    }

    public Map<K, V> toMutableMap() {
        return new HashMap<K, V>(this.map);
    }

    public Map<K, V> toMap() {
        return this.toImmutableMap();
    }
}

